/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_zh_HK extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "{0} \u4e2d\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.FUNCTION_ERROR_INFO, "{0} \u5728\u8655\u7406 {1} \u51fd\u6578\u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.FILE_ERROR_INFO, "{0} \u5728\u8655\u7406 {1} \u51fd\u6578\u7684\u7b2c {2} \u884c\u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.PROPERTIES_FILE_MISSING, "\u7121\u6cd5\u8f09\u5165 {0} \u5167\u5bb9\u6a94\u3002" },
		{ Message.LOAD_LIBRARY_FAILED, "\u7121\u6cd5\u8f09\u5165 {0} \u7a0b\u5f0f\u5eab\u3002\u767c\u751f\u4e0b\u5217\u932f\u8aa4\uff1a{1}\u3002" },
		{ Message.CREATE_OBJECT_FAILED, "\u5efa\u7acb {0} \u985e\u578b\u7684\u7269\u4ef6\u6642\u767c\u751f\u932f\u8aa4\u3002\u767c\u751f\u4e0b\u5217\u932f\u8aa4\uff1a{1}\u3002" },
		{ Message.INITIAL_CONTEXT_ERROR, "\u5efa\u7acb InitialContext \u6216\u67e5\u95b1 java:comp/env \u74b0\u5883\u6642\u767c\u751f\u932f\u8aa4\u3002\u767c\u751f\u4e0b\u5217\u932f\u8aa4\uff1a{0}" },
		{ Message.LISTENER_ERROR, "\u767c\u751f\u4e0b\u5217\u7570\u5e38\u72c0\u6cc1\u548c\u8a0a\u606f\u3002\u7570\u5e38\u72c0\u6cc1\uff1a{0}\u3002\u8a0a\u606f\uff1a{1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "\u9700\u8981 {0} \u5167\u5bb9\u7684\u503c\u3002" },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "\u907a\u6f0f\u5916\u90e8\u76f8\u4f9d\u95dc\u4fc2\u3002\u767c\u751f\u4e0b\u5217\u7570\u5e38\u72c0\u6cc1\u3002\u7570\u5e38\u72c0\u6cc1\uff1a{0}" },
		{ Message.UNSUPPORTED_COMPARE, "\u7121\u6cd5\u6bd4\u8f03 {0} \u548c {1} \u904b\u7b97\u5143\u3002" },
		{ Message.ASSIGNMENT_OVERFLOW, "\u5c07\u503c {0} \u6307\u6d3e\u7d66 {1} \u6642\u767c\u751f\u6ea2\u4f4d\u932f\u8aa4\u3002" },
		{ Message.EXPRESSION_OVERFLOW, "\u5728\u8a08\u7b97\u4ee5\u4e0b\u7684\u8868\u793a\u5f0f\u6642\u767c\u751f\u6ea2\u4f4d\u932f\u8aa4\uff1a{0}\u3002" },
		{ Message.UNSUPPORTED_OPERANDS, "{1} \u548c {2} \u904b\u7b97\u5143\u4e0d\u652f\u63f4 {0} \u904b\u7b97\u5b50\u3002" },
		{ Message.UNSUPPORTED_OPERAND, "{2} \u985e\u578b\u7684 {1} \u904b\u7b97\u5143\u4e0d\u652f\u63f4 {0} \u904b\u7b97\u5b50\u3002" },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "{1} \u985e\u578b\u7684 {0} \u904b\u7b97\u5143\u4e0d\u652f\u63f4\u4e0b\u6a19\u904b\u7b97\u5b50\u3002" },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "{1} \u985e\u578b\u7684 {0} \u904b\u7b97\u5143\u4e0d\u652f\u63f4\u5b50\u5b57\u4e32\u904b\u7b97\u5b50\u3002" },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "{1} \u985e\u578b\u7684 {0} \u904b\u7b97\u5143\u4e0d\u652f\u63f4 SET EMPTY \u9673\u8ff0\u5f0f\u3002" },
		{ Message.INVALID_REGULAR_EXPRESSION, "{0} \u6b63\u898f\u8868\u793a\u5f0f\u4e2d\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}\u3002" },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "\u7576\u4f7f\u7528 CICSSSL \u901a\u8a0a\u5354\u5b9a\u6642\uff0c\u5fc5\u9808\u540c\u6642\u6307\u5b9a ctgKeyStore \u548c ctgKeyStorePassword\u3002" },
		{ Message.INVALID_CTGPORT, "ctgport \u9805\u76ee\u7684 {0} \u503c\u4e0d\u6b63\u78ba\u3002" },
		{ Message.CTG_CONNECT_FAILED, "\u9023\u63a5 CTG \u6642\u767c\u751f\u932f\u8aa4\u3002CTG \u4f4d\u7f6e\u70ba {0}\u3002CTG \u57e0\u70ba {1}\u3002\u767c\u751f\u4e0b\u5217\u932f\u8aa4\uff1a{2}" },
		{ Message.CTG_DISCONNECT_FAILED, "\u5207\u65b7 CTG \u9023\u7dda\u6642\u767c\u751f\u932f\u8aa4\u3002CTG \u4f4d\u7f6e\u70ba {0}\u3002CTG \u57e0\u70ba {1}\u3002\u767c\u751f\u4e0b\u5217\u932f\u8aa4\uff1a{2}" },
		{ Message.NO_CICS, "\u547c\u53eb\u4f7f\u7528 CICS ECI \u7684 {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba -3 (ECI_ERR_NO_CICS)\u3002CICS \u7cfb\u7d71 ID \u70ba {1}\u3002" },
		{ Message.CICS_DIED, "\u547c\u53eb\u4f7f\u7528 CICS ECI \u7684 {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba -4 (ECI_ERR_CICS_DIED)\u3002CICS \u7cfb\u7d71 ID \u70ba {1}\u3002" },
		{ Message.CICS_TIMEOUT, "\u547c\u53eb\u4f7f\u7528 CICS ECI \u7684 {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba -6 (ECI_ERR_RESPONSE_TIMEOUT)\u3002CICS \u7cfb\u7d71 ID \u70ba {1}\u3002" },
		{ Message.CICS_TRANSACTION_ABEND, "\u547c\u53eb\u4f7f\u7528 CICS ECI \u7684 {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba -7 (ECI_ERR_TRANSACTION_ABEND)\u3002CICS \u7cfb\u7d71 ID \u70ba {1}\u3002\u7570\u5e38\u7d42\u6b62\u78bc\u70ba {2}\u3002" },
		{ Message.CICS_UNKNOWN_SERVER, "\u547c\u53eb\u4f7f\u7528 CICS ECI \u7684 {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba -22 (ECI_ERR_UNKNOWN_SERVER)\u3002CICS \u7cfb\u7d71 ID \u70ba {1}\u3002" },
		{ Message.CICS_SECURITY_ERROR, "\u547c\u53eb\u4f7f\u7528 CICS ECI \u7684 {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba -27 (ECI_ERR_SECURITY_ERROR)\u3002CICS \u7cfb\u7d71 ID \u70ba {1}\u3002" },
		{ Message.CICS_MAX_SYSTEMS, "\u547c\u53eb\u4f7f\u7528 CICS ECI \u7684 {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba -28 (ECI_ERR_MAX_SYSTEMS)\u3002CICS \u7cfb\u7d71 ID \u70ba {1}\u3002" },
		{ Message.CICS_NONZERO_RETURN_CODE, "\u5728\u4f7f\u7528\u8005\u540d\u7a31\u70ba {2} \u7684 {1} \u7cfb\u7d71\u4e0a\uff0c\u547c\u53eb {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002CICS ECI \u547c\u53eb\u50b3\u56de\u56de\u8986\u78bc {3} \u548c\u7570\u5e38\u7d42\u6b62\u78bc {4}\u3002" },
		{ Message.CICS_COMMIT_FAILED, "\u547c\u53eb CICS ECI \u4ee5\u78ba\u5b9a\u5de5\u4f5c\u55ae\u4f4d\u6642\u767c\u751f\u932f\u8aa4\u3002CICS \u56de\u8986\u78bc\u70ba {0}\u3002" },
		{ Message.CICS_ROLLBACK_FAILED, "\u547c\u53eb CICS ECI \u4ee5\u56de\u5fa9\u5de5\u4f5c\u55ae\u4f4d\u6642\u767c\u751f\u932f\u8aa4\u3002CICS \u56de\u8986\u78bc\u70ba {0}\u3002" },
		{ Message.CICS_ECI_FLOW_FAILED, "\u300c\u5411 CICS \u7cfb\u7d71 {0} \u63d0\u51fa ECI \u8981\u6c42\u300d\u6d41\u7a0b\u4e2d\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u7570\u5e38\u72c0\u6cc1\uff1a{1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "\u53c3\u6578\u9577\u5ea6\u932f\u8aa4\u3002\u4e32\u6d41\u6709 {0} \u500b\u53c3\u6578\uff0c\u800c\u672c\u7aef\u51fd\u6578\u6709 {1} \u500b\u53c3\u6578\u3002" },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "\u8d85\u904e {0} \u9663\u5217\u7684\u5927\u5c0f\u4e0a\u9650\u3002" },
		{ Message.WRONG_NUMBER_OF_PARMS, "\u88ab\u547c\u53eb\u7684\u7a0b\u5f0f {0} \u9810\u671f\u6709 {1} \u500b\u53c3\u6578\uff0c\u4f46\u537b\u6536\u5230 {2} \u500b\u3002" },
		{ Message.FUNCTION_NOT_FOUND, "\u53d6\u5f97 {1} \u5171\u7528\u7a0b\u5f0f\u5eab\u4e2d\u7684 {0} \u9032\u5165\u9ede\u4f4d\u5740\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba {2}\u3002" },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "\u8f09\u5165 {0} \u5171\u7528\u7a0b\u5f0f\u5eab\u6642\u767c\u751f\u932f\u8aa4\u3002\u56de\u8986\u78bc\u70ba {1}\u3002" },
		{ Message.CALL_NONZERO_RETURN_CODE, "\u88ab\u547c\u53eb\u7684\u7a0b\u5f0f\u57f7\u884c\u5931\u6557\uff0c\u56de\u8986\u78bc\u70ba {0}\u3002" },
		{ Message.REMOTE_PROGRAM_ERROR, "\u5728 {3} \u7cfb\u7d71\u4e0a\uff0c{0} \u9060\u7aef\u7a0b\u5f0f\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\u767c\u751f\u5728\u4f4d\u65bc {2} \u7684 {1} \u4e0a\u3002{4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "\u5728 {1} \u7cfb\u7d71\u4e0a\uff0c{0} \u9060\u7aef\u7a0b\u5f0f\u767c\u751f\u932f\u8aa4\u3002{2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "{0} \u4e3b\u6a5f\u540d\u7a31\u70ba\u4e0d\u660e\u7684 TCP/IP \u4e3b\u6a5f\u540d\u7a31\u3002" },
		{ Message.SERVERID_IS_INVALID_PORT, "{0} \u4f3a\u670d\u5668 ID \u4e0d\u662f\u6709\u6548\u7684\u57e0\u865f\u3002" },
		{ Message.TCPIP_SERVER_ERROR, "\u7528\u6236\u7aef\u6536\u5230\u901a\u77e5\uff0c\u6307\u51fa\u4f3a\u670d\u5668\u7121\u6cd5\u555f\u52d5\u9060\u7aef\u88ab\u547c\u53eb\u7684\u7a0b\u5f0f\u3002\u539f\u56e0\u78bc\uff1a{0}\u3002" },
		{ Message.INVALID_REMOTECOMTYPE, "remoteComType \u503c\u907a\u6f0f\u6216\u4e0d\u6b63\u78ba\u3002" },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "\u7121\u6cd5\u958b\u555f {0} \u93c8\u7d50\u5167\u5bb9\u6a94\u3002" },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "\u5728 {1} \u93c8\u7d50\u5167\u5bb9\u6a94\u4e2d\u627e\u4e0d\u5230\u88ab\u547c\u53eb\u7a0b\u5f0f {0} \u7684\u9805\u76ee\u3002" },
		{ Message.AS400_UNKNOWN_HOST, "{0} \u4e3b\u6a5f\u627e\u4e0d\u5230\u6216\u4e0d\u660e\u3002" },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "\u9023\u63a5 {0} \u7cfb\u7d71\u6240\u7528\u7684\u5bc6\u78bc\u6216\u4f7f\u7528\u8005 ID \u4e0d\u6b63\u78ba\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "\u547c\u53eb {3} \u7cfb\u7d71\u4e0a\u7684 {2} \u7a0b\u5f0f\u6642\uff0c\u767c\u751f\u300c{0} AS400 \u5de5\u5177\u7bb1\u300d\u57f7\u884c\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.AS400_NO_AUTHORITY, "{1} \u4f7f\u7528\u8005\u7684 {0} \u7cfb\u7d71\u767c\u751f\u9060\u7aef\u5b58\u53d6\u5b89\u5168\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{2}" },
		{ Message.REMOTE_COMMIT_FAILED, "\u5728 {0} \u7cfb\u7d71\u4e0a\u57f7\u884c\u78ba\u5b9a\u529f\u80fd\u5931\u6557\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "\u5728 {0} \u7cfb\u7d71\u4e0a\u57f7\u884c\u56de\u5fa9\u529f\u80fd\u5931\u6557\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.AS400_CONNECTION_ERROR, "\u5b58\u53d6 {0} \u7cfb\u7d71\u6642\uff0c\u767c\u751f\u9060\u7aef\u9023\u7dda\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "\u767c\u751f\u300cEGL OS/400 \u4e3b\u6a5f\u670d\u52d9\u300d\u932f\u8aa4\u3002\u5728 {0} \u7cfb\u7d71\u4e0a\u627e\u4e0d\u5230\u5fc5\u8981\u7684\u6a94\u6848\u3002" },
		{ Message.AS400_APPLICATION_ERROR, "\u57f7\u884c\u55ae\u5143\u5df2\u505c\u6b62\uff0c\u56e0\u70ba\u5728\u5617\u8a66\u547c\u53eb {1} \u7a0b\u5f0f\u6642\uff0c{0} \u7cfb\u7d71\u4e0a\u767c\u751f\u61c9\u7528\u7a0b\u5f0f\u932f\u8aa4\u3002\u8a0a\u606f\uff1a{2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "\u53c3\u7167\u8b8a\u6578 {0} \u662f\u7a7a\u503c\u3002" },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "\u767c\u751f\u7121\u6cd5\u8655\u7406\u7684\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{0}\u3002" },
		{ Message.DATA_FORMAT_ERROR, "{0} \u8b8a\u6578\u7684\u503c\u4e0d\u662f\u6b63\u78ba\u7684\u683c\u5f0f\u3002" },
		{ Message.CONVERSION_ERROR, "\u7121\u6cd5\u5c07 {1} \u985e\u578b\u7684\u503c {0} \u8f49\u63db\u6210 {2} \u985e\u578b\u3002" },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "{0} \u65e5\u671f\u683c\u5f0f\u578b\u6a23\u7121\u6548\u3002" },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "{0} \u6642\u9593\u683c\u5f0f\u578b\u6a23\u7121\u6548\u3002" },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "{0} \u6642\u9593\u6233\u8a18\u683c\u5f0f\u578b\u6a23\u7121\u6548\u3002" },
		{ Message.NULL_REFERENCE, "\u6240\u7528\u7684\u53c3\u7167\u70ba\u7a7a\u503c\u3002" },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "{0} \u4e0d\u652f\u63f4\u52d5\u614b\u5b58\u53d6\u3002" },
		{ Message.DYNAMIC_ACCESS_FAILED, "\u5728 {1} \u4e2d\u627e\u4e0d\u5230 {0} ID \u7684\u6b04\u4f4d\u3002" },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "{0} \u6578\u503c\u683c\u5f0f\u578b\u6a23\u7121\u6548\u3002" },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "\u5c07 {0} \u6307\u6d3e\u7d66 {1} \u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{2}\u3002" },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "SET {0} EMPTY \u9673\u8ff0\u5f0f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}\u3002" },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "\u547c\u53eb\u5167\u542b {1} \u7c3d\u7ae0\u7684\u65b9\u6cd5\u6642\u767c\u751f {0} \u932f\u8aa4\u3002" },
		{ Message.RUN_COMMAND_FAILED, "\u57f7\u884c {0} \u6307\u4ee4\u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}\u3002" },
		{ Message.MDY_ERROR, "DateTimeLib.mdy \u51fd\u6578\u7121\u6cd5\u5c07\u503c {0}\u3001{1} \u548c {2} \u8f49\u63db\u6210\u6708\u3001\u65e5\u548c\u5e74\u3002" },
		{ Message.NON_NUMERIC_STRING, "\u50b3\u7d66 {0} \u7684\u662f {1} \u975e\u6578\u503c\u5b57\u4e32\u3002\u5728\u9577\u5ea6\u5f15\u6578\u6240\u5b9a\u7fa9\u7684\u5b57\u4e32\u90e8\u5206\u4e2d\uff0c\u6240\u6709\u5b57\u5143\u90fd\u5fc5\u9808\u662f\u6578\u503c\u3002" },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u8a0a\u606f {1}\u3002" },
		{ Message.INT_AS_CHAR_ERROR, "StrLib.intAsChar \u7684\u5f15\u6578\u5fc5\u9808\u662f 0 \u548c 255 \u4e4b\u9593\u7684\u6578\u5b57\u3002" },
		{ Message.INVALID_LOB_LENGTH, "{1} \u7684\u9577\u5ea6 {0}\uff08\u5927\u5c0f\u70ba {2}\uff09\u7121\u6548\u3002" },
		{ Message.INVALID_LOB_POSITION, "\u5c0d {1} \u800c\u8a00\uff0c{0} \u4f4d\u7f6e\u7121\u6548\u3002\u5176\u5927\u5c0f\u70ba {2}\u3002" },
		{ Message.LOB_ERROR, "\u8655\u7406 Blob \u6216 Clob \u9805\u76ee\u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\u8a0a\u606f\u70ba {0}" },
		{ Message.START_TRANSACTION_ERROR, "VGLib.startTransaction \u81f3 {0} \u985e\u5225\u5931\u6557\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {1}\u3002" },
		{ Message.INT_AS_UNICODE_ERROR, "StrLib.intAsUnicode \u7684\u5f15\u6578\u5fc5\u9808\u662f 0 \u548c 65535 \u4e4b\u9593\u7684\u6578\u5b57\u3002" },
		{ Message.INVALID_ARRAY_SIZE, "{1} \u9663\u5217\u7684\u5927\u5c0f\u503c {0} \u7121\u6548\u3002\u5927\u5c0f\u4e0a\u9650\u662f {2}\u3002" },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "\u7d22\u5f15 {0} \u8d85\u51fa {1} \u9663\u5217\u7684\u754c\u9650\u3002\u9663\u5217\u5927\u5c0f\u70ba {2}\u3002" },
		{ Message.INVALID_SUBSTRING_INDEX, "\u7121\u6548\u7684\u5b50\u5b57\u4e32\u7d22\u5f15 {0}:{1}\u3002" },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "{0} \u9663\u5217\u7684\u51fd\u6578\u5f15\u6578\u7121\u6548\u3002" },
		{ Message.INDEX_OUT_OF_BOUNDS, "{0} \u7d22\u5f15\u503c\u8d85\u51fa\u754c\u9650\u3002" },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "\u4e0d\u652f\u63f4 {0} \u8f49\u63db\u8868\u3002" },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "\u7121\u6cd5\u8b80\u53d6 csouidpwd.properties \u6a94\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "\u7528\u6236\u7aef\u7684\u7de9\u885d\u5340\u592a\u5c0f\uff0c\u7121\u6cd5\u5bb9\u7d0d\u547c\u53eb\u6642\u6240\u50b3\u905e\u7684\u8cc7\u6599\u91cf\u3002\u8981\u50b3\u905e\u7684\u53c3\u6578\u7684\u7d2f\u7a4d\u5927\u5c0f\u70ba {0} \u4f4d\u5143\u7d44\uff0c\u8d85\u904e\u4e86\u5141\u8a31\u7684\u4e0a\u9650 - {1} \u4f4d\u5143\u7d44\u3002" },
		{ Message.INVALID_PARMFORM, "parmForm \u93c8\u7d50\u5167\u5bb9\u5fc5\u9808\u8a2d\u70ba COMMPTR \u624d\u80fd\u547c\u53eb {0} \u7a0b\u5f0f\uff0c\u56e0\u70ba\u81f3\u5c11\u6709\u4e00\u500b\u53c3\u6578\u70ba\u52d5\u614b\u9663\u5217\u3002" },
		{ Message.PARM_PASSING_ERROR, "\u50b3\u905e\u53c3\u6578\u7d66\u88ab\u547c\u53eb\u7684\u7a0b\u5f0f {0} \u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.CALL_ERROR, "\u547c\u53eb {0} \u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} \u662f System i \u670d\u52d9\u7a0b\u5f0f\u4e0d\u53d7\u652f\u63f4\u7684\u53c3\u6578\u985e\u578b\u3002" },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} \u662f System i \u670d\u52d9\u7a0b\u5f0f\u4e0d\u53d7\u652f\u63f4\u7684\u50b3\u56de\u985e\u578b\u3002" },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "\u7121\u6cd5\u53d6\u5f97 ConnectionFactory\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "\u7121\u6cd5\u95dc\u9589\u300c\u4e92\u52d5\u300d\u6216\u300c\u9023\u7dda\u300d\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.ERROR_GETTING_CONNECTION, "\u7121\u6cd5\u5efa\u7acb\u9023\u7dda\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.ERROR_GETTING_INTERACTION, "\u7121\u6cd5\u53d6\u5f97\u4e92\u52d5\u4f5c\u696d\u3002\u7570\u5e38\u72c0\u6cc1\u70ba\uff1a{0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "\u7121\u6cd5\u8a2d\u5b9a\u4e92\u52d5\u4f5c\u696d\u52d5\u8a5e\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "\u7121\u6cd5\u53d6\u5f97\u7528\u6236\u7aef\u5de5\u4f5c\u55ae\u4f4d\u7684 LocalTransaction\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "\u7121\u6cd5\u5728 CICSJ2C \u547c\u53eb\u4e0a\u8a2d\u5b9a\u903e\u6642\u503c\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "\u8a66\u5716\u8207 CICS \u901a\u8a0a\u671f\u9593\u767c\u751f\u932f\u8aa4\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "\u8a66\u5716\u57f7\u884c\u9060\u7aef CICS \u4ea4\u6613\u5931\u6557\u3002" },
		{ Message.EXCEPTION_CALLING_IMS, "\u8a66\u8457\u548c IMS \u901a\u8a0a\u6642\u767c\u751f\u932f\u8aa4\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "\u8a66\u8457\u548c IMS \u901a\u8a0a\u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.MATH_DOMAIN_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\uff08\u7db2\u57df\u932f\u8aa4\uff09\u3002\u51fd\u6578\u7684\u5f15\u6578\u7121\u6548\u3002" },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\uff08\u7db2\u57df\u932f\u8aa4\uff09\u3002\u5f15\u6578\u5fc5\u9808\u4ecb\u65bc -1 \u548c 1 \u4e4b\u9593\u3002" },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\uff08\u7db2\u57df\u932f\u8aa4\uff09\u3002\u7b2c\u4e8c\u500b\u5f15\u6578\u4e0d\u80fd\u70ba\u96f6\u3002" },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\uff08\u7db2\u57df\u932f\u8aa4\uff09\u3002\u5f15\u6578\u5fc5\u9808\u5927\u65bc\u96f6\u3002" },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\uff08\u7db2\u57df\u932f\u8aa4\uff09\u3002\u5982\u679c\u7b2c\u4e00\u500b\u5f15\u6578\u70ba\u96f6\uff0c\u5247\u7b2c\u4e8c\u500b\u5f15\u6578\u5fc5\u9808\u5927\u65bc\u96f6\u3002" },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\uff08\u7db2\u57df\u932f\u8aa4\uff09\u3002\u5982\u679c\u7b2c\u4e00\u500b\u5f15\u6578\u5c0f\u65bc\u96f6\uff0c\u5247\u7b2c\u4e8c\u500b\u5f15\u6578\u5fc5\u9808\u70ba\u6574\u6578\u3002" },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\uff08\u7db2\u57df\u932f\u8aa4\uff09\u3002\u5f15\u6578\u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc\u96f6\u3002" },
		{ Message.MATH_RANGE_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 12\uff08\u7bc4\u570d\u932f\u8aa4\uff09\u3002" },		
		{ Message.STRING_INDEX_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 8\u3002\u7d22\u5f15\u5fc5\u9808\u4ecb\u65bc 1 \u548c\u5b57\u4e32\u7684\u9577\u5ea6\u3002" },
		{ Message.STRING_LENGTH_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 12\u3002\u9577\u5ea6\u5fc5\u9808\u5927\u65bc\u96f6\u3002" },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator \u5931\u6557\uff0c\u932f\u8aa4\u78bc 16\u3002\u76ee\u6a19\u5b57\u4e32\u7684\u6700\u5f8c\u4e00\u500b\u4f4d\u5143\u7d44\u5fc5\u9808\u662f\u7a7a\u767d\u6216\u7a7a\u5b57\u5143\u3002" },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 20\u3002STRING\u3001DBCHAR \u6216 UNICODE \u5b50\u5b57\u4e32\u7684\u7d22\u5f15\u5fc5\u9808\u662f\u5947\u6578\uff0c\u5982\u6b64\u4e00\u4f86\uff0c\u9019\u500b\u7d22\u5f15\u624d\u6703\u8b58\u5225\u5b57\u5143\u7684\u7b2c\u4e00\u500b\u4f4d\u5143\u7d44\u3002" },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} \u5931\u6557\uff0c\u932f\u8aa4\u78bc 24\u3002STRING\u3001DBCHAR \u6216 UNICODE \u5b50\u5b57\u4e32\u7684\u9577\u5ea6\u5fc5\u9808\u662f\u5076\u6578\uff0c\u4ee5\u4ee3\u8868\u5b57\u5143\u7684\u7e3d\u6578\u3002" },
		{ Message.NO_DEBUG_LISTENER, "\u7121\u6cd5\u5728\u4e3b\u6a5f\u540d\u7a31 {0} \u548c\u57e0 {1} \u4e0a\u9023\u63a5\u5230 EGL \u9664\u932f\u5668\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "\u8207\u4e3b\u6a5f\u540d\u7a31 {0} \u548c\u57e0 {1} \u4e0a\u7684 EGL \u9664\u932f\u5668\u901a\u8a0a\u6642\u767c\u751f\u932f\u8aa4\u3002\u7570\u5e38\u72c0\u6cc1\u70ba {2}" },
		{ Message.NOT_DEBUG_MODE, "\u93c8\u7d50\u5728 J2EE \u4f3a\u670d\u5668\u5167\u6307\u5b9a DEBUG \u547c\u53eb\u3002J2EE \u4f3a\u670d\u5668\u4e0a\u672a\u57f7\u884c\u547c\u53eb\u3001J2EE \u4f3a\u670d\u5668\u4e0d\u5728\u9664\u932f\u6a21\u5f0f\u4e0b\uff0c\u6216 J2EE \u4f3a\u670d\u5668\u672a\u555f\u7528 EGL \u9664\u932f\u3002" },
		{ Message.LIBRARY_NOT_SPECIFIED, "\u93c8\u7d50\u6307\u5b9a\u5c0d EGL \u63a5\u807d\u5668\u7684 DEBUG \u547c\u53eb\uff0c\u4f46\u672a\u6307\u5b9a\u7a0b\u5f0f\u5eab\u5167\u5bb9\u3002" },
		
		{ Message.FILETYPE_MISSING, "\u627e\u4e0d\u5230 {0} \u6a94\u7684\u57f7\u884c\u6642\u671f\u5167\u5bb9 vgj.ra.fileName.fileType\u3002" },
		{ Message.FILETYPE_INVALID, "{0} \u6a94\u7684 vgj.ra.fileName.fileType \u57f7\u884c\u6642\u671f\u5167\u5bb9\u503c\u7121\u6548\u3002" },
		{ Message.INVALID_RECORD_LENGTH, "\u8a18\u9304\u9577\u5ea6\u9805\u76ee\u5fc5\u9808\u542b\u6709\u5728\u9805\u76ee\u754c\u9650\u4e0a\u5206\u5272\u975e\u5b57\u5143\u8cc7\u6599\u7684\u503c\u3002" },
		{ Message.RECORD_LENGTH_TOO_LARGE, "occursItem \u6216 lengthItem \u4e2d\u7684\u503c\u592a\u5927\u3002" },
		{ Message.IO_ERROR, "{0}\uff1a{1} \u7684 I/O \u5931\u6557\uff0c\u539f\u56e0\uff1a{2}\u3002" },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}\uff1a\u627e\u4e0d\u5230\u5099\u59a5\u9673\u8ff0\u5f0f {1}[sql \u9673\u8ff0\u5f0f\uff1a{2}][SQL \u7a0b\u5f0f\u78bc\uff1a{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}\uff1a\u627e\u4e0d\u5230\u7d50\u679c\u96c6 {1}[SQL \u9673\u8ff0\u5f0f\uff1a{2}][SQL \u7a0b\u5f0f\u78bc\uff1a{3}]" },
		{ Message.SQL_ERROR, "{0}\uff1a\u932f\u8aa4[SQL \u9673\u8ff0\u5f0f\uff1a{1}][SQL \u7a0b\u5f0f\u78bc\uff1a{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [SQL \u9673\u8ff0\u5f0f\uff1a02000][SQL \u7a0b\u5f0f\u78bc\uff1a100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}\uff1a{1}[SQL \u9673\u8ff0\u5f0f\uff1a{2}][SQL \u7a0b\u5f0f\u78bc\uff1a{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "\u7121\u6cd5\u9023\u63a5 {0}\uff1a{1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "\u7121\u6cd5\u9023\u63a5 {0}\uff0c\u8cc7\u6599\u5eab URL \u53ef\u80fd\u4e0d\u6b63\u78ba\uff1a{1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "\u8f09\u5165 JDBC \u9a45\u52d5\u7a0b\u5f0f\u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "{0} \u7d50\u679c\u96c6\u7121\u6cd5\u6372\u52d5\u3002" },
		{ Message.SQL_NO_DEFAULT_DATABASE, "\u7121\u6cd5\u9023\u63a5\u9810\u8a2d\u8cc7\u6599\u5eab\u3002\u672a\u6307\u5b9a\u9810\u8a2d\u8cc7\u6599\u5eab\u7684\u540d\u7a31\u3002" },
		{ Message.SQL_NO_DATABASE_CONNECTION, "\u5728\u57f7\u884c SQL I/O \u4f5c\u696d\u524d\u5fc5\u9808\u5148\u5efa\u7acb\u8cc7\u6599\u5eab\u9023\u7dda\u3002" },
		{ Message.SQL_DISCONNECT_ERROR, "\u5207\u65b7 {0} \u8cc7\u6599\u5eab\u9023\u7dda\u6642\u767c\u751f\u932f\u8aa4\u3002{1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "\u7121\u6cd5\u8a2d\u5b9a\u548c {0} \u8cc7\u6599\u5eab\u9593\u7684\u9023\u7dda\u3002\u9023\u7dda\u4e0d\u5b58\u5728\u3002" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "\u51fd\u6578 SQLLib.{0} \u767c\u751f SQL \u932f\u8aa4\uff1a{1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "\u51fd\u6578 SQLLib.{0} \u767c\u751f\u975e SQL \u932f\u8aa4\uff1a{1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "\u5f9e\u8cc7\u6599\u5eab\u6536\u5230\u7a7a\u503c\uff0c\u4f46\u4e3b\u8b8a\u6578 {0} \u4e0d\u53ef\u70ba\u7a7a\u503c\u3002" },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "\u672a\u5728\u5fc5\u8981\u6b04\u4f4d\u4e2d\u8f38\u5165 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "\u8f38\u5165\u4e2d\u7684\u8cc7\u6599\u985e\u578b\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "\u8d85\u904e\u5bb9\u8a31\u7684\u6709\u6548\u4f4d\u6578 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "\u8f38\u5165\u672a\u5728\u5b9a\u7fa9\u7684\u7bc4\u570d\uff08{0} \u81f3 {1}\uff09\u5167 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_VALID_VALUES_ERR, "\u8f38\u5165\u672a\u5728\u5b9a\u7fa9\u7684\u6709\u6548\u503c\u6e05\u55ae\u5167 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "\u6307\u5b9a\u7684\u65e5\u671f\u548c\u6642\u9593\u683c\u5f0f {0} \u7121\u6548\u3002" },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "\u8f38\u5165\u9577\u5ea6\u4e0b\u9650\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "\u8f38\u5165\u9577\u5ea6\u4e0a\u9650\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "\u8868\u683c\u7de8\u8f2f\u6709\u6548\u6027\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "\u8f38\u5165\u4e2d\u767c\u751f\u6a21\u7d44\u6aa2\u67e5\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "\u5c0d\u6240\u5b9a\u7fa9\u7684\u65e5\u671f\u6216\u6642\u9593\u683c\u5f0f {0} \u4f86\u8aaa\uff0c\u8f38\u5165\u7121\u6548\u3002" },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "\u5c0d Boolean \u6b04\u4f4d\u4f86\u8aaa\uff0c\u8f38\u5165\u7121\u6548\u3002" },
		{ Message.EDIT_INVALID_PATTERN_ERR, "\u6240\u8f38\u5165\u7684\u503c\u7121\u6548\uff0c\u56e0\u70ba\u5b83\u4e0d\u7b26\u5408\u6240\u8a2d\u7684\u578b\u6a23\u3002" },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "\u672a\u5b9a\u7fa9 {1} \u7684\u7de8\u8f2f\u8868\u683c {0}\u3002" },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "\u5341\u516d\u9032\u4f4d\u8cc7\u6599\u7121\u6548\u3002" },
		{ Message.EDIT_VALIDATION_ERR, "\u767c\u751f\u9801\u9762\u9a57\u8b49\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{0}\u3002" },
		{ Message.EDIT_INPUT_ERR, "\u5256\u6790\u8f38\u5165\u503c\u6642\u767c\u751f\u932f\u8aa4\u3002"},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "\u5c07\u503c\u683c\u5f0f\u5316\u4ee5\u4fbf\u986f\u793a\u6642\uff0c\u767c\u751f\u932f\u8aa4\uff1a{0}\u3002"},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "\u5c0d\u6240\u5b9a\u7fa9\u7684\u9805\u76ee\u9577\u5ea6\u4f86\u8aaa\uff0c\u5167\u542b SO/SI \u5b57\u5143\u7684\u8f38\u5165\u8cc7\u6599\u592a\u9577\u3002"},
		
		{ Message.ACTION_REQUEST_ERROR, "J2EELib RequestAttr \u51fd\u6578\u5931\u6557\uff0c\u7d22\u5f15\u9375 {0}\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.ACTION_SESSION_ERROR, "J2EELib SessionAttr \u51fd\u6578\u5931\u6557\uff0c\u7d22\u5f15\u9375 {0}\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.ACTION_APPLICATION_ERROR, "J2EELib ApplicationAttr \u51fd\u6578\u5931\u6557\uff0c\u7d22\u5f15\u9375 {0}\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib \u53ea\u80fd\u7528\u65bc J2EE \u74b0\u5883\u3002" },
		
		{ Message.PORTALLIB_SESSION_ERROR, "PortalLib PortletSessionAttr \u51fd\u6578\u5931\u6557\uff0c\u7d22\u5f15\u9375 {0}\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode \u5931\u6557\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState \u5931\u6557\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "\u5728\u5448\u73fe\u8981\u6c42\u671f\u9593\uff0c\u4e0d\u80fd\u5617\u8a66\u8b8a\u66f4 Portlet \u6a21\u5f0f\u3002" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "\u5728\u5448\u73fe\u8981\u6c42\u671f\u9593\uff0c\u4e0d\u80fd\u5617\u8a66\u8b8a\u66f4 Portlet \u8996\u7a97\u3002" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "\u7121\u6cd5\u53d6\u5f97 PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "\u50b3\u905e\u7d66\u51fd\u6578 {0} \u7684\u7d22\u5f15\u9375\u7121\u6548" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "\u7121\u6cd5\u53d6\u5f97 PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "PortalLib resetPreferenceValue \u51fd\u6578\u5931\u6557\uff0c\u7d22\u5f15\u9375 {0}\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "PortalLib savePreferences \u51fd\u6578\u5931\u6557\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib \u7121\u6cd5\u8a2d\u5b9a\u7d22\u5f15\u9375 {0} \u7684\u559c\u597d\u8a2d\u5b9a\u3002\u932f\u8aa4\uff1a{1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib \u7121\u6cd5\u53d6\u5f97\u7d22\u5f15\u9375 {0} \u7684\u559c\u597d\u8a2d\u5b9a\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "\u7121\u6cd5\u5b58\u53d6\u300c\u8a8d\u8b49\u5132\u5b58\u5eab\u670d\u52d9\u300d\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "\u7121\u6cd5\u5728\u69fd {0} \u4e2d\u5b58\u53d6\u6240\u8981\u6c42\u7684\u8a8d\u8b49\u3002\u932f\u8aa4\uff1a{1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "\u7121\u6cd5\u5728\u4f7f\u7528\u8005\u7a7a\u9593\u4e2d\u5efa\u7acb\u300c\u8a8d\u8b49\u5132\u5b58\u5eab\u300d\u69fd\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "\u7121\u6cd5\u5728\u4f7f\u7528\u8005\u7a7a\u9593\u4e2d\u522a\u9664\u300c\u8a8d\u8b49\u5132\u5b58\u5eab\u300d\u69fd\u3002\u932f\u8aa4\uff1a{0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "\u7121\u6cd5\u8a2d\u5b9a\u300c\u8a8d\u8b49\u300d\u503c\u3002\u932f\u8aa4\uff1a{0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} \u5931\u6557\u3002\u547c\u53eb\u65b9\u6cd5\u6216\u5b58\u53d6\u6b04\u4f4d {1} \u5c0e\u81f4\u7121\u6cd5\u8655\u7406\u7684\u932f\u8aa4\u3002\u932f\u8aa4\u8a0a\u606f\u70ba {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} \u5931\u6557\u3002{1} \u4e0d\u662f ID \u6216\u70ba\u7a7a\u503c\u7269\u4ef6\u7684 ID\u3002" },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} \u5931\u6557\u3002\u516c\u7528\u65b9\u6cd5\u3001\u6b04\u4f4d\u6216\u985e\u5225 {1} \u4e0d\u5b58\u5728\u6216\u7121\u6cd5\u8f09\u5165\uff0c\u6216\u53c3\u6578\u7684\u500b\u6578\u6216\u985e\u578b\u4e0d\u6b63\u78ba\u3002\u932f\u8aa4\u8a0a\u606f\u70ba {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} \u5931\u6557\u3002EGL \u4e2d\u7684\u503c\u985e\u578b\u4e0d\u7b26\u5408 Java for {1} \u9810\u671f\u7684\u985e\u578b\u3002\u932f\u8aa4\u8a0a\u606f\u70ba {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} \u5931\u6557\u3002\u76ee\u6a19\u662f\u50b3\u56de\u7a7a\u503c\u7684\u65b9\u6cd5\u3001\u4e0d\u50b3\u56de\u503c\u7684\u65b9\u6cd5\u6216\u542b\u6709\u7a7a\u503c\u7684\u6b04\u4f4d\u3002" },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} \u5931\u6557\u3002\u7121\u6cd5\u8f09\u5165\u7a7a\u503c\u5f15\u6578\u7684\u985e\u5225 {1}\u3002\u932f\u8aa4\u8a0a\u606f\u70ba {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} \u5931\u6557\u3002\u7121\u6cd5\u53d6\u5f97\u65b9\u6cd5\u6216\u6b04\u4f4d {1} \u7684\u76f8\u95dc\u8cc7\u8a0a\uff0c\u6216\u8a66\u5716\u8a2d\u5b9a\u4ee5 final \u5ba3\u544a\u4e4b\u6b04\u4f4d\u7684\u503c\u3002\u932f\u8aa4\u8a0a\u606f\u70ba {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} \u5931\u6557\u3002{1} \u662f\u4ecb\u9762\u6216\u62bd\u8c61\u985e\u5225\uff0c\u7121\u6cd5\u547c\u53eb\u5efa\u69cb\u5b50\u3002" },
		{ Message.JAVALIB_NOT_STATIC, "{0} \u5931\u6557\u3002\u65b9\u6cd5\u6216\u6b04\u4f4d {1} \u4e0d\u662f static\u3002\u5fc5\u9808\u4f7f\u7528 ID \u4f86\u4ee3\u66ff\u985e\u5225\u540d\u7a31\u3002" },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "{0} \u52d5\u4f5c\u6b04\u4f4d\u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_ARRAY_FULL, "\u7121\u6cd5\u63d2\u5165\u53e6\u4e00\u5217\uff0c\u56e0\u70ba\u8f38\u5165\u9663\u5217\u5df2\u6eff\u3002" },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "\u627e\u4e0d\u5230 {0} \u9663\u5217\u3002" },
		{ Message.CUI_E_ASSIGN_RESULT, "\u6307\u6d3e\u7d66\u63d0\u793a\u7d50\u679c\u8b8a\u6578\u5931\u6557\u3002" },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "\u300c\u87a2\u5e55\u9663\u5217\u300d\u6b04\u4f4d\u7684 {0} \u5927\u5c0f\u4e0d\u6b63\u78ba\u3002"	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "DrawBox \u53c3\u6578\u8d85\u51fa\u7bc4\u570d\u3002" },
		{ Message.CUI_E_BAD_COORDINATES, "\u986f\u793a\u5ea7\u6a19\u843d\u5728\u8996\u7a97\u754c\u9650\u5916\u3002" },
		{ Message.CUI_E_BAD_KEYNAME, "\u5f62\u614b\u7570\u5e38\u7684\u7d22\u5f15\u9375\u540d\u7a31 ''{0}''\u3002" },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "\u60a8\u7121\u6cd5\u4f7f\u7528\u9019\u500b\u7de8\u8f2f\u7279\u6027\uff0c\u56e0\u70ba\u6709\u5716\u7247\u5b58\u5728" },
		{ Message.CUI_E_BAD_WINDOW_NAME, "\u627e\u4e0d\u5230\u8996\u7a97 ''{0}''\u3002" },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "\u65b0\u8996\u7a97\u4f4d\u7f6e[{0},{1}]/\u7dad\u5ea6[{2},{3}] \u503c\u7121\u6548\u3002" },
		{ Message.CUI_E_CMDSTACK_SYNC, "\u6307\u4ee4\u5806\u758a\u4e0d\u540c\u6b65\u3002" },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "\u4e3b\u63a7\u53f0 UI \u7a0b\u5f0f\u5eab\u672a\u8d77\u59cb\u8a2d\u5b9a\u3002" },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "\u5efa\u69cb\u7684\u6b04\u4f4d\u985e\u578b\u4e0d\u5408\u6cd5\u3002" },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "\u7121\u6cd5\u4f7f\u7528\u8b8a\u6578\u6e05\u55ae\u4f86\u547c\u53eb ConstructQuery\u3002" },
		{ Message.CUI_E_DISABLE_INVISIBLE, "\u7121\u6cd5\u505c\u7528\u96b1\u85cf\u7684\u529f\u80fd\u8868\u9805\u76ee\u3002" },
		{ Message.CUI_E_EDIT_FAILED, "\u7de8\u8f2f\u52d5\u4f5c\u5931\u6557\u3002" },
		{ Message.CUI_E_EXEC_HOTKEY, "\u57f7\u884c\u5feb\u901f\u9375\u52d5\u4f5c\u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.CUI_E_EXIT_NO_CMD, "\u6c92\u6709\u4f5c\u7528\u4e2d\u6307\u4ee4\u53ef\u4f9b\u8df3\u96e2\u3002" },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "\u6c92\u6709\u4f5c\u7528\u4e2d\u6307\u4ee4\u53ef\u4f9b\u7e7c\u7e8c\u9032\u884c\u3002" },
		{ Message.CUI_E_FATALERROR, "\u56b4\u91cd\u932f\u8aa4\uff1a{0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "{0} \u6b04\u4f4d\u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "{0} \u87a2\u5e55\u9663\u5217\u6b04\u4f4d\u4e0d\u662f\u9663\u5217\u3002" },
		{ Message.CUI_E_FIELD_NOT_FOUND, "\u627e\u4e0d\u5230 {0} \u6b04\u4f4d\u3002" },
		{ Message.CUI_E_FIELD_NO_WINDOW, "\u6c92\u6709\u8996\u7a97\uff0c\u7121\u6cd5\u5efa\u7acb ConsoleField\u3002" },
		{ Message.CUI_E_FIELD_COUNT, "\u9663\u5217\u6b04\u4f4d\u8a08\u6578\u4e0d\u7b26\u3002" },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "{0} \u8868\u55ae\u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "{0} \u8868\u55ae\u4e0d\u7b26\u5408 {1} \u8996\u7a97\u5927\u5c0f\u3002" },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "\u6b04\u4f4d\u6e05\u55ae\u4e0d\u76f8\u7b26\u3002" },
		{ Message.CUI_E_FORM_IN_USE, "{0} \u8868\u55ae\u5fd9\u788c\u4e2d\u3002" },
		{ Message.CUI_E_FORM_NAME_USED, "\u5df2\u5b58\u5728\u540d\u70ba {0} \u7684\u8868\u55ae\u3002" },
		{ Message.CUI_E_FORM_NOT_OPEN, "\u672a\u958b\u555f {0} \u8868\u55ae\u3002" },
		{ Message.CUI_E_FORM_NO_WINDOW, "\u6c92\u6709\u8996\u7a97\uff0c\u7121\u6cd5\u5efa\u7acb ConsoleForm\u3002" },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "\u7121\u6cd5\u5728\u865b\u64ec\u9375\u4e0a\u4f7f\u7528 KeyObject.getChar()\u3002" },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "\u7121\u6cd5\u5728\u865b\u64ec\u9375\u4e0a\u4f7f\u7528 KeyObject.getCookedChar()\u3002" },
		{ Message.CUI_E_INTERNAL, "\u5167\u90e8\u932f\u8aa4\uff1a{0}" },
		{ Message.CUI_E_INTR_RECEIVED, "\u6536\u5230 INTERRUPT \u4fe1\u865f\u3002" },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "\u6c92\u6709\u52a0\u901f\u5668\uff0c\u800c\u7121\u6cd5\u5177\u6709\u96b1\u85cf\u7684\u529f\u80fd\u8868\u9805\u76ee\u3002" },
		{ Message.CUI_E_LABEL_NO_WINDOW, "\u6c92\u6709\u8996\u7a97\uff0c\u7121\u6cd5\u5efa\u7acb ConsoleLabel\u3002" },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "{0} \u529f\u80fd\u8868\u9805\u76ee\u4e0d\u7b26\u5408\u8996\u7a97\u5927\u5c0f\u3002" },
		{ Message.CUI_E_MISSING_ITEM, "{0} \u529f\u80fd\u8868\u9805\u76ee\u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "\u529f\u80fd\u8868\u52a9\u8a18\u9375\u885d\u7a81\uff08\u6309\u9375={0}\uff09\u3002" },
		{ Message.CUI_E_NO_ACTIVE_FORM, "\u6c92\u6709\u4f5c\u7528\u4e2d\u8868\u55ae\u3002" },
		{ Message.CUI_E_NO_EDITOR, "\u672a\u6307\u5b9a blob \u7de8\u8f2f\u5668\u3002" },
		{ Message.CUI_E_NO_HELP_FILE, "\u672a\u6307\u5b9a\u8aaa\u660e\u6a94\u3002" },
		{ Message.CUI_E_NO_HELP_MSG, "\u672a\u6307\u5b9a\u8aaa\u660e\u8a0a\u606f\u3002" },
		{ Message.CUI_E_NO_NUMPAGES, "\u672a\u4f48\u7f6e\u529f\u80fd\u8868\u3002" },
		{ Message.CUI_E_NO_SCREENARRAY, "\u6c92\u6709\u4f5c\u7528\u4e2d\u7684\u87a2\u5e55\u9663\u5217\u3002" },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "\u6c92\u6709\u53ef\u898b\u7684\u529f\u80fd\u8868\u9805\u76ee\u3002" },
		{ Message.CUI_E_NULL_WNDOW_NAME, "\u65b0\u8996\u7a97\u7684\u540d\u7a31\u70ba\u7a7a\u503c\u3002" },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "\u8a66\u5716\u958b\u555f\u7a7a\u503c\u8996\u7a97\u3002" },
		{ Message.CUI_E_PROMPT_EXCEPTION, "\u63d0\u793a\u4e2d\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002" },
		{ Message.CUI_E_QUIT_RECEIVED, "\u6536\u5230 QUIT \u4fe1\u865f\u3002" },
		{ Message.CUI_E_SCROLL_FAILED, "\u529f\u80fd\u8868\u7121\u6cd5\u6372\u52d5\u81f3\u73fe\u884c\u9805\u76ee\u3002" },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "\u4e0d\u660e\u5c6c\u6027 ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "{0} \u6b04\u4f4d\u4e2d\u6709\u932f\u8aa4\u3002" },
		{ Message.CUI_E_VAR_LIST_SHORT, "\u672a\u63d0\u4f9b\u8db3\u5920\u7684\u8b8a\u6578\u3002" },
		{ Message.CUI_E_WINDOW_NAME_USED, "{0} \u8996\u7a97\u540d\u7a31\u5df2\u5728\u4f7f\u7528\u4e2d\u3002" },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "\u5c0d\u8aaa\u660e\u756b\u9762\u4f86\u8aaa\uff0c\u8996\u7a97\u592a\u5c0f\u3002" },
		{ Message.CUI_E_VALID_VALUES, "\u6307\u5b9a\u7684\u503c\u4e0d\u662f\u6709\u6548\u503c\u3002" },
		{ Message.CUI_W_NO_MORE_FIELDS, "\u60a8\u7684\u884c\u9032\u65b9\u5411\u4e2d\u5df2\u7121\u5176\u4ed6\u6b04\u4f4d\u3002" },
		{ Message.CUI_W_NO_MORE_ROWS, "\u60a8\u7684\u884c\u9032\u65b9\u5411\u4e2d\u5df2\u7121\u5176\u4ed6\u5217\u3002" },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "{0} \u87a2\u5e55\u9663\u5217\u5167\u5bb9\u7121\u6548\u3002" },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "{0} \u87a2\u5e55\u9663\u5217\u4e0d\u80fd\u5305\u542b {1} \u5206\u6bb5\u6b04\u4f4d\u3002"	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "{0} \u87a2\u5e55\u9663\u5217\u548c\u8cc7\u6599\u9663\u5217\u4e0d\u76f8\u5bb9\u3002" },
		{ Message.CUI_E_FIELD_NAME_DUP, "{0} \u6b04\u4f4d\u540d\u7a31\u4f7f\u7528\u4e86\u591a\u6b21\u3002" },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "{0} \u4e3b\u63a7\u53f0\u6b04\u4f4d\u9577\u5ea6\u7121\u6548\u3002" },
		{ Message.CUI_E_LABEL_NOT_FIT, "\u4f4d\u65bc [{0}, {1}] \u7684\u6a19\u7c64\u4e0d\u7b26\u5408\u53ef\u7528\u7a7a\u9593\u7684\u5927\u5c0f\u3002" },
		{ Message.CUI_E_FIELD_NOT_FIT, "\u4f4d\u65bc ({1}, {2}) \u7684 {0} \u6b04\u4f4d\u5340\u6bb5\u4e0d\u7b26\u5408\u53ef\u7528\u7a7a\u9593\u7684\u5927\u5c0f\u3002" },
		{ Message.CUI_E_PROMPT_TOO_LONG,"\u5c0d\u4f5c\u7528\u4e2d\u8996\u7a97\u4f86\u8aaa\uff0c\u63d0\u793a\u5b57\u4e32\u592a\u9577\u3002"},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"OpenUI \u9663\u5217\u5f15\u6578\u7121\u6548\u3002"},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, " OpenUI \u6b04\u4f4d\u5f15\u6578\u7121\u6548\u3002"},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "\u53ea\u80fd\u6709\u4e00\u500b\u8b8a\u6578\u9023\u7d50\u81f3\u63d0\u793a\u9673\u8ff0\u5f0f\u3002" },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "\u7121\u6cd5\u5224\u65b7 {0} \u4e3b\u63a7\u53f0\u6b04\u4f4d\u7684\u8cc7\u6599\u9023\u7d50\u3002" },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "\u8b66\u544a\uff1a\u5728 clob \u8cc7\u6599\u4e2d\uff0c\u627e\u5230 NUL \u5b57\u5143" },
		{ Message.CUI_I_STR_WINDOWTITLE , "EGL \u4e3b\u63a7\u53f0\u8996\u7a97" },
		{ Message.CUI_E_MISSING_FORMAT , "{0} \u6b04\u4f4d\u6c92\u6709\u683c\u5f0f\u7269\u4ef6\u3002" },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "\u9019\u5169\u500b\u9805\u76ee\u4e0d\u540c -- \u8acb\u91cd\u8a66" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "\u8acb\u91cd\u65b0\u8f38\u5165\uff0c\u4ee5\u9032\u884c\u9a57\u8b49" },
		{ Message.CUI_I_STR_HELP,"\u8aaa\u660e"},
		{ Message.CUI_I_STR_RESUME,"\u56de\u5fa9"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"\u7d50\u675f\u9019\u500b\u8aaa\u660e\u968e\u6bb5\u4f5c\u696d\u3002"},
		{ Message.CUI_I_STR_SCROLL , "\u6372\u52d5" },
		{ Message.CUI_I_STR_LAST_PAGE, "\u60a8\u5df2\u5230\u9054\u8aaa\u660e\u6587\u5b57\u7684\u672b\u9801\u3002\u6309\u4e0b RETURN \u9375\u4ee5\u7e7c\u7e8c\u3002"},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "\u986f\u793a\u8aaa\u660e\u6587\u5b57\u7684\u4e0b\u4e00\u9801\u3002"},
		{ Message.CUI_I_STR_SELECT , "\u9078\u53d6"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "\u5728\u7a7a\u767d\u9663\u5217\u4e2d\u63d2\u5165\u7b2c\u4e00\u5217\u6642\u767c\u751f\u932f\u8aa4\u3002"},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "\u672a\u5be6\u4f5c F25-F64\u3002"},
		{ Message.CUI_E_UNIMP_FN_KEYS , "\u5167\u90e8\uff1a\u672a\u5be6\u4f5c F25-64" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "\u7121\u6cd5\u6709 CursesCanvas \u7684\u591a\u500b\u5be6\u4f8b" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "\u672a\u8d77\u59cb\u8a2d\u5b9a CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas \u592a\u5c0f"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "\u672a\u5be6\u4f5c\u4f9d\u540d\u7a31\u986f\u793a\u6b04\u4f4d\u3002"},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "\u81f3\u5c11\u9700\u8981 {0} \u8f38\u5165 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "\u8d85\u51fa\u6700\u5927\u8f38\u5165 {0} - \u8acb\u91cd\u65b0\u8f38\u5165\u3002" },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "\u7121\u6cd5\u958b\u555f Script \u6a94 ''{0}''\u3002" },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "\u7121\u6cd5\u8b80\u53d6 Script \u6a94\u3002"},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "\u5167\u5bb9 automation.scenario ''{0}'' \u4e0d\u662f\u76ee\u9304\u3002"},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "\u91cd\u65b0\u64ad\u653e Script \u4e2d\u7684 <click> \u6307\u5f15\u5f62\u614b\u7570\u5e38\u3002"},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "\u7121\u6cd5\u53d6\u5f97\u81ea\u52d5\u5316\u5167\u5bb9 ''{0}''\u3002"},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "\u9632\u6bc0\u7d22\u5f15\u9375\u540d\u7a31 ''{0}'' \u7121\u6548"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "<click> \u4e2d\u6709\u7570\u5e38\u72c0\u6cc1\u3002"},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "\u7121\u6cd5\u958b\u555f Snapshot \u6a94\u6848 ''{0}''"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "automation.scriptdir ''{0}'' \u7684\u5167\u5bb9\u96c6\u4e0d\u5b58\u5728\u3002"},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "\u7121\u6cd5\u5efa\u7acb automation.scenario \u76ee\u9304 ''{0}'' \u7684\u5167\u5bb9\u96c6\u3002"},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Snapshot \u7d22\u5f15\u9375\u540d\u7a31 ''{0}'' \u7121\u6548"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "\u6bd4\u8f03\u5b8c\u6210\u3002"},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "\u7576\u5728 RCP \u6a21\u5f0f\u4e0b\u57f7\u884c\u6642\uff0c\u4e0d\u5bb9\u8a31\u4f7f\u7528\u986f\u793a\u756b\u9762 I/O \u4f5c\u696d\u3002"},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "\u5728 {1} \u8a0a\u606f\u8868\u4e2d\u627e\u4e0d\u5230 {0} ID \u7684\u8a0a\u606f\u3002" },
		{ Message.MSG_TBL_LOAD_ERR, "\u7121\u6cd5\u8f09\u5165 {0} \u8a0a\u606f\u8868\u6a94\u6848\u3002" },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "\u672a\u5b9a\u7fa9 {0} VGUIRecord \u7684\u4f7f\u7528\u8005\u8a0a\u606f\u8868\u3002" },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "\u5728 ({1},{2}) \u4f4d\u7f6e\u4e0a\u7684\u6b04\u4f4d ''{0}'' \u4e0d\u5728\u8868\u55ae\u5167\u3002" },
		{ Message.TUI_E_FIELD_OVERLAP, "\u6b04\u4f4d ''{0}'' \u8207 ''{1}'' \u91cd\u758a\u3002" },
		{ Message.TUI_E_NO_FORMGROUP, "\u5167\u90e8\u932f\u8aa4\uff1a\u7121\u6cd5\u5224\u65b7\u8868\u55ae\u7fa4\u7d44\u3002" },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "\u8868\u55ae ''{0}'' \u7121\u6cd5\u586b\u5165\u4efb\u4f55\u6d6e\u52d5\u5340\u57df\u5167\u3002" },
		{ Message.TUI_E_BAD_FIELD_COORDS, "\u6b04\u4f4d ''{0}'' \u5ea7\u6a19\u7121\u6548\u3002" },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "\u7121\u6cd5\u53d6\u5f97\u5217\u5370\u95dc\u806f\u3002" },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "\u6c92\u6709\u9069\u5408\u7684\u5217\u5370\u88dd\u7f6e\u5927\u5c0f\u3002" },
		{ Message.TUI_E_NO_DISPLAY, "\u6c92\u6709\u8868\u55ae\u7684\u986f\u793a\u88dd\u7f6e\u3002" },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "\u6c92\u6709\u6240\u986f\u793a\u4e4b\u8868\u55ae\u7684\u76f8\u5bb9\u88dd\u7f6e\u5927\u5c0f\u3002" },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "\u8aaa\u660e\u8868\u55ae\u985e\u5225 ''{0}'' \u4e0d\u5b58\u5728\u3002" },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "\u4e0d\u660e\u5c6c\u6027 ''{0}''\u3002" },
		{ Message.TUI_E_INVALID_VALID_VALUE, "\u6307\u5b9a\u5728\u6709\u6548\u503c\u5c6c\u6027\u4e2d\u7684\u503c\u4e0d\u6b63\u78ba\u800c\u7121\u6cd5\u5256\u6790\u3002" },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "\u7121\u6cd5\u5efa\u7acb\u8aaa\u660e\u8868\u55ae ''{0}''" },
		{ Message.TUI_E_INTERNAL, "\u5167\u90e8\u932f\u8aa4\uff1a{0}" },
		{ Message.TUI_E_NO_PRINTERS, "\u6c92\u6709\u53ef\u7528\u7684\u5370\u8868\u6a5f\u3002" },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "\u6c92\u6709\u9810\u8a2d\u5370\u8868\u6a5f\u3002" },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "\u627e\u4e0d\u5230\u5370\u8868\u6a5f ''{0}''\u3002\n\u53ef\u7528\u7684\u5370\u8868\u6a5f\u70ba\uff1a\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "\u8f09\u5165\u8a0a\u606f ''{0}'' \u6642\u767c\u751f\u932f\u8aa4" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "{0} \u7684\u5167\u5bb9\u7121\u6cd5\u4f5c\u70ba\u6b04\u4f4d\u3002" },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "\u627e\u4e0d\u5230 ''{0}'' \u5370\u8868\u6a5f" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "\u7a0b\u5f0f {0} \u9810\u671f\u4f7f\u7528\u6587\u5b57\u8868\u55ae {1}\uff0c\u4f46\u5728 show \u9673\u8ff0\u5f0f\u4e2d\u6240\u63d0\u4f9b\u7684\u537b\u662f\u6587\u5b57\u8868\u55ae {2}\u3002" },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "\u4e0b\u4e00\u9801" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "\u7b2c {0} / {1} \u9801" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "\u4e0a\u4e00\u9801" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "\u5217\u5370" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "\u5217\u5370\u9810\u89bd - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "\u5132\u5b58" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "\u5132\u5b58\u5217\u5370\u5de5\u4f5c - {0}" },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "\u5217\u5370\u81f3\u6a94\u6848\u6642\u767c\u751f\u932f\u8aa4\uff1a{0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "\u5217\u5370\u81f3\u5370\u8868\u6a5f\u6642\u767c\u751f\u932f\u8aa4\uff1a{0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "\u8a2d\u5b9a ZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "\u9a57\u8b49\u6b04\u4f4d ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "\u9a57\u8b49\u6587\u5b57\u8868\u55ae" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "\u9a57\u8b49\u6587\u5b57\u8868\u55ae - \u57f7\u884c\u9a57\u8b49\u5668\u51fd\u6578 ''{0}''" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "\u7121\u6cd5\u5efa\u7acb\u65e5\u8a8c\u5beb\u5165\u5668\u3002" },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "\u555f\u52d5\u4e4b\u5f8c\u7121\u6cd5\u8a2d\u5b9a\u8a18\u8f09\u53c3\u6578 ''{0}''\u3002" },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Logdir ''{0}'' \u4e0d\u5b58\u5728\u3002" },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "\u7121\u6cd5\u5beb\u5165 logdir ''{0}''\u3002" },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "\u7121\u6cd5\u5efa\u7acb\u65e5\u8a8c\u6a94 ''{0}''\u3002" },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "\u7121\u6cd5\u5beb\u5165\u65e5\u8a8c\u6a94 ''{0}''\u3002" },
		
		{ Message.SOA_E_LOAD_SERVICE, "\u8f09\u5165\u5143\u4ef6/\u5916\u90e8\u670d\u52d9 {0} \u7684\u670d\u52d9\u6642\u767c\u751f\u554f\u984c\u3002" },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "\u5efa\u7acb Web \u670d\u52d9\u4f5c\u696d ''{0}'' \u7684\u9023\u7dda\u6642\u767c\u751f\u932f\u8aa4\u3002{1}\u3002" },
		{ Message.SOA_E_WS_GET_OPERATION, "\u5f9e WSDL \u6a94\u6848 ''{1}'' \u53d6\u5f97\u4f5c\u696d ''{0}'' \u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.SOA_E_WS_MALFORMED_URL, "{1} Web \u670d\u52d9\u4f5c\u696d\u7684\u76ee\u6a19 URL \u7121\u6548\u3002URL\uff1a{0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "\u8f09\u5165 {0} \u670d\u52d9\u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\uff1a{1}\u3002" },
		{ Message.SOA_E_LOAD_WEB_PROXY, "\u8a66\u8457\u8f09\u5165 Web \u670d\u52d9\u6642\u767c\u751f\u932f\u8aa4\u3002\u7121\u6cd5\u89e3\u6790\u5916\u90e8\u670d\u52d9 {0} \u7684 WSDL \u57e0\u3002" },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "{0} \u5143\u4ef6\u907a\u6f0f\u670d\u52d9\u5be6\u4f5c\u6240\u9700\u7684 {1} \u5167\u5bb9\u3002" },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "\u670d\u52d9\u53c3\u7167 ''{0}'' \u907a\u6f0f\u6216\u6c92\u6709\u76ee\u6a19\u503c\u3002" },
		{ Message.SOA_E_MISSING_BINDING, "\u90e8\u7f72\u63cf\u8ff0\u5b50 ''{1}'' \u4e2d\u4e0d\u5b58\u5728\u670d\u52d9\u9023\u7d50 ''{0}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "\u5617\u8a66\u5c07\u8a18\u9304 ''{0}'' \u8f49\u63db\u6210 SOAP \u8a0a\u606f\u6642\u767c\u751f\u932f\u8aa4\u3002\u5728\u8a18\u9304\u4e2d\u627e\u4e0d\u5230\u6b04\u4f4d ''{1}''\u3002" },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "\u5617\u8a66\u5c07 ''{0}'' \u8f49\u63db\u6210 SOAP \u8a0a\u606f\u6642\u767c\u751f\u932f\u8aa4\u3002"},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "\u8655\u7406 Web \u670d\u52d9\u50b3\u4f86\u7684\u5165\u57e0\u8a0a\u606f\u6642\u767c\u751f\u932f\u8aa4\u3002Java \u985e\u578b\u548c EGL \u985e\u578b\u4e0d\u76f8\u5bb9\u3002" },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "\u8655\u7406\u9001\u5f80 Web \u670d\u52d9\u7684\u96e2\u57e0\u8a0a\u606f\u6642\u767c\u751f\u932f\u8aa4\u3002EGL \u985e\u578b\u548c Java \u985e\u578b\u4e0d\u76f8\u5bb9" },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "\u7121\u6cd5\u8d77\u59cb\u8a2d\u5b9a\u8a18\u9304 ''{0}''\u3002" },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "\u7121\u6cd5\u5c07\u503c ''{0}'' \u8f49\u63db\u6210 Calendar\u3002" },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "\u7121\u6cd5\u5c07\u503c ''{0}'' \u8f49\u63db\u6210 boolean\u3002" },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "\u7121\u6cd5\u5c07\u503c ''{0}'' \u8f49\u63db\u6210 Byte\u3002" },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "\u7121\u6cd5\u5c07\u503c ''{0}'' \u8f49\u63db\u6210 short\u3002" },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "\u7121\u6cd5\u5c07\u503c ''{0}'' \u8f49\u63db\u6210 URI\u3002" },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "\u4e0d\u652f\u63f4\u5c07 EGL \u985e\u578b\u7576\u6210 Web \u670d\u52d9\u53c3\u6578\u3002" },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "\u8a66\u8457\u5efa\u7acb\u8a18\u9304\u9663\u5217\u6642\u767c\u751f\u932f\u8aa4\u3002{0}\u3002" },
		{ Message.SOA_E_METHOD_NOT_FOUND, "\u5728 {1} \u670d\u52d9\u4e2d\u627e\u4e0d\u5230 {0} \u65b9\u6cd5\u3002" },
		{ Message.SOA_E_NOT_WEB_SERVICE, "\u670d\u52d9\u4e0d\u662f Web \u670d\u52d9\u3002" },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "\u5617\u8a66\u5728 WebService {1} \u4e0a\u547c\u53eb\u51fd\u6578 {0} \u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "\u5617\u8a66\u5728 EGL \u670d\u52d9 {1} \u4e0a\u547c\u53eb\u51fd\u6578 {0} \u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "\u5617\u8a66\u5728 EGL \u670d\u52d9 {1} \u4e0a\u4f7f\u7528 {2}:{3} \u547c\u53eb\u51fd\u6578 {0} \u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "\u670d\u52d9\u4e0d\u662f tcpip \u670d\u52d9\u3002" },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "\u5617\u8a66\u5728\u9032\u5165\u9ede {1} \u4e0a\u547c\u53eb\u51fd\u6578 {0} \u6642\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "\u5617\u8a66\u8f09\u5165\u670d\u52d9\u9023\u7d50\u6a94 {0} \u6642\u767c\u751f\u932f\u8aa4\u3002{1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "\u5617\u8a66\u5728 CICS \u670d\u52d9 {1} \u4e0a\u547c\u53eb\u51fd\u6578 {0} \u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\u78bc\uff1a{2}\uff0c\u8a0a\u606f\uff1a{3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "\u5617\u8a66\u5728 iSeries \u670d\u52d9 {1} \u4e0a\u547c\u53eb\u51fd\u6578 {0} \u6642\u767c\u751f\u932f\u8aa4\u3002\u932f\u8aa4\u78bc\uff1a{2}\uff0c\u8a0a\u606f\uff1a{3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "\u670d\u52d9\u4e0d\u662f CICS \u670d\u52d9\u3002" },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "\u5728 {3} \u7cfb\u7d71\u4e0a\uff0c\u9060\u7aef\u670d\u52d9 {0} \u767c\u751f\u932f\u8aa4\uff0c\u65e5\u671f {1}\u3001\u6642\u9593 {2}\u3002" },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "\u5728\u7cfb\u7d71 {1} \u4e0a\uff0c\u9060\u7aef\u670d\u52d9 {0} \u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "\u8a66\u5716\u547c\u53eb {1} \u670d\u52d9\u6642\uff0c\u5728 {0} \u7cfb\u7d71\u4e0a\u767c\u751f\u61c9\u7528\u7a0b\u5f0f\u932f\u8aa4\uff0c\u5c0e\u81f4\u57f7\u884c\u55ae\u5143\u7d50\u675f\u3002\u8a0a\u606f\uff1a{2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "\u5728 {3} \u7cfb\u7d71\u4e0a\u547c\u53eb {2} \u670d\u52d9\u6642\uff0c\u767c\u751f AS400Toolbox \u57f7\u884c\u932f\u8aa4\uff1a{0}\uff0c{1}\u3002" },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "\u4e0d\u652f\u63f4\u7684\u670d\u52d9\u7528\u6236\u7aef\u9023\u7d50\u3002\u5df2\u70ba WebSphere \u7522\u751f {0}\uff0c\u4f46\u537b\u662f\u5f9e\u975e J2EE \u74b0\u5883\u4f86\u547c\u53eb\u3002\u8acb\u91cd\u65b0\u7522\u751f\u5230\u975e J2EE \u5c08\u6848\u4e2d\u3002" },
		{ Message.SOA_E_USER_ID_NOT_SET, "\u5728\u547c\u53eb WebService {0} \u51fd\u6578 {1} \u524d\uff0c\u5fc5\u9808\u5148\u8a2d\u5b9a\u9060\u7aef\u4f7f\u7528\u8005 ID \u8207\u5bc6\u78bc\u3002" },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "\u5728\u547c\u53eb\u670d\u52d9\u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002" },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "\u8207\u670d\u52d9\u901a\u8a0a\u6642\uff0c\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002URL\uff1a{0}" },
		{ Message.SOA_E_WS_PROXY_REST, "\u5728 REST \u670d\u52d9\u547c\u53eb\u671f\u9593\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u9023\u7d50\uff1a{0}\uff0c\u4f5c\u696d\uff1a{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "\u5728 SOAP \u670d\u52d9\u547c\u53eb\u671f\u9593\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u9023\u7d50\uff1a{0}\uff0c\u670d\u52d9\uff1a{1}\uff0c\u57e0\uff1a{2}\uff0cWSDL \u4f4d\u7f6e\uff1a{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "\u5f9e JSON \u8f49\u63db\u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u53c3\u6578\uff1a{0}\uff0cJSON\uff1a{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "\u8f49\u63db\u6210 JSON \u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u53c3\u6578\uff1a{0}\uff0c\u503c\uff1a{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "\u627e\u4e0d\u5230 REST-RPC \u670d\u52d9\u3002URL\uff1a{0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "\u672a\u6536\u5230\u670d\u52d9\u7684\u56de\u61c9\u3002URL\uff1a{0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "\u7121\u6cd5\u5c07\u8981\u6c42\u8f49\u63db\u6210\u670d\u52d9\u547c\u53eb\u3002\u6536\u5230\u7684\u8981\u6c42\u70ba ''{0}''\u3002" },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "\u670d\u52d9\u547c\u53eb\u767c\u751f\u903e\u6642\u3002\u7570\u5e38\u72c0\u6cc1\uff1a\u9023\u7dda\u8b80\u53d6\u903e\u6642\u932f\u8aa4\u3002URL\uff1a{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "\u670d\u52d9\u4e0d\u662f REST \u670d\u52d9\u3002" },
		{ Message.SOA_E_REST_SERVICE, "\u547c\u53eb REST \u670d\u52d9\u547c\u53eb\u5931\u6557\u3002\u9023\u7d50\uff1a{0}\uff0c\u4f5c\u696d\uff1a{1}\uff0cHTTP \u65b9\u6cd5\uff1a{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "\u5c07\u8cc7\u6599\u8f49\u63db\u6210 EGL \u53c3\u6578\u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u9023\u7d50\uff1a{0}\uff0c\u8981\u8f49\u63db\u7684\u8cc7\u6599\uff1a{1}\uff0c\u7570\u5e38\u72c0\u6cc1\uff1a{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "\u5728\u975e REST \u670d\u52d9\u53c3\u7167\u4e0a\u9032\u884c\u4e86 REST \u670d\u52d9\u547c\u53eb\u3002\u670d\u52d9\u53c3\u7167\uff1a{0}\uff0c\u4f5c\u696d\uff1a{1}\uff0cHTTP \u65b9\u6cd5\uff1a{2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "\u5f9e XML \u8f49\u63db\u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u907a\u6f0f\u5fc5\u8981\u5143\u7d20 {0}\u3002" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "\u5f9e XML \u8f49\u63db\u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u53c3\u6578\uff1a{0}\uff0cxml\uff1a{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "\u8f49\u63db\u6210 XML \u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u53c3\u6578\uff1a{0}\uff0c\u503c\uff1a{1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "\u5f9e XML \u8f49\u63db {0} \u6642\u767c\u751f XML \u5256\u6790\u7570\u5e38\u72c0\u6cc1\u3002" },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "\u5c07 {0} \u8f49\u63db\u6210 XML \u6642\u767c\u751f XML \u8f49\u63db\u7570\u5e38\u72c0\u6cc1\u3002" },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "\u7528\u65bc\u547c\u53eb\u670d\u52d9\u7684 URL ''{0}'' \u7121\u6548\u3002\u5b83\u4e0d\u5305\u542b http:// \u901a\u8a0a\u5354\u5b9a\u3002" },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "\u7528\u65bc\u547c\u53eb\u670d\u52d9\u7684 URL ''{0}'' \u7121\u6548\u3002{1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "\u7528\u65bc\u547c\u53eb\u670d\u52d9\u7684 URL \u662f\u7a7a\u7684\u3002\u8acb\u6307\u5b9a\u6307\u5411\u670d\u52d9\u7684 URL\u3002" },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "\u7121\u6cd5\u4f7f\u7528 {0} \u9023\u7dda\u4f86\u586b\u5beb\u5831\u544a"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "\u7121\u6cd5\u4f7f\u7528 {0} SQL \u9673\u8ff0\u5f0f\u4f86\u586b\u5beb\u5831\u544a"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "\u7121\u6cd5\u4f7f\u7528 {0} \u52d5\u614b\u9663\u5217\u4f86\u586b\u5beb\u5831\u544a"},
		{ Message.REPORT_E_FILL_ERROR , "\u7121\u6cd5\u586b\u5beb {0} \u5831\u544a"},
		{ Message.REPORT_E_EXPORT_ERROR, "\u7121\u6cd5\u532f\u51fa {0} \u5831\u544a" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "\u7121\u6cd5\u5728 EGL {0} \u548c Java {1} \u985e\u578b\u9593\u8f49\u63db" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "\u7121\u6cd5\u5728 Java {0} \u548c EGL {1} \u985e\u578b\u9593\u8f49\u63db" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "\u7121\u6cd5\u65b0\u589e\u5831\u544a\u53c3\u6578" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "\u7121\u6cd5\u91cd\u8a2d\u5831\u544a\u53c3\u6578\u6e05\u55ae" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "{0} \u6b04\u4f4d\u540d\u7a31\u4e0d\u6b63\u78ba" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "{0} \u5b50\u5831\u544a\u540d\u7a31\u4e0d\u6b63\u78ba" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "\u4e0d\u652f\u63f4\u5831\u544a\u4e2d\u6240\u7528\u7684\u985e\u578b" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "\u7121\u6cd5\u50b3\u905e\u8907\u5f0f\u985e\u578b\u7d66\u6b64\u51fd\u6578" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "\u5728\u547c\u53eb getParameterDefaultValue() \u51fd\u6578\u4e4b\u524d\uff0c\u61c9\u5148\u8a2d\u5b9a\u8a2d\u8a08\u6a94\u540d\u7a31\u3002" },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "\u7121\u6cd5\u53d6\u5f97 {0} \u53c3\u6578\u7684\u9810\u8a2d\u503c\u3002{1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "\u627e\u4e0d\u5230\u540d\u70ba {0} \u7684\u5831\u544a\u53c3\u6578\u3002" },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "\u5728\u547c\u53eb createReportFromDesign() \u6216 createDocument() \u51fd\u6578\u4e4b\u524d\uff0c\u61c9\u5148\u8a2d\u5b9a\u8a2d\u8a08\u6a94\u540d\u7a31\u3002" },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "\u5728\u547c\u53eb createReportFromDocument() \u51fd\u6578\u4e4b\u524d\uff0c\u61c9\u5148\u8a2d\u5b9a\u6587\u4ef6\u6a94\u540d\u7a31\u3002" },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "\u7121\u6cd5\u5efa\u7acb\u5831\u544a\u6587\u4ef6\u6a94\u3002{0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "\u7121\u6cd5\u5f9e\u8a2d\u8a08\u6a94\u4f86\u5efa\u7acb\u5831\u544a\u3002{0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "\u7121\u6cd5\u5f9e\u6587\u4ef6\u6a94\u4f86\u5efa\u7acb\u5831\u544a\u3002{0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "\u6307\u5b9a\u7d66 BirtReport \u7684\u8655\u7406\u7a0b\u5f0f\u7269\u4ef6\u5fc5\u9808\u662f BirtHandler \u985e\u578b\u3002" },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "{0} \u5143\u7d20\u4e0d\u5b58\u5728\u65bc\u5831\u544a\u8a2d\u8a08\u4e2d\uff0c\u6216\u8005\u4e0d\u662f\u63a1\u7528\u6307\u5b9a\u7684\u985e\u578b\u3002" },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "{2} \u8868\u683c\u4e2d\u4e26\u7121 {0}\uff08\u5217\u865f\u70ba {1}\uff09\u3002" },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "\u5728\u683c\u7dda\u5143\u7d20 {1} \u4e2d\u627e\u4e0d\u5230\u5217\u865f {0}\u3002" },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "{1} \u8868\u683c\u4e2d\u4e26\u7121\u7fa4\u7d44 {0}\u3002" },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "\u5728 {3} \u8868\u683c\u7684 {2} \u7fa4\u7d44\u4e2d\uff0c\u627e\u4e0d\u5230 {0}\uff08\u5217\u865f\u70ba {1}\uff09\u3002" },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "\u5728 {2} \u8868\u683c\u7684\u7b2c {1} \u5217\u4e2d\u627e\u4e0d\u5230\u76f4\u6b04\u865f\u78bc {0}\u3002" },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "\u5728\u683c\u7dda {1} \u4e2d\u627e\u4e0d\u5230\u76f4\u6b04\u865f\u78bc {0}\u3002" },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "\u5728 {3} \u8868\u683c\u4e2d\u7fa4\u7d44 {2} \u7684\u7b2c {1} \u5217\u5167\uff0c\u627e\u4e0d\u5230\u76f4\u6b04\u865f\u78bc {0}\u3002" },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "\u5fc5\u9808\u5728 {0} \u8868\u683c\u4e2d\uff0c\u6307\u5b9a\u4e8b\u4ef6\u8655\u7406\u7a0b\u5f0f\u51fd\u6578\u7684\u5217\u6216 Cell \u7684 ''RowType'' \u5167\u5bb9\u3002" },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "\u7121\u6cd5\u5c07 Java \u985e\u578b {0} \u8f49\u63db\u70ba EGL \u985e\u578b\u3002" },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "\u7121\u6cd5\u5c07 EGL \u985e\u578b {0} \u8f49\u63db\u70ba Java \u985e\u578b\u3002" },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "\u5728\u5831\u544a\u8a2d\u8a08\u4e2d\u627e\u4e0d\u5230\u8cc7\u6599\u96c6 {0}\u3002" },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "\u8cc7\u6599\u96c6 {0} \u662f\u4e00\u500b Script \u5316\u7684\u8cc7\u6599\u96c6\uff0c\u4f46\u537b\u672a\u8655\u7406\u4e0b\u5217\u4efb\u4f55\u7684 eventType\uff1aopenEvent\u3001fetchEvent\u3001closeEvent\u3002" },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "\u5728\u5831\u544a\u8a2d\u8a08\u4e2d\u627e\u4e0d\u5230\u8cc7\u6599\u4f86\u6e90 {0}\u3002" },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "\u8cc7\u6599\u4f86\u6e90 {0} \u662f\u4e00\u500b Script \u5316\u7684\u8cc7\u6599\u4f86\u6e90\uff0c\u4f46\u537b\u672a\u8655\u7406\u4e0b\u5217\u4efb\u4f55\u7684 eventType\uff1aopenEvent\u3001closeEvent\u3002" },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "\u5728\u8cc7\u6599\u96c6 {1} \u4e2d\u627e\u4e0d\u5230\u76f4\u6b04\u865f\u78bc {0}\u3002" },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "\u5f9e\u8cc7\u6599\u96c6 {1} \u53d6\u5f97\u76f4\u6b04 {0} \u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002{2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "\u8a2d\u5b9a Script \u5316\u8cc7\u6599\u96c6 {1} \u7684\u76f4\u6b04 {0} \u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002{2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "\u53d6\u5f97\u76f4\u6b04\u9023\u7d50 {0} \u6642\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002{1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "\u672a\u6307\u5b9a vgj.defaultI4GLNativeLibrary \u5167\u5bb9" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "{0} \u7a0b\u5f0f\u5eab\u8f09\u5165\u5931\u6557 {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "\u6240\u50b3\u56de\u7684\u53c3\u6578\u548c\u51fd\u6578\u4e0d\u76f8\u7b26" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "\u7121\u6cd5\u914d\u7f6e\u8a18\u61b6\u9ad4"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "\u7121\u6cd5\u5728\u985e\u578b\u9593\u8f49\u63db"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "\u300c\u65e5\u671f\u6642\u9593\u300d\u6216\u300c\u9593\u9694\u300d\u7cbe\u6e96\u5ea6\u7121\u6548"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "\u5c0d\u8cc7\u6599\u800c\u8a00\uff0c\u5b57\u5143\u4e3b\u8b8a\u6578\u592a\u77ed"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "\u5728\u7b26\u865f\u8868\u4e2d\u627e\u4e0d\u5230\u51fd\u6578\u3002"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "\u5fc5\u9808\u5728\u6b64\u74b0\u5883\u5b9a\u7fa9\u4e2d\u63d0\u4f9b\u300c\u6587\u5b57\u300d\u6216\u300c\u4f4d\u5143\u7d44\u300d\u8cc7\u6599\u985e\u578b"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "\u7121\u6cd5\u5c07\u5806\u758a\u4e2d\u7684\u503c\u8f49\u63db\u70ba\u503c\u985e\u578b"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "\u7121\u6cd5\u5c07\u5806\u758a\u4e2d\u7684\u503c\u8f49\u63db\u70ba ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "\u7121\u6cd5\u5f9e\u5806\u758a\u4e2d\u53d6\u51fa {0} \u985e\u578b\u7684\u503c"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "\u7121\u6cd5\u5c07 {1} \u985e\u578b\u7684\u503c\u63a8\u9001\u81f3\u5806\u758a\u4e2d"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "\u6c92\u6709\u53ef\u63a8\u9001/\u53d6\u51fa\u7684"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "\u7121\u6cd5\u5f9e\u5806\u758a\u4e2d\u53d6\u51fa\u300c\u5b9a\u4f4d\u5668\u300d"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "\u5806\u758a\u70ba\u7a7a\u7684"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "\u7121\u6cd5\u8907\u88fd\u5b9a\u4f4d\u5668"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "\u7a7a\u503c\u53c3\u7167\u63a8\u5165\u5806\u758a"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "\u7121\u6cd5\u5c07 Any \u503c\u63a8\u9001\u81f3\u5806\u758a\u4e2d"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "\u7121\u6cd5\u6307\u6d3e\u5806\u758a\u5143\u7d20\u7d66 Any \u985e\u578b"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "\u50b3\u56de\u985e\u578b\u4e0d\u7b26"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "\u53c3\u6578\u985e\u578b\u4e0d\u7b26"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "\u627e\u4e0d\u5230 EGL \u539f\u59cb\u6a94 {0}\u3002\u5c07\u6539\u4ee5\u57f7\u884c\u7522\u751f\u7684\u7a0b\u5f0f\u78bc\u3002" },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "\u627e\u4e0d\u5230 Web \u4ea4\u6613\u540d\u7a31\u70ba {0} \u7684 EGL \u4f86\u6e90\u6a94\u3002" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "\u5f9e \"{1}\" \u986f\u793a\u6642\uff0c\u6b04\u4f4d \"{0}\" \u4e0a\u767c\u751f\u4e0b\u5217\u683c\u5f0f\u5316\u554f\u984c\uff1a" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\n\u6b04\u4f4d\u7684\u9810\u671f\u5167\u90e8\u683c\u5f0f\u662f \"{1}\"\u3002\u8acb\u6aa2\u67e5\u9664\u932f\u5efa\u7f6e\u63cf\u8ff0\u5b50\u5167\u300cEGL Java \u57f7\u884c\u6642\u671f\u300d\u5167\u5bb9\u4e2d\u7684\u65e5\u671f\u683c\u5f0f\u5167\u5bb9\uff0c\u6216\u8005\u5f71\u97ff\u65e5\u671f\u683c\u5f0f\u7684 JDBC \u5167\u5bb9\u3002" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\n\u6b04\u4f4d\u7684\u986f\u793a\u683c\u5f0f\u662f \"{1}\"\u3002\u8acb\u6aa2\u67e5\u8868\u55ae\u6b04\u4f4d\u4e0a\u7684 \"{2}\" \u5167\u5bb9\u3002" },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "\u7121\u6cd5\u5c07 {0} \u7a0b\u5f0f\u7576\u6210 Web \u4ea4\u6613\u57f7\u884c\u3002" },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "\u63d0\u4f9b\u8f38\u5165 UI \u8a18\u9304 {0} \u7d66 Web \u4ea4\u6613\uff0c\u4f46\u5b9a\u7fa9\u7d66\u5b83\u7684\u537b\u662f\u8f38\u5165 UI \u8a18\u9304 {1}\u3002" },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "\u5c0d Boolean \u6b04\u4f4d\u4f86\u8aaa\uff0c\u8f38\u5165\u7121\u6548\u3002" },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "\u56e0\u9592\u7f6e\uff0c\u4f7f\u5f97\u7a0b\u5f0f {0} \u4e2d\u767c\u751f\u903e\u6642\u3002" },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "\u4f7f\u7528\u8005\u4ecb\u9762\u8a18\u9304 {0} \u542b\u6709\u592a\u591a\u8cc7\u6599\uff0c\u800c\u7121\u6cd5\u50b3\u7d66\u9598\u9053 Servlet\u3002" },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "\u7a0b\u5f0f\u7121\u6cd5\u9a57\u8b49\u9598\u9053 Servlet \u50b3\u4f86\u7684\u8cc7\u6599\u3002\u8cc7\u6599 ID \u70ba {0}\u3002" },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "\u7121\u6cd5\u5c55\u958b\u9663\u5217\u5c01\u5957 {0}\uff0c\u56e0\u70ba\u5df2\u8d85\u904e\u5176\u5927\u5c0f\u4e0a\u9650\u3002{1} \u65b9\u6cd5\u4e2d\u767c\u751f\u932f\u8aa4\u3002" },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "\u5c0d\u9663\u5217\u5c01\u5957 {1} \u800c\u8a00\uff0c{0} \u70ba\u7121\u6548\u7684\u7d22\u5f15\u3002\u5927\u5c0f\u4e0a\u9650\uff1a{2}\u3002\u73fe\u884c\u5927\u5c0f\uff1a{3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "\u5c0d\u9663\u5217\u5c01\u5957 {1} \u800c\u8a00\uff0c{0} \u4e0d\u662f\u6709\u6548\u7684\u5927\u5c0f\u4e0a\u9650\u3002" },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} \u7269\u4ef6\u985e\u578b\u4e0d\u9069\u5408\u65b0\u589e\u81f3 {1} \u985e\u578b\u7684\u9663\u5217\u5c01\u5957\u4e2d\u3002" },
		
		{ Message.IMS_HOST_ABORT, "\u4e2d\u65b7\u5f9e\u9060\u7aef\u4e3b\u6a5f\u63a5\u6536\u7684\u5c01\u5305\u3002"},
		{ Message.IMS_HOST_TCPIP_ERROR, "\u9060\u7aef\u4e3b\u6a5f\u4e0a\u767c\u751f TCPIP \u932f\u8aa4\u3002\u5340\u6bb5\uff1a{0}\uff0cTCPIP \u4f5c\u696d\uff1a{1}\uff0cTCPIP-RETCODE\uff1a{2}\uff0cTCPIP-ERRNO\uff1a{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "\u547c\u53eb\u6642\u4e3b\u6a5f\u4e0a\u767c\u751f\u932f\u8aa4\uff1a{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "\u5f9e\u4e3b\u6a5f\u6536\u5230\u932f\u8aa4\u7684\u56de\u61c9\u5c01\u5305\u3002\u539f\u9810\u671f\u70ba\uff1a{0}\uff0c\u63a5\u6536\u7684\u662f\uff1a{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "\u57f7\u884c\u5132\u5b58\u7a0b\u5e8f\u6642\u767c\u751f IO \u932f\u8aa4\u3002{0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "\u57f7\u884c\u5132\u5b58\u7a0b\u5e8f\u6642\u767c\u751f SQL \u932f\u8aa4\u3002{0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "\u5728\u9060\u7aef\u4e3b\u6a5f\u4e0a\u57f7\u884c\u6642\u767c\u751f\u932f\u8aa4\uff1a{0} \u56de\u8986\u78bc\uff1a{1} DLI Proxy \u5de5\u4f5c ID\uff1a{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "\u9060\u7aef\u4e3b\u6a5f\u4e0a\u767c\u751f DLI \u932f\u8aa4\u3002DLI \u51fd\u6578\uff1a{0} AIB \u56de\u8986\u78bc\uff1a0x{1} AIB \u539f\u56e0\uff1a0x{2} statusCode\uff1a{3} DLI Proxy \u5de5\u4f5c ID\uff1a{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "\u9060\u7aef\u4e3b\u6a5f\u4e0a\u767c\u751f DLI \u932f\u8aa4\u3002DLI \u51fd\u6578\uff1a{0} AIB \u56de\u8986\u78bc\uff1a0x{1} AIB \u539f\u56e0\uff1a0x{2} DLIVar.statusCode\uff1a{3} DLIVar.DbName\uff1a{4} DLIVar.SegmentName\uff1a{5} DLIVar.SegmentLevel\uff1a{6} DLI Proxy \u5de5\u4f5c ID\uff1a{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "AIB \u56de\u8986\u78bc\u6307\u51fa PCB \u72c0\u614b\u78bc\uff0c\u4f46\u537b\u672a\u50b3\u56de PCB\u3002AIB \u51fd\u6578\uff1a{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "\u9060\u7aef\u4e3b\u6a5f\u4e0a\u7684 CALL EZEDBTCP \u4e2d\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002\u5340\u6bb5\uff1a{0}\uff0cTCPIP \u4f5c\u696d\uff1a{1}\uff0cTCPIP-RETCODE\uff1a{2}\uff0cTCPIP-ERRNO\uff1a{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "\u9060\u7aef\u4e3b\u6a5f\u4e0a\u767c\u751f ABEND\u3002\u5e38\u5f0f\uff1a{0}\uff0c\u8a0a\u606f\uff1a{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "\u9060\u7aef\u4e3b\u6a5f\u4e0a\u767c\u751f\u7570\u5e38\u72c0\u6cc1\u3002CALL\uff1a{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "\u9664\u932f\u5668\u4e0d\u652f\u63f4 DLI \u51fd\u6578\u3002\u51fd\u6578\uff1a{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "\u6b63\u767c\u51fa DL/I \u547c\u53eb\uff0c\u4f46\u662f\u6c92\u6709\u70ba DL/I \u5b58\u53d6\u914d\u7f6e\u5efa\u7f6e\u63cf\u8ff0\u5b50\u3002"},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "\u9060\u7aef\u7570\u5e38\u72c0\u6cc1\uff1a{0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "\u8a66\u8457\u914d\u7f6e PSB \u6642\u767c\u751f\u932f\u8aa4\u3002\u8a2d\u5b9a IMSID \u6307\u793a\u5b58\u53d6 DL/I\uff0c\u4f46\u662f\u6c92\u6709\u6307\u5b9a PSB"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "RBD \u7528\u6236\u7aef\u7248\u672c\u548c\u4e3b\u6a5f\u7248\u672c\u4e0d\u76f8\u5bb9\u3002RBD \u7528\u6236\u7aef\u7248\u672c\uff1a{0} \u4e3b\u6a5f\u7248\u672c\uff1a{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "\u7576\u64f7\u53d6\u5f9e\u547c\u53eb\u8fd4\u56de\u7684\u8cc7\u6599\u5230\u4e3b\u6a5f\u7a0b\u5f0f\u6642\uff0c\u767c\u751f\u932f\u8aa4\u3002{0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "\u64f7\u53d6 PCB \u540d\u7a31\u6642\u767c\u751f\u932f\u8aa4\u3002PCB \u7d22\u5f15\uff1a{0}\uff0cPCB \u6578\u76ee\uff1a{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
