/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.runtime.java.egl.lang;

import org.eclipse.edt.javart.JavartException;

public class IndexOutOfBoundsException extends AnyException
{
	private static final long serialVersionUID = 70L;
	
	public int indexValue;
			
	public IndexOutOfBoundsException( ) 
		throws JavartException
	{
		indexValue = 0;
	}
		
	/**
	 * Returns a clone of this object.
	 */
	public Object clone() throws CloneNotSupportedException
	{
		IndexOutOfBoundsException theClone = (IndexOutOfBoundsException)super.clone();
		
		theClone.indexValue = indexValue;
		
		return theClone;
	}
}
