/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.eclipse.edt.javart.Constants;
import org.eclipse.edt.javart.resources.Platform;
import org.eclipse.edt.javart.util.NumericUtil;

public class ByteStorage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 70L;
    public static final byte BYTEORDER_BIG_ENDIAN = 1;
    public static final byte BYTEORDER_LITTLE_ENDIAN = 2;
    public static final byte BYTEORDER_UNIX = 3;
    public static final byte REF_NULL = 0;
    public static final byte REF_NOT_NULL = 1;
    public static final byte SHIFT_OUT = 14;
    public static final byte SHIFT_IN = 15;
    private byte[] buffer;
    public int position;
    private byte byteOrder;
    private String encoding;
    private boolean isBidi;
    private boolean isAscii;
    private boolean isUnicode;
    private boolean isIeeeFloat;
    private boolean eglJavaFormat;

    public ByteStorage(int capacity) {
        this(new byte[capacity]);
    }

    public ByteStorage(byte[] buffer) {
        this.buffer = buffer;
        this.position = 0;
        this.byteOrder = 1;
        this.encoding = null;
        this.isAscii = Platform.IS_ASCII;
        this.isBidi = false;
        this.isUnicode = false;
        this.isIeeeFloat = true;
        this.eglJavaFormat = true;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public byte[] getBytesCopy() {
        byte[] retbytes = new byte[this.position];
        System.arraycopy(this.buffer, 0, retbytes, 0, this.position);
        return retbytes;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (position > this.buffer.length) {
            this.ensureCapacity(position);
        }
        this.position = position;
    }

    private void reallocate(int size) {
        byte[] newbuf = new byte[size];
        int copylen = Math.min(this.buffer.length, size);
        System.arraycopy(this.buffer, 0, newbuf, 0, copylen);
        this.buffer = newbuf;
        if (this.position > size) {
            this.position = size;
        }
    }

    public void ensureCapacity(int need) {
        if (this.buffer.length < need) {
            this.reallocate(Math.max(need, this.buffer.length * 2));
        }
    }

    public void setConversion(byte byteOrder, String encoding, boolean isAscii, boolean isBidi, boolean isUnicode, boolean isIeeeFloat) {
        this.byteOrder = byteOrder;
        this.encoding = encoding;
        this.isAscii = isAscii;
        this.isUnicode = isUnicode;
        this.isIeeeFloat = isIeeeFloat;
        this.isBidi = encoding == null ? false : isBidi;
    }

    public void setNoConversion() {
        this.setConversion((byte)1, null, Platform.IS_ASCII, false, false, true);
        this.setEglJavaFormat(true);
    }

    public void reset(byte[] newBuffer) {
        this.buffer = newBuffer;
        this.position = 0;
    }

    public int storeBlanks(int count) {
        if (this.isUnicode) {
            byte[] blanks = Constants.FIFTY_UNICODE_BLANK_BYTES;
            while (count >= 50) {
                this.storeBytes(blanks, 0, 100);
                count -= 50;
            }
            if (count > 0) {
                this.storeBytes(blanks, 0, count * 2);
            }
        } else if (this.encoding == null || this.isAscii == Platform.IS_ASCII) {
            byte[] blanks = Constants.HUNDRED_BLANK_BYTES;
            while (count >= 100) {
                this.storeBytes(blanks, 0, 100);
                count -= 100;
            }
            if (count > 0) {
                this.storeBytes(blanks, 0, count);
            }
        } else {
            int newPosition = this.position + count;
            this.ensureCapacity(newPosition);
            Arrays.fill(this.buffer, this.position, newPosition, this.isAscii ? (byte)32 : 64);
            this.position = newPosition;
        }
        return this.position;
    }

    public int storeByte(int value) {
        int pos = this.position;
        try {
            this.buffer[pos++] = (byte)value;
            this.position = pos;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.ensureCapacity(this.position + 1);
            pos = this.position;
            this.buffer[pos++] = (byte)value;
            this.position = pos;
        }
        return this.position;
    }

    public int storeBytes(byte[] value, int start, int length) {
        try {
            System.arraycopy(value, start, this.buffer, this.position, length);
            this.position += length;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.ensureCapacity(this.position + length);
            System.arraycopy(value, start, this.buffer, this.position, length);
            this.position += length;
        }
        return this.position;
    }

    public int storeBytes(byte[] value) {
        return this.storeBytes(value, 0, value.length);
    }

    public int storeShort(int value) {
        int pos = this.position;
        try {
            if (this.byteOrder != 2) {
                this.buffer[pos] = (byte)(value >> 8);
                this.buffer[pos + 1] = (byte)value;
            } else {
                this.buffer[pos + 1] = (byte)(value >> 8);
                this.buffer[pos] = (byte)value;
            }
            this.position = pos + 2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.ensureCapacity(this.position + 2);
            if (this.byteOrder != 2) {
                this.buffer[pos] = (byte)(value >> 8);
                this.buffer[pos + 1] = (byte)value;
            } else {
                this.buffer[pos + 1] = (byte)(value >> 8);
                this.buffer[pos] = (byte)value;
            }
            this.position = pos + 2;
        }
        return this.position;
    }

    public int storeShort(byte[] value, int start) {
        if (this.byteOrder != 2) {
            return this.storeBytes(value, start, 2);
        }
        int shortValue = (value[start] & 0xFF) << 8 | value[start + 1] & 0xFF;
        return this.storeShort(shortValue);
    }

    public int storeInt(int value) {
        int pos = this.position;
        try {
            if (this.byteOrder != 2) {
                this.buffer[pos] = (byte)(value >> 24);
                this.buffer[pos + 1] = (byte)(value >> 16);
                this.buffer[pos + 2] = (byte)(value >> 8);
                this.buffer[pos + 3] = (byte)value;
            } else {
                this.buffer[pos + 3] = (byte)(value >> 24);
                this.buffer[pos + 2] = (byte)(value >> 16);
                this.buffer[pos + 1] = (byte)(value >> 8);
                this.buffer[pos] = (byte)value;
            }
            this.position = pos + 4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.ensureCapacity(this.position + 4);
            if (this.byteOrder != 2) {
                this.buffer[pos] = (byte)(value >> 24);
                this.buffer[pos + 1] = (byte)(value >> 16);
                this.buffer[pos + 2] = (byte)(value >> 8);
                this.buffer[pos + 3] = (byte)value;
            } else {
                this.buffer[pos + 3] = (byte)(value >> 24);
                this.buffer[pos + 2] = (byte)(value >> 16);
                this.buffer[pos + 1] = (byte)(value >> 8);
                this.buffer[pos] = (byte)value;
            }
            this.position = pos + 4;
        }
        return this.position;
    }

    public int storeInt(byte[] value, int start) {
        if (this.byteOrder != 2) {
            return this.storeBytes(value, start, 4);
        }
        int intValue = (value[start] & 0xFF) << 24 | (value[start + 1] & 0xFF) << 16 | (value[start + 2] & 0xFF) << 8 | value[start + 3] & 0xFF;
        return this.storeInt(intValue);
    }

    public int storeLong(long value) {
        int pos = this.position;
        try {
            switch (this.byteOrder) {
                case 1: {
                    this.buffer[pos] = (byte)(value >> 56);
                    this.buffer[pos + 1] = (byte)(value >> 48);
                    this.buffer[pos + 2] = (byte)(value >> 40);
                    this.buffer[pos + 3] = (byte)(value >> 32);
                    this.buffer[pos + 4] = (byte)(value >> 24);
                    this.buffer[pos + 5] = (byte)(value >> 16);
                    this.buffer[pos + 6] = (byte)(value >> 8);
                    this.buffer[pos + 7] = (byte)value;
                    break;
                }
                case 2: {
                    this.buffer[pos + 7] = (byte)(value >> 56);
                    this.buffer[pos + 6] = (byte)(value >> 48);
                    this.buffer[pos + 5] = (byte)(value >> 40);
                    this.buffer[pos + 4] = (byte)(value >> 32);
                    this.buffer[pos + 3] = (byte)(value >> 24);
                    this.buffer[pos + 2] = (byte)(value >> 16);
                    this.buffer[pos + 1] = (byte)(value >> 8);
                    this.buffer[pos] = (byte)value;
                    break;
                }
                case 3: {
                    this.buffer[pos + 4] = (byte)(value >> 56);
                    this.buffer[pos + 5] = (byte)(value >> 48);
                    this.buffer[pos + 6] = (byte)(value >> 40);
                    this.buffer[pos + 7] = (byte)(value >> 32);
                    this.buffer[pos] = (byte)(value >> 24);
                    this.buffer[pos + 1] = (byte)(value >> 16);
                    this.buffer[pos + 2] = (byte)(value >> 8);
                    this.buffer[pos + 3] = (byte)value;
                }
            }
            this.position = pos + 8;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.ensureCapacity(this.position + 8);
            switch (this.byteOrder) {
                case 1: {
                    this.buffer[pos] = (byte)(value >> 56);
                    this.buffer[pos + 1] = (byte)(value >> 48);
                    this.buffer[pos + 2] = (byte)(value >> 40);
                    this.buffer[pos + 3] = (byte)(value >> 32);
                    this.buffer[pos + 4] = (byte)(value >> 24);
                    this.buffer[pos + 5] = (byte)(value >> 16);
                    this.buffer[pos + 6] = (byte)(value >> 8);
                    this.buffer[pos + 7] = (byte)value;
                    break;
                }
                case 2: {
                    this.buffer[pos + 7] = (byte)(value >> 56);
                    this.buffer[pos + 6] = (byte)(value >> 48);
                    this.buffer[pos + 5] = (byte)(value >> 40);
                    this.buffer[pos + 4] = (byte)(value >> 32);
                    this.buffer[pos + 3] = (byte)(value >> 24);
                    this.buffer[pos + 2] = (byte)(value >> 16);
                    this.buffer[pos + 1] = (byte)(value >> 8);
                    this.buffer[pos] = (byte)value;
                    break;
                }
                case 3: {
                    this.buffer[pos + 4] = (byte)(value >> 56);
                    this.buffer[pos + 5] = (byte)(value >> 48);
                    this.buffer[pos + 6] = (byte)(value >> 40);
                    this.buffer[pos + 7] = (byte)(value >> 32);
                    this.buffer[pos] = (byte)(value >> 24);
                    this.buffer[pos + 1] = (byte)(value >> 16);
                    this.buffer[pos + 2] = (byte)(value >> 8);
                    this.buffer[pos + 3] = (byte)value;
                }
            }
            this.position = pos + 8;
        }
        return this.position;
    }

    public int storeLong(byte[] value, int start) {
        if (this.byteOrder == 1) {
            return this.storeBytes(value, start, 8);
        }
        long longValue = ((long)value[start] & 0xFFL) << 56 | ((long)value[start + 1] & 0xFFL) << 48 | ((long)value[start + 2] & 0xFFL) << 40 | ((long)value[start + 3] & 0xFFL) << 32 | ((long)value[start + 4] & 0xFFL) << 24 | ((long)value[start + 5] & 0xFFL) << 16 | ((long)value[start + 6] & 0xFFL) << 8 | (long)value[start + 7] & 0xFFL;
        return this.storeLong(longValue);
    }

    public int storeFloat(float value) {
        int pos = this.position;
        int bits = this.isIeeeFloat ? Float.floatToRawIntBits(value) : NumericUtil.floatToS390IntBits(value);
        try {
            this.buffer[pos] = (byte)(bits >> 24);
            this.buffer[pos + 1] = (byte)(bits >> 16);
            this.buffer[pos + 2] = (byte)(bits >> 8);
            this.buffer[pos + 3] = (byte)bits;
            this.position = pos + 4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.ensureCapacity(this.position + 4);
            this.buffer[pos] = (byte)(bits >> 24);
            this.buffer[pos + 1] = (byte)(bits >> 16);
            this.buffer[pos + 2] = (byte)(bits >> 8);
            this.buffer[pos + 3] = (byte)bits;
            this.position = pos + 4;
        }
        return this.position;
    }

    public int storeDouble(double value) {
        int pos = this.position;
        long bits = this.isIeeeFloat ? Double.doubleToRawLongBits(value) : NumericUtil.doubleToS390LongBits(value);
        try {
            this.buffer[pos] = (byte)(bits >> 56);
            this.buffer[pos + 1] = (byte)(bits >> 48);
            this.buffer[pos + 2] = (byte)(bits >> 40);
            this.buffer[pos + 3] = (byte)(bits >> 32);
            this.buffer[pos + 4] = (byte)(bits >> 24);
            this.buffer[pos + 5] = (byte)(bits >> 16);
            this.buffer[pos + 6] = (byte)(bits >> 8);
            this.buffer[pos + 7] = (byte)bits;
            this.position = pos + 8;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.ensureCapacity(this.position + 8);
            this.buffer[pos] = (byte)(bits >> 56);
            this.buffer[pos + 1] = (byte)(bits >> 48);
            this.buffer[pos + 2] = (byte)(bits >> 40);
            this.buffer[pos + 3] = (byte)(bits >> 32);
            this.buffer[pos + 4] = (byte)(bits >> 24);
            this.buffer[pos + 5] = (byte)(bits >> 16);
            this.buffer[pos + 6] = (byte)(bits >> 8);
            this.buffer[pos + 7] = (byte)bits;
            this.position = pos + 8;
        }
        return this.position;
    }

    public int storeString(String value) {
        return this.storeString(value, false);
    }

    public int storeDbchar(String value) {
        return this.storeString(value, true);
    }

    private int storeString(String value, boolean stripSOSI) {
        byte[] bytes;
        block9: {
            if (this.encoding == null && !this.isUnicode) {
                bytes = value.getBytes();
                if (stripSOSI) {
                    bytes = this.stripSOSI(bytes);
                }
            } else if (this.encoding != null) {
                try {
                    bytes = value.getBytes(this.encoding);
                    if (stripSOSI) {
                        bytes = this.stripSOSI(bytes);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bytes = value.getBytes();
                    if (!stripSOSI) break block9;
                    bytes = this.stripSOSI(bytes);
                }
            } else {
                bytes = new byte[value.length() * 2];
                int i = 0;
                int j = 0;
                while (i < bytes.length) {
                    char c = value.charAt(j);
                    bytes[i] = (byte)(c >> 8);
                    bytes[i + 1] = (byte)c;
                    i += 2;
                    ++j;
                }
            }
        }
        return this.storeBytes(bytes, 0, bytes.length);
    }

    private byte[] stripSOSI(byte[] bytes) {
        if (bytes[0] != 14 || bytes[bytes.length - 1] != 15) {
            return bytes;
        }
        byte[] temp = new byte[bytes.length - 2];
        System.arraycopy(bytes, 1, temp, 0, temp.length);
        return temp;
    }

    public byte loadByte() {
        int pos = this.position;
        byte value = this.buffer[pos++];
        this.position = pos;
        return value;
    }

    public short loadShort() {
        int pos = this.position;
        int value = this.byteOrder != 2 ? (this.buffer[pos] & 0xFF) << 8 | this.buffer[pos + 1] & 0xFF : (this.buffer[pos + 1] & 0xFF) << 8 | this.buffer[pos] & 0xFF;
        this.position = pos + 2;
        return (short)value;
    }

    public void loadShort(byte[] value, int start) {
        if (this.byteOrder != 2) {
            this.loadBytes(value, start, 2);
        } else {
            short shortValue = this.loadShort();
            value[start] = (byte)(shortValue >> 8);
            value[start + 1] = (byte)shortValue;
        }
    }

    public int loadInt() {
        int pos = this.position;
        int value = this.byteOrder != 2 ? (this.buffer[pos] & 0xFF) << 24 | (this.buffer[pos + 1] & 0xFF) << 16 | (this.buffer[pos + 2] & 0xFF) << 8 | this.buffer[pos + 3] & 0xFF : (this.buffer[pos + 3] & 0xFF) << 24 | (this.buffer[pos + 2] & 0xFF) << 16 | (this.buffer[pos + 1] & 0xFF) << 8 | this.buffer[pos] & 0xFF;
        this.position = pos + 4;
        return value;
    }

    public void loadInt(byte[] value, int start) {
        if (this.byteOrder != 2) {
            this.loadBytes(value, start, 4);
        } else {
            int intValue = this.loadInt();
            value[start] = (byte)(intValue >> 24);
            value[start + 1] = (byte)(intValue >> 16);
            value[start + 2] = (byte)(intValue >> 8);
            value[start + 3] = (byte)intValue;
        }
    }

    public long loadLong() {
        long value;
        int pos = this.position;
        switch (this.byteOrder) {
            case 1: {
                value = ((long)this.buffer[pos] & 0xFFL) << 56 | ((long)this.buffer[pos + 1] & 0xFFL) << 48 | ((long)this.buffer[pos + 2] & 0xFFL) << 40 | ((long)this.buffer[pos + 3] & 0xFFL) << 32 | ((long)this.buffer[pos + 4] & 0xFFL) << 24 | ((long)this.buffer[pos + 5] & 0xFFL) << 16 | ((long)this.buffer[pos + 6] & 0xFFL) << 8 | (long)this.buffer[pos + 7] & 0xFFL;
                break;
            }
            case 2: {
                value = ((long)this.buffer[pos + 7] & 0xFFL) << 56 | ((long)this.buffer[pos + 6] & 0xFFL) << 48 | ((long)this.buffer[pos + 5] & 0xFFL) << 40 | ((long)this.buffer[pos + 4] & 0xFFL) << 32 | ((long)this.buffer[pos + 3] & 0xFFL) << 24 | ((long)this.buffer[pos + 2] & 0xFFL) << 16 | ((long)this.buffer[pos + 1] & 0xFFL) << 8 | (long)this.buffer[pos] & 0xFFL;
                break;
            }
            default: {
                value = ((long)this.buffer[pos] & 0xFFL) << 24 | ((long)this.buffer[pos + 1] & 0xFFL) << 16 | ((long)this.buffer[pos + 2] & 0xFFL) << 8 | (long)this.buffer[pos + 3] & 0xFFL | ((long)this.buffer[pos + 4] & 0xFFL) << 56 | ((long)this.buffer[pos + 5] & 0xFFL) << 48 | ((long)this.buffer[pos + 6] & 0xFFL) << 40 | ((long)this.buffer[pos + 7] & 0xFFL) << 32;
            }
        }
        this.position = pos + 8;
        return value;
    }

    public void loadLong(byte[] value, int start) {
        if (this.byteOrder == 1) {
            this.loadBytes(value, start, 8);
        } else {
            long longValue = this.loadLong();
            value[start] = (byte)(longValue >> 56);
            value[start + 1] = (byte)(longValue >> 48);
            value[start + 2] = (byte)(longValue >> 40);
            value[start + 3] = (byte)(longValue >> 32);
            value[start + 4] = (byte)(longValue >> 24);
            value[start + 5] = (byte)(longValue >> 16);
            value[start + 6] = (byte)(longValue >> 8);
            value[start + 7] = (byte)longValue;
        }
    }

    public int loadBytes(byte[] value, int valstart, int length) {
        System.arraycopy(this.buffer, this.position, value, valstart, length);
        this.position += length;
        return this.position;
    }

    public int loadBytes(byte[] value) {
        return this.loadBytes(value, 0, value.length);
    }

    public String loadString(int byteLength, int unicodeExpansion) {
        return this.loadString(byteLength, unicodeExpansion, false);
    }

    public String loadDbchar(int byteLength) {
        return this.loadString(byteLength, 1, true);
    }

    private String loadString(int byteLength, int unicodeExpansion, boolean addSOSI) {
        if (this.isUnicode && (this.encoding == null || this.isBidi)) {
            byteLength *= unicodeExpansion;
        }
        byte[] bytes = new byte[byteLength];
        this.loadBytes(bytes, 0, byteLength);
        if (this.encoding != null || !this.isUnicode) {
            return this.bytesToString(bytes, this.encoding, addSOSI);
        }
        char[] chars = new char[byteLength / 2];
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            chars[i] = (char)(bytes[j] << 8);
            int n = i++;
            chars[n] = (char)(chars[n] | bytes[j + 1] & 0xFF);
            j += 2;
        }
        return new String(chars);
    }

    private String bytesToString(byte[] bytes, String encoding, boolean addSOSI) {
        try {
            String str;
            if (!this.isAscii && addSOSI && bytes[0] != 14 && bytes[bytes.length - 1] != 15) {
                byte[] temp = new byte[bytes.length + 2];
                System.arraycopy(bytes, 0, temp, 1, bytes.length);
                temp[0] = 14;
                temp[temp.length - 1] = 15;
                bytes = temp;
            }
            String string = str = encoding != null ? new String(bytes, encoding) : new String(bytes);
            if (!this.isAscii && addSOSI && str.charAt(0) == '\u000e' && str.charAt(str.length() - 1) == '\u000f') {
                str = str.substring(1, str.length() + 1);
            }
            return str;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(bytes);
        }
    }

    public float loadFloat() {
        int pos = this.position;
        int bits = (this.buffer[pos] & 0xFF) << 24 | (this.buffer[pos + 1] & 0xFF) << 16 | (this.buffer[pos + 2] & 0xFF) << 8 | this.buffer[pos + 3] & 0xFF;
        this.position = pos + 4;
        float value = this.isIeeeFloat ? Float.intBitsToFloat(bits) : NumericUtil.intS390BitsToFloat(bits);
        return value;
    }

    public double loadDouble() {
        int pos = this.position;
        long bits = ((long)this.buffer[pos] & 0xFFL) << 56 | ((long)this.buffer[pos + 1] & 0xFFL) << 48 | ((long)this.buffer[pos + 2] & 0xFFL) << 40 | ((long)this.buffer[pos + 3] & 0xFFL) << 32 | ((long)this.buffer[pos + 4] & 0xFFL) << 24 | ((long)this.buffer[pos + 5] & 0xFFL) << 16 | ((long)this.buffer[pos + 6] & 0xFFL) << 8 | (long)this.buffer[pos + 7] & 0xFFL;
        this.position = pos + 8;
        double value = this.isIeeeFloat ? Double.longBitsToDouble(bits) : NumericUtil.longS390BitsToDouble(bits);
        return value;
    }

    public int getNumBytesRemaining() {
        return this.buffer.length - this.position;
    }

    public byte getByteOrder() {
        return this.byteOrder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isAscii() {
        return this.isAscii;
    }

    public boolean isBidi() {
        return this.isBidi;
    }

    public boolean isUnicode() {
        return this.isUnicode;
    }

    public boolean isIeeeFloat() {
        return this.isIeeeFloat;
    }

    public boolean isEglJavaFormat() {
        return this.eglJavaFormat;
    }

    public void setEglJavaFormat(boolean eglJava) {
        this.eglJavaFormat = eglJava;
    }

    public String toString() {
        return "ByteStorage[pos=" + this.position + " of " + this.buffer.length + ']';
    }

    public Object clone() throws CloneNotSupportedException {
        ByteStorage theClone = (ByteStorage)super.clone();
        this.buffer = (byte[])this.buffer.clone();
        return theClone;
    }
}

