/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.edt.javart.resources.JavartProperties;

public class JavartPropertiesFile
extends JavartProperties {
    private static final long serialVersionUID = 70L;
    protected static Properties rununitProperties;
    private static String ruPropFile;
    protected static Properties userProperties;
    private static String userPropFile;
    protected Properties pgmProperties;
    private String pgmPropFile;

    protected JavartPropertiesFile() {
    }

    public JavartPropertiesFile(String propFile) {
        if (rununitProperties == null) {
            this.getRunUnitProps();
        }
        if (userProperties == null) {
            this.getUserProps();
        }
        this.getProgramProps(propFile);
    }

    @Override
    public String get(String key) {
        return this.pgmProperties.getProperty(key);
    }

    @Override
    public String get(String propName, String defVal) {
        return this.pgmProperties.getProperty(propName, defVal);
    }

    @Override
    public void put(String key, String value) {
        this.pgmProperties.put(key, value);
    }

    @Override
    public String getInfo() {
        return "User Properties: " + userPropFile + ", Program Properties: " + this.pgmPropFile + ", RunUnit Properties: " + ruPropFile;
    }

    @Override
    public Properties getProperties() {
        if (this.pgmProperties == null) {
            return null;
        }
        return new Properties(this.pgmProperties);
    }

    @Override
    public String getProgramPropertiesFile() {
        return this.pgmPropFile;
    }

    protected void getRunUnitProps() {
        try {
            URL url = this.getClass().getClassLoader().getResource("rununit.properties");
            if (url == null) {
                rununitProperties = new Properties();
                this.initDefaultSettings(rununitProperties);
            } else {
                InputStream iStream = url.openStream();
                rununitProperties = new Properties();
                rununitProperties.load(iStream);
                ruPropFile = url.toString();
                iStream.close();
            }
        }
        catch (IOException iOException) {
            rununitProperties = new Properties();
            this.initDefaultSettings(rununitProperties);
        }
    }

    protected void getUserProps() {
        try {
            String fileName = System.getProperty("user.home");
            if (fileName == null) {
                userProperties = new Properties();
            } else {
                if (!fileName.endsWith(File.separator)) {
                    fileName = String.valueOf(fileName) + File.separatorChar;
                }
                fileName = String.valueOf(fileName) + "user.properties";
                FileInputStream iStream = new FileInputStream(fileName);
                userProperties = new Properties();
                userProperties.load(iStream);
                userPropFile = fileName;
                ((InputStream)iStream).close();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {}
    }

    protected void getProgramProps(String fileName) {
        this.pgmProperties = new Properties(rununitProperties);
        try {
            try {
                InputStream iStream;
                URL url;
                URL uRL = url = fileName != null ? this.getClass().getClassLoader().getResource(fileName) : null;
                if (url != null && (iStream = url.openStream()) != null) {
                    this.pgmProperties.load(iStream);
                    this.pgmPropFile = url.toString();
                    iStream.close();
                }
            }
            catch (IOException iOException) {
                if (userProperties != null) {
                    this.pgmProperties.putAll((Map<?, ?>)userProperties);
                }
            }
        }
        finally {
            if (userProperties != null) {
                this.pgmProperties.putAll((Map<?, ?>)userProperties);
            }
        }
    }

    @Override
    public void remove(String key) {
        this.pgmProperties.remove(key);
    }
}

