/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.eclipse.edt.javart.EglExit;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.ExitProgram;
import org.eclipse.edt.javart.ExitRunUnit;
import org.eclipse.edt.javart.FatalException;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.Program;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Transfer;
import org.eclipse.edt.javart.resources.JavartProperties;
import org.eclipse.edt.javart.resources.JavartPropertiesFile;
import org.eclipse.edt.javart.resources.LocalizedText;
import org.eclipse.edt.javart.resources.Platform;
import org.eclipse.edt.javart.resources.RecoverableResource;
import org.eclipse.edt.javart.resources.ResourceManager;
import org.eclipse.edt.javart.resources.StartupInfo;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.util.JavartUtil;

public class RunUnitBase
implements RunUnit,
Serializable {
    private static final long serialVersionUID = 70L;
    public static final String VERSION = "0.7";
    private StartupInfo startupInfo;
    protected JavartProperties properties;
    protected Trace trace;
    protected LocalizedText localizedText;
    private transient ResourceManager resourceManager;
    protected List<Program> programStack;
    private Program lastProgram;
    protected HashMap<String, Executable> libraries;
    private Exception fatalError;
    private int returnCode;

    public RunUnitBase(StartupInfo startInfo) throws JavartException {
        this.startupInfo = startInfo;
        this.properties = startInfo.getProperties() != null ? startInfo.getProperties() : new JavartPropertiesFile(this.startupInfo.getPropertyFilePath());
        this.trace = new Trace(this.properties.get("egl.trace.type"), this.properties.get("egl.trace.device.option", "2"), this.properties.get("egl.trace.device.spec"));
        this.localizedText = new LocalizedText(this.properties);
        this.resourceManager = new ResourceManager();
        this.libraries = new HashMap();
        if (this.trace.traceIsOn()) {
            this.trace.put("*** " + new Date() + " ***");
            this.trace.put(" ");
            this.trace.put("RunUnit: " + startInfo.getRuName());
            this.trace.put("Version: 0.7");
            this.trace.put("System: " + Platform.SYSTEM_TYPE);
            this.trace.put(this.properties.getInfo());
            if (this.trace.traceIsOn(512)) {
                this.traceProperties();
            }
            this.trace.put(this.localizedText.getInfo());
            this.trace.put(this.getTrace().getInfo());
            this.trace.put("java.class.path: " + System.getProperty("java.class.path"));
            this.trace.put("java.library.path: " + System.getProperty("java.library.path"));
            this.trace.put(" ");
        }
    }

    @Override
    public StartupInfo getStartupInfo() {
        return this.startupInfo;
    }

    @Override
    public JavartProperties getProperties() {
        return this.properties;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void registerResource(RecoverableResource rs) {
        this.resourceManager.register(rs);
    }

    @Override
    public void unregisterResource(RecoverableResource rs) {
        this.resourceManager.unregister(rs);
    }

    @Override
    public void commit() throws JavartException {
        this.resourceManager.commit(this);
    }

    @Override
    public void rollback() throws JavartException {
        this.resourceManager.rollback(this);
    }

    @Override
    public void debugStart(Program program, String ... args) throws Exception {
        try {
            while (true) {
                try {
                    program._start(args);
                    this.endRunUnit(program);
                    return;
                }
                catch (Transfer trans) {
                    program = this.setupTransfer(trans);
                    continue;
                }
                break;
            }
        }
        catch (EglExit eglExit) {
            this.endRunUnit(program);
            return;
        }
    }

    @Override
    public void start(Program program, String ... args) throws Exception {
        try {
            while (true) {
                try {
                    program._start(args);
                    this.endRunUnit(program);
                    return;
                }
                catch (Transfer trans) {
                    program = this.setupTransfer(trans);
                    continue;
                }
                break;
            }
        }
        catch (EglExit eglExit) {
            this.endRunUnit(program);
        }
        catch (Exception ex) {
            this.endRunUnit(program, ex);
        }
    }

    public void startWrapped(Program program, String ... args) throws JavartException {
        try {
            while (true) {
                try {
                    program._finishTransfer();
                    program._start(args);
                    return;
                }
                catch (Transfer trans) {
                    program = this.setupTransfer(trans);
                    continue;
                }
                break;
            }
        }
        catch (EglExit eglExit) {
        }
        catch (JavartException jx) {
            throw jx;
        }
        catch (Exception ex) {
            Executable programInError = null;
            throw new JavartException("EGL0099E", JavartUtil.errorMessage(programInError, "EGL0099E", new Object[]{ex.toString()}));
        }
    }

    @Override
    public void endRunUnit(Executable program) throws Exception {
        if (this.trace.traceIsOn()) {
            this.trace.put("endRunUnit " + this.startupInfo.getRuName() + " (normal termination) with returnCode=" + this.returnCode);
        }
        try {
            this.commit();
            this.resourceManager.exit(this);
            this.trace.close();
        }
        catch (Exception ex) {
            this.endRunUnit(program, ex);
        }
    }

    @Override
    public void endRunUnit(Executable program, Exception ex) throws Exception {
        String message;
        this.returnCode = 693;
        if (this.trace.traceIsOn()) {
            this.trace.put("endRunUnit " + this.startupInfo.getRuName() + " (error termination) with returnCode=" + this.returnCode);
        }
        this.fatalError = ex;
        if (ex instanceof JavartException) {
            message = ex.getMessage();
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
        } else {
            message = program != null ? JavartUtil.errorMessage(program, "EGL0100E", (Object[])new String[]{ex.toString()}) : JavartUtil.errorMessage(program, "EGL0100E", (Object[])new String[]{ex.toString()});
        }
        System.out.println(message);
        try {
            this.rollback();
        }
        catch (Exception exception) {}
        try {
            this.resourceManager.exit(this);
        }
        catch (Exception exception) {}
        this.trace.close();
    }

    public void addLibrary(String name, Executable library) {
        this.libraries.put(name, library);
    }

    public Executable loadLibrary(String name) throws JavartException {
        Executable library = this.libraries.get(name);
        if (library == null) {
            library = this.loadProgramByName(name);
            this.libraries.put(name, library);
        }
        return library;
    }

    public Executable loadProgramByName(String name) throws JavartException {
        try {
            Class<?> pgmClass = Class.forName(name);
            Class[] classes = new Class[]{RunUnit.class};
            Constructor<?> cons = pgmClass.getDeclaredConstructor(classes);
            Object[] args = new Object[]{this};
            return (Executable)cons.newInstance(args);
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            String message = JavartUtil.errorMessage(this, "EGL0006E", new Object[]{name, ex});
            throw new FatalException("EGL0006E", message);
        }
    }

    public static Program loadProgramByNameInNewRU(String name) throws FatalException {
        RunUnitBase ru = null;
        try {
            Class<?> pgmClass = Class.forName(name);
            Method siMethod = pgmClass.getDeclaredMethod("_startupInfo", new Class[0]);
            StartupInfo si = (StartupInfo)siMethod.invoke(null, null);
            ru = new RunUnitBase(si);
            Constructor<?> cons = pgmClass.getDeclaredConstructor(RunUnitBase.class);
            return (Program)cons.newInstance(ru);
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            String message = ru != null ? JavartUtil.errorMessage(ru, "EGL0006E", new Object[]{name, ex}) : RunUnitBase.formatMessageInDefaultLocale("EGL0006E", new Object[]{name, ex});
            throw new FatalException("EGL0006E", message);
        }
    }

    protected static String formatMessageInDefaultLocale(String id, Object[] inserts) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.javart.messages.MessageBundle");
        String message = bundle.getString(id);
        MessageFormat mf = new MessageFormat(message);
        return mf.format(inserts);
    }

    private void traceProperties() {
        Properties props = this.properties.getProperties();
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            TreeSet keySet = new TreeSet();
            while (names.hasMoreElements()) {
                keySet.add(names.nextElement());
            }
            for (String key : keySet) {
                String val = props.getProperty(key);
                if (key.equals("egl.jdbc.default.database.user.password")) {
                    val = "?";
                }
                this.trace.put(" > " + key + '=' + val);
            }
        }
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int rc) {
        this.returnCode = rc;
    }

    public Exception getFatalError() {
        return this.fatalError;
    }

    @Override
    public LocalizedText getLocalizedText() {
        return this.localizedText;
    }

    @Override
    public void switchLocale(Locale loc) {
        if (this.trace.traceIsOn()) {
            this.trace.put("Change Locale to <" + loc.getDisplayName() + ">");
        }
        this.localizedText.switchLocale(loc);
    }

    public void exitProgram() throws ExitProgram {
        if (this.trace.traceIsOn()) {
            this.trace.put("Exit Program");
        }
        throw ExitProgram.getSingleton();
    }

    public void exitRunUnit() throws ExitRunUnit {
        if (this.trace.traceIsOn()) {
            this.trace.put("Exit RunUnit");
        }
        throw ExitRunUnit.getSingleton();
    }

    @Override
    public void transferCleanup(boolean toTransaction) {
        this.resourceManager.transferCleanup(this, toTransaction);
        if (toTransaction) {
            this.unloadLibraries();
        }
    }

    public void unloadLibraries() throws JavartException {
        for (Executable lib : this.libraries.values()) {
            lib._cleanup();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String noRollback = this.properties.get("com.ibm.egl.noRollbackOnSerialize");
        if (noRollback == null) {
            noRollback = Boolean.getBoolean("com.ibm.egl.noRollbackOnSerialize") ? "true" : "false";
            this.properties.put("com.ibm.egl.noRollbackOnSerialize", noRollback);
        }
        out.defaultWriteObject();
        if (noRollback.equals("false")) {
            try {
                try {
                    this.resourceManager.rollback(this);
                }
                catch (JavartException je) {
                    throw new IOException(je.getMessage());
                }
            }
            finally {
                try {
                    this.resourceManager.exit(this);
                }
                catch (JavartException je) {
                    throw new IOException(je.getMessage());
                }
            }
            out.writeObject(this.resourceManager);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.resourceManager = "true".equals(this.properties.get("com.ibm.egl.noRollbackOnSerialize")) ? new ResourceManager() : (ResourceManager)in.readObject();
    }

    public Program activeProgram() throws JavartException {
        if (this.programStack.isEmpty() && this.lastProgram != null) {
            return this.lastProgram;
        }
        return this.programStack.get(this.programStack.size() - 1);
    }

    public Program peekProgram() {
        if (this.programStack.isEmpty()) {
            return null;
        }
        return this.programStack.get(this.programStack.size() - 1);
    }

    public Program popProgram() {
        Program program = this.programStack.remove(this.programStack.size() - 1);
        if (program != null) {
            boolean retain = false;
            try {
                retain = program._retainOnExit(3);
            }
            catch (JavartException javartException) {}
            if (!retain) {
                program._cleanup();
            }
            if (this.programStack.isEmpty()) {
                this.lastProgram = program;
            }
        }
        return program;
    }

    public void pushProgram(Program program) {
        this.programStack.add(program);
        this.lastProgram = null;
    }

    private Program setupTransfer(Transfer trans) throws Exception {
        String oldName;
        String newName;
        if (trans.toTransaction && !(newName = JavartUtil.removePackageName(trans.name)).equals(oldName = this.programStack.get(this.programStack.size() - 1)._alias())) {
            String newPropertiesFilePath = String.valueOf(trans.name.replace('.', '/')) + ".properties";
            this.properties = new JavartPropertiesFile(newPropertiesFilePath);
            this.trace = new Trace(this.properties.get("egl.trace.type"), this.properties.get("egl.trace.device.option", "2"), this.properties.get("egl.trace.device.spec"));
            this.localizedText = new LocalizedText(this.properties);
        }
        Program newProgram = (Program)this.loadProgramByName(trans.name);
        this.popProgram();
        if (trans.input != null && newProgram._inputRecord() != null) {
            newProgram._inputRecord().ezeCopy(trans.input);
        }
        return newProgram;
    }

    @Override
    public void exit() {
    }

    @Override
    public Executable getExecutable(String name) throws JavartException {
        return this.loadProgramByName(name);
    }

    public String getDefaultDefaultDateFormat(Locale lc) {
        String pattern;
        String property = this.getProperties().get("egl.default.dateFormat");
        if (property != null && property.length() > 0) {
            pattern = property;
        } else {
            DateFormat df;
            DateFormat dateFormat = df = lc == null ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(3, lc);
            if (df instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)df;
                pattern = sdf.toPattern();
            } else {
                pattern = "MM/dd/yyyy";
            }
        }
        return pattern;
    }

    public String getDefaultDefaultTimeFormat(Locale lc) {
        String pattern;
        String property = this.getProperties().get("egl.default.timeFormat");
        if (property != null && property.length() > 0) {
            pattern = property;
        } else {
            DateFormat tf;
            DateFormat dateFormat = tf = lc == null ? DateFormat.getTimeInstance(3) : DateFormat.getTimeInstance(3, lc);
            if (tf instanceof SimpleDateFormat) {
                SimpleDateFormat stf = (SimpleDateFormat)tf;
                pattern = stf.toPattern();
            } else {
                pattern = "HH:mm:ss";
            }
        }
        return pattern;
    }

    public String getDefaultDefaultTimestampFormat() {
        String property = this.getProperties().get("egl.default.timestampFormat");
        String pattern = property != null && property.length() > 0 ? property : "yyyy-MM-dd-HH.mm.ss.SSSSSS";
        return pattern;
    }

    @Override
    public String getDefaultDateFormat() {
        return this.getDefaultDefaultDateFormat(null);
    }

    @Override
    public String getDefaultNumericFormat() {
        return null;
    }

    @Override
    public String getDefaultTimestampFormat() {
        return this.getDefaultDefaultTimestampFormat();
    }

    @Override
    public String getDefaultTimeFormat() {
        return this.getDefaultDefaultTimestampFormat();
    }
}

