/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.eclipse.edt.javart.util.JavartUtil;

public class Trace
implements Serializable {
    private static final long serialVersionUID = 70L;
    private transient PrintWriter out;
    private int traceLevel;
    private boolean usingFile;
    private String name;
    public static final int NO_TRACE = 0;
    public static final int GENERAL_TRACE = 1;
    public static final int MATH_TRACE = 2;
    public static final int STRING_TRACE = 4;
    public static final int TABLE_TRACE = 8;
    public static final int CALL_PARM_TRACE = 16;
    public static final int CALL_OPTIONS_TRACE = 32;
    public static final int UI_RECORD_TRACE = 64;
    public static final int JDBC_TRACE = 128;
    public static final int FILE_TRACE = 256;
    public static final int PROPERTIES_TRACE = 512;
    public static final String DEFAULT_FILE_NAME = "egltrace.out";

    public Trace(String trcLevel, String devType, String file) {
        this.traceLevel = this.convertStringToIntValue(trcLevel, 0);
        if (this.traceLevel == 0) {
            this.name = "not tracing";
        } else if (devType.equals("0")) {
            this.out = new PrintWriter(System.out);
            this.name = "System.out";
        } else if (devType.equals("2")) {
            if (file == null || file.length() == 0) {
                file = DEFAULT_FILE_NAME;
            }
            try {
                this.out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file, true)), true);
                this.name = file;
                this.usingFile = true;
            }
            catch (Exception ex) {
                this.out = new PrintWriter(System.err);
                this.name = "System.err";
                this.put(" Exception on trace file: <" + file + ">");
                ex.printStackTrace(this.out);
            }
        } else {
            this.out = new PrintWriter(System.err);
            this.name = "System.err";
        }
    }

    public boolean traceIsOn() {
        return this.traceLevel != 0;
    }

    public boolean traceIsOn(int level) {
        return (this.traceLevel & level) != 0;
    }

    public int setTraceLevel(int level) {
        int oldlevel = this.traceLevel;
        this.traceLevel = level;
        return oldlevel;
    }

    public void close() {
        if (this.usingFile && this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    private void checkReopen() {
        if (this.usingFile && this.out == null) {
            try {
                this.out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.name, true)), true);
            }
            catch (Exception ex) {
                this.usingFile = false;
                this.out = new PrintWriter(System.err);
                this.put(" Exception on trace file: <" + this.name + ">");
                this.name = "System.err";
                ex.printStackTrace(this.out);
            }
        }
    }

    private int convertStringToIntValue(String s, int defVal) {
        if (s == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defVal;
        }
    }

    public String getInfo() {
        return "Trace to: " + this.name + ", level: " + this.traceLevel;
    }

    public void put(String text) {
        this.checkReopen();
        this.out.println(String.valueOf('(') + JavartUtil.getCurrentTime() + "> " + text);
        this.out.flush();
    }

    public void putBytes(byte[] bytes) {
        this.putBytes(bytes, bytes.length);
    }

    public void putBytes(byte[] bytes, int length) {
        String spaces;
        String charStr;
        StringBuilder byteStrBuf = new StringBuilder(" ");
        int spacer = 0;
        int label = 0;
        int chars = 0;
        int i = 0;
        while (i < length) {
            if (chars == 16) {
                charStr = new String(bytes, i - 16, 16);
                spacer = label < 16 ? 0 : (label < 256 ? 1 : (label < 4096 ? 2 : 3));
                spaces = "   ".substring(spacer);
                this.put(String.valueOf(spaces) + Integer.toHexString(label) + " |" + byteStrBuf + " | " + charStr);
                byteStrBuf = new StringBuilder();
                chars = 0;
                label += 16;
            }
            if (i % 4 == 0 && i > 0) {
                byteStrBuf.append(' ');
            }
            if ((bytes[i] & 0xFF) < 16) {
                byteStrBuf.append('0');
            }
            ++chars;
            byteStrBuf.append(Integer.toHexString(bytes[i] & 0xFF));
            ++i;
        }
        if (chars > 0) {
            if (chars < 16) {
                String blanks = "                                   ";
                int bytesMissing = chars % 4 == 0 ? 0 : 4 - chars % 4;
                int blocksMissing = 3 - (chars - 1) / 4;
                int blanksNeeded = bytesMissing * 2 + blocksMissing * 9;
                byteStrBuf.append(blanks.substring(0, blanksNeeded));
            }
            charStr = new String(bytes, i - chars, chars);
            spacer = label < 16 ? 0 : (label < 256 ? 1 : (label < 4096 ? 2 : 3));
            spaces = "   ".substring(spacer);
            this.put(String.valueOf(spaces) + Integer.toHexString(label) + " |" + byteStrBuf + " | " + charStr);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.close();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.traceIsOn()) {
            if (this.usingFile) {
                this.checkReopen();
            } else {
                this.out = "System.out".equals(this.name) ? new PrintWriter(System.out) : new PrintWriter(System.err);
            }
        }
    }

    public boolean isValidDeviceType() {
        return this.out != null;
    }
}

