/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.edt.javart.EglException;
import org.eclipse.edt.javart.EglThrowable;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.FatalException;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.runtime.java.egl.lang.AnyObject;
import org.eclipse.edt.runtime.java.egl.lang.IndexOutOfBoundsException;
import org.eclipse.edt.runtime.java.egl.lang.JavaObjectException;
import org.eclipse.edt.runtime.java.egl.lang.NullValueException;
import org.eclipse.edt.runtime.java.egl.lang.RuntimeException;
import org.eclipse.edt.runtime.java.egl.lang.TypeCastException;

public class JavartUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static GregorianCalendar gregorianCalendar;
    private static ExecutorService threadPool;

    private JavartUtil() {
    }

    public static GregorianCalendar getCalendar() {
        if (gregorianCalendar == null) {
            gregorianCalendar = new GregorianCalendar();
        }
        return gregorianCalendar;
    }

    public static String getCurrentTime() {
        GregorianCalendar calendar = JavartUtil.getCalendar();
        calendar.setTime(new Date());
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        StringBuilder time = new StringBuilder(8);
        if (hour < 10) {
            time.append('0');
        }
        time.append(hour);
        time.append(':');
        if (minute < 10) {
            time.append('0');
        }
        time.append(minute);
        time.append(':');
        if (second < 10) {
            time.append('0');
        }
        time.append(second);
        return time.toString();
    }

    public static String getEglType(Object object) {
        if (object instanceof AnyObject) {
            return ((AnyObject)object).ezeTypeSignature();
        }
        return object.getClass().getName();
    }

    public static String removePackageName(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public static String packageName(String fullName, String defaultName) {
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return defaultName;
        }
        return fullName.substring(0, index);
    }

    public static final boolean alwaysTrue() {
        return true;
    }

    public static final boolean alwaysFalse() {
        return false;
    }

    public static final void beginTry() throws JavartException {
    }

    public static boolean isJavaObjectException(Exception ex) {
        return ex instanceof JavaObjectException || !(ex instanceof JavartException) && !(ex instanceof EglThrowable);
    }

    public static JavaObjectException makeJavaObjectException(Executable p, String name, Exception ex) throws JavartException {
        if (ex instanceof JavaObjectException) {
            return (JavaObjectException)ex;
        }
        String msg = ex.getMessage();
        String className = ex.getClass().getName();
        if (msg == null || msg.trim().length() == 0) {
            msg = className;
        }
        JavaObjectException jox = new JavaObjectException("EGL0099E", msg);
        jox.setExceptionType(className);
        return jox;
    }

    public static String checkSubstringValue(String value, int startIndex, int endIndex, char padding) {
        int subLength;
        int valLength = value.length();
        if (valLength > (subLength = endIndex - startIndex + 1)) {
            return value.substring(0, subLength);
        }
        if (valLength < subLength) {
            StringBuilder buf = new StringBuilder(value);
            int i = valLength;
            while (i < subLength) {
                buf.append(padding);
                ++i;
            }
            return buf.toString();
        }
        return value;
    }

    public static byte[] checkSubstringValue(byte[] value, byte[] padding, int lengthInBytes) {
        if (value.length > lengthInBytes) {
            byte[] newValue = new byte[lengthInBytes];
            System.arraycopy(value, 0, newValue, 0, newValue.length);
            return newValue;
        }
        if (value.length < lengthInBytes) {
            byte[] newValue = new byte[lengthInBytes];
            System.arraycopy(value, 0, newValue, 0, value.length);
            int i = value.length;
            while (i < lengthInBytes) {
                byte pad;
                newValue[i] = pad = padding.length == 1 ? padding[0] : padding[i % 2];
                ++i;
            }
            return newValue;
        }
        return value;
    }

    public static void checkSubstringIndices(Executable program, int startIndex, int endIndex, int maxlen) throws JavartException {
        if (startIndex < 1 || startIndex > maxlen) {
            String message = JavartUtil.errorMessage(program, "EGL0142E", new Object[]{startIndex, endIndex});
            IndexOutOfBoundsException ex = new IndexOutOfBoundsException();
            ex.message = message;
            ex.indexValue = startIndex;
            ex.setMessageID("EGL0142E");
            throw ex;
        }
        if (endIndex < startIndex || endIndex < 1 || endIndex > maxlen) {
            String message = JavartUtil.errorMessage(program, "EGL0142E", new Object[]{startIndex, endIndex});
            IndexOutOfBoundsException ex = new IndexOutOfBoundsException();
            ex.message = message;
            ex.indexValue = endIndex;
            ex.setMessageID("EGL0142E");
            throw ex;
        }
    }

    public static String errorMessage(Executable p, String id) {
        String message = p._runUnit().getLocalizedText().getMessage(id);
        return JavartUtil.errorMessage(id, message, p);
    }

    public static String errorMessage(Executable p, String id, Object[] inserts) {
        String message = p._runUnit().getLocalizedText().getMessage(id, inserts);
        return JavartUtil.errorMessage(id, message, p);
    }

    private static String errorMessage(String id, String message, Executable p) {
        RunUnit ru = p._runUnit();
        String locationMessageId = "EGL0001I";
        String locationMessage = ru.getLocalizedText().getMessage("EGL0001I", new String[]{p._alias()});
        message = String.valueOf(id) + ' ' + message;
        locationMessage = String.valueOf(locationMessageId) + ' ' + locationMessage;
        return String.valueOf(message) + '\n' + locationMessage;
    }

    public static String errorMessage(RunUnit ru, String id) {
        String message = ru.getLocalizedText().getMessage(id);
        return JavartUtil.errorMessage(id, message, ru);
    }

    public static String errorMessage(RunUnit ru, String id, Object[] inserts) {
        String message = ru.getLocalizedText().getMessage(id, inserts);
        return JavartUtil.errorMessage(id, message, ru);
    }

    private static String errorMessage(String id, String message, RunUnit ru) {
        String programName = ru.getStartupInfo().getRuName();
        String locationMessage = ru.getLocalizedText().getMessage("EGL0001I", new String[]{programName});
        message = String.valueOf(id) + ' ' + message;
        locationMessage = "EGL0001I " + locationMessage;
        if (ru.getTrace().traceIsOn()) {
            ru.getTrace().put(message);
            ru.getTrace().put(locationMessage);
        }
        return String.valueOf(message) + '\n' + locationMessage;
    }

    public static void throwDataFormatException(String name, Executable program) throws JavartException {
        String message = JavartUtil.errorMessage(program, "EGL0101E", new Object[]{name});
        JavartUtil.throwRuntimeException("EGL0101E", message, program);
    }

    public static void throwNullReferenceVariableException(Executable program, String nullRef) throws JavartException {
        String message = JavartUtil.errorMessage(program, "EGL0098E", new Object[]{nullRef});
        NullValueException nvx = new NullValueException();
        nvx.message = message;
        nvx.setMessageID("EGL0098E");
        throw nvx;
    }

    public static void throwNullValueException(Executable program) throws JavartException {
        String message = JavartUtil.errorMessage(program, "EGL0106E");
        NullValueException nvx = new NullValueException();
        nvx.message = message;
        nvx.setMessageID("EGL0106E");
        throw nvx;
    }

    public static void throwRuntimeException(String id, String message, Executable program) throws JavartException {
        RuntimeException rex = new RuntimeException();
        rex.setMessage(message);
        rex.setMessageID(id);
        throw rex;
    }

    public static void throwTypeCastException(String actualTypeName, String castToName, Executable program) throws JavartException {
        String message = JavartUtil.errorMessage(program, "EGL0102E", (Object[])new String[]{actualTypeName, castToName});
        TypeCastException tcx = new TypeCastException();
        tcx.message = message;
        tcx.setMessageID("EGL0102E");
        tcx.castToName = castToName;
        tcx.actualTypeName = actualTypeName;
        throw tcx;
    }

    public static void throwUnsupportedOperandsException(String operator, String op1, String op2, Executable program) throws JavartException {
        String message = JavartUtil.errorMessage(program, "EGL0051E", new Object[]{operator, op1, op2});
        JavartUtil.throwRuntimeException("EGL0051E", message, program);
    }

    public static void throwIndexOutOfBoundsException(int index, Executable program) throws JavartException {
        String message = JavartUtil.errorMessage(program, "EGL0144E", new Object[]{String.valueOf(index)});
        IndexOutOfBoundsException ex = new IndexOutOfBoundsException();
        ex.message = message;
        ex.indexValue = index;
        ex.setMessageID("EGL0144E");
        throw ex;
    }

    public static void throwArrayIndexOutOfBoundsException(int index, String name, int size, Executable program) throws JavartException {
        String message = JavartUtil.errorMessage(program, "EGL0141E", new Object[]{String.valueOf(index), name, String.valueOf(size)});
        IndexOutOfBoundsException ex = new IndexOutOfBoundsException();
        ex.message = message;
        ex.indexValue = index;
        ex.setMessageID("EGL0141E");
        throw ex;
    }

    public static String removeTrailingBlanks(String s) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == ' ') {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public static String removeTrailingDbcsBlanks(String s) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == '\u3000') {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public static String removeTrailingDbcsAndSbcsBlanks(String s) {
        int i = s.length() - 1;
        while (i >= 0 && (s.charAt(i) == ' ' || s.charAt(i) == '\u3000')) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public static String removeTrailingUnicodeBlanks(String s) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == ' ') {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public static int getTrueBinLength(int length, int decimals) {
        switch (length) {
            case 4: {
                return Integer.toString(Short.MAX_VALUE - decimals).length();
            }
            case 9: {
                return Integer.toString(Integer.MAX_VALUE - decimals).length();
            }
        }
        return Long.toString(Long.MAX_VALUE - (long)decimals).length();
    }

    public static void noExceptionHandlers(Exception caught) throws Exception {
        if (caught instanceof FatalException || caught instanceof EglThrowable) {
            throw caught;
        }
        if (!(caught instanceof EglException) && caught instanceof JavartException) {
            throw caught;
        }
    }

    public static boolean javaObjectChanged(Object prevValue, Object newValue) {
        if (newValue == null || prevValue == null) {
            return newValue != null || prevValue != null;
        }
        if (newValue.getClass().isArray() && prevValue.getClass().isArray()) {
            int length = Array.getLength(newValue);
            if (length != Array.getLength(prevValue)) {
                return true;
            }
            int i = 0;
            while (i < length) {
                if (JavartUtil.javaObjectChanged(Array.get(prevValue, i), Array.get(newValue, i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (prevValue instanceof String) {
            prevValue = ((String)prevValue).trim();
        }
        if (newValue instanceof String) {
            newValue = ((String)newValue).trim();
        }
        return !newValue.equals(prevValue);
    }

    public static synchronized ExecutorService getThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newCachedThreadPool(new EGLThreadFactory());
        }
        return threadPool;
    }

    private static class EGLThreadFactory
    implements ThreadFactory {
        private EGLThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

