/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import java.util.Calendar;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.egl.lang.ETimestamp;

public class DateTimeLib
extends ExecutableBase {
    private static final long serialVersionUID = 70L;

    public DateTimeLib(RunUnit ru) throws JavartException {
        super(ru);
    }

    public Calendar currentTimeStamp() {
        return DateTimeUtil.getNewCalendar();
    }

    public Integer dayOf(Calendar aTimestamp) throws JavartException {
        if (aTimestamp == null) {
            return 0;
        }
        return aTimestamp.get(5);
    }

    private Calendar extend(Calendar extensionField, String timespanPattern) throws JavartException {
        if (timespanPattern == null) {
            return this.extend(ETimestamp.asTimestamp(this, extensionField, 0, 5));
        }
        if (extensionField == null) {
            return null;
        }
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timespanPattern);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(this, extensionField, startCode, endCode);
    }

    public Calendar extend(Calendar extensionField) throws JavartException {
        return this.extend(extensionField, "yyyyMMddHHmmss");
    }

    public Integer monthOf(Calendar aTimestamp) throws JavartException {
        return aTimestamp != null ? Integer.valueOf(aTimestamp.get(2) + 1) : null;
    }

    public Calendar timeStampValue(String timestampAsString) throws JavartException {
        return this.timeStampValueWithPattern(timestampAsString);
    }

    public Calendar timeStampValueWithPattern(String timestampAsString) throws JavartException {
        return this.timeStampValueWithPattern(timestampAsString, "yyyyMMddHHmmss");
    }

    public Calendar timeStampValueWithPattern(String timestampAsString, String pattern) throws JavartException {
        return ETimestamp.asTimestamp((Executable)this, timestampAsString, pattern);
    }

    public Integer weekdayOf(Calendar aTimestamp) throws JavartException {
        if (aTimestamp == null) {
            return null;
        }
        return aTimestamp.get(7) - 1;
    }

    public Integer yearOf(Calendar aTimestamp) throws JavartException {
        if (aTimestamp == null) {
            return null;
        }
        return aTimestamp.get(1);
    }
}

