/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import egl.lang.AnyNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.runtime.java.egl.lang.AnyObject;
import org.eclipse.edt.runtime.java.egl.lang.NullValueException;
import org.eclipse.edt.runtime.java.egl.lang.NumericOverflowException;

public class EDecimal
extends AnyBoxedObject<BigDecimal>
implements AnyNumber {
    private static final long serialVersionUID = 80L;
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal[][] MAX_DIGIT_ORIENTED_BD_VALUES = new BigDecimal[34][];
    private static final BigDecimal[][] MIN_DIGIT_ORIENTED_BD_VALUES;
    private static final BigDecimal[][] MAX_BYTE_ORIENTED_BD_VALUES;
    private static final BigDecimal[][] MIN_BYTE_ORIENTED_BD_VALUES;
    public static final int TRUNCATE_BD = 1;
    public static final int ROUND_BD = 4;
    public static final int BIGDECIMAL_RESULT_SCALE = 32;
    private static final long[] MAX_DIGIT_ORIENTED_LONG_VALUES;
    private static final long[] MIN_DIGIT_ORIENTED_LONG_VALUES;
    public static final BigInteger[] MAX_DIGIT_ORIENTED_BI_VALUES;
    public static final BigInteger[] MIN_DIGIT_ORIENTED_BI_VALUES;
    private int maxPrecision;

    static {
        EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[0] = new BigDecimal[1];
        EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[0][0] = ZERO;
        MIN_DIGIT_ORIENTED_BD_VALUES = new BigDecimal[34][];
        EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[0] = new BigDecimal[1];
        EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[0][0] = ZERO;
        int i = 1;
        while (i < 34) {
            EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[i] = new BigDecimal[i + 1];
            EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[i] = new BigDecimal[i + 1];
            ++i;
        }
        MAX_BYTE_ORIENTED_BD_VALUES = new BigDecimal[3][];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[0] = new BigDecimal[5];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[0][0] = ZERO;
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[1] = new BigDecimal[10];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[1][0] = ZERO;
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[2] = new BigDecimal[19];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[2][0] = ZERO;
        MIN_BYTE_ORIENTED_BD_VALUES = new BigDecimal[3][];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[0] = new BigDecimal[5];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[0][0] = ZERO;
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[1] = new BigDecimal[10];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[1][0] = ZERO;
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[2] = new BigDecimal[19];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[2][0] = ZERO;
        long[] lArray = new long[20];
        lArray[1] = 9L;
        lArray[2] = 99L;
        lArray[3] = 999L;
        lArray[4] = 9999L;
        lArray[5] = 99999L;
        lArray[6] = 999999L;
        lArray[7] = 9999999L;
        lArray[8] = 99999999L;
        lArray[9] = 999999999L;
        lArray[10] = 9999999999L;
        lArray[11] = 99999999999L;
        lArray[12] = 999999999999L;
        lArray[13] = 9999999999999L;
        lArray[14] = 99999999999999L;
        lArray[15] = 999999999999999L;
        lArray[16] = 9999999999999999L;
        lArray[17] = 99999999999999999L;
        lArray[18] = 999999999999999999L;
        lArray[19] = Long.MAX_VALUE;
        MAX_DIGIT_ORIENTED_LONG_VALUES = lArray;
        long[] lArray2 = new long[20];
        lArray2[1] = -9L;
        lArray2[2] = -99L;
        lArray2[3] = -999L;
        lArray2[4] = -9999L;
        lArray2[5] = -99999L;
        lArray2[6] = -999999L;
        lArray2[7] = -9999999L;
        lArray2[8] = -99999999L;
        lArray2[9] = -999999999L;
        lArray2[10] = -9999999999L;
        lArray2[11] = -99999999999L;
        lArray2[12] = -999999999999L;
        lArray2[13] = -9999999999999L;
        lArray2[14] = -99999999999999L;
        lArray2[15] = -999999999999999L;
        lArray2[16] = -9999999999999999L;
        lArray2[17] = -99999999999999999L;
        lArray2[18] = -999999999999999999L;
        lArray2[19] = Long.MIN_VALUE;
        MIN_DIGIT_ORIENTED_LONG_VALUES = lArray2;
        MAX_DIGIT_ORIENTED_BI_VALUES = new BigInteger[]{BigInteger.ZERO, BigInteger.valueOf(9L), BigInteger.valueOf(99L), BigInteger.valueOf(999L), BigInteger.valueOf(9999L), BigInteger.valueOf(99999L), BigInteger.valueOf(999999L), BigInteger.valueOf(9999999L), BigInteger.valueOf(99999999L), BigInteger.valueOf(999999999L), BigInteger.valueOf(9999999999L), BigInteger.valueOf(99999999999L), BigInteger.valueOf(999999999999L), BigInteger.valueOf(9999999999999L), BigInteger.valueOf(99999999999999L), BigInteger.valueOf(999999999999999L), BigInteger.valueOf(9999999999999999L), BigInteger.valueOf(99999999999999999L), BigInteger.valueOf(999999999999999999L), new BigInteger("9999999999999999999"), new BigInteger("99999999999999999999"), new BigInteger("999999999999999999999"), new BigInteger("9999999999999999999999"), new BigInteger("99999999999999999999999"), new BigInteger("999999999999999999999999"), new BigInteger("9999999999999999999999999"), new BigInteger("99999999999999999999999999"), new BigInteger("999999999999999999999999999"), new BigInteger("9999999999999999999999999999"), new BigInteger("99999999999999999999999999999"), new BigInteger("999999999999999999999999999999"), new BigInteger("9999999999999999999999999999999"), new BigInteger("99999999999999999999999999999999"), new BigInteger("999999999999999999999999999999999")};
        MIN_DIGIT_ORIENTED_BI_VALUES = new BigInteger[]{BigInteger.ZERO, MAX_DIGIT_ORIENTED_BI_VALUES[1].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[2].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[3].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[4].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[5].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[6].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[7].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[8].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[9].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[10].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[11].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[12].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[13].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[14].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[15].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[16].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[17].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[18].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[19].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[20].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[21].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[22].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[23].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[24].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[25].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[26].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[27].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[28].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[29].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[30].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[31].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[32].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[33].negate()};
    }

    public int getPrecision() {
        return this.maxPrecision;
    }

    public int getDecimals() {
        return ((BigDecimal)this.object).scale();
    }

    private EDecimal(BigDecimal value) {
        super(value);
        this.maxPrecision = value.precision();
    }

    private EDecimal(BigDecimal value, int precision) {
        super(value);
        this.maxPrecision = precision;
    }

    public static EDecimal ezeBox(BigDecimal value) {
        return new EDecimal(value);
    }

    public static EDecimal ezeBox(BigDecimal value, int precision, int decimals) {
        return new EDecimal(value, precision);
    }

    public static BigDecimal getMaxValue(int length, int decimals) {
        BigDecimal max = MAX_DIGIT_ORIENTED_BD_VALUES[length][decimals];
        if (max == null) {
            EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[length][decimals] = max = new BigDecimal(MAX_DIGIT_ORIENTED_BI_VALUES[length], decimals);
        }
        return max;
    }

    public static BigDecimal getMinValue(int length, int decimals) {
        BigDecimal min = MIN_DIGIT_ORIENTED_BD_VALUES[length][decimals];
        if (min == null) {
            BigDecimal max = EDecimal.getMaxValue(length, decimals);
            EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[length][decimals] = min = max.negate();
        }
        return min;
    }

    private static BigDecimal handleNumericOverflow(Executable program, BigDecimal value, int precision, int scale, boolean ignoreOverflow) throws JavartException {
        BigDecimal result = value;
        if (!ignoreOverflow) {
            throw new NumericOverflowException();
        }
        BigDecimal divisor = new BigDecimal(BigInteger.ONE, -(precision - scale));
        result = value.subtract(value.divide(divisor, 0, 1).multiply(divisor));
        return result;
    }

    public static Object ezeCast(Object value, Object[] constraints) throws JavartException {
        Integer[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return EDecimal.ezeCast(value, args);
    }

    public static BigDecimal ezeCast(Object value, Integer ... args) throws JavartException {
        return (BigDecimal)AnyObject.ezeCast(value, "asDecimal", EDecimal.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... args) {
        boolean isa = value instanceof EDecimal;
        if (isa && args.length != 0) {
            boolean bl = isa = ((EDecimal)value).getPrecision() == args[0].intValue();
            if (isa && args.length == 1) {
                isa = ((EDecimal)value).getDecimals() == 0;
            } else if (isa && args.length == 2) {
                isa = ((EDecimal)value).getDecimals() == args[1].intValue();
            }
        }
        return isa;
    }

    public static BigDecimal asDecimal(Executable program, Short value, Integer ... args) throws JavartException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(program, BigDecimal.valueOf(value.shortValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value.shortValue());
    }

    public static BigDecimal asDecimal(Executable program, Integer value, Integer ... args) throws JavartException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(program, BigDecimal.valueOf(value.intValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value.intValue());
    }

    public static BigDecimal asDecimal(Executable program, Long value, Integer ... args) throws JavartException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(program, BigDecimal.valueOf(value), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value);
    }

    public static BigDecimal asDecimal(Executable program, BigDecimal value, Integer ... args) throws JavartException {
        if (args.length == 2) {
            return EDecimal.asDecimal(program, value, (int)args[0], (int)args[1]);
        }
        return value;
    }

    public static BigDecimal asDecimal(Executable program, BigDecimal value, int precision, int scale) throws JavartException {
        return EDecimal.asDecimal(program, value, EDecimal.getMaxValue(precision, scale), EDecimal.getMinValue(precision, scale), precision, scale, false);
    }

    public static BigDecimal asDecimal(Executable program, BigDecimal value, BigDecimal max, BigDecimal min, int precision, int scale) throws JavartException {
        return EDecimal.asDecimal(program, value, max, min, precision, scale, false);
    }

    public static BigDecimal asDecimal(Executable program, BigDecimal value, BigDecimal max, BigDecimal min, int precision, int scale, boolean ignoreOverflow) throws JavartException {
        if (value == null) {
            return null;
        }
        BigDecimal result = value;
        if (scale < value.scale()) {
            result = value.setScale(scale, 4);
        }
        if (ignoreOverflow) {
            return result;
        }
        if (result.compareTo(max) <= 0 && result.compareTo(min) >= 0) {
            return result;
        }
        return EDecimal.handleNumericOverflow(program, value, precision, scale, ignoreOverflow);
    }

    public static BigDecimal asDecimal(Executable program, String value, Integer ... args) throws JavartException {
        return EDecimal.asDecimal(program, EDecimal.asDecimal(program, value, false), args);
    }

    public static BigDecimal asDecimal(Executable program, String value, boolean blanksAsZero) {
        if ((value = value.trim()).length() == 0) {
            if (blanksAsZero) {
                return BigDecimal.ZERO;
            }
            throw new NumberFormatException();
        }
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        int decSym = 46;
        if (value.indexOf(101) != -1 || value.indexOf(69) != -1) {
            return new BigDecimal(Double.parseDouble(value));
        }
        if (value.indexOf(decSym) != -1) {
            return new BigDecimal(value);
        }
        if (value.length() > 18) {
            return new BigDecimal(new BigInteger(value));
        }
        return BigDecimal.valueOf(Long.valueOf(value));
    }

    public static String asString(Executable program, BigDecimal value) throws JavartException {
        return value.toString();
    }

    public static BigDecimal plus(Executable program, BigDecimal op1, BigDecimal op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return op1.add(op2);
    }

    public static BigDecimal minus(Executable program, BigDecimal op1, BigDecimal op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return op1.subtract(op2);
    }

    public static BigDecimal divide(Executable program, BigDecimal op1, BigDecimal op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return op1.divide(op2, 32, 4);
    }

    public static BigDecimal multiply(Executable program, BigDecimal op1, BigDecimal op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return op1.multiply(op2);
    }

    public static BigDecimal remainder(Executable program, BigDecimal op1, BigDecimal op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return op1.remainder(op2);
    }

    public static int compareTo(Executable program, BigDecimal op1, BigDecimal op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Executable program, BigDecimal op1, BigDecimal op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 != null && op2 == null || op1 == null && op2 != null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(Executable program, BigDecimal op1, BigDecimal op2) {
        return !EDecimal.equals(program, op1, op2);
    }
}

