/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.runtime.java.egl.lang.AnyObject;
import org.eclipse.edt.runtime.java.egl.lang.AnyValue;
import org.eclipse.edt.runtime.java.egl.lang.EList;
import org.eclipse.edt.runtime.java.egl.lang.EString;

public class EDictionary
extends AnyObject
implements egl.lang.EDictionary {
    private static final long serialVersionUID = 70L;
    public static final int NONE = 0;
    public static final int INSERTION_ORDER = 1;
    public static final int KEY_ORDER = 2;
    private Map<String, Object> map;
    private boolean caseSensitive;
    private int order;

    public EDictionary() {
        this(false, 0);
    }

    public EDictionary(boolean caseSensitive, int order) {
        this.caseSensitive = caseSensitive;
        this.order = order;
        this.createMap();
    }

    public EDictionary(EDictionary other) throws JavartException {
        this(other.caseSensitive, other.order);
        this.insertAll(other);
    }

    @Override
    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void setCaseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
    }

    @Override
    public void setOrder(int orderConstant) {
        this.order = orderConstant;
    }

    @Override
    public void removeElement(String key) throws JavartException {
    }

    @Override
    public int order() {
        return this.order;
    }

    private void createMap() {
        switch (this.order) {
            case 1: {
                this.map = new LinkedHashMap<String, Object>();
                break;
            }
            case 2: {
                this.map = new TreeMap<String, Object>();
                break;
            }
            default: {
                this.map = new HashMap<String, Object>();
            }
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.caseSensitive && key instanceof EString) {
            key = ((String)key).toLowerCase();
        }
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object get(Object key) {
        if (!this.caseSensitive) {
            key = ((String)key).toLowerCase();
        }
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(EString key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection values() {
        return this.map.values();
    }

    @Override
    public String[] getKeyArray() {
        String[] keyArray = new String[this.map.size()];
        int ii = 0;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyArray[ii] = iter.next();
            ++ii;
        }
        return keyArray;
    }

    @Override
    public Object[] getValueArray() {
        Object[] valueArray = new Object[this.map.size()];
        int ii = 0;
        Iterator<Object> iter = this.map.values().iterator();
        while (iter.hasNext()) {
            valueArray[ii] = iter.next();
            ++ii;
        }
        return valueArray;
    }

    public void insert(String key, Object value) {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        this.put(key, value);
    }

    public boolean containsKey(String key) {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        return this.map.containsKey(key);
    }

    public EList<String> getKeys(Executable program) throws JavartException {
        EList<String> keys = new EList<String>();
        for (String key : this.map.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    public EList<Object> getValues(Executable program) throws JavartException {
        EList<Object> vals = new EList<Object>();
        for (Object value : this.map.values()) {
            vals.add(value);
        }
        return vals;
    }

    @Override
    public void insertAll(egl.lang.EDictionary d) throws JavartException {
        if (d == this) {
            return;
        }
        String[] newKeys = d.getKeyArray();
        Object[] newValues = d.getValueArray();
        int ii = 0;
        while (ii < newKeys.length) {
            this.insert(newKeys[ii], newValues[ii]);
            ++ii;
        }
    }

    public void removeElement(Executable program, String key) throws JavartException {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        this.map.remove(key);
    }

    @Override
    public void removeAll() {
        this.map.clear();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EDictionary theClone = (EDictionary)super.clone();
        switch (this.order) {
            case 1: {
                theClone.map = new LinkedHashMap<String, Object>(this.map.size());
                break;
            }
            case 2: {
                theClone.map = new TreeMap<String, Object>();
                break;
            }
            default: {
                theClone.map = new HashMap<String, Object>(this.map.size());
            }
        }
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof AnyValue) {
                value = ((AnyValue)value).clone();
            }
            theClone.map.put(entry.getKey(), value);
        }
        return theClone;
    }

    @Override
    public Object lookup(String key, Executable program) {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        this.map.put(key, value);
        return value;
    }

    @Override
    public egl.lang.AnyObject ezeGet(String name) throws JavartException {
        Object value = this.get(name);
        return value instanceof egl.lang.AnyObject ? (AnyBoxedObject<Object>)value : AnyObject.ezeBox(value);
    }

    @Override
    public void ezeSet(String name, Object value) {
        this.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.map.putAll(map);
    }
}

