/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import egl.lang.AnyNumber;
import java.math.BigDecimal;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.runtime.java.egl.lang.AnyObject;
import org.eclipse.edt.runtime.java.egl.lang.EDecimal;
import org.eclipse.edt.runtime.java.egl.lang.NullValueException;
import org.eclipse.edt.runtime.java.egl.lang.NumericOverflowException;

public class EInt16
extends AnyBoxedObject<Short>
implements AnyNumber {
    private static final long serialVersionUID = 80L;
    private static final int precision = 4;

    private EInt16(Short value) {
        super(value);
    }

    public static EInt16 ezeBox(Short value) {
        return new EInt16(value);
    }

    public static Short ezeCast(Object value) throws JavartException {
        return (Short)AnyObject.ezeCast(value, "asInt16", EInt16.class, null, null);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof EInt16;
    }

    public static Short asInt16(Executable program, Short value) {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static Short asInt16(Executable program, Integer value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = true;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value.intValue()).shortValueExact();
            }
            catch (ArithmeticException ex) {
                throw new NumericOverflowException(ex.getLocalizedMessage());
            }
        } else {
            result = Long.valueOf(value.intValue()).shortValue();
        }
        return result;
    }

    public static Short asInt16(Executable program, Long value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = true;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value).shortValueExact();
            }
            catch (ArithmeticException ex) {
                throw new NumericOverflowException(ex.getLocalizedMessage());
            }
        } else {
            result = Long.valueOf(value).shortValue();
        }
        return result;
    }

    public static Short asInt16(Executable program, Float value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = true;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value.floatValue()).shortValueExact();
            }
            catch (ArithmeticException ex) {
                throw new NumericOverflowException(ex.getLocalizedMessage());
            }
        } else {
            result = value.shortValue();
        }
        return result;
    }

    public static Short asInt16(Executable program, Double value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = true;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value).shortValueExact();
            }
            catch (ArithmeticException ex) {
                throw new NumericOverflowException(ex.getLocalizedMessage());
            }
        } else {
            result = value.shortValue();
        }
        return result;
    }

    public static Short asInt16(Executable program, BigDecimal value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = true;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = value.shortValueExact();
            }
            catch (ArithmeticException ex) {
                throw new NumericOverflowException(ex.getLocalizedMessage());
            }
        } else {
            result = value.shortValue();
        }
        return result;
    }

    public static Short asInt16(Executable program, String value) throws JavartException {
        if (value == null) {
            return null;
        }
        return EInt16.asInt16(program, EDecimal.asDecimal(program, value, new Integer[0]));
    }

    public static int plus(Executable program, Short op1, Short op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return op1 + op2;
    }

    public static int minus(Executable program, Short op1, Short op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return op1 - op2;
    }

    public static BigDecimal divide(Executable program, Short op1, Short op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return BigDecimal.valueOf(op1.shortValue()).divide(BigDecimal.valueOf(op2.shortValue()), 32, 4);
    }

    public static int multiply(Executable program, Short op1, Short op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        try {
            return BigDecimal.valueOf(op1 * op2).intValueExact();
        }
        catch (ArithmeticException ex) {
            throw new NumericOverflowException(ex.getLocalizedMessage());
        }
    }

    public static int remainder(Executable program, Short op1, Short op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return op1 % op2;
    }

    public static int compareTo(Executable program, Short op1, Short op2) throws JavartException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        if (op1 != null && op2 == null || op1 == null && op2 != null) {
            throw new NullValueException();
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Executable program, Short op1, Short op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 != null && op2 == null || op1 == null && op2 != null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(Executable program, Short op1, Short op2) {
        return !EInt16.equals(program, op1, op2);
    }

    public int precision() {
        return 4;
    }
}

