/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import egl.lang.AnyNumber;
import java.math.BigDecimal;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.runtime.java.egl.lang.AnyObject;
import org.eclipse.edt.runtime.java.egl.lang.EDecimal;
import org.eclipse.edt.runtime.java.egl.lang.NullValueException;

public class EInt32
extends AnyBoxedObject<Integer>
implements AnyNumber {
    private static final long serialVersionUID = 80L;
    private static final int DefaultValue = 0;
    private static final int Precision = 9;

    private EInt32(Integer value) {
        super(value);
    }

    public static EInt32 ezeBox(Integer value) {
        return new EInt32(value);
    }

    public static Integer ezeCast(Object value) throws JavartException {
        return (Integer)AnyObject.ezeCast(value, "asInt32", EInt32.class, null, null);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof EInt32;
    }

    public static Integer asInt32(Executable program, Short value) throws JavartException {
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public static Integer asInt32(Executable program, Long value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? BigDecimal.valueOf(value).intValueExact() : Long.valueOf(value).intValue();
        return result;
    }

    public static Integer asInt32(Executable program, BigDecimal value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? value.intValueExact() : value.intValue();
        return result;
    }

    public static Integer asInt32(Executable program, Float value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? BigDecimal.valueOf(value.floatValue()).intValueExact() : value.intValue();
        return result;
    }

    public static Integer asInt32(Executable program, Double value) throws JavartException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        int result = 0;
        result = throwOverflowExceptions ? BigDecimal.valueOf(value).intValueExact() : value.intValue();
        return result;
    }

    public static Integer asInt32(Executable program, String value) throws JavartException {
        if (value == null) {
            return null;
        }
        return EInt32.asInt32(program, EDecimal.asDecimal(program, value, new Integer[0]));
    }

    public static int defaultValue() {
        return 0;
    }

    public static int precision() {
        return 9;
    }

    public static int plus(Executable program, Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return BigDecimal.valueOf((long)op1.intValue() + (long)op2.intValue()).intValueExact();
    }

    public static int minus(Executable program, Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return BigDecimal.valueOf((long)op1.intValue() - (long)op2.intValue()).intValueExact();
    }

    public static BigDecimal divide(Executable program, Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return BigDecimal.valueOf(op1.intValue()).divide(BigDecimal.valueOf(op2.intValue()), 32, 4);
    }

    public static int multiply(Executable program, Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return BigDecimal.valueOf((long)op1.intValue() * (long)op2.intValue()).intValueExact();
    }

    public static int remainder(Executable program, Integer op1, Integer op2) throws JavartException {
        if (op1 == null || op2 == null) {
            throw new NullValueException();
        }
        return op1 % op2;
    }

    public static int compareTo(Executable program, Integer op1, Integer op2) throws JavartException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        if (op1 != null && op2 == null || op1 == null && op2 != null) {
            throw new NullValueException();
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Executable program, Integer op1, Integer op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 != null && op2 == null || op1 == null && op2 != null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(Executable program, Integer op1, Integer op2) {
        return !EInt32.equals(program, op1, op2);
    }
}

