/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.egl.lang.AnyObject;
import org.eclipse.edt.runtime.java.egl.lang.TimestampFormatException;
import org.eclipse.edt.runtime.java.egl.lang.TypeCastException;

public class ETimestamp
extends AnyBoxedObject<Calendar> {
    private static final long serialVersionUID = 80L;
    public static final String DefaultPattern = "yyyyMMddHHmmss";
    public static final String DefaultFormatPattern = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final int YEAR_CODE = 0;
    public static final int MONTH_CODE = 1;
    public static final int DAY_CODE = 2;
    public static final int HOUR_CODE = 3;
    public static final int MINUTE_CODE = 4;
    public static final int SECOND_CODE = 5;
    public static final int FRACTION1_CODE = 6;
    public static final int FRACTION2_CODE = 7;
    public static final int FRACTION3_CODE = 8;
    public static final int FRACTION4_CODE = 9;
    public static final int FRACTION5_CODE = 10;
    public static final int FRACTION6_CODE = 11;
    private int startCode;
    private int endCode;

    public ETimestamp() {
        this(DateTimeUtil.getNewCalendar(), 0, 5);
    }

    public ETimestamp(Calendar value, int startCode, int endCode) {
        super(value);
        this.startCode = startCode;
        this.endCode = endCode;
    }

    public static ETimestamp ezeBox(Calendar value, int startCode, int endCode) {
        return new ETimestamp((Calendar)value.clone(), startCode, endCode);
    }

    public static Object ezeCast(Object value, Object[] constraints) throws JavartException {
        Integer[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return ETimestamp.ezeCast(value, args);
    }

    public static BigDecimal ezeCast(Object value, Integer ... args) throws JavartException {
        return (BigDecimal)AnyObject.ezeCast(value, "asTimestamp", ETimestamp.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... args) {
        boolean isa = value instanceof ETimestamp;
        if (isa && args.length == 2) {
            isa = ((ETimestamp)value).startCode == args[0] && ((ETimestamp)value).endCode == args[1];
        }
        return isa;
    }

    public static Calendar asTimestamp(Executable program, Calendar timestamp, String timespanMask) throws JavartException {
        if (timestamp == null) {
            return null;
        }
        if (timespanMask == null || timespanMask.length() == 0) {
            timespanMask = DefaultPattern;
        }
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timespanMask);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(program, timestamp, startCode, endCode);
    }

    public static Calendar asTimestamp(Executable program, String timestampString, String timespanMask) throws JavartException {
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timespanMask);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.convert(timestampString, startCode, endCode);
    }

    public static Calendar asTimestamp(Executable program, Calendar date, int startCode, int endCode) {
        int milliseconds;
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        if (date == null) {
            return null;
        }
        Calendar result = DateTimeUtil.getBaseCalendar();
        Calendar forDefaults = null;
        if (startCode == 0) {
            year = date.get(1);
        } else {
            forDefaults = DateTimeUtil.getNewCalendar();
            year = forDefaults.get(1);
        }
        if (startCode <= 1 && endCode >= 1) {
            month = date.get(2);
        } else if (startCode < 1) {
            month = 0;
        } else {
            if (forDefaults == null) {
                forDefaults = DateTimeUtil.getNewCalendar();
            }
            month = forDefaults.get(2);
        }
        if (startCode <= 2 && endCode >= 2) {
            day = date.get(5);
        } else if (startCode < 2) {
            day = 1;
        } else {
            if (forDefaults == null) {
                forDefaults = DateTimeUtil.getNewCalendar();
            }
            day = forDefaults.get(5);
        }
        if (startCode <= 3 && endCode >= 3) {
            hour = date.get(11);
        } else if (startCode < 3) {
            hour = 0;
        } else {
            if (forDefaults == null) {
                forDefaults = DateTimeUtil.getNewCalendar();
            }
            hour = forDefaults.get(11);
        }
        if (startCode <= 4 && endCode >= 4) {
            minute = date.get(12);
        } else if (startCode < 4) {
            minute = 0;
        } else {
            if (forDefaults == null) {
                forDefaults = DateTimeUtil.getNewCalendar();
            }
            minute = forDefaults.get(12);
        }
        if (startCode <= 5 && endCode >= 5) {
            second = date.get(13);
        } else if (startCode < 5) {
            second = 0;
        } else {
            if (forDefaults == null) {
                forDefaults = DateTimeUtil.getNewCalendar();
            }
            second = forDefaults.get(13);
        }
        if (startCode <= 6 && endCode >= 6) {
            milliseconds = date.get(14);
        } else if (startCode < 6) {
            milliseconds = 0;
        } else {
            if (forDefaults == null) {
                forDefaults = DateTimeUtil.getNewCalendar();
            }
            milliseconds = forDefaults.get(14);
        }
        result.set(year, month, day, hour, minute, second);
        result.set(14, milliseconds);
        return result;
    }

    public static Calendar asTimestamp(Executable program, String source, String format, int startCode, int endCode) throws JavartException {
        Calendar result;
        if (source == null) {
            return null;
        }
        source = source.trim();
        if (format == null || format.length() == 0) {
            format = program._runUnit().getDefaultTimestampFormat();
        }
        try {
            result = ETimestamp.convert(source, format);
        }
        catch (ParseException parseException) {
            result = ETimestamp.convert(source, startCode, endCode);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String asString(Executable program, Calendar value) throws JavartException {
        String format = program._runUnit().getDefaultTimestampFormat();
        if (format.length() == 0) {
            format = DefaultFormatPattern;
        }
        boolean reset = false;
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
            int micros = value.get(14) * 1000;
            if (micros < 0) {
                reset = true;
                value.add(13, -1);
                micros += 1000000;
            }
            formatter.setCentury(value.get(1) / 100 + 1);
            formatter.setMicrosecond(micros);
            try {
                String string = formatter.format(value.getTime());
                // ** MonitorExit[byArray] (shouldn't be in output)
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TimestampFormatException();
            }
            finally {
                if (reset) {
                    value.add(13, 1);
                }
            }
        }
    }

    private static Calendar convert(String source, int startCode, int endCode) {
        int microseconds;
        int seconds;
        int minutes;
        int hours;
        int days;
        int months;
        int years;
        block31: {
            char ch;
            int i;
            int length;
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                years = -1;
                                months = -1;
                                days = -1;
                                hours = -1;
                                minutes = -1;
                                seconds = -1;
                                microseconds = -1;
                                length = source.length();
                                if (length <= 0) break block31;
                                i = 0;
                                do {
                                    ch = source.charAt(i);
                                } while (++i < length && ('0' > ch || ch > '9'));
                                if (i <= length && startCode == 0) {
                                    years = 0;
                                    int j = 0;
                                    while ('0' <= ch && ch <= '9' && j < 4) {
                                        years = years * 10 + ch - 48;
                                        if (i < length) {
                                            ch = source.charAt(i);
                                            ++i;
                                            ++j;
                                            continue;
                                        }
                                        break block31;
                                    }
                                }
                                while (i < length && ('0' > ch || ch > '9')) {
                                    ch = source.charAt(i);
                                    ++i;
                                }
                                if (i > length || startCode > 1 || endCode < 1) break block32;
                                months = ch - 48;
                                if (i >= length) break block31;
                                ch = source.charAt(i);
                                ++i;
                                if ('0' > ch || ch > '9') break block32;
                                months = months * 10 + ch - 48;
                                if (i >= length) break block31;
                                ch = source.charAt(i);
                                ++i;
                            }
                            while (i < length && ('0' > ch || ch > '9')) {
                                ch = source.charAt(i);
                                ++i;
                            }
                            if (i > length || startCode > 2 || endCode < 2) break block33;
                            days = ch - 48;
                            if (i >= length) break block31;
                            ch = source.charAt(i);
                            ++i;
                            if ('0' > ch || ch > '9') break block33;
                            days = days * 10 + ch - 48;
                            if (i >= length) break block31;
                            ch = source.charAt(i);
                            ++i;
                        }
                        while (i < length && ('0' > ch || ch > '9')) {
                            ch = source.charAt(i);
                            ++i;
                        }
                        if (i > length || startCode > 3 || endCode < 3) break block34;
                        hours = ch - 48;
                        if (i >= length) break block31;
                        ch = source.charAt(i);
                        ++i;
                        if ('0' > ch || ch > '9') break block34;
                        hours = hours * 10 + ch - 48;
                        if (i >= length) break block31;
                        ch = source.charAt(i);
                        ++i;
                    }
                    while (i < length && ('0' > ch || ch > '9')) {
                        ch = source.charAt(i);
                        ++i;
                    }
                    if (i > length || startCode > 4 || endCode < 4) break block35;
                    minutes = ch - 48;
                    if (i >= length) break block31;
                    ch = source.charAt(i);
                    ++i;
                    if ('0' > ch || ch > '9') break block35;
                    minutes = minutes * 10 + ch - 48;
                    if (i >= length) break block31;
                    ch = source.charAt(i);
                    ++i;
                }
                while (i < length && ('0' > ch || ch > '9')) {
                    ch = source.charAt(i);
                    ++i;
                }
                if (i > length || startCode > 5 || endCode < 5) break block36;
                seconds = ch - 48;
                if (i >= length) break block31;
                ch = source.charAt(i);
                ++i;
                if ('0' > ch || ch > '9') break block36;
                seconds = seconds * 10 + ch - 48;
                if (i >= length) break block31;
                ch = source.charAt(i);
                ++i;
            }
            while (i < length && ('0' > ch || ch > '9')) {
                ch = source.charAt(i);
                ++i;
            }
            if (i <= length && endCode >= 6) {
                microseconds = 0;
                int microsecondsFound = 0;
                int fractionDigits = endCode - 6 + 1;
                while (microsecondsFound < fractionDigits && '0' <= ch && ch <= '9') {
                    microseconds *= 10;
                    microseconds += ch - 48;
                    ++microsecondsFound;
                    if (i >= length) break;
                    ch = source.charAt(i);
                    ++i;
                }
                if (microsecondsFound < 6) {
                    int j = microsecondsFound;
                    while (j < 6) {
                        microseconds *= 10;
                        ++j;
                    }
                }
            }
        }
        if (years == -1 && startCode == 0 || months == -1 && startCode <= 1 && endCode >= 1 || days == -1 && startCode <= 2 && endCode >= 2 || hours == -1 && startCode <= 3 && endCode >= 3 || minutes == -1 && startCode <= 4 && endCode >= 4 || seconds == -1 && startCode <= 5 && endCode >= 5 || microseconds == -1 && endCode >= 6) {
            throw new TypeCastException();
        }
        Calendar cal = DateTimeUtil.getBaseCalendar();
        if (years != -1) {
            cal.set(1, years);
        }
        if (months != -1) {
            cal.set(2, months - 1);
        }
        if (days != -1) {
            cal.set(5, days);
        } else if (months != -1) {
            cal.set(5, 1);
        }
        if (hours != -1) {
            cal.set(11, hours);
        }
        if (minutes != -1) {
            cal.set(12, minutes);
        }
        if (seconds != -1) {
            cal.set(13, seconds);
        }
        if (microseconds == -1) {
            microseconds = 0;
        }
        cal.set(14, 0);
        try {
            cal.getTimeInMillis();
        }
        catch (Exception exception) {
            throw new TypeCastException();
        }
        Calendar result = cal;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar convert(String source, String format) throws ParseException {
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
            formatter.setMicrosecond(0);
            Date date = formatter.parse(source);
            Calendar cal = DateTimeUtil.getBaseCalendar();
            cal.setTime(date);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cal;
        }
    }

    public static String createPattern(int startCode, int endCode) {
        if (startCode > endCode) {
            return null;
        }
        String[] code = new String[]{"yyyy", "MM", "dd", "HH", "mm", "ss", "SSSSSS"};
        String[] delimiters = new String[]{"-", "-", " ", ":", ":", "."};
        int sindex = startCode > 6 ? 6 : startCode;
        int eindex = endCode > 6 ? 6 : endCode;
        StringBuilder patternString = new StringBuilder(26);
        int i = sindex;
        int j = 0;
        while (i <= eindex) {
            if (j > 0) {
                patternString.append(delimiters[i - 1]);
            }
            patternString.append(code[i]);
            ++i;
            ++j;
        }
        return patternString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar defaultValue() {
        Class<ETimestamp> clazz = ETimestamp.class;
        synchronized (ETimestamp.class) {
            long now = System.currentTimeMillis();
            Calendar cal = DateTimeUtil.getBaseCalendar();
            cal.setTimeInMillis(now);
            cal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(10), cal.get(12), cal.get(13));
            cal.set(14, cal.get(14));
            // ** MonitorExit[var1] (shouldn't be in output)
            return cal;
        }
    }
}

