/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.egl.lang;

import egl.lang.EList;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import org.eclipse.edt.javart.EglException;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.JavartException;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.resources.Platform;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.util.JavartUtil;
import org.eclipse.edt.runtime.java.egl.lang.RuntimeException;

public class System
extends ExecutableBase {
    private static final long serialVersionUID = 70L;
    private transient PrintWriter outputStream = null;
    public EglException currentException = null;

    public System(RunUnit ru) throws JavartException {
        super(ru);
    }

    public String getProperty(String propertyName) {
        String value = this._runUnit().getProperties().get(propertyName.trim());
        if (value == null) {
            value = java.lang.System.getProperty(propertyName.trim());
        }
        return value;
    }

    public void writeStdout(String output) {
        java.lang.System.out.println(output);
    }

    public void writeStderr(String output) {
        java.lang.System.err.println(output);
    }

    public void wait(BigDecimal time) {
        time = time.movePointRight(2);
        time = new BigDecimal(BigInteger.valueOf(time.longValue()));
        try {
            Thread.sleep(time.longValue() * 10L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public void startLog(String filename) throws JavartException {
        try {
            this.outputStream = new PrintWriter((Writer)new BufferedWriter(new FileWriter(filename, true)), true);
        }
        catch (IOException e) {
            JavartUtil.throwRuntimeException("EGL0117E", JavartUtil.errorMessage(null, "EGL0117E", new Object[]{"SysLib.startLog", e}), null);
        }
    }

    public void errorLog(String errorMsg) {
        if (this.outputStream == null) {
            return;
        }
        this.outputStream.println(this._runUnit().getLocalizedText().getDateFormatter().format(new Date()));
        this.outputStream.println(errorMsg);
    }

    public boolean _errorLogIsOn() {
        return this.outputStream != null;
    }

    public static void callCmd(String commandString) throws JavartException {
        System.callCmd(commandString, true);
    }

    public static void callCmd(String commandString, boolean lineMode) throws JavartException {
        System.runCommand(commandString, lineMode, true);
    }

    public static void startCmd(String commandString) throws JavartException {
        System.startCmd(commandString, true);
    }

    public static void startCmd(String commandString, boolean lineMode) throws JavartException {
        System.runCommand(commandString, lineMode, false);
    }

    private static void runCommand(String commandString, boolean lineMode, boolean wait) throws JavartException {
        Process proc;
        try {
            proc = Platform.SYSTEM_TYPE == "WIN     " ? Runtime.getRuntime().exec(new String[]{"cmd", "/c", commandString}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", commandString});
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (wait) {
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getErrorStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getInputStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            try {
                proc.waitFor();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public long currentTimeMillis() {
        return java.lang.System.currentTimeMillis();
    }

    public String getMessage(Executable program, String key) {
        return this.getMessage(program, key, null);
    }

    public String getMessage(Executable program, String key, EList<String> inserts) {
        Object[] insertStrings = null;
        if (inserts != null) {
            insertStrings = new String[inserts.size()];
            int i = 0;
            while (i < insertStrings.length) {
                insertStrings[i] = (String)inserts.get(i);
                ++i;
            }
        }
        key = key.trim();
        String message = program._runUnit().getLocalizedText().getMessage(key, insertStrings);
        return message;
    }

    public void rollback(Executable program) throws JavartException {
        block13: {
            RuntimeException errorException = null;
            Trace trace = program._runUnit().getTrace();
            boolean tracing = trace.traceIsOn(1);
            try {
                try {
                    if (tracing) {
                        trace.put("rollBack()");
                        trace.put("    resetting Recoverable Resources ...");
                    }
                    program._runUnit().rollback();
                }
                catch (JavartException jx) {
                    String message = JavartUtil.errorMessage(program, "EGL0117E", new Object[]{"SysLib.rollBack", jx.getMessage()});
                    errorException = new RuntimeException("EGL0117E", message);
                    if (errorException == null) {
                        if (tracing) {
                            trace.put("<-- rollBack()   rc = 0");
                        }
                        break block13;
                    }
                    if (tracing) {
                        trace.put("<-- rollBack()   rc <> 0");
                    }
                    throw errorException;
                }
            }
            finally {
                if (errorException == null) {
                    if (tracing) {
                        trace.put("<-- rollBack()   rc = 0");
                    }
                } else {
                    if (tracing) {
                        trace.put("<-- rollBack()   rc <> 0");
                    }
                    throw errorException;
                }
            }
        }
    }

    public void setLocale(Executable program, String languageCode, String countryCode, String variant) {
        Locale locale = variant == null ? new Locale(languageCode, countryCode) : new Locale(languageCode, countryCode, variant);
        program._runUnit().switchLocale(locale);
    }
}

