/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.SMAPFunctionInfo;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;

public class SMAPUtil {
    private static final SMAPVariableInfo[] EMPTY_VARIABLE_INFOS = new SMAPVariableInfo[0];

    private SMAPUtil() {
    }

    public static SMAPVariableInfo[] parseVariables(String smap, IEGLJavaStackFrame frame) {
        if (smap == null || smap.trim().length() == 0) {
            return EMPTY_VARIABLE_INFOS;
        }
        ArrayList<SMAPVariableInfo> vars = new ArrayList<SMAPVariableInfo>();
        int idx = smap.indexOf("*E");
        if (idx != -1) {
            String variableSection = smap.substring(idx + 2).trim();
            StringTokenizer tok = new StringTokenizer(variableSection, "\n");
            String javaFrameSignature = null;
            if (frame != null) {
                try {
                    javaFrameSignature = String.valueOf(frame.getJavaStackFrame().getMethodName()) + ";" + frame.getJavaStackFrame().getSignature();
                }
                catch (DebugException debugException) {}
            }
            String currentFunction = null;
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken().trim();
                int tokenLen = next.length();
                if (tokenLen == 0) continue;
                if ("*X".equals(next)) break;
                boolean specialGlobalType = next.charAt(0) == '*';
                try {
                    String eglName;
                    StringTokenizer semiTok;
                    int semicolon;
                    int line;
                    if (specialGlobalType) {
                        line = -1;
                        semicolon = next.indexOf(59);
                    } else {
                        int pound = next.indexOf(35);
                        if (pound == -1) continue;
                        line = Integer.parseInt(next.substring(0, pound));
                        semicolon = next.indexOf(59, pound);
                    }
                    if (semicolon == -1) continue;
                    if (specialGlobalType) {
                        semiTok = new StringTokenizer(next.substring(semicolon + 1), ";");
                        int tokenCount = semiTok.countTokens();
                        if (tokenCount <= 0) continue;
                        eglName = semiTok.nextToken();
                        String javaName = tokenCount > 1 ? semiTok.nextToken() : eglName;
                        String type = tokenCount > 2 ? semiTok.nextToken() : eglName;
                        vars.add(new SMAPVariableInfo(eglName, javaName, type, line, next));
                        continue;
                    }
                    if (tokenLen > semicolon + 2 && next.charAt(semicolon + 1) == 'F' && next.charAt(semicolon + 2) == ':') {
                        int semicolon2 = next.indexOf(59, semicolon + 1);
                        if (semicolon2 == -1) continue;
                        eglName = next.substring(semicolon + 3, semicolon2);
                        currentFunction = next.substring(semicolon2 + 1);
                        if (frame == null || currentFunction == null || !currentFunction.equals(javaFrameSignature)) continue;
                        frame.setSMAPFunctionInfo(new SMAPFunctionInfo(eglName, currentFunction, line, next));
                        continue;
                    }
                    semiTok = new StringTokenizer(next.substring(semicolon + 1), ";");
                    if (semiTok.countTokens() != 3) continue;
                    vars.add(new SMAPVariableInfo(semiTok.nextToken(), semiTok.nextToken(), semiTok.nextToken(), line, currentFunction, next));
                }
                catch (NumberFormatException nfe) {
                    EDTDebugCorePlugin.log(nfe);
                }
            }
        }
        return vars.toArray(new SMAPVariableInfo[vars.size()]);
    }

    public static String getSMAP(IJavaType type) {
        Type underlyingType;
        String smap = null;
        if (type instanceof JDIReferenceType && (underlyingType = ((JDIReferenceType)type).getUnderlyingType()) instanceof ReferenceType) {
            try {
                smap = ((ReferenceType)underlyingType).sourceDebugExtension();
            }
            catch (AbsentInformationException absentInformationException) {}
        }
        return smap == null ? "" : smap.trim();
    }
}

