/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.edt.debug.core.IEGLThread;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaThread;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.SMAPFunctionInfo;
import org.eclipse.edt.debug.core.java.SMAPUtil;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaThread;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.VariableUtil;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;

public class EGLJavaStackFrame
extends EGLJavaDebugElement
implements IEGLJavaStackFrame,
IDropToFrame {
    private IJavaStackFrame javaFrame;
    private final IEGLJavaThread eglThread;
    private IVariable[] variables;
    private Hashtable<String, IEGLJavaVariable> currentEGLVariables;
    private Hashtable<String, IEGLJavaVariable> previousEGLVariables;
    private String smap;
    private SMAPVariableInfo[] smapVariableInfos;
    private SMAPFunctionInfo smapFunctionInfo;
    private int lineBeforeStepInto;

    public EGLJavaStackFrame(IJavaStackFrame frame, EGLJavaThread thread) {
        super(thread.getDebugTarget());
        this.eglThread = thread;
        this.bind(frame);
    }

    protected void bind(IJavaStackFrame javaFrame) {
        int oldSize;
        this.javaFrame = javaFrame;
        this.previousEGLVariables = this.currentEGLVariables;
        int hashSize = 10;
        if (this.previousEGLVariables != null && (oldSize = this.previousEGLVariables.size()) > hashSize) {
            hashSize = oldSize;
        }
        this.currentEGLVariables = new Hashtable(hashSize);
        this.variables = null;
    }

    public boolean canStepInto() {
        return this.javaFrame.canStepInto();
    }

    public boolean canStepOver() {
        return this.javaFrame.canStepOver();
    }

    public boolean canStepReturn() {
        return this.javaFrame.canStepReturn();
    }

    public boolean isStepping() {
        return this.javaFrame.isStepping();
    }

    public void stepInto() throws DebugException {
        this.javaFrame.stepInto();
    }

    public void stepOver() throws DebugException {
        this.javaFrame.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.javaFrame.stepReturn();
    }

    public boolean canResume() {
        return this.javaFrame.canResume();
    }

    public boolean canSuspend() {
        return this.javaFrame.canSuspend();
    }

    public boolean isSuspended() {
        return this.javaFrame.isSuspended();
    }

    public void resume() throws DebugException {
        this.javaFrame.resume();
    }

    public void suspend() throws DebugException {
        this.javaFrame.suspend();
    }

    public boolean canTerminate() {
        return this.javaFrame.canTerminate();
    }

    public boolean isTerminated() {
        return this.javaFrame.isTerminated();
    }

    public void terminate() throws DebugException {
        this.javaFrame.terminate();
    }

    public IThread getThread() {
        return this.eglThread;
    }

    @Override
    public IEGLJavaThread getEGLThread() {
        return this.eglThread;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.variables != null) {
            return this.variables;
        }
        if (this.getSMAP().length() == 0) {
            this.variables = this.javaFrame.getVariables();
        } else {
            List<IEGLJavaVariable> newEGLVariables = VariableUtil.filterAndWrapVariables(this.javaFrame.getVariables(), this, true, null);
            this.variables = new EGLJavaVariable[newEGLVariables.size() + 1];
            newEGLVariables.toArray(this.variables);
            this.variables[this.variables.length - 1] = this.getCorrespondingVariable(new EGLJavaFunctionVariable(this), null);
        }
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length != 0;
    }

    public int getLineNumber() throws DebugException {
        return this.javaFrame.getLineNumber();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.javaFrame.getName();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.javaFrame.getRegisterGroups();
    }

    public boolean hasRegisterGroups() throws DebugException {
        return this.javaFrame.hasRegisterGroups();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IStackFrame.class || adapter == EGLJavaStackFrame.class || adapter == IEGLStackFrame.class || adapter == IDropToFrame.class || adapter == IEGLJavaStackFrame.class) {
            return this;
        }
        if (adapter == IThread.class || adapter == EGLJavaThread.class || adapter == IEGLThread.class || adapter == IEGLJavaThread.class) {
            return this.getThread();
        }
        if (adapter == IJavaStackFrame.class) {
            return this.javaFrame;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IJavaStackFrame getJavaStackFrame() {
        return this.javaFrame;
    }

    @Override
    public Object getJavaDebugElement() {
        return this.getJavaStackFrame();
    }

    public boolean canDropToFrame() {
        return this.javaFrame.canDropToFrame();
    }

    public void dropToFrame() throws DebugException {
        this.javaFrame.dropToFrame();
    }

    public String getSMAP() throws DebugException {
        if (this.smap == null) {
            this.smap = SMAPUtil.getSMAP((IJavaType)this.javaFrame.getReferenceType());
        }
        return this.smap;
    }

    @Override
    public SMAPVariableInfo[] getSMAPVariableInfos() throws DebugException {
        if (this.smapVariableInfos == null) {
            this.smapVariableInfos = SMAPUtil.parseVariables(this.getSMAP(), this);
        }
        return this.smapVariableInfos;
    }

    @Override
    public void setSMAPVariableInfos(SMAPVariableInfo[] infos) {
        this.smapVariableInfos = infos;
    }

    @Override
    public SMAPFunctionInfo getSMAPFunctionInfo() throws DebugException {
        this.getSMAPVariableInfos();
        return this.smapFunctionInfo;
    }

    @Override
    public void setSMAPFunctionInfo(SMAPFunctionInfo info) {
        this.smapFunctionInfo = info;
    }

    public int getLineBeforeStepInto() {
        return this.lineBeforeStepInto;
    }

    public void setLineBeforeStepInto(int line) {
        this.lineBeforeStepInto = line;
    }

    @Override
    public IEGLJavaVariable getCorrespondingVariable(IEGLJavaVariable newVariable, IEGLJavaValue parent) throws DebugException {
        IEGLJavaVariable eglVar = null;
        String qualifiedName = VariableUtil.getQualifiedName(newVariable);
        if (this.previousEGLVariables != null) {
            eglVar = this.previousEGLVariables.get(qualifiedName);
        }
        if (eglVar != null) {
            eglVar.initialize(newVariable, parent);
        } else {
            eglVar = newVariable;
        }
        if (this.currentEGLVariables != null) {
            this.currentEGLVariables.put(qualifiedName, eglVar);
        }
        return eglVar;
    }
}

