/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.edt.debug.core.IEGLVariable;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaStackFrame;
import org.eclipse.edt.debug.internal.core.java.EGLJavaValue;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class EGLJavaVariable
extends EGLJavaDebugElement
implements IEGLJavaVariable {
    protected IJavaVariable javaVariable;
    protected IEGLJavaValue value;
    protected SMAPVariableInfo variableInfo;
    protected IEGLJavaStackFrame frame;
    protected IEGLJavaValue parent;

    public EGLJavaVariable(IDebugTarget target, IJavaVariable javaVariable, SMAPVariableInfo variableInfo, IEGLJavaStackFrame frame, IEGLJavaValue parent) {
        super(target);
        this.initialize(frame, variableInfo, javaVariable, parent);
    }

    @Override
    public void initialize(IEGLJavaVariable newVariable, IEGLJavaValue newParent) {
        this.initialize(newVariable.getEGLStackFrame(), newVariable.getVariableInfo(), newVariable.getJavaVariable(), newParent);
    }

    private void initialize(IEGLJavaStackFrame frame, SMAPVariableInfo varInfo, IJavaVariable javaVar, IEGLJavaValue parent) {
        this.frame = frame;
        this.variableInfo = varInfo;
        this.javaVariable = javaVar;
        this.parent = parent;
        this.value = null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IVariable.class || adapter == EGLJavaVariable.class || adapter == IEGLVariable.class || adapter == IEGLJavaVariable.class) {
            return this;
        }
        if (adapter == IJavaVariable.class) {
            return this.javaVariable;
        }
        if (adapter == IStackFrame.class || adapter == IEGLStackFrame.class || adapter == IEGLJavaStackFrame.class || adapter == EGLJavaStackFrame.class) {
            return this.frame;
        }
        if (adapter == IJavaStackFrame.class) {
            return this.frame.getJavaStackFrame();
        }
        return super.getAdapter(adapter);
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        if (this.value == null) {
            this.value = this.createEGLValue((IJavaValue)this.javaVariable.getValue());
        }
        return this.value;
    }

    protected IEGLJavaValue createEGLValue(IJavaValue javaValue) {
        return new EGLJavaValue(this.getDebugTarget(), javaValue, this);
    }

    public String getName() throws DebugException {
        return this.variableInfo.eglName;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.variableInfo.type;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.javaVariable.hasValueChanged();
    }

    @Override
    public IJavaVariable getJavaVariable() {
        return this.javaVariable;
    }

    @Override
    public Object getJavaDebugElement() {
        return this.getJavaVariable();
    }

    @Override
    public IEGLJavaStackFrame getEGLStackFrame() {
        return this.frame;
    }

    @Override
    public SMAPVariableInfo getVariableInfo() {
        return this.variableInfo;
    }

    @Override
    public boolean isLocal() {
        if (this.parent != null && this.parent.getParentVariable() != null) {
            this.parent.getParentVariable().isLocal();
        }
        return false;
    }

    @Override
    public IEGLJavaValue getParentValue() {
        return this.parent;
    }
}

