/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.IVariableAdapter;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionContainerVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class VariableUtil {
    public static final IVariable[] EMPTY_VARIABLES = new IVariable[0];

    private VariableUtil() {
    }

    public static List<IEGLJavaVariable> filterAndWrapVariables(IVariable[] javaVariables, IEGLJavaStackFrame frame, boolean skipLocals, IEGLJavaValue parent) throws DebugException {
        ArrayList<IEGLJavaVariable> newEGLVariables = new ArrayList<IEGLJavaVariable>(javaVariables.length);
        SMAPVariableInfo[] infos = frame.getSMAPVariableInfos();
        String javaFrameSignature = String.valueOf(frame.getJavaStackFrame().getMethodName()) + ";" + frame.getJavaStackFrame().getSignature();
        int currentLine = frame.getLineNumber();
        int frameStartLine = frame.getSMAPFunctionInfo() == null ? -1 : frame.getSMAPFunctionInfo().lineDeclared;
        int i = 0;
        while (i < javaVariables.length) {
            SMAPVariableInfo info;
            SMAPVariableInfo matchingInfo;
            IJavaVariable javaVar = (IJavaVariable)javaVariables[i];
            String javaName = javaVar.getName();
            if (javaVar.isLocal()) {
                if (!skipLocals) {
                    matchingInfo = null;
                    int j = 0;
                    while (j < infos.length) {
                        info = infos[j];
                        if (info.javaName.equals(javaName) && info.javaMethodSignature != null && info.javaMethodSignature.equals(javaFrameSignature) && (currentLine >= info.lineDeclared || currentLine == frameStartLine) && (matchingInfo == null || matchingInfo.lineDeclared < info.lineDeclared)) {
                            matchingInfo = info;
                        }
                        ++j;
                    }
                    if (matchingInfo != null) {
                        IEGLJavaVariable var = frame.getCorrespondingVariable(VariableUtil.createEGLVariable(javaVar, matchingInfo, frame, parent), parent);
                        newEGLVariables.add(var);
                    }
                }
            } else if ("this".equals(javaName)) {
                IEGLJavaVariable var = frame.getCorrespondingVariable(new EGLJavaFunctionContainerVariable(frame.getDebugTarget(), javaVar, frame), parent);
                newEGLVariables.add(var);
            } else {
                matchingInfo = null;
                int j = 0;
                while (j < infos.length) {
                    info = infos[j];
                    if (info.javaName.equals(javaName) && info.javaMethodSignature == null) {
                        matchingInfo = info;
                        break;
                    }
                    ++j;
                }
                if (matchingInfo != null) {
                    IEGLJavaVariable var = frame.getCorrespondingVariable(VariableUtil.createEGLVariable(javaVar, matchingInfo, frame, parent), parent);
                    newEGLVariables.add(var);
                }
            }
            ++i;
        }
        return newEGLVariables;
    }

    public static IEGLJavaVariable createEGLVariable(IJavaVariable javaVariable, SMAPVariableInfo info, IEGLJavaStackFrame frame, IEGLJavaValue parent) {
        IVariableAdapter[] iVariableAdapterArray = EDTDebugCorePlugin.getDefault().getVariableAdapters();
        int n = iVariableAdapterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableAdapter adapter = iVariableAdapterArray[n2];
            IEGLJavaVariable variable = adapter.adapt(javaVariable, frame, info, parent);
            if (variable != null) {
                return variable;
            }
            ++n2;
        }
        return new EGLJavaVariable(frame.getDebugTarget(), javaVariable, info, frame, parent);
    }

    public static String getQualifiedName(IEGLJavaVariable var) throws DebugException {
        if (var == null) {
            return null;
        }
        IEGLJavaValue parent = var.getParentValue();
        if (parent == null || parent.getParentVariable() == null) {
            return var.getName();
        }
        StringBuilder buf = new StringBuilder(100);
        buf.append(VariableUtil.getQualifiedName(parent.getParentVariable()));
        buf.append('|');
        buf.append(var.getName());
        return buf.toString();
    }
}

