/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.variables;

import java.util.HashMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.IVariableAdapter;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.variables.ChildlessVariable;
import org.eclipse.edt.debug.internal.core.java.variables.ToStringVariable;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class DefaultVariableAdapter
implements IVariableAdapter {
    private HashMap<String, Object> supportedTypes;

    @Override
    public IEGLJavaVariable adapt(IJavaVariable variable, IEGLJavaStackFrame frame, SMAPVariableInfo info, IEGLJavaValue parent) {
        try {
            if (variable.getJavaType() instanceof IJavaClassType) {
                IValue value = variable.getValue();
                String type = value.getReferenceTypeName();
                if (this.getSupportedTypeMap().containsKey(type)) {
                    IVariable[] vars;
                    if ("java.lang.String".equals(type)) {
                        return new ChildlessVariable(frame.getDebugTarget(), variable, info, frame, parent);
                    }
                    if ("java.math.BigDecimal".equals(type) || "java.math.BigInteger".equals(type)) {
                        return new ToStringVariable(frame.getDebugTarget(), variable, info, frame, parent);
                    }
                    IVariable[] iVariableArray = vars = value.getVariables();
                    int n = vars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVariable var = iVariableArray[n2];
                        if (var instanceof IJavaVariable && !((IJavaVariable)var).isStatic() && var.getName().equals("value")) {
                            return new EGLJavaVariable(frame.getDebugTarget(), (IJavaVariable)var, info, frame, parent);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (DebugException debugException) {}
        return null;
    }

    private HashMap<String, Object> getSupportedTypeMap() {
        if (this.supportedTypes == null) {
            this.supportedTypes = new HashMap(11);
            this.supportedTypes.put("java.lang.Integer", null);
            this.supportedTypes.put("java.lang.Long", null);
            this.supportedTypes.put("java.lang.Short", null);
            this.supportedTypes.put("java.lang.Boolean", null);
            this.supportedTypes.put("java.lang.String", null);
            this.supportedTypes.put("java.lang.Float", null);
            this.supportedTypes.put("java.lang.Double", null);
            this.supportedTypes.put("java.lang.Byte", null);
            this.supportedTypes.put("java.lang.Character", null);
            this.supportedTypes.put("java.math.BigDecimal", null);
            this.supportedTypes.put("java.math.BigInteger", null);
        }
        return this.supportedTypes;
    }
}

