/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.IVariableAdapter;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.VariableUtil;
import org.eclipse.edt.debug.internal.core.java.variables.ListVariable;
import org.eclipse.edt.debug.internal.core.java.variables.MapVariable;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class EDTVariableAdapter
implements IVariableAdapter {
    @Override
    public IEGLJavaVariable adapt(IJavaVariable variable, IEGLJavaStackFrame frame, SMAPVariableInfo info, IEGLJavaValue parent) {
        try {
            String signature = variable.getGenericSignature();
            if (signature != null) {
                if (signature.startsWith("Legl/lang/EList<") || signature.startsWith("L/org/eclipse/edt/runtime/java/egl/lang/EList<")) {
                    return new ListVariable(frame.getDebugTarget(), variable, info, frame, parent);
                }
                if (signature.equals("Legl/lang/EDictionary;") || signature.equals("Lorg/eclipse/edt/runtime/java/egl/lang/EDictionary;")) {
                    return new MapVariable(frame.getDebugTarget(), variable, info, frame, parent){

                        @Override
                        protected String getTypeNameForElement(IJavaValue value) {
                            return "egl.lang.AnyObject";
                        }
                    };
                }
                if (signature.startsWith("Lorg/eclipse/edt/javart/AnyBoxedObject<")) {
                    IVariable[] kids;
                    IVariable[] iVariableArray = kids = variable.getValue().getVariables();
                    int n = kids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVariable kid = iVariableArray[n2];
                        if (kid instanceof IJavaVariable && "object".equals(kid.getName())) {
                            return VariableUtil.createEGLVariable((IJavaVariable)kid, info, frame, parent);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return null;
    }
}

