/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.java;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.breakpoints.EGLBreakpoint;
import org.eclipse.edt.debug.core.breakpoints.EGLLineBreakpoint;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugElement;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionVariable;
import org.eclipse.edt.debug.internal.ui.EDTDebugUIPlugin;
import org.eclipse.edt.debug.internal.ui.java.EGLJavaMessages;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class EGLJavaModelPresentation
extends JDIModelPresentation {
    public String getText(Object element) {
        if (element instanceof EGLBreakpoint) {
            return this.getBreakpointText((EGLBreakpoint)element);
        }
        if (element instanceof IEGLJavaDebugElement) {
            element = ((IEGLJavaDebugElement)element).getJavaDebugElement();
        }
        return super.getText(element);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof IEGLJavaValue) {
            IEGLJavaValue eglValue = (IEGLJavaValue)value;
            String detail = eglValue.computeDetail();
            if (detail != null) {
                listener.detailComputed(value, detail);
                return;
            }
            if (eglValue.getJavaValue() != null) {
                value = eglValue.getJavaValue();
            }
        }
        super.computeDetail(value, listener);
    }

    public Image getImage(Object item) {
        IEGLJavaVariable var;
        IBreakpoint bp;
        if (item instanceof EGLJavaFunctionVariable) {
            return EGLJavaModelPresentation.getJavaElementImageRegistry().get(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.localvariable_obj.gif"));
        }
        if (item instanceof EGLBreakpoint) {
            return this.getBreakpointImage((EGLBreakpoint)item);
        }
        if (item instanceof IMarker && (bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)item)) instanceof EGLBreakpoint) {
            return this.getBreakpointImage((EGLBreakpoint)bp);
        }
        if (item instanceof IAdaptable && (var = (IEGLJavaVariable)((IAdaptable)item).getAdapter(IEGLJavaVariable.class)) != null) {
            if (var.isLocal()) {
                return EGLJavaModelPresentation.getJavaElementImageRegistry().get(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.localvariable_obj.gif"));
            }
            return EGLJavaModelPresentation.getJavaElementImageRegistry().get(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpub_obj.gif"));
        }
        if (item instanceof IEGLJavaDebugElement) {
            item = ((IEGLJavaDebugElement)item).getJavaDebugElement();
        }
        return super.getImage(item);
    }

    private Image getBreakpointImage(EGLBreakpoint bp) {
        try {
            if (bp instanceof EGLLineBreakpoint && ((EGLLineBreakpoint)bp).isRunToLine()) {
                return null;
            }
        }
        catch (CoreException e) {
            EDTDebugUIPlugin.log(e);
        }
        boolean enabled = true;
        try {
            enabled = bp.isEnabled();
        }
        catch (CoreException coreException) {}
        if (enabled) {
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
        }
        return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
    }

    private String getBreakpointText(EGLBreakpoint bp) {
        if (bp instanceof EGLLineBreakpoint) {
            EGLLineBreakpoint lineBP = (EGLLineBreakpoint)bp;
            try {
                return NLS.bind((String)EGLJavaMessages.LineBreakpointLabel, (Object[])new Object[]{bp.getMarker().getResource().getLocation().lastSegment(), lineBP.getLineNumber()});
            }
            catch (CoreException e) {
                EDTDebugCorePlugin.log((Throwable)e);
                return EGLJavaMessages.LineBreakpointUnkown;
            }
        }
        return null;
    }

    public IEditorInput getEditorInput(Object item) {
        if (item instanceof IMarker) {
            return EditorUtility.getEditorInput((Object)((IMarker)item).getResource());
        }
        if (item instanceof EGLBreakpoint) {
            return EditorUtility.getEditorInput((Object)((EGLBreakpoint)item).getMarker().getResource());
        }
        return super.getEditorInput(item);
    }
}

