/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.IEGLDebugTarget;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;

public class EGLJavaLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String vmArgs;
        String transformerPath = EDTDebugCorePlugin.getDefault().getTransformerPath();
        if (transformerPath != null && transformerPath.length() != 0 && !(vmArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "")).contains("-javaagent:")) {
            vmArgs = String.valueOf(vmArgs) + " -javaagent:\"" + transformerPath + "\"";
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
            configuration = wc;
        }
        DebugTargetWrapper wrapper = new DebugTargetWrapper(launch);
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)wrapper);
        new JavaLaunchDelegate().launch(configuration, mode, launch, monitor);
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)wrapper);
    }

    private class DebugTargetWrapper
    implements IDebugEventFilter {
        private final ILaunch launch;

        DebugTargetWrapper(ILaunch launch) {
            this.launch = launch;
        }

        public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
            IJavaDebugTarget javaTarget;
            Object src;
            if (events != null && events.length != 0 && events[0].getKind() == 4 && (src = events[0].getSource()) instanceof IDebugTarget && !(src instanceof IEGLDebugTarget) && (javaTarget = (IJavaDebugTarget)((IDebugTarget)src).getAdapter(IJavaDebugTarget.class)) != null && javaTarget.getLaunch() == this.launch) {
                EGLJavaDebugTarget edtTarget = new EGLJavaDebugTarget(javaTarget);
                this.launch.removeDebugTarget((IDebugTarget)javaTarget);
                this.launch.addDebugTarget((IDebugTarget)edtTarget);
                edtTarget.handleDebugEvents(events);
                return null;
            }
            return events;
        }
    }
}

