/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.StringLiteral;

public class StringLiteralTemplate
extends JavaTemplate {
    public void genExpression(StringLiteral expr, Context ctx, TabbedWriter out) {
        out.print("\"");
        if (!expr.isHex().booleanValue()) {
            out.print(StringLiteralTemplate.addStringEscapes(expr.getValue()));
        } else {
            String value = expr.getValue();
            int numSegments = value.length() / 4;
            int i = 0;
            while (i < numSegments) {
                int start = i * 4;
                String unicode = value.substring(start, start + 4).toLowerCase();
                if (unicode.equals("000a")) {
                    out.print("\\n");
                } else if (unicode.equals("000d")) {
                    out.print("\\r");
                } else if (unicode.equals("0022")) {
                    out.print("\\\"");
                } else if (unicode.equals("005c")) {
                    out.print("\\\\");
                } else {
                    out.print("\\u" + unicode);
                }
                ++i;
            }
        }
        out.print("\"");
    }

    public static String addStringEscapes(String str) {
        StringBuffer buf = new StringBuffer(str);
        int i = 0;
        while (i < buf.length()) {
            char c = buf.charAt(i);
            if (c > '\u007f') {
                String hexValue = Integer.toHexString(c);
                if (c < '\u0100') {
                    hexValue = "00" + hexValue;
                } else if (c < '\u1000') {
                    hexValue = "0" + hexValue;
                }
                buf.setCharAt(i, '\\');
                buf.insert(i + 1, "u" + hexValue);
                i += 5;
            } else if (c == '\"' || c == '\\') {
                buf.insert(i, '\\');
                ++i;
            } else if (c == '\n') {
                buf.insert(i, '\\');
                buf.setCharAt(++i, 'n');
            } else if (c == '\r') {
                buf.insert(i, '\\');
                buf.setCharAt(++i, 'r');
            } else if (c == '\b') {
                buf.insert(i, '\\');
                buf.setCharAt(++i, 'b');
            } else if (c == '\f') {
                buf.insert(i, '\\');
                buf.setCharAt(++i, 'f');
            } else if (c == '\t') {
                buf.insert(i, '\\');
                buf.setCharAt(++i, 't');
            }
            ++i;
        }
        return buf.toString();
    }
}

