/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class TypeTemplate
extends JavaTemplate {
    public void preGen(Type type, Context ctx) {
        CommonUtilities.processImport((String)ctx.getNativeImplementationMapping((Type)type.getClassifier()), (Context)ctx);
        if (ctx.getNativeMapping(ctx.getNativeMapping(type.getClassifier().getTypeSignature())) != null) {
            CommonUtilities.processImport((String)ctx.getNativeMapping(type.getClassifier().getTypeSignature()), (Context)ctx);
        }
        if (ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            if (ctx.getPrimitiveMapping(ctx.getPrimitiveMapping(type.getClassifier().getTypeSignature())) != null) {
                CommonUtilities.processImport((String)ctx.getPrimitiveMapping(ctx.getPrimitiveMapping(type.getClassifier().getTypeSignature())), (Context)ctx);
            } else {
                CommonUtilities.processImport((String)ctx.getPrimitiveMapping(type.getClassifier().getTypeSignature()), (Context)ctx);
            }
        }
    }

    public void genInstantiation(Type type, Context ctx, TabbedWriter out) {
        out.print("new ");
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaTemplate.TypeNameKind.JavaImplementation});
        out.print("(");
        ctx.invoke("genConstructorOptions", type, new Object[]{ctx, out});
        out.print(")");
    }

    public void genInstantiation(Type type, Context ctx, TabbedWriter out, Field arg) {
        ctx.invoke("genInstantiation", type, new Object[]{ctx, out});
    }

    public void genInvocation(Type type, Context ctx, TabbedWriter out, InvocationExpression arg) {
        ctx.invoke("genInvocation", (Expression)arg, (TemplateContext)ctx, out);
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out, TypedElement arg) {
        if (arg.isNullable()) {
            out.print("null");
        } else {
            ctx.invoke("genDefaultValue", type, new Object[]{ctx, out});
        }
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out, Expression arg) {
        if (arg.isNullable()) {
            out.print("null");
        } else {
            ctx.invoke("genDefaultValue", type, new Object[]{ctx, out});
        }
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out) {
        if (TypeUtils.isReferenceType((Type)type)) {
            out.print("null");
        } else {
            out.print("\"Invalid default value\"");
        }
    }

    public void genRuntimeConstraint(Type type, Context ctx, TabbedWriter out) {
        this.genRuntimeTypeName(type, ctx, out, JavaTemplate.TypeNameKind.EGLImplementation);
        out.print(".class");
    }

    public void genRuntimeTypeName(Type type, Context ctx, TabbedWriter out) {
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaTemplate.TypeNameKind.JavaPrimitive});
    }

    public void genRuntimeTypeName(Type type, Context ctx, TabbedWriter out, JavaTemplate.TypeNameKind arg) {
        if (arg == JavaTemplate.TypeNameKind.JavaPrimitive && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            out.print(ctx.getPrimitiveMapping((Type)type.getClassifier()));
            return;
        }
        if (arg == JavaTemplate.TypeNameKind.JavaObject && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            String item = ctx.getPrimitiveMapping((Type)type.getClassifier());
            if (ctx.getPrimitiveMapping(item) == null) {
                out.print(item);
            } else {
                out.print(ctx.getPrimitiveMapping(item));
            }
            return;
        }
        if (arg == JavaTemplate.TypeNameKind.JavaImplementation && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            String item = ctx.getPrimitiveMapping((Type)type.getClassifier());
            if (ctx.getPrimitiveMapping(item) == null) {
                out.print(item);
            } else {
                out.print(ctx.getPrimitiveMapping(item));
            }
            return;
        }
        if (arg == JavaTemplate.TypeNameKind.EGLImplementation && ctx.mapsToNativeType((Type)type.getClassifier())) {
            out.print(ctx.getNativeImplementationMapping((Type)type.getClassifier()));
            return;
        }
        if (arg == JavaTemplate.TypeNameKind.JavaImplementation) {
            out.print(ctx.getNativeImplementationMapping((Type)type.getClassifier()));
        } else {
            out.print(ctx.getNativeInterfaceMapping((Type)type.getClassifier()));
        }
    }

    public void genConstructorOptions(Type type, Context ctx, TabbedWriter out) {
    }

    public void genTypeDependentOptions(Type type, Context ctx, TabbedWriter out) {
    }

    public void genAssignment(Type type, Context ctx, TabbedWriter out, Expression arg1, Expression arg2, String arg3) {
        if (!TypeUtils.isReferenceType((Type)arg1.getType()) && !arg1.isNullable() && arg2.isNullable()) {
            if (IRUtils.hasSideEffects((Expression)arg2)) {
                String temporary = ctx.nextTempName();
                ctx.invoke("genRuntimeTypeName", arg1.getType(), new Object[]{ctx, out, JavaTemplate.TypeNameKind.JavaObject});
                out.print(" " + temporary + " = ");
                ctx.invoke("genExpression", arg2, (TemplateContext)ctx, out);
                out.println(";");
                ctx.invoke("genExpression", arg1, (TemplateContext)ctx, out);
                out.print(String.valueOf(arg3) + temporary + " == null ? ");
                ctx.invoke("genDefaultValue", type, new Object[]{ctx, out, arg1});
                out.print(" : " + temporary);
            } else if (TypeUtils.isReferenceType((Type)arg2.getType())) {
                ctx.invoke("genExpression", arg1, (TemplateContext)ctx, out);
                out.print(arg3);
                ctx.invoke("genExpression", arg2, (TemplateContext)ctx, out);
            } else {
                ctx.invoke("genExpression", arg1, (TemplateContext)ctx, out);
                out.print(arg3);
                ctx.invoke("genExpression", arg2, (TemplateContext)ctx, out);
                out.print(" == null ? ");
                ctx.invoke("genDefaultValue", type, new Object[]{ctx, out, arg1});
                out.print(" : ");
                ctx.invoke("genExpression", arg2, (TemplateContext)ctx, out);
            }
        } else {
            ctx.invoke("genExpression", arg1, (TemplateContext)ctx, out);
            out.print(arg3);
            ctx.invoke("genExpression", arg2, (TemplateContext)ctx, out);
        }
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) throws GenerationException {
        if (arg.getLHS().isNullable() || arg.getRHS().isNullable() || CommonUtilities.getNativeJavaOperation((BinaryExpression)arg, (Context)ctx).length() == 0) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)arg.getOperation().getContainer())) + '.');
            out.print(CommonUtilities.getNativeRuntimeOperationName((BinaryExpression)arg));
            out.print("(");
            ctx.invoke("genExpression", arg.getLHS(), (TemplateContext)ctx, out);
            out.print(", ");
            ctx.invoke("genExpression", arg.getRHS(), (TemplateContext)ctx, out);
            out.print(")" + CommonUtilities.getNativeRuntimeComparisionOperation((BinaryExpression)arg));
        } else {
            ctx.invoke("genExpression", arg.getLHS(), (TemplateContext)ctx, out);
            out.print(CommonUtilities.getNativeJavaOperation((BinaryExpression)arg, (Context)ctx));
            ctx.invoke("genExpression", arg.getRHS(), (TemplateContext)ctx, out);
        }
    }

    public void genUnaryExpression(Type type, Context ctx, TabbedWriter out, UnaryExpression arg) {
        if (arg.getOperator().equals("-")) {
            out.print(String.valueOf(arg.getOperator()) + "(");
        }
        ctx.invoke("genExpression", arg.getExpression(), (TemplateContext)ctx, out);
        if (arg.getOperator().equals("-")) {
            out.print(")");
        }
    }

    public void genContainerBasedAssignment(Type type, Context ctx, TabbedWriter out, Assignment arg1, Field arg2) {
        ctx.invoke("genAssignment", (Expression)arg1, (TemplateContext)ctx, out);
    }

    public void genContainerBasedArrayAccess(Type type, Context ctx, TabbedWriter out, ArrayAccess arg1, Field arg2) {
        ctx.invoke("genArrayAccess", (Expression)arg1, (TemplateContext)ctx, out);
    }

    public void genContainerBasedMemberAccess(Type type, Context ctx, TabbedWriter out, MemberAccess arg1, Member arg2) {
        ctx.invoke("genMemberAccess", (Expression)arg1, (TemplateContext)ctx, out);
    }

    public void genContainerBasedMemberName(Type type, Context ctx, TabbedWriter out, MemberName arg1, Member arg2) {
        ctx.invoke("genMemberName", (Expression)arg1, (TemplateContext)ctx, out);
    }

    public void genContainerBasedNewExpression(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genNewExpression", arg, (TemplateContext)ctx, out);
    }

    public void genContainerBasedInvocation(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genInvocation", arg, (TemplateContext)ctx, out);
    }

    public void genXmlTransient(Type type, TabbedWriter out) {
    }
}

