/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.JavaAliaser;
import org.eclipse.edt.mof.codegen.api.TabbedReportWriter;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class JavaGenerator
extends Generator {
    protected Context context;
    protected TabbedWriter out;
    protected AbstractGeneratorCommand generator;

    public JavaGenerator(AbstractGeneratorCommand processor) {
        this(processor, null);
    }

    public JavaGenerator(AbstractGeneratorCommand processor, IGenerationMessageRequestor requestor) {
        super(processor, requestor);
        this.generator = processor;
        this.out = Boolean.TRUE == (Boolean)this.context.getParameter("report") ? new TabbedReportWriter("org.eclipse.edt.gen.java.templates.", (Writer)new StringWriter()) : new TabbedWriter((Writer)new StringWriter());
    }

    public String getResult() {
        return this.out.getWriter().toString();
    }

    public TabbedReportWriter getReport() {
        return this.out instanceof TabbedReportWriter ? (TabbedReportWriter)this.out : null;
    }

    public Context makeContext(AbstractGeneratorCommand processor) {
        this.context = new Context(processor);
        return this.context;
    }

    public boolean visit(Part part) {
        try {
            this.context.invoke("genPart", (Type)part, new Object[]{this.context, this.out});
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void generate(Part part) throws GenerationException {
        try {
            this.context.putAttribute(((Object)((Object)this.context)).getClass(), "partBeingGenerated", part);
            this.context.invoke("preGenPart", (Type)part, new Object[]{this.context});
            if (!this.context.getMessageRequestor().isError()) {
                String fileName;
                this.out.getWriter().flush();
                String eglFileName = part.getFileName();
                if (eglFileName.indexOf(92) >= 0) {
                    eglFileName = eglFileName.substring(eglFileName.lastIndexOf(92) + 1);
                }
                if (eglFileName.indexOf(47) >= 0) {
                    eglFileName = eglFileName.substring(eglFileName.lastIndexOf(47) + 1);
                }
                if ((fileName = eglFileName).indexOf(46) >= 0) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(46));
                }
                this.context.getSmapData().append(String.valueOf(JavaAliaser.getAlias(fileName)) + this.getFileExtension() + "\negl\n*S egl\n*F\n");
                this.context.getSmapData().append("*L\n");
                this.context.invoke("genPart", (Type)part, new Object[]{this.context, this.out});
                this.context.writeSmapLine();
                int index = 0;
                String fileList = "";
                for (String eglFile : this.context.getSmapFiles()) {
                    fileList = String.valueOf(fileList) + "+ " + ++index + " " + this.unqualifyFileName(eglFile) + "\n" + eglFile + "\n";
                }
                this.context.getSmapData().insert(this.context.getSmapData().indexOf("\negl\n*S egl\n*F\n") + "\negl\n*S egl\n*F\n".length(), fileList);
                this.context.getSmapData().append("*E\n");
                this.context.getSmapData().append(this.context.getSmapExtension());
                this.context.getSmapData().append("*X\n");
                this.out.flush();
            }
        }
        catch (IOException e) {
            throw new GenerationException((Throwable)e);
        }
        catch (TemplateException e) {
            String[] details1 = new String[]{e.getLocalizedMessage()};
            EGLMessage message1 = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9998", (Object)((Object)e), (String[])details1, (int)0, (int)0, (int)0, (int)0);
            this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message1);
            if (e.getCause() != null) {
                String[] details2 = new String[]{e.getCause().toString()};
                EGLMessage message2 = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9999", (Object)((Object)e), (String[])details2, (int)0, (int)0, (int)0, (int)0);
                this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message2);
            }
            e.printStackTrace();
        }
        this.out.close();
    }

    private String unqualifyFileName(String fileName) {
        int lastSlash = fileName.lastIndexOf(47);
        if (lastSlash != -1) {
            return fileName.substring(lastSlash + 1);
        }
        return fileName;
    }

    public void dumpErrorMessages() {
        for (IGenerationResultsMessage message : this.context.getMessageRequestor().getMessages()) {
            System.out.println(message.getBuiltMessage());
        }
    }

    public void processFile(String fileName) {
        JavaGenerator.writeReport((EglContext)this.context, (String)fileName, (TabbedReportWriter)this.getReport(), (String)"8000", (String)"9992");
        if (!this.context.getMessageRequestor().isError()) {
            File outSmapFile = new File(String.valueOf(fileName.substring(0, fileName.length() - this.getFileExtension().length())) + ".eglsmap");
            try {
                FileOutputStream outStream = new FileOutputStream(outSmapFile);
                byte[] outSmapBytes = this.context.getSmapData().toString().getBytes("UTF-8");
                outStream.write(outSmapBytes, 0, outSmapBytes.length);
                outStream.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String[] details = new String[]{"UTF-8"};
                EGLMessage message = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9971", null, (String[])details, (int)0, (int)0, (int)0, (int)0);
                this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
            }
            catch (IOException iOException) {
                String[] details = new String[]{outSmapFile.getName()};
                EGLMessage message = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9970", null, (String[])details, (int)0, (int)0, (int)0, (int)0);
                this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
                return;
            }
        }
    }

    public String getRelativeFileName(Part part) {
        StringBuilder buf = new StringBuilder(50);
        String pkg = part.getPackageName();
        if (pkg.length() > 0) {
            buf.append(JavaAliaser.packageNameAlias(pkg.split("[.]"), '/'));
            buf.append('/');
        }
        buf.append(JavaAliaser.getAlias(part.getId()));
        buf.append(this.getFileExtension());
        return buf.toString();
    }

    public String getFileExtension() {
        return ".java";
    }

    public void generate(Object objectClass) throws GenerationException {
    }
}

