/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.egl.lang;

import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Type;

public class BigintTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(EGLClass type, Context ctx, TabbedWriter out) {
        out.print("egl." + ctx.getNativeMapping("eglx.lang.EBigint") + ".ZERO");
    }

    public void genSignature(EGLClass type, Context ctx, TabbedWriter out) {
        String signature = "B;";
        out.print(signature);
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) {
        out.print(this.getNativeStringPrefixOperation(arg));
        out.print("(");
        ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringOperation(arg));
        ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringComparisionOperation(arg));
        out.print(")");
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "!";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("==")) {
            return ".compareTo(";
        }
        if (op.equals("!=")) {
            return ".compareTo(";
        }
        if (op.equals("<")) {
            return ".compareTo(";
        }
        if (op.equals(">")) {
            return ".compareTo(";
        }
        if (op.equals("<=")) {
            return ".compareTo(";
        }
        if (op.equals(">=")) {
            return ".compareTo(";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return ") == 0";
        }
        if (op.equals("!=")) {
            return ")";
        }
        if (op.equals("<")) {
            return ") < 0";
        }
        if (op.equals(">")) {
            return ") > 0";
        }
        if (op.equals("<=")) {
            return ") <= 0";
        }
        if (op.equals(">=")) {
            return ") >= 0";
        }
        return "";
    }
}

