/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Field;

public class ArrayTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(ArrayType generic, Context ctx, TabbedWriter out, Field arg) {
        if (arg.getInitializerStatements() != null) {
            this.processDefaultValue(generic, ctx, out);
        } else {
            out.print("null");
        }
    }

    public void genDefaultValue(ArrayType generic, Context ctx, TabbedWriter out) {
        if (generic.getInitialSize() != null) {
            this.processDefaultValue(generic, ctx, out);
        } else {
            out.print("null");
        }
    }

    public void processDefaultValue(ArrayType generic, Context ctx, TabbedWriter out) {
        String temporary = ctx.nextTempName();
        out.print("(function() { var ");
        out.print(temporary);
        out.print(" = []; ");
        out.print(temporary);
        out.print(".setType(");
        out.print("\"");
        this.genSignature(generic, ctx, out);
        out.print("\"");
        if (generic.getInitialSize() == null) {
            out.println(");");
        } else {
            out.println("); for (var i = 0; i < " + generic.getInitialSize() + "; i++) {");
            out.print(temporary);
            out.print("[i] = ");
            ctx.invoke("genDefaultValue", generic.getElementType(), new Object[]{ctx, out});
            out.println(";}");
        }
        out.print("return ");
        out.print(temporary);
        out.print(";})()");
    }

    public void genSignature(ArrayType generic, Context ctx, TabbedWriter out) {
        if (!generic.getTypeArguments().isEmpty()) {
            int i = 0;
            while (i < generic.getTypeArguments().size()) {
                out.print("[");
                ++i;
            }
        }
        if (generic.elementsNullable()) {
            out.print("?");
        }
        ctx.invoke("genSignature", generic.getElementType(), new Object[]{ctx, out});
    }

    public void genRuntimeTypeName(ArrayType generic, Context ctx, TabbedWriter out, JavaScriptTemplate.TypeNameKind arg) {
        out.print("Array");
    }

    public void genConversionOperation(ArrayType type, Context ctx, TabbedWriter out, AsExpression arg) {
        ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
    }
}

