/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class EGLClassTemplate
extends JavaScriptTemplate {
    public void preGenClassBody(EGLClass part, Context ctx) {
        ctx.invoke("preGenUsedParts", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenFields", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenFunctions", (Type)part, new Object[]{ctx});
        this.addNamespaceMap(part, ctx);
    }

    private void addNamespaceMap(EGLClass part, Context ctx) {
        String localName = part.getName();
        String namespace = CommonUtilities.createNamespaceFromPackage((Part)part);
        Annotation annot = part.getAnnotation("eglx.xml.binding.annotation.xmlRootElement");
        if (annot != null) {
            if (annot.getValue("namespace") != null && ((String)annot.getValue("namespace")).length() > 0) {
                namespace = (String)annot.getValue("namespace");
            }
            if (annot.getValue("name") != null && ((String)annot.getValue("name")).length() > 0) {
                localName = (String)annot.getValue("name");
            }
        }
        ctx.addNamespace(namespace, localName, part.getFullyQualifiedName());
    }

    public void preGenUsedParts(EGLClass part, Context ctx) {
        for (Part item : IRUtils.getReferencedPartsFor((Part)part)) {
            ctx.invoke("preGenUsedPart", (Type)part, new Object[]{ctx, item});
        }
    }

    public void preGenUsedPart(EGLClass part, Context ctx, Part arg) {
        ctx.invoke("preGen", (Type)arg, new Object[]{ctx});
    }

    public void preGenFields(EGLClass part, Context ctx) {
        for (Field field : part.getFields()) {
            ctx.invoke("preGenField", (Type)part, new Object[]{ctx, field});
        }
    }

    public void preGenField(EGLClass part, Context ctx, Field arg) {
        ctx.invoke("preGen", (EObject)arg, new Object[]{ctx});
    }

    public void preGenFunctions(EGLClass part, Context ctx) {
        for (Function function : part.getFunctions()) {
            ctx.invoke("preGenFunction", (Type)part, new Object[]{ctx, function});
        }
    }

    public void preGenFunction(EGLClass part, Context ctx, Function arg) {
        ctx.invoke("preGen", (EObject)arg, new Object[]{ctx});
    }

    public void genClassHeader(EGLClass part, Context ctx, TabbedWriter out) {
        out.print("egl.defineClass(");
        out.print(EGLClassTemplate.singleQuoted((String)part.getPackageName().toLowerCase()));
        out.print(", ");
        out.print(EGLClassTemplate.quoted((String)part.getName()));
        out.print(", ");
        ctx.invoke("genSuperClass", (Type)part, new Object[]{ctx, out});
        out.print(", ");
        out.println("{");
    }

    public void genClassBody(EGLClass part, Context ctx, TabbedWriter out) {
        ctx.invoke("genConstructors", (Type)part, new Object[]{ctx, out});
        out.println(",");
        ctx.invoke("genSetEmptyMethods", (Type)part, new Object[]{ctx, out});
        out.println(",");
        ctx.invoke("genInitializeMethods", (Type)part, new Object[]{ctx, out});
        out.println(",");
        ctx.invoke("genCloneMethods", (Type)part, new Object[]{ctx, out});
        out.println(",");
        ctx.invoke("genAnnotations", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genFieldAnnotations", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genNamespaceMap", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genFunctions", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genFields", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genGetterSetters", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genToString", (Type)part, new Object[]{ctx, out});
    }

    public void genToString(EGLClass part, Context ctx, TabbedWriter out) {
        out.println(",");
        out.print(EGLClassTemplate.quoted((String)"toString"));
        out.println(": function() {");
        out.println("return \"[" + part.getId() + "]\";");
        out.println("}");
    }

    public void genFields(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genField", (Type)part, new Object[]{ctx, out, field});
        }
    }

    public void genField(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
    }

    public void genConstructors(EGLClass part, Context ctx, TabbedWriter out) {
        ctx.invoke("genConstructor", (Type)part, new Object[]{ctx, out});
    }

    public void genConstructor(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"constructor"));
        out.println(": function() {");
        ctx.invoke("genLibraries", (Type)part, new Object[]{ctx, out});
        out.println("this.eze$$setInitial();");
        out.println("}");
    }

    public void genLibraries(EGLClass part, Context ctx, TabbedWriter out) {
        List libraries = (List)ctx.getAttribute(ctx.getClass(), "partLibrariesUsed");
        for (Library library : libraries) {
            ctx.invoke("genLibrary", (Type)part, new Object[]{ctx, out, library});
        }
    }

    public void genLibrary(EGLClass part, Context ctx, TabbedWriter out, Library arg) {
        ctx.invoke("genInstantiation", (Type)arg, new Object[]{ctx, out});
        out.println(";");
    }

    public void genSetEmptyMethods(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"eze$$setEmpty"));
        out.println(": function() {");
        ctx.invoke("genSetEmptyMethodBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genSetEmptyMethodBody(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genSetEmptyMethod", (Type)part, new Object[]{ctx, out, field});
        }
    }

    public void genSetEmptyMethod(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        out.print("this.");
        ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
        out.print(" = ");
        ctx.invoke("genInitialization", (EObject)arg, new Object[]{ctx, out});
        out.println(";");
    }

    public void genInitializeMethods(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"eze$$setInitial"));
        out.println(": function() {");
        ctx.invoke("genInitializeMethodBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genInitializeMethodBody(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genInitializeMethod", (Type)part, new Object[]{ctx, out, field});
        }
        if (part.getInitializerStatements() != null) {
            ctx.invoke("genStatementNoBraces", (EObject)part.getInitializerStatements(), new Object[]{ctx, out});
        }
    }

    public void genInitializeMethod(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        if (arg.getInitializerStatements() != null) {
            ctx.invoke("genStatementNoBraces", (EObject)arg.getInitializerStatements(), new Object[]{ctx, out});
        } else {
            if (arg.getContainer() != null && arg.getContainer() instanceof Type) {
                ctx.invoke("genQualifier", (EObject)arg.getContainer(), new Object[]{ctx, out, arg});
            }
            ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
            out.print(" = ");
            ctx.invoke("genInitialization", (EObject)arg, new Object[]{ctx, out});
            out.println(";");
        }
    }

    public void genCloneMethods(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"eze$$clone"));
        out.println(": function() {");
        ctx.invoke("genCloneMethodBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genCloneMethodBody(EGLClass part, Context ctx, TabbedWriter out) {
        String temp1 = "ezert$$1";
        String temp2 = "ezert$$2";
        out.print("var ");
        out.print(temp1);
        out.println(" = this;");
        out.print("var ");
        out.print(temp2);
        out.print(" = ");
        ctx.invoke("genInstantiation", (Type)part, new Object[]{ctx, out});
        out.println(";");
        out.print(temp2);
        out.println(".eze$$isNull = this.eze$$isNull;");
        out.print(temp2);
        out.println(".eze$$isNullable = this.eze$$isNullable;");
        for (Field field : part.getFields()) {
            ctx.invoke("genCloneMethod", (Type)part, new Object[]{ctx, out, field});
        }
        out.print(temp2);
        out.print(".setNull(");
        out.print(temp1);
        out.println("eze$$isNull);");
        out.print("return ");
        out.print(temp2);
        out.println(";");
    }

    public void genCloneMethod(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        String temp1 = "ezert$$1";
        String temp2 = "ezert$$2";
        out.print(temp2);
        out.print(".");
        ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
        out.print(" = ");
        out.print(temp1);
        out.print(".");
        ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
        out.println(";");
    }

    public void genGetterSetters(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genGetterSetter", (Type)part, new Object[]{ctx, out, field});
        }
    }

    public void genGetterSetter(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
    }

    public void genFunctions(EGLClass part, Context ctx, TabbedWriter out) {
        for (Function function : part.getFunctions()) {
            ctx.invoke("genFunction", (Type)part, new Object[]{ctx, out, function});
        }
    }

    public void genFunction(EGLClass part, Context ctx, TabbedWriter out, Function arg) {
        out.println(",");
        ctx.invoke("genDeclaration", (EObject)arg, new Object[]{ctx, out});
    }

    public void genAdditionalConstructorParams(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genAdditionalSuperConstructorArgs(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genDeclaration(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genSuperClass(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genAnnotations(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"eze$$getAnnotations"));
        out.println(": function() {");
        out.println("var annotations;");
        for (Annotation annot : part.getAnnotations()) {
            ctx.invoke("genAnnotation", (EType)annot.getEClass(), new Object[]{ctx, out, annot, part});
        }
        out.println("return annotations;");
        out.println("},");
    }

    public void genFieldAnnotations(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"eze$$getFieldInfos"));
        out.println(": function() {");
        out.println("var annotations;");
        out.println("fieldInfos = new Array();");
        int idx = 0;
        for (Field field : part.getFields()) {
            if (field instanceof ConstantField || field.isStatic().booleanValue()) continue;
            ctx.invoke("genAnnotations", (EObject)field, new Object[]{ctx, out, idx});
            ++idx;
        }
        out.println("return fieldInfos;");
        out.println("},");
    }

    public void genNamespaceMap(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"eze$$resolvePart"));
        out.println(": function(/*string*/ namespace, /*string*/ localName) {");
        out.println("if(this.namespaceMap == undefined){");
        out.println("this.namespaceMap = {};");
        for (Map.Entry entry : ctx.getNamespaceMap().entrySet()) {
            out.println("this.namespaceMap[" + EGLClassTemplate.quoted((String)((String)entry.getKey())) + "] = " + EGLClassTemplate.quoted((String)((String)entry.getValue())) + ";");
        }
        out.println("}");
        out.println("var newObject = null;");
        out.println("var className = this.namespaceMap[namespace + \"{\" + localName + \"}\"];");
        out.println("if(className != undefined && className != null){");
        out.println("newObject = instantiate(className, []);");
        out.println("};");
        out.println("return newObject;");
        out.println("}");
    }

    public void genQualifier(EGLClass part, Context ctx, TabbedWriter out, NamedElement arg) {
        for (Member mbr : part.getAllMembers()) {
            if (!mbr.getId().equalsIgnoreCase(arg.getId())) continue;
            out.print("this.");
            break;
        }
    }
}

