/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.JavaScriptAliaser;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.NamedElement;

public class NamedElementTemplate
extends JavaScriptTemplate {
    public void genAccessor(NamedElement element, Context ctx, TabbedWriter out) {
        Annotation property = CommonUtilities.getPropertyAnnotation((Element)element);
        if (property != null) {
            String functionName = null;
            String propertyFn = (String)property.getValue("getMethod");
            if (propertyFn != null && propertyFn.length() > 0) {
                functionName = CommonUtilities.getPropertyFunction((Object)propertyFn);
            }
            if (functionName == null || functionName.trim().length() == 0) {
                functionName = "get" + element.getName().substring(0, 1).toUpperCase();
                if (element.getName().length() > 1) {
                    functionName = String.valueOf(functionName) + element.getName().substring(1);
                }
            }
            if (functionName.equals(ctx.getCurrentFunction())) {
                this.genName(element, ctx, out);
            } else {
                out.print(String.valueOf(functionName) + "()");
            }
        } else {
            this.genName(element, ctx, out);
        }
    }

    public void genName(NamedElement element, Context ctx, TabbedWriter out) {
        out.print(JavaScriptAliaser.getAlias((String)element.getName()));
    }

    public void genQualifier(NamedElement element, Context ctx, TabbedWriter out) {
    }
}

