/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class TypeTemplate
extends JavaScriptTemplate {
    public void preGen(Type type, Context ctx) {
    }

    public void genInstantiation(Type type, Context ctx, TabbedWriter out) {
        out.print("new ");
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptImplementation});
        out.print("(");
        ctx.invoke("genConstructorOptions", type, new Object[]{ctx, out});
        out.print(")");
    }

    public void genInstantiation(Type type, Context ctx, TabbedWriter out, Field arg) {
        ctx.invoke("genInstantiation", type, new Object[]{ctx, out});
    }

    public void genInvocation(Type type, Context ctx, TabbedWriter out, InvocationExpression arg) {
        ctx.invoke("genInvocation", (EObject)arg, new Object[]{ctx, out});
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out, TypedElement arg) {
        if (arg.isNullable()) {
            out.print("null");
        } else {
            ctx.invoke("genDefaultValue", type, new Object[]{ctx, out});
        }
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out, Expression arg) {
        if (arg.isNullable()) {
            out.print("null");
        } else {
            ctx.invoke("genDefaultValue", type, new Object[]{ctx, out});
        }
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out) {
        if (TypeUtils.isReferenceType((Type)type)) {
            out.print("null");
        } else {
            out.print("\"Invalid default value\"");
        }
    }

    public void genRuntimeTypeName(Type type, Context ctx, TabbedWriter out) {
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptPrimitive});
    }

    public void genRuntimeTypeName(Type type, Context ctx, TabbedWriter out, JavaScriptTemplate.TypeNameKind arg) {
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptPrimitive && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            out.print(ctx.getPrimitiveMapping((Type)type.getClassifier()));
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptObject && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            String item = ctx.getPrimitiveMapping((Type)type.getClassifier());
            if (ctx.getPrimitiveMapping(item) == null) {
                out.print(item);
            } else {
                out.print(ctx.getPrimitiveMapping(item));
            }
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptImplementation && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            String item = ctx.getPrimitiveMapping((Type)type.getClassifier());
            if (ctx.getPrimitiveMapping(item) == null) {
                out.print(item);
            } else {
                out.print(ctx.getPrimitiveMapping(item));
            }
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.EGLImplementation && ctx.mapsToNativeType((Type)type.getClassifier())) {
            out.print(ctx.getNativeImplementationMapping((Type)type.getClassifier()));
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptImplementation) {
            out.print(ctx.getNativeImplementationMapping((Type)type.getClassifier()));
        } else {
            out.print(ctx.getNativeInterfaceMapping((Type)type.getClassifier()));
        }
    }

    public void genConstructorOptions(Type type, Context ctx, TabbedWriter out) {
    }

    public void genTypeDependentOptions(Type type, Context ctx, TabbedWriter out, AsExpression arg) {
        ctx.invoke("genTypeDependentOptions", type, new Object[]{ctx, out});
    }

    public void genTypeDependentOptions(Type type, Context ctx, TabbedWriter out) {
    }

    public void genAssignment(Type type, Context ctx, TabbedWriter out, Expression arg1, Expression arg2, String arg3) {
        if (!arg1.isNullable() && arg2.isNullable()) {
            ctx.invoke("genExpression", (EObject)arg1, new Object[]{ctx, out});
            out.print(arg3);
            out.print("(function(x){ return x != null ? (x) : ");
            ctx.invoke("genDefaultValue", type, new Object[]{ctx, out, arg1});
            out.print("; })");
            out.print("(");
            ctx.invoke("genExpression", (EObject)arg2, new Object[]{ctx, out});
            out.print(")");
        } else {
            ctx.invoke("genExpression", (EObject)arg1, new Object[]{ctx, out});
            out.print(arg3);
            ctx.invoke("genExpression", (EObject)arg2, new Object[]{ctx, out});
        }
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) throws GenerationException {
        if (arg.getLHS().isNullable() || arg.getRHS().isNullable() || CommonUtilities.getNativeJavaScriptOperation((BinaryExpression)arg, (Context)ctx).length() == 0) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)arg.getOperation().getContainer())) + '.');
            out.print(CommonUtilities.getNativeRuntimeOperationName((BinaryExpression)arg));
            out.print("(");
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
            out.print(", ");
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
            out.print(")" + CommonUtilities.getNativeRuntimeComparisionOperation((BinaryExpression)arg));
        } else {
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
            out.print(CommonUtilities.getNativeJavaScriptOperation((BinaryExpression)arg, (Context)ctx));
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
        }
    }

    public void genUnaryExpression(Type type, Context ctx, TabbedWriter out, UnaryExpression arg) {
        if (arg.getOperator().equals("-")) {
            out.print(String.valueOf(arg.getOperator()) + "(");
        }
        ctx.invoke("genExpression", (EObject)arg.getExpression(), new Object[]{ctx, out});
        if (arg.getOperator().equals("-")) {
            out.print(")");
        }
    }

    public void genSignature(Type type, Context ctx, TabbedWriter out, TypedElement arg) {
        if (arg.isNullable()) {
            out.print("?");
        }
        ctx.invoke("genSignature", type, new Object[]{ctx, out});
    }

    public void genSignature(Type type, Context ctx, TabbedWriter out, Expression arg) {
        if (arg.isNullable()) {
            out.print("?");
        }
        ctx.invoke("genSignature", type, new Object[]{ctx, out});
    }

    public void genSignature(Type type, Context ctx, TabbedWriter out) {
        out.print(type.getTypeSignature());
    }

    public void genContainerBasedAccessor(Type type, Context ctx, TabbedWriter out, Function arg) {
    }

    public void genContainerBasedAssignment(Type type, Context ctx, TabbedWriter out, Assignment arg1, Field arg2) {
        ctx.invoke("genAssignment", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedArrayAccess(Type type, Context ctx, TabbedWriter out, ArrayAccess arg1, Field arg2) {
        ctx.invoke("genArrayAccess", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedMemberAccess(Type type, Context ctx, TabbedWriter out, MemberAccess arg1, Member arg2) {
        ctx.invoke("genMemberAccess", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedMemberName(Type type, Context ctx, TabbedWriter out, MemberName arg1, Member arg2) {
        ctx.invoke("genMemberName", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedNewExpression(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genNewExpression", (EObject)arg, new Object[]{ctx, out});
    }

    public void genContainerBasedInvocation(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genInvocation", (EObject)arg, new Object[]{ctx, out});
    }
}

