/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class CommonUtilities {
    public static String getEglNameForType(Type type) {
        switch (TypeUtils.getTypeKind((Type)type)) {
            case 1: {
                return "any";
            }
            case 27: {
                return "boolean";
            }
            case 9: {
                return "bigint";
            }
            case 18: {
                return "date";
            }
            case 16: {
                return "float";
            }
            case 10: {
                return "decimal";
            }
            case 8: {
                return "int";
            }
            case 13: {
                return "num";
            }
            case 17: {
                return "smallfloat";
            }
            case 7: {
                return "smallint";
            }
            case 5: {
                return "string";
            }
            case 19: {
                return "time";
            }
            case 20: {
                return "timeStamp";
            }
        }
        return "undefined";
    }

    public static String getEglNameForTypeCamelCase(Type type) {
        String name = CommonUtilities.getEglNameForType(type);
        StringBuilder b = new StringBuilder(name);
        b.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return b.toString();
    }

    public static String getNativeRuntimeOperationName(BinaryExpression expr) throws GenerationException {
        if (expr.getOperation() == null || expr.getOperation().getName() == null) {
            throw new GenerationException();
        }
        String op = expr.getOperator();
        if (op.equals("+")) {
            return "plus";
        }
        if (op.equals("-")) {
            return "minus";
        }
        if (op.equals("/")) {
            return "divide";
        }
        if (op.equals("*")) {
            return "multiply";
        }
        if (op.equals("%")) {
            return "modulo";
        }
        if (op.equals("==")) {
            return "equals";
        }
        if (op.equals("!=")) {
            return "notEquals";
        }
        if (op.equals("<")) {
            return "compareTo";
        }
        if (op.equals(">")) {
            return "compareTo";
        }
        if (op.equals("<=")) {
            return "compareTo";
        }
        if (op.equals(">=")) {
            return "compareTo";
        }
        if (op.equals("&&")) {
            return "and";
        }
        if (op.equals("||")) {
            return "or";
        }
        if (op.equals("xor")) {
            return "xor";
        }
        if (op.equals("::")) {
            return "concat";
        }
        if (op.equals("?:")) {
            return "concat";
        }
        if (op.equals("&")) {
            return "bitand";
        }
        if (op.equals("|")) {
            return "bitor";
        }
        if (op.equals("**")) {
            return "power";
        }
        if (op.equals("in")) {
            return "in";
        }
        if (op.equals("matches")) {
            return "matches";
        }
        if (op.equals("like")) {
            return "like";
        }
        return "UnknownOp";
    }

    public static String getNativeRuntimeComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("<")) {
            return " < 0";
        }
        if (op.equals(">")) {
            return " > 0";
        }
        if (op.equals("<=")) {
            return " <= 0";
        }
        if (op.equals(">=")) {
            return " >= 0";
        }
        return "";
    }

    public static String getNativeJavaScriptOperation(BinaryExpression expr, Context ctx) {
        String op = expr.getOperator();
        if (expr.isNullable() || ((Boolean)ctx.getParameter("checkOverflow")).booleanValue()) {
            if (op.equals("==")) {
                return " == ";
            }
            if (op.equals("!=")) {
                return " != ";
            }
            if (op.equals("<")) {
                return " < ";
            }
            if (op.equals(">")) {
                return " > ";
            }
            if (op.equals("<=")) {
                return " <= ";
            }
            if (op.equals(">=")) {
                return " >= ";
            }
            if (op.equals("&&")) {
                return " && ";
            }
            if (op.equals("||")) {
                return " || ";
            }
            if (op.equals("xor")) {
                return " ^ ";
            }
            if (op.equals("::")) {
                return " + ";
            }
            if (op.equals("&")) {
                return " & ";
            }
            if (op.equals("|")) {
                return " | ";
            }
            return "";
        }
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("-")) {
            return " - ";
        }
        if (op.equals("*")) {
            return " * ";
        }
        if (op.equals("%")) {
            return " % ";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("xor")) {
            return " ^ ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("&")) {
            return " & ";
        }
        if (op.equals("|")) {
            return " | ";
        }
        return "";
    }

    public static String getNativeJavaScriptAssignment(String op) {
        if (op.equals("xor=")) {
            return "^=";
        }
        return op;
    }

    public static String createNamespaceFromPackage(Part part) {
        String ePackage = part.getPackageName();
        if (ePackage == null || ePackage.length() == 0) {
            return "http://default";
        }
        return "http://" + ePackage;
    }

    public static boolean needsConversion(Type fromType, Type toType) {
        boolean result = true;
        if (fromType instanceof FixedPrecisionType && toType instanceof FixedPrecisionType) {
            FixedPrecisionType fpExpr = (FixedPrecisionType)fromType;
            FixedPrecisionType fpType = (FixedPrecisionType)toType;
            result = fpExpr.getLength() > fpType.getLength() || fpExpr.getDecimals() > fpType.getDecimals();
        }
        return result;
    }

    public static boolean proceedWithConversion(Context ctx, Operation conOp) {
        boolean result = true;
        Type fromType = ((FunctionParameter)conOp.getParameters().get(0)).getType();
        Type toType = conOp.getReturnType();
        if (!(conOp.isNarrowConversion() || fromType instanceof ParameterizableType || toType instanceof ParameterizableType)) {
            String fromType_RT = ctx.getPrimitiveMapping(fromType);
            String toType_RT = ctx.getPrimitiveMapping(toType);
            if (fromType_RT != null && toType_RT != null) {
                result = !fromType_RT.equals(toType_RT);
            }
        }
        return result;
    }

    public static boolean isJavaScriptNumber(Type type) {
        return TypeUtils.Type_INT.equals(type) != false || TypeUtils.Type_SMALLINT.equals(type) != false || TypeUtils.Type_FLOAT.equals(type) != false || TypeUtils.Type_SMALLFLOAT.equals(type) != false;
    }

    public static boolean isJavaScriptBigDecimal(Type type) {
        return TypeUtils.Type_BIGINT.equals(type) != false || TypeUtils.Type_NUM.equals(type) != false || TypeUtils.Type_DECIMAL.equals(type) != false || TypeUtils.Type_MONEY.equals(type) != false;
    }

    public static Boolean convertBoolean(Object value) {
        if (value instanceof String) {
            return new Boolean((String)value);
        }
        return (Boolean)value;
    }

    public static boolean isRUIHandler(Object obj) {
        if (obj instanceof EGLClass) {
            return ((EGLClass)obj).getAnnotation("eglx.ui.rui.RUIHandler") != null;
        }
        return false;
    }

    public static boolean isRUIWidget(Object obj) {
        if (obj instanceof EGLClass) {
            return ((EGLClass)obj).getAnnotation("eglx.ui.rui.RUIWidget") != null;
        }
        return false;
    }

    public static boolean isBasicHandler(Object obj) {
        if (obj instanceof EGLClass) {
            return ((EGLClass)obj).getAnnotation("BasicHandler") != null;
        }
        return false;
    }

    public static boolean isBasicLibrary(Object obj) {
        if (obj instanceof EGLClass) {
            return ((EGLClass)obj).getAnnotation("BasicLibrary") != null;
        }
        return false;
    }

    public static boolean isRUIPropertiesLibrary(Object obj) {
        if (obj instanceof EGLClass) {
            return ((EGLClass)obj).getAnnotation("RUIPropertiesLibrary") != null;
        }
        return false;
    }

    public static Annotation getPropertyAnnotation(Element element) {
        Annotation result = element.getAnnotation("eglx.lang.Property");
        if (result == null) {
            result = element.getAnnotation("egl.javascript.JavaScriptProperty");
        }
        if (result == null) {
            result = element.getAnnotation("egl.core.eglproperty");
        }
        return result;
    }

    public static String getPropertyFunction(Object property) {
        String result = null;
        if (property != null) {
            result = property instanceof MemberName ? ((MemberName)property).getNamedElement().getName() : (String)property;
        }
        return result;
    }

    public static Annotation getAnnotation(Context ctx, String key) throws MofObjectNotFoundException, DeserializationException {
        EObject eObject = Environment.getCurrentEnv().find(key);
        if (eObject instanceof StereotypeType && (eObject = ((StereotypeType)eObject).newInstance()) instanceof Annotation) {
            return (Annotation)eObject;
        }
        if (eObject instanceof AnnotationType && (eObject = ((AnnotationType)eObject).newInstance()) instanceof Annotation) {
            return (Annotation)eObject;
        }
        return null;
    }
}

