/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Type;

public class Context
extends EglContext {
    private static final long serialVersionUID = 6429116299734843162L;
    private String currentFunction;
    private Map<String, String> namespaceMap = new HashMap<String, String>();

    public Context(AbstractGeneratorCommand processor) {
        super(processor);
    }

    public String getCurrentFunction() {
        return this.currentFunction;
    }

    public void setCurrentFunction(String currentFunction) {
        this.currentFunction = currentFunction;
    }

    public String getRawPrimitiveMapping(String item) {
        return super.getPrimitiveMapping(item);
    }

    public String getRawPrimitiveMapping(Type type) {
        return super.getPrimitiveMapping(type);
    }

    public String getRawNativeImplementationMapping(Type type) {
        return super.getNativeImplementationMapping(type);
    }

    public String getRawNativeInterfaceMapping(Type type) {
        return super.getNativeInterfaceMapping(type);
    }

    public String getNativeImplementationMapping(Type type) {
        return "egl." + super.getNativeImplementationMapping(type);
    }

    public String getNativeTypeName(Type type) {
        String typeName = this.getNativeImplementationMapping(type);
        return typeName.substring(typeName.lastIndexOf(".") + 1);
    }

    public void handleValidationError(Element obj) {
        int startLine = 0;
        int startOffset = 0;
        int endLine = 0;
        int endOffset = 0;
        String[] details = new String[]{obj.getEClass().getETypeSignature()};
        Annotation annotation = obj.getAnnotation("EGL_Location");
        if (annotation != null) {
            if (annotation.getValue("line") != null) {
                startLine = (Integer)annotation.getValue("line");
            }
            if (annotation.getValue("off") != null) {
                startOffset = (Integer)annotation.getValue("off");
            }
        }
        EGLMessage message = EGLMessage.createEGLMessage((Map)this.getMessageMapping(), (int)1, (String)"1001", (Object)obj, (String[])details, (int)startLine, (int)startOffset, (int)endLine, (int)endOffset);
        this.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
    }

    public void handleValidationError(Annotation obj) {
        String[] details = new String[]{obj.getEClass().getETypeSignature()};
        EGLMessage message = EGLMessage.createEGLMessage((Map)this.getMessageMapping(), (int)1, (String)"1002", (Object)obj, (String[])details, (int)0, (int)0, (int)0, (int)0);
        this.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
    }

    public void handleValidationError(Type obj) {
        String[] details = new String[]{obj.getEClass().getETypeSignature()};
        EGLMessage message = EGLMessage.createEGLMessage((Map)this.getMessageMapping(), (int)1, (String)"1003", (Object)obj, (String[])details, (int)0, (int)0, (int)0, (int)0);
        this.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
    }

    public void addNamespace(String namespace, String localName, String qualifiedPart) {
        this.namespaceMap.put(String.valueOf(namespace) + '{' + localName + '}', qualifiedPart);
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }
}

