/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript;

import java.util.Properties;

public class JavaScriptAliaser {
    private static final String specialChars = "-@#";
    private static final Properties keywordCache = new Properties();
    private static final Properties aliasCache = new Properties(keywordCache);
    private static final Properties javascriptNames = new Properties();

    static {
        keywordCache.put("abstract", "ezekw$$abstract");
        keywordCache.put("as", "ezekw$$as");
        keywordCache.put("boolean", "ezekw$$boolean");
        keywordCache.put("break", "ezekw$$break");
        keywordCache.put("byte", "ezekw$$byte");
        keywordCache.put("case", "ezekw$$case");
        keywordCache.put("catch", "ezekw$$catch");
        keywordCache.put("char", "ezekw$$char");
        keywordCache.put("class", "ezekw$$class");
        keywordCache.put("continue", "ezekw$$continue");
        keywordCache.put("const", "ezekw$$const");
        keywordCache.put("debugger", "ezekw$$debugger");
        keywordCache.put("default", "ezekw$$default");
        keywordCache.put("delete", "ezekw$$delete");
        keywordCache.put("do", "ezekw$$do");
        keywordCache.put("double", "ezekw$$double");
        keywordCache.put("else", "ezekw$$else");
        keywordCache.put("enum", "ezekw$$enum");
        keywordCache.put("export", "ezekw$$export");
        keywordCache.put("extends", "ezekw$$extends");
        keywordCache.put("false", "ezekw$$false");
        keywordCache.put("final", "ezekw$$final");
        keywordCache.put("finally", "ezekw$$finally");
        keywordCache.put("float", "ezekw$$float");
        keywordCache.put("for", "ezekw$$for");
        keywordCache.put("function", "ezekw$$function");
        keywordCache.put("goto", "ezekw$$goto");
        keywordCache.put("if", "ezekw$$if");
        keywordCache.put("implements", "ezekw$$implements");
        keywordCache.put("import", "ezekw$$import");
        keywordCache.put("in", "ezekw$$in");
        keywordCache.put("instanceof", "ezekw$$instanceof");
        keywordCache.put("int", "ezekw$$int");
        keywordCache.put("interface", "ezekw$$interface");
        keywordCache.put("is", "ezekw$$is");
        keywordCache.put("long", "ezekw$$long");
        keywordCache.put("namespace", "ezekw$$namespace");
        keywordCache.put("native", "ezekw$$native");
        keywordCache.put("new", "ezekw$$new");
        keywordCache.put("null", "ezekw$$null");
        keywordCache.put("package", "ezekw$$package");
        keywordCache.put("private", "ezekw$$private");
        keywordCache.put("protected", "ezekw$$protected");
        keywordCache.put("public", "ezekw$$public");
        keywordCache.put("return", "ezekw$$return");
        keywordCache.put("short", "ezekw$$short");
        keywordCache.put("static", "ezekw$$static");
        keywordCache.put("super", "ezekw$$super");
        keywordCache.put("switch", "ezekw$$switch");
        keywordCache.put("synchronized", "ezekw$$synchronized");
        keywordCache.put("this", "ezekw$$this");
        keywordCache.put("throw", "ezekw$$throw");
        keywordCache.put("throws", "ezekw$$throws");
        keywordCache.put("transient", "ezekw$$transient");
        keywordCache.put("true", "ezekw$$true");
        keywordCache.put("try", "ezekw$$try");
        keywordCache.put("typeof", "ezekw$$typeof");
        keywordCache.put("use", "ezekw$$use");
        keywordCache.put("var", "ezekw$$var");
        keywordCache.put("void", "ezekw$$void");
        keywordCache.put("volatile", "ezekw$$volatile");
        keywordCache.put("while", "ezekw$$while");
        keywordCache.put("with", "ezekw$$with");
        javascriptNames.put("class", "className");
    }

    private static void addCharacterAlias(StringBuffer buffer, char c, char escapeChar) {
        buffer.append(escapeChar);
        String hex = Integer.toHexString(c);
        if (escapeChar == 'x') {
            hex = hex.toUpperCase();
        }
        if (c < '\u0010') {
            buffer.append("000");
        } else if (c < '\u0100') {
            buffer.append("00");
        } else if (c < '\u1000') {
            buffer.append('0');
        }
        buffer.append(hex);
    }

    public static String getAlias(String partName) {
        return JavaScriptAliaser.getAlias(partName, '_');
    }

    public static String getAlias(String partName, char escapeChar) {
        String alias = aliasCache.getProperty(partName);
        if (alias != null) {
            return alias;
        }
        char[] chars = partName.toCharArray();
        int start = 0;
        StringBuffer buffer = null;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != escapeChar && specialChars.indexOf(chars[i]) >= 0) {
                if (buffer == null) {
                    buffer = new StringBuffer(chars.length + 16);
                }
                buffer.append(chars, start, i - start);
                JavaScriptAliaser.addCharacterAlias(buffer, chars[i], escapeChar);
                start = i + 1;
            }
            ++i;
        }
        if (buffer == null) {
            alias = partName;
        } else {
            buffer.append(chars, start, chars.length - start);
            alias = buffer.toString();
        }
        aliasCache.put(partName, alias);
        return alias;
    }

    public static String getJavascriptSafeAlias(String partName) {
        String alias = JavaScriptAliaser.getAlias(partName);
        return javascriptNames.getProperty(alias, alias);
    }

    public static boolean isJavaScriptKeyword(String name) {
        return keywordCache.containsKey(name);
    }

    /*
     * Unable to fully structure code
     */
    public static String packageNameAlias(String packageName) {
        block1: {
            unAliased = packageName.toLowerCase();
            aliased = "";
            dotIndex = unAliased.indexOf(46);
            if (dotIndex != -1) ** GOTO lbl11
            aliased = JavaScriptAliaser.getJavascriptSafeAlias(unAliased);
            break block1;
lbl-1000:
            // 1 sources

            {
                piece = unAliased.substring(0, dotIndex);
                aliased = String.valueOf(aliased) + JavaScriptAliaser.getJavascriptSafeAlias(piece) + ".";
                unAliased = unAliased.substring(dotIndex + 1);
                dotIndex = unAliased.indexOf(46);
lbl11:
                // 2 sources

                ** while (dotIndex != -1)
            }
lbl12:
            // 1 sources

            aliased = String.valueOf(aliased) + JavaScriptAliaser.getJavascriptSafeAlias(unAliased);
        }
        return aliased;
    }

    public static String packageNameAlias(String[] pkg, char separator) {
        return JavaScriptAliaser.packageNameAlias(pkg, separator, true);
    }

    public static String packageNameAlias(String[] pkg, char separator, boolean toLowerCase) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < pkg.length) {
            if (i > 0) {
                buff.append(separator);
            }
            String alias = JavaScriptAliaser.getJavascriptSafeAlias(pkg[i]);
            if (toLowerCase) {
                alias = alias.toLowerCase();
            }
            buff.append(alias);
            ++i;
        }
        return buff.toString();
    }
}

