/*******************************************************************************
 * Copyright © 2008, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/* The following code was generated by JFlex 1.4.1 on 12/11/06 11:58 AM */

package org.eclipse.edt.ide.core.internal.errors;
import java.io.IOException;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 12/11/06 11:58 AM from the specification file
 * <tt>error.flex</tt>
 */
public class ErrorLexer implements IErrorLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int DLI = 6;
  public static final int DLI_QUOTED_ID = 7;
  public static final int SQLDELIMITEDID = 3;
  public static final int STRING = 1;
  public static final int BLOCKCOMMENT = 5;
  public static final int DLI_DBL_QUOTED_ID = 8;
  public static final int SQL = 2;
  public static final int YYINITIAL = 0;
  public static final int SQLSTRING = 4;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\3\1\1\1\0\1\3\1\2\16\5\4\0\1\3\1\53"+
    "\1\46\1\47\1\4\1\65\1\60\1\100\1\51\1\52\1\13\1\11"+
    "\1\54\1\14\1\7\1\12\1\45\5\6\1\44\3\6\1\56\1\55"+
    "\1\62\1\57\1\63\1\64\1\71\1\15\1\16\1\32\1\24\1\10"+
    "\1\37\1\35\1\40\1\25\1\4\1\43\1\21\1\30\1\26\1\20"+
    "\1\31\1\42\1\33\1\17\1\23\1\22\1\34\1\41\1\36\1\27"+
    "\1\4\1\66\1\72\1\67\1\0\1\4\1\0\1\15\1\73\1\32"+
    "\1\24\1\10\1\74\1\35\1\40\1\25\1\4\1\43\1\21\1\30"+
    "\1\75\1\20\1\31\1\42\1\76\1\17\1\77\1\22\1\34\1\41"+
    "\1\36\1\27\1\4\1\50\1\61\1\70\1\0\41\5\2\0\4\4"+
    "\4\0\1\4\12\0\1\4\4\0\1\4\5\0\27\4\1\0\37\4"+
    "\1\0\u0128\4\2\0\22\4\34\0\136\4\2\0\11\4\2\0\7\4"+
    "\16\0\2\4\16\0\5\4\11\0\1\4\21\0\117\5\21\0\3\5"+
    "\27\0\1\4\13\0\1\4\1\0\3\4\1\0\1\4\1\0\24\4"+
    "\1\0\54\4\1\0\10\4\2\0\32\4\14\0\202\4\1\0\4\5"+
    "\5\0\71\4\2\0\2\4\2\0\2\4\3\0\46\4\2\0\2\4"+
    "\67\0\46\4\2\0\1\4\7\0\47\4\11\0\21\5\1\0\27\5"+
    "\1\0\3\5\1\0\1\5\1\0\2\5\1\0\1\5\13\0\33\4"+
    "\5\0\3\4\56\0\32\4\5\0\13\4\13\5\12\0\12\5\6\0"+
    "\1\5\143\4\1\0\1\4\7\5\2\0\6\5\2\4\2\5\1\0"+
    "\4\5\2\0\12\5\3\4\22\0\1\5\1\4\1\5\33\4\3\0"+
    "\33\5\65\0\46\4\13\5\u0150\0\3\5\1\0\65\4\2\0\1\5"+
    "\1\4\20\5\2\0\1\4\4\5\3\0\12\4\2\5\2\0\12\5"+
    "\21\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4\1\0\7\4"+
    "\1\0\1\4\3\0\4\4\2\0\1\5\1\0\7\5\2\0\2\5"+
    "\2\0\3\5\11\0\1\5\4\0\2\4\1\0\3\4\2\5\2\0"+
    "\12\5\4\4\16\0\1\5\2\0\6\4\4\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4\2\0\1\5"+
    "\1\0\5\5\4\0\2\5\2\0\3\5\13\0\4\4\1\0\1\4"+
    "\7\0\14\5\3\4\14\0\3\5\1\0\7\4\1\0\1\4\1\0"+
    "\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0"+
    "\1\5\1\4\10\5\1\0\3\5\1\0\3\5\2\0\1\4\17\0"+
    "\1\4\5\0\12\5\21\0\3\5\1\0\10\4\2\0\2\4\2\0"+
    "\26\4\1\0\7\4\1\0\2\4\2\0\4\4\2\0\1\5\1\4"+
    "\6\5\3\0\2\5\2\0\3\5\10\0\2\5\4\0\2\4\1\0"+
    "\3\4\4\0\12\5\22\0\2\5\1\0\6\4\3\0\3\4\1\0"+
    "\4\4\3\0\2\4\1\0\1\4\1\0\2\4\3\0\2\4\3\0"+
    "\3\4\3\0\10\4\1\0\3\4\4\0\5\5\3\0\3\5\1\0"+
    "\4\5\11\0\1\5\17\0\11\5\21\0\3\5\1\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\12\4\1\0\5\4\4\0\7\5\1\0"+
    "\3\5\1\0\4\5\7\0\2\5\11\0\2\4\4\0\12\5\22\0"+
    "\2\5\1\0\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0"+
    "\5\4\4\0\7\5\1\0\3\5\1\0\4\5\7\0\2\5\7\0"+
    "\1\4\1\0\2\4\4\0\12\5\22\0\2\5\1\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\20\4\4\0\6\5\2\0\3\5\1\0"+
    "\4\5\11\0\1\5\10\0\2\4\4\0\12\5\22\0\2\5\1\0"+
    "\22\4\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4\3\0"+
    "\1\5\4\0\6\5\1\0\1\5\1\0\10\5\22\0\2\5\15\0"+
    "\60\4\1\5\2\4\7\5\4\0\10\4\10\5\1\0\12\5\47\0"+
    "\2\4\1\0\1\4\2\0\2\4\1\0\1\4\2\0\1\4\6\0"+
    "\4\4\1\0\7\4\1\0\3\4\1\0\1\4\1\0\1\4\2\0"+
    "\2\4\1\0\4\4\1\5\2\4\6\5\1\0\2\5\1\4\2\0"+
    "\5\4\1\0\1\4\1\0\6\5\2\0\12\5\2\0\2\4\42\0"+
    "\1\4\27\0\2\5\6\0\12\5\13\0\1\5\1\0\1\5\1\0"+
    "\1\5\4\0\2\5\10\4\1\0\42\4\6\0\24\5\1\0\2\5"+
    "\4\4\4\0\10\5\1\0\44\5\11\0\1\5\71\0\42\4\1\0"+
    "\5\4\1\0\2\4\1\0\7\5\3\0\4\5\6\0\12\5\6\0"+
    "\6\4\4\5\106\0\46\4\12\0\47\4\11\0\132\4\5\0\104\4"+
    "\5\0\122\4\6\0\7\4\1\0\77\4\1\0\1\4\1\0\4\4"+
    "\2\0\7\4\1\0\1\4\1\0\4\4\2\0\47\4\1\0\1\4"+
    "\1\0\4\4\2\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4"+
    "\1\0\1\4\1\0\4\4\2\0\7\4\1\0\7\4\1\0\27\4"+
    "\1\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\47\4"+
    "\1\0\23\4\16\0\11\5\56\0\125\4\14\0\u026c\4\2\0\10\4"+
    "\12\0\32\4\5\0\113\4\225\0\64\4\40\5\7\0\1\4\4\0"+
    "\12\5\41\0\4\5\1\0\12\5\6\0\130\4\10\0\51\4\1\5"+
    "\u0556\0\234\4\4\0\132\4\6\0\26\4\2\0\6\4\2\0\46\4"+
    "\2\0\6\4\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4"+
    "\1\0\37\4\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4"+
    "\1\0\7\4\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4"+
    "\1\0\7\4\17\0\4\5\32\0\5\5\20\0\2\4\51\0\6\5"+
    "\17\0\1\4\40\0\20\4\40\0\15\5\4\0\1\5\40\0\1\4"+
    "\4\0\1\4\2\0\12\4\1\0\1\4\3\0\5\4\6\0\1\4"+
    "\1\0\1\4\1\0\1\4\1\0\4\4\1\0\3\4\1\0\7\4"+
    "\46\0\44\4\u0e81\0\3\4\31\0\11\4\6\5\1\0\5\4\2\0"+
    "\3\4\6\0\124\4\4\0\2\5\2\0\2\4\2\0\136\4\6\0"+
    "\50\4\4\0\136\4\21\0\30\4\u0248\0\u19b6\4\112\0\u51a6\4\132\0"+
    "\u048d\4\u0773\0\u2ba4\4\u215c\0\u012e\4\322\0\7\4\14\0\5\4\5\0"+
    "\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4\1\0"+
    "\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0"+
    "\66\4\50\0\14\4\44\0\4\5\17\0\2\4\30\0\3\4\31\0"+
    "\1\4\6\0\3\4\1\0\1\4\1\0\207\4\2\0\1\5\4\0"+
    "\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4\12\0"+
    "\132\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4\3\0"+
    "\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\1\0\1\2\2\0\2\2\2\0\1\3\1\1"+
    "\1\4\1\5\1\6\1\4\1\7\1\10\1\11\1\12"+
    "\23\4\1\13\1\3\1\14\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\2\2\36\1\37"+
    "\1\40\4\2\1\41\1\42\1\43\1\2\2\44\1\45"+
    "\1\2\1\46\2\2\1\47\1\50\1\51\2\52\1\53"+
    "\1\54\1\55\1\0\5\4\1\56\1\1\1\57\1\60"+
    "\1\61\1\62\1\63\1\4\1\64\6\4\1\65\13\4"+
    "\1\66\7\4\1\67\7\4\1\70\1\71\1\4\1\72"+
    "\33\4\2\0\1\73\1\74\1\75\1\76\1\77\1\100"+
    "\1\66\1\101\1\102\1\103\1\104\1\105\1\106\1\107"+
    "\1\110\1\111\1\112\1\113\1\2\1\114\1\115\1\116"+
    "\1\117\1\0\3\4\1\120\4\4\2\1\2\0\1\121"+
    "\1\4\1\122\1\123\1\77\1\124\2\4\1\125\3\4"+
    "\1\126\10\4\1\127\7\4\1\130\3\4\1\131\2\4"+
    "\1\132\7\4\1\133\2\4\1\124\3\4\1\134\1\135"+
    "\2\4\1\125\23\4\1\136\1\4\1\137\1\140\6\4"+
    "\1\141\5\4\2\0\1\142\1\143\1\2\1\4\1\144"+
    "\4\4\1\145\2\4\1\146\1\147\12\4\1\150\4\4"+
    "\1\151\1\4\1\152\1\4\1\153\3\4\1\154\1\4"+
    "\1\155\11\4\1\156\3\4\1\157\1\4\1\160\1\4"+
    "\1\125\2\4\1\161\7\4\1\162\1\163\12\4\1\164"+
    "\1\165\2\4\1\166\6\4\1\167\1\4\1\170\1\171"+
    "\1\172\1\4\2\0\2\4\1\173\11\4\1\174\11\4"+
    "\1\175\1\4\1\176\3\4\1\177\10\4\1\200\14\4"+
    "\1\201\1\4\1\202\2\4\1\203\13\4\1\204\1\205"+
    "\3\4\1\206\2\0\1\207\1\210\1\211\6\4\1\212"+
    "\2\4\1\213\2\4\1\214\4\4\1\215\4\4\1\216"+
    "\2\4\1\217\6\4\1\220\2\4\1\221\16\4\1\222"+
    "\1\4\1\223\11\4\1\0\1\4\1\224\1\225\3\4"+
    "\1\226\3\4\1\227\1\4\1\230\10\4\1\231\4\4"+
    "\1\232\1\233\1\234\1\235\1\4\1\236\1\237\3\4"+
    "\1\240\1\4\1\241\1\4\1\242\1\243\1\244\2\4"+
    "\1\245\1\4\1\246\1\247\1\4\1\0\2\4\1\250"+
    "\5\4\1\251\2\4\1\252\1\253\2\4\1\254\1\4"+
    "\1\255\1\4\1\256\1\257\1\4\1\260\1\261\1\262"+
    "\3\4\1\263\1\4\1\0\3\4\1\264\1\4\1\265"+
    "\1\4\1\266\1\4\1\267\1\270\1\271\2\4\1\272"+
    "\1\273\1\274\1\4\1\0\2\4\1\275\3\4\1\276"+
    "\2\4\1\0\1\277\1\4\1\300\1\301\1\302\1\303"+
    "\1\4\1\0\1\304\1\4\1\0\1\305\1\0\1\306";

  private static int [] zzUnpackAction() {
    int [] result = new int[662];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\101\0\202\0\303\0\u0104\0\u0145\0\u0186\0\u01c7"+
    "\0\u0208\0\u0249\0\u028a\0\u02cb\0\u030c\0\u034d\0\u038e\0\u03cf"+
    "\0\u0410\0\u0451\0\u0492\0\u04d3\0\u0514\0\u0555\0\u0596\0\u05d7"+
    "\0\u0618\0\u0659\0\u069a\0\u06db\0\u071c\0\u075d\0\u079e\0\u07df"+
    "\0\u0820\0\u0861\0\u08a2\0\u08e3\0\u0924\0\u0965\0\u0249\0\u09a6"+
    "\0\u0249\0\u0249\0\u0249\0\u09e7\0\u0249\0\u0249\0\u0a28\0\u0a69"+
    "\0\u0aaa\0\u0aeb\0\u0b2c\0\u0b6d\0\u0bae\0\u0bef\0\u0249\0\u0249"+
    "\0\u0249\0\u0249\0\u0c30\0\u0249\0\u0c71\0\u0249\0\u0cb2\0\u0249"+
    "\0\u0cf3\0\u0d34\0\u0d75\0\u0249\0\u0249\0\u0249\0\u0db6\0\u0249"+
    "\0\u0df7\0\u0e38\0\u0e79\0\u0eba\0\u0efb\0\u0f3c\0\u0249\0\u0249"+
    "\0\u0249\0\u0249\0\u0f7d\0\u0eba\0\u0e38\0\u0fbe\0\u0fff\0\u1040"+
    "\0\u1081\0\u10c2\0\u1103\0\u1144\0\u0249\0\u1185\0\u11c6\0\u0249"+
    "\0\u1207\0\u0249\0\u0249\0\u1248\0\u02cb\0\u1289\0\u12ca\0\u130b"+
    "\0\u134c\0\u138d\0\u13ce\0\u140f\0\u1450\0\u1491\0\u14d2\0\u1513"+
    "\0\u1554\0\u1595\0\u15d6\0\u1617\0\u1658\0\u1699\0\u16da\0\u02cb"+
    "\0\u171b\0\u175c\0\u179d\0\u17de\0\u181f\0\u1860\0\u18a1\0\u02cb"+
    "\0\u18e2\0\u1923\0\u1964\0\u19a5\0\u19e6\0\u1a27\0\u1a68\0\u1aa9"+
    "\0\u1aea\0\u1b2b\0\u02cb\0\u1b6c\0\u1bad\0\u1bee\0\u1c2f\0\u1c70"+
    "\0\u1cb1\0\u1cf2\0\u1d33\0\u1d74\0\u1db5\0\u1df6\0\u1e37\0\u1e78"+
    "\0\u1eb9\0\u1efa\0\u1f3b\0\u1f7c\0\u1fbd\0\u1ffe\0\u203f\0\u2080"+
    "\0\u20c1\0\u2102\0\u2143\0\u2184\0\u21c5\0\u2206\0\u2247\0\u2288"+
    "\0\u0249\0\u22c9\0\u0249\0\u0249\0\u0249\0\u0249\0\u0249\0\u0249"+
    "\0\u0249\0\u230a\0\u0249\0\u0249\0\u0249\0\u0249\0\u0249\0\u0249"+
    "\0\u0249\0\u0249\0\u234b\0\u0249\0\u0249\0\u0249\0\u238c\0\u238c"+
    "\0\u23cd\0\u240e\0\u244f\0\u02cb\0\u2490\0\u24d1\0\u2512\0\u2553"+
    "\0\u0249\0\u2594\0\u11c6\0\u25d5\0\u0249\0\u2616\0\u02cb\0\u02cb"+
    "\0\u02cb\0\u02cb\0\u2657\0\u2698\0\u26d9\0\u271a\0\u275b\0\u279c"+
    "\0\u02cb\0\u27dd\0\u281e\0\u285f\0\u28a0\0\u28e1\0\u2922\0\u2963"+
    "\0\u29a4\0\u02cb\0\u29e5\0\u2a26\0\u2a67\0\u2aa8\0\u2ae9\0\u2b2a"+
    "\0\u2b6b\0\u02cb\0\u2bac\0\u2bed\0\u2c2e\0\u02cb\0\u2c6f\0\u2cb0"+
    "\0\u02cb\0\u2cf1\0\u2d32\0\u2d73\0\u2db4\0\u2df5\0\u2e36\0\u2e77"+
    "\0\u02cb\0\u2eb8\0\u2ef9\0\u2f3a\0\u2f7b\0\u2fbc\0\u2ffd\0\u02cb"+
    "\0\u02cb\0\u303e\0\u307f\0\u30c0\0\u3101\0\u3142\0\u3183\0\u31c4"+
    "\0\u3205\0\u3246\0\u3287\0\u32c8\0\u3309\0\u334a\0\u338b\0\u33cc"+
    "\0\u340d\0\u344e\0\u348f\0\u34d0\0\u3511\0\u3552\0\u3593\0\u02cb"+
    "\0\u35d4\0\u3615\0\u3656\0\u3697\0\u36d8\0\u3719\0\u375a\0\u379b"+
    "\0\u37dc\0\u02cb\0\u381d\0\u385e\0\u389f\0\u38e0\0\u3921\0\u3962"+
    "\0\u39a3\0\u0249\0\u0249\0\u39e4\0\u3a25\0\u02cb\0\u3a66\0\u3aa7"+
    "\0\u3ae8\0\u3b29\0\u02cb\0\u3b6a\0\u3bab\0\u02cb\0\u02cb\0\u3bec"+
    "\0\u3c2d\0\u3c6e\0\u3caf\0\u3cf0\0\u3d31\0\u3d72\0\u3db3\0\u3df4"+
    "\0\u3e35\0\u02cb\0\u3e76\0\u3eb7\0\u3ef8\0\u3f39\0\u3f7a\0\u3fbb"+
    "\0\u02cb\0\u3ffc\0\u02cb\0\u403d\0\u407e\0\u40bf\0\u02cb\0\u4100"+
    "\0\u02cb\0\u4141\0\u4182\0\u41c3\0\u4204\0\u4245\0\u4286\0\u42c7"+
    "\0\u4308\0\u4349\0\u02cb\0\u438a\0\u43cb\0\u440c\0\u02cb\0\u444d"+
    "\0\u02cb\0\u448e\0\u02cb\0\u44cf\0\u4510\0\u02cb\0\u4551\0\u4592"+
    "\0\u45d3\0\u4614\0\u4655\0\u4696\0\u46d7\0\u02cb\0\u02cb\0\u4718"+
    "\0\u4759\0\u479a\0\u47db\0\u481c\0\u485d\0\u489e\0\u48df\0\u4920"+
    "\0\u4961\0\u02cb\0\u0249\0\u49a2\0\u49e3\0\u4a24\0\u4a65\0\u4aa6"+
    "\0\u4ae7\0\u4b28\0\u4b69\0\u4baa\0\u02cb\0\u4beb\0\u02cb\0\u4c2c"+
    "\0\u02cb\0\u4c6d\0\u4cae\0\u4cef\0\u4d30\0\u4d71\0\u02cb\0\u4db2"+
    "\0\u4df3\0\u4e34\0\u4e75\0\u4eb6\0\u4ef7\0\u4f38\0\u4f79\0\u4fba"+
    "\0\u02cb\0\u4ffb\0\u503c\0\u507d\0\u50be\0\u50ff\0\u5140\0\u5181"+
    "\0\u51c2\0\u5203\0\u02cb\0\u5244\0\u5285\0\u52c6\0\u5307\0\u5348"+
    "\0\u02cb\0\u5389\0\u53ca\0\u540b\0\u544c\0\u548d\0\u54ce\0\u550f"+
    "\0\u5550\0\u02cb\0\u5591\0\u55d2\0\u5613\0\u5654\0\u5695\0\u56d6"+
    "\0\u5717\0\u5758\0\u5799\0\u57da\0\u581b\0\u585c\0\u02cb\0\u589d"+
    "\0\u58de\0\u591f\0\u5960\0\u02cb\0\u59a1\0\u59e2\0\u5a23\0\u5a64"+
    "\0\u5aa5\0\u5ae6\0\u5b27\0\u5b68\0\u5ba9\0\u5bea\0\u5c2b\0\u02cb"+
    "\0\u02cb\0\u5c6c\0\u5cad\0\u5cee\0\u02cb\0\u5d2f\0\u5d70\0\u0249"+
    "\0\u0249\0\u02cb\0\u5db1\0\u5df2\0\u5e33\0\u5e74\0\u5eb5\0\u5ef6"+
    "\0\u02cb\0\u5f37\0\u5f78\0\u02cb\0\u5fb9\0\u5ffa\0\u02cb\0\u603b"+
    "\0\u607c\0\u60bd\0\u60fe\0\u02cb\0\u613f\0\u6180\0\u61c1\0\u6202"+
    "\0\u02cb\0\u6243\0\u6284\0\u02cb\0\u62c5\0\u6306\0\u6347\0\u6388"+
    "\0\u63c9\0\u640a\0\u02cb\0\u644b\0\u648c\0\u02cb\0\u64cd\0\u650e"+
    "\0\u654f\0\u6590\0\u65d1\0\u6612\0\u6653\0\u6694\0\u66d5\0\u6716"+
    "\0\u6757\0\u6798\0\u67d9\0\u681a\0\u685b\0\u689c\0\u02cb\0\u68dd"+
    "\0\u691e\0\u695f\0\u69a0\0\u69e1\0\u6a22\0\u6a63\0\u6aa4\0\u6ae5"+
    "\0\u6b26\0\u6b67\0\u02cb\0\u02cb\0\u6ba8\0\u6be9\0\u6c2a\0\u02cb"+
    "\0\u6c6b\0\u6cac\0\u6ced\0\u02cb\0\u6d2e\0\u02cb\0\u6d6f\0\u6db0"+
    "\0\u6df1\0\u6e32\0\u6e73\0\u6eb4\0\u6ef5\0\u6f36\0\u02cb\0\u6f77"+
    "\0\u6fb8\0\u6ff9\0\u703a\0\u02cb\0\u02cb\0\u02cb\0\u02cb\0\u707b"+
    "\0\u02cb\0\u02cb\0\u70bc\0\u70fd\0\u713e\0\u02cb\0\u717f\0\u02cb"+
    "\0\u71c0\0\u02cb\0\u02cb\0\u02cb\0\u7201\0\u7242\0\u02cb\0\u7283"+
    "\0\u02cb\0\u02cb\0\u72c4\0\u7305\0\u7346\0\u7387\0\u02cb\0\u73c8"+
    "\0\u7409\0\u744a\0\u748b\0\u74cc\0\u02cb\0\u750d\0\u754e\0\u02cb"+
    "\0\u02cb\0\u758f\0\u75d0\0\u02cb\0\u7611\0\u02cb\0\u7652\0\u02cb"+
    "\0\u02cb\0\u7693\0\u02cb\0\u02cb\0\u02cb\0\u76d4\0\u7715\0\u7756"+
    "\0\u02cb\0\u7797\0\u77d8\0\u7819\0\u785a\0\u789b\0\u02cb\0\u78dc"+
    "\0\u02cb\0\u791d\0\u02cb\0\u795e\0\u02cb\0\u02cb\0\u02cb\0\u799f"+
    "\0\u79e0\0\u02cb\0\u02cb\0\u02cb\0\u7a21\0\u7a62\0\u7aa3\0\u7ae4"+
    "\0\u02cb\0\u7b25\0\u7b66\0\u7ba7\0\u02cb\0\u7be8\0\u7c29\0\u7c6a"+
    "\0\u02cb\0\u7cab\0\u02cb\0\u02cb\0\u02cb\0\u02cb\0\u7cec\0\u7d2d"+
    "\0\u02cb\0\u7d6e\0\u7daf\0\u02cb\0\u7df0\0\u0249";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[662];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\12\3\13\1\14\1\12\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\14\1\36\1\37"+
    "\1\40\1\41\1\14\1\42\1\43\1\44\1\45\1\46"+
    "\2\14\2\15\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\12\1\25"+
    "\1\44\1\35\1\41\1\32\1\12\1\73\1\74\1\75"+
    "\43\73\1\76\23\73\1\77\6\73\1\100\3\101\1\102"+
    "\3\100\1\102\3\100\1\103\27\102\2\100\1\104\21\100"+
    "\1\105\2\100\5\102\1\106\1\107\1\110\1\111\43\107"+
    "\1\112\32\107\1\113\1\110\1\111\75\113\1\114\13\115"+
    "\1\116\65\115\1\100\3\101\1\102\3\100\1\102\4\100"+
    "\27\102\2\100\1\117\21\100\1\120\2\100\5\102\1\121"+
    "\1\113\1\122\1\123\75\113\1\124\1\107\1\122\1\123"+
    "\43\107\1\125\32\107\102\0\3\13\101\0\3\14\1\0"+
    "\1\14\4\0\31\14\25\0\5\14\7\0\1\15\1\126"+
    "\1\127\33\0\2\15\41\0\1\126\35\0\2\126\37\0"+
    "\3\14\1\0\1\14\4\0\2\14\1\130\1\14\1\131"+
    "\4\14\1\132\1\14\1\133\5\14\1\134\7\14\25\0"+
    "\2\14\1\132\2\14\60\0\1\135\33\0\1\136\1\137"+
    "\43\0\1\140\34\0\1\141\43\0\1\142\100\0\1\143"+
    "\25\0\3\14\1\0\1\14\4\0\1\14\1\144\1\145"+
    "\1\14\1\146\2\14\1\147\1\14\1\150\17\14\25\0"+
    "\1\144\1\14\1\150\2\14\5\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\151\1\152\3\14\1\153\1\14\1\154"+
    "\16\14\25\0\5\14\5\0\3\14\1\0\1\155\4\0"+
    "\6\14\1\156\1\14\1\157\2\14\1\160\1\14\1\161"+
    "\5\14\1\162\1\14\1\163\3\14\25\0\4\14\1\156"+
    "\5\0\3\14\1\0\1\14\4\0\5\14\1\164\1\165"+
    "\2\14\1\166\2\14\1\167\1\14\1\170\12\14\25\0"+
    "\2\14\1\166\1\170\1\165\5\0\3\14\1\0\1\14"+
    "\4\0\1\171\7\14\1\172\20\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\2\14\1\173\6\14\1\174"+
    "\2\14\1\175\1\14\1\176\2\14\1\177\7\14\25\0"+
    "\2\14\1\174\1\176\1\14\5\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\200\6\14\1\201\3\14\1\202\4\14"+
    "\1\203\5\14\25\0\3\14\1\202\1\14\5\0\3\14"+
    "\1\0\1\204\4\0\1\205\1\206\6\14\1\207\10\14"+
    "\1\177\7\14\1\47\24\0\1\206\4\14\5\0\3\14"+
    "\1\0\1\14\4\0\2\14\1\210\6\14\1\211\1\14"+
    "\1\212\6\14\1\213\6\14\25\0\1\14\1\213\1\211"+
    "\2\14\5\0\3\14\1\0\1\214\4\0\3\14\1\215"+
    "\1\14\1\216\23\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\1\217\1\206\1\14\1\220\15\14\1\177"+
    "\7\14\1\47\24\0\1\206\4\14\5\0\3\14\1\0"+
    "\1\14\4\0\1\221\15\14\1\222\12\14\25\0\3\14"+
    "\1\222\1\14\5\0\3\14\1\0\1\14\4\0\1\223"+
    "\2\14\1\224\1\225\1\226\13\14\1\177\1\14\1\227"+
    "\5\14\1\47\24\0\5\14\5\0\3\14\1\0\1\230"+
    "\4\0\5\14\1\231\23\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\232\4\0\3\14\1\233\25\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\3\14\1\234\25\14"+
    "\1\47\24\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\3\14\1\235\1\236\1\237\2\14\1\240\5\14\1\241"+
    "\12\14\25\0\3\14\1\241\1\14\5\0\3\14\1\0"+
    "\1\242\4\0\1\243\2\14\1\244\25\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\10\14\1\245\12\14"+
    "\1\246\5\14\25\0\5\14\20\0\1\247\4\0\1\250"+
    "\133\0\1\251\77\0\1\252\101\0\1\253\100\0\1\254"+
    "\1\255\77\0\1\256\1\0\1\257\76\0\1\260\100\0"+
    "\1\261\77\0\1\262\101\0\1\263\21\0\1\73\2\0"+
    "\43\73\1\0\23\73\1\0\6\73\1\0\1\74\145\0"+
    "\1\264\23\0\1\265\1\266\1\267\1\270\1\271\1\272"+
    "\2\0\3\101\101\0\3\102\1\0\1\102\4\0\31\102"+
    "\25\0\5\102\15\0\1\273\64\0\1\107\2\0\43\107"+
    "\1\0\32\107\1\0\1\110\145\0\1\274\32\0\1\113"+
    "\2\0\75\113\101\0\1\275\13\115\1\0\65\115\12\0"+
    "\1\276\67\0\1\122\105\0\1\126\1\0\1\127\33\0"+
    "\2\126\41\0\1\277\2\0\1\300\2\0\1\300\27\0"+
    "\2\277\37\0\3\14\1\0\1\14\4\0\15\14\1\301"+
    "\13\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\2\14\1\302\26\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\5\14\1\303\1\14\1\304\21\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\1\14\1\305"+
    "\27\14\25\0\1\305\4\14\5\0\3\14\1\0\1\306"+
    "\4\0\6\14\1\307\1\14\1\310\20\14\25\0\4\14"+
    "\1\307\1\0\1\136\1\311\1\312\76\136\13\313\1\314"+
    "\65\313\57\0\1\315\25\0\3\14\1\0\1\14\4\0"+
    "\2\14\1\316\26\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\4\14\1\317\24\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\7\14\1\320\21\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\7\14\1\321"+
    "\2\14\1\322\16\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\3\14\1\323\25\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\3\14\1\324\25\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\11\14\1\325"+
    "\6\14\1\326\10\14\25\0\2\14\1\325\2\14\5\0"+
    "\3\14\1\0\1\14\4\0\11\14\1\327\2\14\1\330"+
    "\14\14\25\0\2\14\1\327\2\14\5\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\331\7\14\1\332\12\14\25\0"+
    "\3\14\1\332\1\331\5\0\3\14\1\0\1\14\4\0"+
    "\1\333\15\14\1\334\12\14\25\0\3\14\1\334\1\14"+
    "\5\0\3\14\1\0\1\14\4\0\11\14\1\335\17\14"+
    "\25\0\2\14\1\335\2\14\5\0\3\14\1\0\1\14"+
    "\4\0\1\336\30\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\16\14\1\337\12\14\25\0\3\14\1\337"+
    "\1\14\5\0\3\14\1\0\1\14\4\0\3\14\1\340"+
    "\25\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\4\14\1\341\24\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\342\22\14\25\0\4\14\1\342"+
    "\5\0\3\14\1\0\1\14\4\0\23\14\1\343\5\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\344\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\345\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\1\14"+
    "\1\346\1\347\26\14\25\0\1\346\4\14\5\0\3\14"+
    "\1\0\1\14\4\0\1\14\1\350\24\14\1\351\2\14"+
    "\25\0\1\350\4\14\5\0\3\14\1\0\1\352\4\0"+
    "\10\14\1\353\20\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\10\14\1\354\20\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\7\14\1\355\21\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\4\14\1\356"+
    "\24\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\31\14\1\47\24\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\14\14\1\357\14\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\1\360\11\14\1\361\16\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\10\14\1\362"+
    "\5\14\1\363\12\14\25\0\3\14\1\363\1\14\5\0"+
    "\3\14\1\0\1\14\4\0\4\14\1\364\10\14\1\365"+
    "\13\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\6\14\1\366\22\14\25\0\4\14\1\366\5\0\3\14"+
    "\1\0\1\14\4\0\15\14\1\367\13\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\2\14\1\370\26\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\1\371"+
    "\30\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\2\14\1\372\1\373\2\14\1\374\5\14\1\375\14\14"+
    "\25\0\4\14\1\374\5\0\3\14\1\0\1\14\4\0"+
    "\14\14\1\376\14\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\21\14\1\377\2\14\1\u0100\4\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\6\14\1\u0101"+
    "\6\14\1\u0102\13\14\25\0\4\14\1\u0101\5\0\3\14"+
    "\1\0\1\14\4\0\4\14\1\u0103\6\14\1\u0104\15\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\6\14"+
    "\1\u0105\22\14\25\0\4\14\1\u0105\5\0\3\14\1\0"+
    "\1\14\4\0\11\14\1\u0106\5\14\1\u0107\11\14\25\0"+
    "\2\14\1\u0106\2\14\5\0\3\14\1\0\1\14\4\0"+
    "\2\14\1\u0108\12\14\1\u0109\13\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\u010a\4\0\3\14\1\u010b\4\14\1\u010c"+
    "\20\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\2\14\1\u010d\1\14\1\u010e\24\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\11\14\1\u010f\17\14\25\0"+
    "\2\14\1\u010f\2\14\5\0\3\14\1\0\1\14\4\0"+
    "\3\14\1\u0110\25\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\16\14\1\u0111\12\14\25\0\3\14\1\u0111"+
    "\1\14\5\0\3\14\1\0\1\14\4\0\1\u0112\30\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\4\14"+
    "\1\u0113\1\14\1\u0114\5\14\1\u0115\1\u0116\13\14\25\0"+
    "\4\14\1\u0114\5\0\3\14\1\0\1\14\4\0\11\14"+
    "\1\u0117\17\14\25\0\2\14\1\u0117\2\14\5\0\3\14"+
    "\1\0\1\14\4\0\6\14\1\u0118\22\14\25\0\4\14"+
    "\1\u0118\5\0\3\14\1\0\1\14\4\0\6\14\1\u0119"+
    "\22\14\25\0\4\14\1\u0119\5\0\3\14\1\0\1\14"+
    "\4\0\16\14\1\u011a\12\14\25\0\3\14\1\u011a\1\14"+
    "\5\0\3\14\1\0\1\14\4\0\16\14\1\u011b\12\14"+
    "\25\0\3\14\1\u011b\1\14\5\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\u011c\25\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\11\14\1\u011d\17\14\25\0\2\14"+
    "\1\u011d\2\14\5\0\3\14\1\0\1\u011e\4\0\16\14"+
    "\1\u011f\12\14\25\0\3\14\1\u011f\1\14\5\0\3\14"+
    "\1\0\1\u0120\4\0\3\14\1\u0121\25\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\21\14\1\u0122\7\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\11\14"+
    "\1\u0123\17\14\25\0\2\14\1\u0123\2\14\5\0\3\14"+
    "\1\0\1\14\4\0\4\14\1\u0124\24\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\6\14\1\u0125\22\14"+
    "\25\0\4\14\1\u0125\5\0\3\14\1\0\1\u0126\4\0"+
    "\10\14\1\u0127\20\14\25\0\5\14\43\0\1\u0128\57\0"+
    "\1\u0129\136\0\1\u012a\100\0\1\u012b\21\0\1\273\1\100"+
    "\1\u012c\76\273\6\0\1\277\35\0\2\277\37\0\3\14"+
    "\1\0\1\14\4\0\1\u012d\30\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\u012e\4\0\31\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\13\14\1\u012f\15\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\u0130\4\0\31\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\15\14\1\u0131"+
    "\13\14\25\0\5\14\5\0\3\14\1\0\1\u0132\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\6\14\1\u0133\22\14\25\0\4\14\1\u0133\2\0\1\311"+
    "\77\0\12\313\1\311\1\314\65\313\4\0\3\14\1\0"+
    "\1\14\4\0\3\14\1\u0134\25\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\4\14\1\u0135\24\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\1\14\1\u0136"+
    "\27\14\25\0\1\u0136\4\14\5\0\3\14\1\0\1\14"+
    "\4\0\7\14\1\u0137\21\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\10\14\1\u0138\20\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\1\u0139\30\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\3\14\1\u013a"+
    "\25\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\17\14\1\u013b\11\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\u013c\6\14\1\u013d\13\14\25\0"+
    "\4\14\1\u013c\5\0\3\14\1\0\1\14\4\0\10\14"+
    "\1\u013e\20\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\20\14\1\u013f\10\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\4\14\1\u0140\24\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\3\14\1\u0141\25\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\24\14"+
    "\1\u0142\4\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\11\14\1\u0143\17\14\25\0\2\14\1\u0143\2\14"+
    "\5\0\3\14\1\0\1\u0144\4\0\31\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\17\14\1\u0145\1\14"+
    "\1\u0146\7\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\11\14\1\u0147\17\14\25\0\2\14\1\u0147\2\14"+
    "\5\0\3\14\1\0\1\u0148\4\0\31\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\6\14\1\u0149\22\14"+
    "\25\0\4\14\1\u0149\5\0\3\14\1\0\1\14\4\0"+
    "\16\14\1\u014a\12\14\25\0\3\14\1\u014a\1\14\5\0"+
    "\3\14\1\0\1\u014b\4\0\31\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\11\14\1\u014c\17\14\25\0"+
    "\2\14\1\u014c\2\14\5\0\3\14\1\0\1\14\4\0"+
    "\15\14\1\u014d\13\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\1\u014e\30\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\u014f\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\11\14\1\u0150\17\14\25\0\2\14"+
    "\1\u0150\2\14\5\0\3\14\1\0\1\14\4\0\2\14"+
    "\1\u0151\26\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\u0152\25\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\u0153\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\10\14\1\u0154\5\14\1\u0155\12\14"+
    "\25\0\3\14\1\u0155\1\14\5\0\3\14\1\0\1\14"+
    "\4\0\1\u0156\30\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\23\14\1\227\5\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\14\14\1\u0157\14\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\u0158\4\0\31\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\5\14\1\u0159"+
    "\23\14\25\0\5\14\5\0\3\14\1\0\1\u015a\4\0"+
    "\3\14\1\u015b\25\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\1\u015c\30\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\3\14\1\u015d\1\u015e\24\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\6\14\1\u015f"+
    "\22\14\25\0\4\14\1\u015f\5\0\3\14\1\0\1\14"+
    "\4\0\5\14\1\u0160\23\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\4\14\1\u0161\24\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\1\14\1\u0162\13\14"+
    "\1\u0163\13\14\25\0\1\u0162\4\14\5\0\3\14\1\0"+
    "\1\14\4\0\15\14\1\u0164\13\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\u0165\4\0\31\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\u0166\4\0\31\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\2\14\1\u0167\26\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\22\14\1\u0163"+
    "\3\14\1\u0168\2\14\25\0\1\14\1\u0163\3\14\5\0"+
    "\3\14\1\0\1\14\4\0\14\14\1\u0169\2\14\1\u016a"+
    "\11\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\20\14\1\u016b\10\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\11\14\1\u016c\5\14\1\u016d\11\14\25\0"+
    "\2\14\1\u016c\2\14\5\0\3\14\1\0\1\u016e\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\4\14\1\u016f\24\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\2\14\1\u0170\3\14\1\u0171\10\14\1\u0172"+
    "\11\14\25\0\4\14\1\u0171\5\0\3\14\1\0\1\14"+
    "\4\0\1\14\1\u0136\1\u0173\26\14\25\0\1\u0136\4\14"+
    "\5\0\3\14\1\0\1\14\4\0\16\14\1\u0174\12\14"+
    "\25\0\3\14\1\u0174\1\14\5\0\3\14\1\0\1\14"+
    "\4\0\16\14\1\u0122\12\14\25\0\3\14\1\u0122\1\14"+
    "\5\0\3\14\1\0\1\14\4\0\1\u0175\30\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\5\14\1\u0176"+
    "\23\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\4\14\1\u0177\24\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\3\14\1\u0178\25\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\5\14\1\u0179\23\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\3\14\1\u017a"+
    "\25\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\31\14\11\0\1\u017b\13\0\5\14\5\0\3\14\1\0"+
    "\1\u017c\4\0\5\14\1\u017d\5\14\1\u017e\10\14\1\u017f"+
    "\4\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\1\u0180\30\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\15\14\1\u0181\13\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\4\14\1\u0182\24\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\2\14\1\u0183\26\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u0184\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\13\14"+
    "\1\u0185\15\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\7\14\1\u0186\21\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\7\14\1\u0187\21\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\23\14\1\u0188\5\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\11\14"+
    "\1\u0189\17\14\25\0\2\14\1\u0189\2\14\5\0\3\14"+
    "\1\0\1\14\4\0\4\14\1\u018a\24\14\25\0\5\14"+
    "\22\0\1\u018b\104\0\1\u018c\54\0\1\100\103\0\3\14"+
    "\1\0\1\14\4\0\14\14\1\u018d\14\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\u018e\4\0\31\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\7\14\1\u018f\21\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\5\14"+
    "\1\u0190\23\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\11\14\1\u0191\4\14\1\u0192\12\14\25\0\2\14"+
    "\1\u0191\1\u0192\1\14\5\0\3\14\1\0\1\14\4\0"+
    "\4\14\1\u0193\24\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\u0194\4\0\31\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\11\14\1\u0180\17\14\25\0\2\14\1\u0180"+
    "\2\14\5\0\3\14\1\0\1\14\4\0\13\14\1\u0195"+
    "\15\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\2\14\1\u0196\26\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\10\14\1\u0197\20\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\10\14\1\u0198\20\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\26\14\1\u0199"+
    "\2\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\11\14\1\u019a\17\14\25\0\2\14\1\u019a\2\14\5\0"+
    "\3\14\1\0\1\14\4\0\4\14\1\u019b\24\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\4\14\1\u019c"+
    "\24\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\4\14\1\u019d\24\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\5\14\1\u019e\23\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\16\14\1\u019f\12\14\25\0"+
    "\3\14\1\u019f\1\14\5\0\3\14\1\0\1\u01a0\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\15\14\1\u01a1\13\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\5\14\1\u01a2\23\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\4\14\1\u01a3\24\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\1\u01a4\30\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\20\14"+
    "\1\u01a5\10\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\u01a6\25\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\6\14\1\u01a7\22\14\25\0\4\14"+
    "\1\u01a7\5\0\3\14\1\0\1\14\4\0\2\14\1\u01a8"+
    "\26\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\24\14\1\u01a9\4\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\u01aa\11\14\1\u01ab\10\14\25\0"+
    "\4\14\1\u01aa\5\0\3\14\1\0\1\14\4\0\13\14"+
    "\1\u01ac\15\14\25\0\5\14\5\0\3\14\1\0\1\u01ad"+
    "\4\0\31\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\6\14\1\u01ae\1\14\1\u01af\20\14\25\0\4\14"+
    "\1\u01ae\5\0\3\14\1\0\1\14\4\0\4\14\1\u01b0"+
    "\24\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\16\14\1\u01b1\12\14\25\0\3\14\1\u01b1\1\14\5\0"+
    "\3\14\1\0\1\14\4\0\6\14\1\u01b2\22\14\25\0"+
    "\4\14\1\u01b2\5\0\3\14\1\0\1\14\4\0\16\14"+
    "\1\u01b3\12\14\25\0\3\14\1\u01b3\1\14\5\0\3\14"+
    "\1\0\1\14\4\0\16\14\1\u01b4\12\14\25\0\3\14"+
    "\1\u01b4\1\14\5\0\3\14\1\0\1\14\4\0\16\14"+
    "\1\u01b5\12\14\25\0\3\14\1\u01b5\1\14\5\0\3\14"+
    "\1\0\1\u01b6\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\16\14\1\u01b7\12\14\25\0\3\14"+
    "\1\u01b7\1\14\5\0\3\14\1\0\1\u01b8\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\23\14"+
    "\1\u01b9\5\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\12\14\1\u0163\16\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\10\14\1\u01ba\20\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\1\u01bb\30\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\1\u01bc\30\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\10\14"+
    "\1\u01bd\20\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\16\14\1\u01be\12\14\25\0\3\14\1\u01be\1\14"+
    "\5\0\3\14\1\0\1\14\4\0\6\14\1\u01bf\22\14"+
    "\25\0\4\14\1\u01bf\5\0\3\14\1\0\1\14\4\0"+
    "\1\u01c0\30\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\6\14\1\u01c1\22\14\25\0\4\14\1\u01c1\5\0"+
    "\3\14\1\0\1\14\4\0\10\14\1\u01c2\20\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\u01c3\4\0\31\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\u01c4\4\0\31\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\u01c5\4\0\31\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\6\14\1\u01c6"+
    "\22\14\25\0\4\14\1\u01c6\5\0\3\14\1\0\1\14"+
    "\4\0\16\14\1\u01c7\12\14\25\0\3\14\1\u01c7\1\14"+
    "\5\0\3\14\1\0\1\14\4\0\1\u01c8\30\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\16\14\1\u01c9"+
    "\12\14\25\0\3\14\1\u01c9\1\14\5\0\3\14\1\0"+
    "\1\14\4\0\11\14\1\u01ca\17\14\25\0\2\14\1\u01ca"+
    "\2\14\5\0\3\14\1\0\1\14\4\0\1\u01cb\30\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\14\14"+
    "\1\u01cc\14\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\20\14\1\u01cd\10\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\1\u01ce\30\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\6\14\1\322\22\14\25\0"+
    "\4\14\1\322\5\0\3\14\1\0\1\14\4\0\6\14"+
    "\1\u01cf\22\14\25\0\4\14\1\u01cf\5\0\3\14\1\0"+
    "\1\14\4\0\7\14\1\u01d0\21\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\6\14\1\u01d1\22\14\25\0"+
    "\4\14\1\u01d1\5\0\3\14\1\0\1\14\4\0\2\14"+
    "\1\u01d2\26\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\4\14\1\u01d3\24\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\17\14\1\u01d4\11\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\u01d5\4\0\31\14\25\0\5\14"+
    "\2\0\3\u01d6\26\0\1\u01d7\15\0\1\u01d8\31\0\3\u018c"+
    "\44\0\1\u01d9\34\0\3\14\1\0\1\u01da\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\16\14"+
    "\1\u01db\12\14\25\0\3\14\1\u01db\1\14\5\0\3\14"+
    "\1\0\1\14\4\0\6\14\1\u01dc\22\14\25\0\4\14"+
    "\1\u01dc\5\0\3\14\1\0\1\14\4\0\7\14\1\u01dd"+
    "\21\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\11\14\1\u01de\17\14\25\0\2\14\1\u01de\2\14\5\0"+
    "\3\14\1\0\1\14\4\0\5\14\1\u01df\23\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\1\u01e0\30\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u01e1\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\10\14"+
    "\1\u01e2\20\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\15\14\1\u01e3\13\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\15\14\1\u01e4\13\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\20\14\1\u0122\10\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u01e5\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\10\14"+
    "\1\u0138\11\14\1\u01e6\6\14\25\0\1\14\1\u01e6\3\14"+
    "\5\0\3\14\1\0\1\14\4\0\4\14\1\u01e7\24\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\4\14"+
    "\1\u01e8\24\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\24\14\1\u01e9\4\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\11\14\1\u01ea\17\14\25\0\2\14"+
    "\1\u01ea\2\14\5\0\3\14\1\0\1\u01eb\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\10\14"+
    "\1\u01ec\20\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\16\14\1\u01ed\12\14\25\0\3\14\1\u01ed\1\14"+
    "\5\0\3\14\1\0\1\14\4\0\14\14\1\u01ee\11\14"+
    "\1\u01ef\2\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\7\14\1\u01f0\21\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\u01f1\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\1\u01f2\21\14\1\u01f3\6\14\25\0"+
    "\1\14\1\u01f3\3\14\5\0\3\14\1\0\1\u01f4\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\1\u01f5\30\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\1\u01f6\30\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\13\14\1\u01f7\15\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\1\u01f8\30\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\6\14\1\u01f9\22\14"+
    "\25\0\4\14\1\u01f9\5\0\3\14\1\0\1\14\4\0"+
    "\1\u01fa\30\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\6\14\1\u01fb\22\14\25\0\4\14\1\u01fb\5\0"+
    "\3\14\1\0\1\14\4\0\22\14\1\u01fc\6\14\25\0"+
    "\1\14\1\u01fc\3\14\5\0\3\14\1\0\1\u01fd\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\6\14\1\u01fe\22\14\25\0\4\14\1\u01fe\5\0\3\14"+
    "\1\0\1\14\4\0\13\14\1\u01ff\15\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\2\14\1\u0200\26\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\16\14"+
    "\1\322\12\14\25\0\3\14\1\322\1\14\5\0\3\14"+
    "\1\0\1\u0201\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\11\14\1\u0202\17\14\25\0\2\14"+
    "\1\u0202\2\14\5\0\3\14\1\0\1\14\4\0\20\14"+
    "\1\u0203\10\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\16\14\1\u0204\12\14\25\0\3\14\1\u0204\1\14"+
    "\5\0\3\14\1\0\1\14\4\0\3\14\1\u0205\25\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\1\u0206"+
    "\30\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\6\14\1\u0207\22\14\25\0\4\14\1\u0207\5\0\3\14"+
    "\1\0\1\14\4\0\16\14\1\u0208\12\14\25\0\3\14"+
    "\1\u0208\1\14\5\0\3\14\1\0\1\14\4\0\11\14"+
    "\1\u0209\17\14\25\0\2\14\1\u0209\2\14\5\0\3\14"+
    "\1\0\1\14\4\0\16\14\1\u020a\12\14\25\0\3\14"+
    "\1\u020a\1\14\5\0\3\14\1\0\1\14\4\0\11\14"+
    "\1\u020b\17\14\25\0\2\14\1\u020b\2\14\5\0\3\14"+
    "\1\0\1\14\4\0\10\14\1\u020c\20\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\11\14\1\u020d\17\14"+
    "\25\0\2\14\1\u020d\2\14\5\0\3\14\1\0\1\14"+
    "\4\0\15\14\1\u020e\13\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\7\14\1\u020f\21\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\10\14\1\u0210\20\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\15\14"+
    "\1\u0211\13\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\7\14\1\u0212\21\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\16\14\1\u0213\12\14\25\0\3\14"+
    "\1\u0213\1\14\5\0\3\14\1\0\1\14\4\0\16\14"+
    "\1\u0214\12\14\25\0\3\14\1\u0214\1\14\5\0\3\14"+
    "\1\0\1\14\4\0\10\14\1\u0215\20\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\25\14\1\u0216\3\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u0217\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\27\14"+
    "\1\u0218\1\14\25\0\5\14\2\0\3\u01d6\44\0\1\u01d8"+
    "\50\0\1\u0219\64\0\3\14\1\0\1\14\4\0\1\u021a"+
    "\30\14\25\0\5\14\5\0\3\14\1\0\1\u021b\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\2\14\1\u021c\26\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\1\u021d\30\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\6\14\1\u021e\22\14\25\0\4\14"+
    "\1\u021e\5\0\3\14\1\0\1\14\4\0\11\14\1\322"+
    "\17\14\25\0\2\14\1\322\2\14\5\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\u021f\22\14\25\0\4\14\1\u021f"+
    "\5\0\3\14\1\0\1\u0220\4\0\31\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\16\14\1\u0221\12\14"+
    "\25\0\3\14\1\u0221\1\14\5\0\3\14\1\0\1\14"+
    "\4\0\4\14\1\236\24\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\4\14\1\u0222\24\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\10\14\1\u0223\20\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\6\14"+
    "\1\u0224\22\14\25\0\4\14\1\u0224\5\0\3\14\1\0"+
    "\1\14\4\0\14\14\1\u0225\14\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\12\14\1\u0226\16\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\15\14\1\u0227"+
    "\13\14\25\0\5\14\5\0\3\14\1\0\1\u0228\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\u0122\4\0"+
    "\31\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\15\14\1\u0229\13\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\u022a\4\0\31\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\u022b\22\14\25\0\4\14\1\u022b"+
    "\5\0\3\14\1\0\1\14\4\0\4\14\1\u0163\24\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u022c\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\1\14"+
    "\1\u022d\27\14\25\0\1\u022d\4\14\5\0\3\14\1\0"+
    "\1\u022e\4\0\31\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\12\14\1\u022f\16\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\1\u0230\30\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\11\14\1\u0231\17\14"+
    "\25\0\2\14\1\u0231\2\14\5\0\3\14\1\0\1\u0232"+
    "\4\0\31\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\u0233\25\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\2\14\1\u0234\26\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\20\14\1\u0235\10\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u0236\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u0237\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\5\14"+
    "\1\u0238\23\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\13\14\1\u0239\15\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\u023a\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\5\14\1\u023b\23\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\5\14\1\u023c\23\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\2\14"+
    "\1\u023d\26\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\6\14\1\u023e\22\14\25\0\4\14\1\u023e\5\0"+
    "\3\14\1\0\1\14\4\0\17\14\1\u023f\11\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\2\14\1\u0240"+
    "\5\14\1\u0241\20\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\u0242\4\0\31\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\u0243\22\14\25\0\4\14\1\u0243"+
    "\5\0\3\14\1\0\1\14\4\0\23\14\1\u0244\5\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\1\u0245"+
    "\30\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\3\14\1\u0246\25\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\7\14\1\u0247\21\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\3\14\1\u0248\25\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\4\14\1\u0249"+
    "\24\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\16\14\1\u024a\12\14\25\0\3\14\1\u024a\1\14\5\0"+
    "\3\14\1\0\1\14\4\0\30\14\1\u024b\25\0\5\14"+
    "\27\0\1\u024c\46\0\1\u024c\7\0\3\14\1\0\1\14"+
    "\4\0\6\14\1\u024d\22\14\25\0\4\14\1\u024d\5\0"+
    "\3\14\1\0\1\14\4\0\4\14\1\u024e\24\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\u024f\4\0\31\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\10\14\1\u0250"+
    "\20\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\3\14\1\u0251\25\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\1\u0252\30\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\2\14\1\u0253\26\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\6\14\1\u0254\22\14"+
    "\25\0\4\14\1\u0254\5\0\3\14\1\0\1\14\4\0"+
    "\1\14\1\u0255\27\14\25\0\1\u0255\4\14\5\0\3\14"+
    "\1\0\1\14\4\0\12\14\1\u0256\16\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\6\14\1\u0257\22\14"+
    "\25\0\4\14\1\u0257\5\0\3\14\1\0\1\14\4\0"+
    "\16\14\1\u0258\12\14\25\0\3\14\1\u0258\1\14\5\0"+
    "\3\14\1\0\1\u0259\4\0\31\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\11\14\1\u025a\17\14\25\0"+
    "\2\14\1\u025a\2\14\5\0\3\14\1\0\1\14\4\0"+
    "\4\14\1\u025b\24\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\13\14\1\u025c\15\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\15\14\1\u025d\13\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\6\14\1\u025e"+
    "\22\14\25\0\4\14\1\u025e\5\0\3\14\1\0\1\14"+
    "\4\0\11\14\1\u025f\17\14\25\0\2\14\1\u025f\2\14"+
    "\5\0\3\14\1\0\1\14\4\0\16\14\1\u0260\12\14"+
    "\25\0\3\14\1\u0260\1\14\5\0\3\14\1\0\1\14"+
    "\4\0\2\14\1\u0261\26\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\15\14\1\u0262\13\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\u0263\4\0\31\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\u0264\4\0\31\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\u0265\4\0\31\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\11\14\1\u0266\17\14"+
    "\25\0\2\14\1\u0266\2\14\5\0\3\14\1\0\1\14"+
    "\4\0\6\14\1\u0267\22\14\25\0\4\14\1\u0267\5\0"+
    "\3\14\1\0\1\14\4\0\5\14\1\u0268\23\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\11\14\1\u0269"+
    "\17\14\25\0\2\14\1\u0269\2\14\5\0\3\14\1\0"+
    "\1\14\4\0\15\14\1\u026a\13\14\25\0\5\14\25\0"+
    "\1\u026b\60\0\3\14\1\0\1\14\4\0\10\14\1\u026c"+
    "\20\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\6\14\1\u026d\22\14\25\0\4\14\1\u026d\5\0\3\14"+
    "\1\0\1\14\4\0\3\14\1\u026e\25\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\24\14\1\u026f\4\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\1\14"+
    "\1\u0270\27\14\25\0\1\u0270\4\14\5\0\3\14\1\0"+
    "\1\u0271\4\0\31\14\25\0\5\14\5\0\3\14\1\0"+
    "\1\14\4\0\10\14\1\u0272\20\14\25\0\5\14\5\0"+
    "\3\14\1\0\1\14\4\0\2\14\1\u0273\26\14\25\0"+
    "\5\14\5\0\3\14\1\0\1\14\4\0\10\14\1\u0274"+
    "\20\14\25\0\5\14\5\0\3\14\1\0\1\14\4\0"+
    "\6\14\1\u0275\22\14\25\0\4\14\1\u0275\5\0\3\14"+
    "\1\0\1\u0276\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\u0277\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\6\14\1\u0278\22\14\25\0\4\14"+
    "\1\u0278\5\0\3\14\1\0\1\14\4\0\6\14\1\u0279"+
    "\22\14\25\0\4\14\1\u0279\5\0\3\14\1\0\1\14"+
    "\4\0\20\14\1\u027a\10\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\u027b\4\0\31\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\14\14\1\u027c\14\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\3\14\1\u027d\25\14"+
    "\25\0\5\14\26\0\1\u027e\57\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\u027f\25\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\12\14\1\u0280\16\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\11\14\1\u0281\17\14"+
    "\25\0\2\14\1\u0281\2\14\5\0\3\14\1\0\1\14"+
    "\4\0\4\14\1\u0282\24\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\3\14\1\u0283\25\14\25\0\5\14"+
    "\5\0\3\14\1\0\1\14\4\0\3\14\1\u0284\25\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\2\14"+
    "\1\u0285\26\14\25\0\5\14\5\0\3\14\1\0\1\14"+
    "\4\0\3\14\1\u0286\25\14\25\0\5\14\5\0\3\14"+
    "\1\0\1\14\4\0\13\14\1\u0287\15\14\25\0\5\14"+
    "\24\0\1\u0288\53\0\1\u0288\5\0\3\14\1\0\1\14"+
    "\4\0\11\14\1\u0289\17\14\25\0\2\14\1\u0289\2\14"+
    "\5\0\3\14\1\0\1\14\4\0\14\14\1\u028a\14\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\u028b\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\11\14"+
    "\1\u028c\17\14\25\0\2\14\1\u028c\2\14\5\0\3\14"+
    "\1\0\1\14\4\0\11\14\1\u028d\17\14\25\0\2\14"+
    "\1\u028d\2\14\5\0\3\14\1\0\1\14\4\0\16\14"+
    "\1\u028e\12\14\25\0\3\14\1\u028e\1\14\5\0\3\14"+
    "\1\0\1\14\4\0\14\14\1\u028f\14\14\25\0\5\14"+
    "\26\0\1\u0290\57\0\3\14\1\0\1\u0291\4\0\31\14"+
    "\25\0\5\14\5\0\3\14\1\0\1\14\4\0\1\u0292"+
    "\30\14\25\0\5\14\21\0\1\u0293\64\0\3\14\1\0"+
    "\1\14\4\0\6\14\1\u0294\22\14\25\0\4\14\1\u0294"+
    "\27\0\1\u0295\46\0\1\u0295\4\0\3\u0295\44\0\1\u0296"+
    "\30\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[32305];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\1\0\1\1\2\0\2\1\2\0\1\11\34\1"+
    "\1\11\1\1\3\11\1\1\2\11\10\1\4\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\3\1\3\11\1\1"+
    "\1\11\6\1\4\11\4\1\1\0\5\1\1\11\2\1"+
    "\1\11\1\1\2\11\103\1\2\0\1\11\1\1\7\11"+
    "\1\1\10\11\1\1\3\11\1\1\1\0\10\1\1\11"+
    "\1\1\2\0\1\11\132\1\2\0\2\11\117\1\1\11"+
    "\17\1\2\0\111\1\2\0\2\11\77\1\1\0\62\1"+
    "\1\0\36\1\1\0\22\1\1\0\11\1\1\0\7\1"+
    "\1\0\2\1\1\0\1\1\1\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[662];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	protected StringBuffer string = new StringBuffer();
	protected int curOffset = 0;
	protected boolean isSQLCondition;
        
	public TerminalNode next() {
		try {
			int type = yylex();
			TerminalNode result;
			if(type == ErrorNodeTypes.STRING || type == ErrorNodeTypes.SQLSTMTLIT || type == ErrorNodeTypes.INLINE_DLI) {
				result = new TerminalNode(type, string.toString(), yyline, yycolumn, curOffset); 
				curOffset += string.length();
			}
			else {
				result =  new TerminalNode(type, yytext(), yyline, yycolumn, curOffset);
				curOffset += yylength();
			}
			return result;
		} catch (IOException e) {
			// Should never happen
			e.printStackTrace();
			return null;
		}
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ErrorLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ErrorLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1692) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 88: 
          { return ErrorNodeTypes.USE;
          }
        case 199: break;
        case 37: 
          { yybegin(SQL); string.append('\"');
          }
        case 200: break;
        case 44: 
          { yybegin(DLI); string.append('\"');
          }
        case 201: break;
        case 51: 
          { return ErrorNodeTypes.MINUSEQ;
          }
        case 202: break;
        case 8: 
          { return ErrorNodeTypes.DIV;
          }
        case 203: break;
        case 155: 
          { return ErrorNodeTypes.PASSING;
          }
        case 204: break;
        case 185: 
          { return ErrorNodeTypes.INTERFACE;
          }
        case 205: break;
        case 76: 
          { string.append("\"\"");
          }
        case 206: break;
        case 188: 
          { return ErrorNodeTypes.FORMGROUP;
          }
        case 207: break;
        case 5: 
          { return ErrorNodeTypes.INTEGER;
          }
        case 208: break;
        case 171: 
          { return ErrorNodeTypes.DELEGATE;
          }
        case 209: break;
        case 42: 
          { yybegin(DLI); string.append(yytext());
          }
        case 210: break;
        case 158: 
          { return ErrorNodeTypes.PROGRAM;
          }
        case 211: break;
        case 38: 
          { yybegin(SQL); string.append('\'');
          }
        case 212: break;
        case 43: 
          { yybegin(DLI); string.append('\'');
          }
        case 213: break;
        case 78: 
          { yybegin(YYINITIAL); string.append(yytext()); return ErrorNodeTypes.WS;
          }
        case 214: break;
        case 117: 
          { return ErrorNodeTypes.XOREQ;
          }
        case 215: break;
        case 151: 
          { return ErrorNodeTypes.ONEVENT;
          }
        case 216: break;
        case 170: 
          { return ErrorNodeTypes.TRANSFER;
          }
        case 217: break;
        case 59: 
          { return ErrorNodeTypes.NE;
          }
        case 218: break;
        case 14: 
          { return ErrorNodeTypes.RPAREN;
          }
        case 219: break;
        case 190: 
          { return ErrorNodeTypes.IMPLEMENTS;
          }
        case 220: break;
        case 137: 
          { return ErrorNodeTypes.ESCAPE;
          }
        case 221: break;
        case 25: 
          { return ErrorNodeTypes.MODULO;
          }
        case 222: break;
        case 65: 
          { return ErrorNodeTypes.LE;
          }
        case 223: break;
        case 6: 
          { return ErrorNodeTypes.DOT;
          }
        case 224: break;
        case 138: 
          { return ErrorNodeTypes.BYNAME;
          }
        case 225: break;
        case 7: 
          { return ErrorNodeTypes.PLUS;
          }
        case 226: break;
        case 156: 
          { return ErrorNodeTypes.PACKAGE;
          }
        case 227: break;
        case 92: 
          { return ErrorNodeTypes.NEW;
          }
        case 228: break;
        case 80: 
          { return ErrorNodeTypes.END;
          }
        case 229: break;
        case 164: 
          { return ErrorNodeTypes.FOREACH;
          }
        case 230: break;
        case 104: 
          { return ErrorNodeTypes.SHOW;
          }
        case 231: break;
        case 116: 
          { return ErrorNodeTypes.GOTO;
          }
        case 232: break;
        case 135: 
          { yybegin(SQL); isSQLCondition = false; string.setLength(0); string.append(yytext());
          }
        case 233: break;
        case 67: 
          { return ErrorNodeTypes.NULLCONCAT;
          }
        case 234: break;
        case 166: 
          { return ErrorNodeTypes.FREESQL;
          }
        case 235: break;
        case 172: 
          { return ErrorNodeTypes.DATAITEM;
          }
        case 236: break;
        case 33: 
          { yybegin(SQLDELIMITEDID); string.append('\"');
          }
        case 237: break;
        case 124: 
          { return ErrorNodeTypes.STACK;
          }
        case 238: break;
        case 103: 
          { return ErrorNodeTypes.BIND;
          }
        case 239: break;
        case 19: 
          { return ErrorNodeTypes.ASSIGN;
          }
        case 240: break;
        case 193: 
          { return ErrorNodeTypes.ONEXCEPTION;
          }
        case 241: break;
        case 74: 
          { string.append("\\r");
          }
        case 242: break;
        case 15: 
          { return ErrorNodeTypes.BANG;
          }
        case 243: break;
        case 147: 
          { return ErrorNodeTypes.RECORD;
          }
        case 244: break;
        case 161: 
          { return ErrorNodeTypes.RETURNS;
          }
        case 245: break;
        case 55: 
          { return ErrorNodeTypes.TO;
          }
        case 246: break;
        case 49: 
          { return ErrorNodeTypes.TIMESTIMES;
          }
        case 247: break;
        case 109: 
          { return ErrorNodeTypes.THIS;
          }
        case 248: break;
        case 154: 
          { return ErrorNodeTypes.MATCHES;
          }
        case 249: break;
        case 113: 
          { return ErrorNodeTypes.MOVE;
          }
        case 250: break;
        case 102: 
          { return ErrorNodeTypes.PRIMITIVE ;
          }
        case 251: break;
        case 134: 
          { return ErrorNodeTypes.WHILE;
          }
        case 252: break;
        case 157: 
          { return ErrorNodeTypes.PREPARE;
          }
        case 253: break;
        case 63: 
          { return ErrorNodeTypes.AND;
          }
        case 254: break;
        case 13: 
          { return ErrorNodeTypes.LPAREN;
          }
        case 255: break;
        case 93: 
          { return ErrorNodeTypes.NOT;
          }
        case 256: break;
        case 27: 
          { return ErrorNodeTypes.RBRACKET;
          }
        case 257: break;
        case 152: 
          { return ErrorNodeTypes.LIBRARY;
          }
        case 258: break;
        case 176: 
          { return ErrorNodeTypes.CONTINUE;
          }
        case 259: break;
        case 175: 
          { return ErrorNodeTypes.PREVIOUS;
          }
        case 260: break;
        case 123: 
          { return ErrorNodeTypes.EMBED;
          }
        case 261: break;
        case 169: 
          { return ErrorNodeTypes.USINGPCB;
          }
        case 262: break;
        case 50: 
          { return ErrorNodeTypes.TIMESEQ;
          }
        case 263: break;
        case 26: 
          { return ErrorNodeTypes.LBRACKET;
          }
        case 264: break;
        case 21: 
          { return ErrorNodeTypes.BITOR;
          }
        case 265: break;
        case 84: 
          { return ErrorNodeTypes.PRIMITIVE;
          }
        case 266: break;
        case 73: 
          { string.append("\\n");
          }
        case 267: break;
        case 83: 
          { return ErrorNodeTypes.ADD;
          }
        case 268: break;
        case 110: 
          { return ErrorNodeTypes.INTO;
          }
        case 269: break;
        case 186: 
          { return ErrorNodeTypes.RETURNING;
          }
        case 270: break;
        case 1: 
          { return ErrorNodeTypes.WS;
          }
        case 271: break;
        case 100: 
          { return ErrorNodeTypes.ELSE;
          }
        case 272: break;
        case 81: 
          { return ErrorNodeTypes.TIMESTIMESEQ;
          }
        case 273: break;
        case 129: 
          { return ErrorNodeTypes.PRINT;
          }
        case 274: break;
        case 194: 
          { return ErrorNodeTypes.TRANSACTION;
          }
        case 275: break;
        case 77: 
          { string.append("\'\'");
          }
        case 276: break;
        case 141: 
          { return ErrorNodeTypes.OPENUI;
          }
        case 277: break;
        case 30: 
          { yybegin(YYINITIAL); string.append(yytext()); return ErrorNodeTypes.ERRORSTRING;
          }
        case 278: break;
        case 97: 
          { return ErrorNodeTypes.CHARPRIMITIVE;
          }
        case 279: break;
        case 180: 
          { return ErrorNodeTypes.SINGLEROW;
          }
        case 280: break;
        case 130: 
          { return ErrorNodeTypes.CONST;
          }
        case 281: break;
        case 139: 
          { return ErrorNodeTypes.STATIC;
          }
        case 282: break;
        case 23: 
          { return ErrorNodeTypes.GT;
          }
        case 283: break;
        case 136: 
          { yybegin(DLI); string.setLength(0); string.append(yytext());
          }
        case 284: break;
        case 87: 
          { return ErrorNodeTypes.OUT;
          }
        case 285: break;
        case 127: 
          { return ErrorNodeTypes.THROW;
          }
        case 286: break;
        case 128: 
          { return ErrorNodeTypes.INOUT;
          }
        case 287: break;
        case 46: 
          { return ErrorNodeTypes.PLUSEQ;
          }
        case 288: break;
        case 3: 
          { return ErrorNodeTypes.error;
          }
        case 289: break;
        case 126: 
          { return ErrorNodeTypes.USING;
          }
        case 290: break;
        case 86: 
          { return ErrorNodeTypes.SET;
          }
        case 291: break;
        case 48: 
          { return ErrorNodeTypes.DIVEQ;
          }
        case 292: break;
        case 108: 
          { return ErrorNodeTypes.TYPE;
          }
        case 293: break;
        case 9: 
          { return ErrorNodeTypes.TIMES;
          }
        case 294: break;
        case 150: 
          { return ErrorNodeTypes.SERVICE;
          }
        case 295: break;
        case 29: 
          { return ErrorNodeTypes.AT;
          }
        case 296: break;
        case 70: 
          { string.append("\\\\");
          }
        case 297: break;
        case 18: 
          { return ErrorNodeTypes.COLON;
          }
        case 298: break;
        case 56: 
          { return ErrorNodeTypes.IS;
          }
        case 299: break;
        case 198: 
          { yybegin(SQL); isSQLCondition = true; string.setLength(0); string.append(yytext());
          }
        case 300: break;
        case 187: 
          { return ErrorNodeTypes.FORUPDATE;
          }
        case 301: break;
        case 32: 
          { string.append("\\");
          }
        case 302: break;
        case 196: 
          { return ErrorNodeTypes.EXTERNALTYPE;
          }
        case 303: break;
        case 54: 
          { return ErrorNodeTypes.OR;
          }
        case 304: break;
        case 168: 
          { return ErrorNodeTypes.ABSOLUTE;
          }
        case 305: break;
        case 2: 
          { string.append(yytext());
          }
        case 306: break;
        case 115: 
          { return ErrorNodeTypes.CALL;
          }
        case 307: break;
        case 58: 
          { return ErrorNodeTypes.IF;
          }
        case 308: break;
        case 114: 
          { return ErrorNodeTypes.CASE;
          }
        case 309: break;
        case 145: 
          { return ErrorNodeTypes.IMPORT;
          }
        case 310: break;
        case 111: 
          { return ErrorNodeTypes.NEXT;
          }
        case 311: break;
        case 149: 
          { return ErrorNodeTypes.EXTENDS;
          }
        case 312: break;
        case 52: 
          { return ErrorNodeTypes.AS;
          }
        case 313: break;
        case 159: 
          { return ErrorNodeTypes.PRIVATE;
          }
        case 314: break;
        case 53: 
          { return ErrorNodeTypes.BY;
          }
        case 315: break;
        case 45: 
          { return ErrorNodeTypes.DECIMALLIT;
          }
        case 316: break;
        case 39: 
          { yybegin(DLI_DBL_QUOTED_ID); string.append('\"');
          }
        case 317: break;
        case 142: 
          { return ErrorNodeTypes.UPDATE;
          }
        case 318: break;
        case 118: 
          { return ErrorNodeTypes.FORM;
          }
        case 319: break;
        case 95: 
          { return ErrorNodeTypes.XOR;
          }
        case 320: break;
        case 72: 
          { string.append("\\f");
          }
        case 321: break;
        case 68: 
          { return ErrorNodeTypes.MODULOEQ;
          }
        case 322: break;
        case 28: 
          { return ErrorNodeTypes.RCURLY;
          }
        case 323: break;
        case 82: 
          { return ErrorNodeTypes.ALL;
          }
        case 324: break;
        case 17: 
          { return ErrorNodeTypes.SEMI;
          }
        case 325: break;
        case 90: 
          { return ErrorNodeTypes.TRY;
          }
        case 326: break;
        case 75: 
          { string.append("\\t");
          }
        case 327: break;
        case 182: 
          { return ErrorNodeTypes.USINGKEYS;
          }
        case 328: break;
        case 66: 
          { return ErrorNodeTypes.GE;
          }
        case 329: break;
        case 178: 
          { return ErrorNodeTypes.RELATIVE;
          }
        case 330: break;
        case 47: 
          { yybegin(BLOCKCOMMENT); string.setLength(0); string.append(yytext());
          }
        case 331: break;
        case 40: 
          { yybegin(YYINITIAL); string.append(yytext()); return ErrorNodeTypes.INLINE_DLI;
          }
        case 332: break;
        case 131: 
          { return ErrorNodeTypes.CLOSE;
          }
        case 333: break;
        case 191: 
          { return ErrorNodeTypes.ENUMERATION;
          }
        case 334: break;
        case 91: 
          { return ErrorNodeTypes.ISA;
          }
        case 335: break;
        case 61: 
          { return ErrorNodeTypes.EQ;
          }
        case 336: break;
        case 96: 
          { return ErrorNodeTypes.FOR;
          }
        case 337: break;
        case 4: 
          { return ErrorNodeTypes.ID;
          }
        case 338: break;
        case 98: 
          { return ErrorNodeTypes.CONCATEQ;
          }
        case 339: break;
        case 181: 
          { return ErrorNodeTypes.OTHERWISE;
          }
        case 340: break;
        case 64: 
          { return ErrorNodeTypes.BITOREQ;
          }
        case 341: break;
        case 160: 
          { return ErrorNodeTypes.CURRENT;
          }
        case 342: break;
        case 133: 
          { return ErrorNodeTypes.FIRST;
          }
        case 343: break;
        case 165: 
          { return ErrorNodeTypes.FORWARD;
          }
        case 344: break;
        case 71: 
          { string.append("\\b");
          }
        case 345: break;
        case 143: 
          { return ErrorNodeTypes.DELETE;
          }
        case 346: break;
        case 10: 
          { return ErrorNodeTypes.MINUS;
          }
        case 347: break;
        case 195: 
          { return ErrorNodeTypes.CONSTRUCTOR;
          }
        case 348: break;
        case 62: 
          { return ErrorNodeTypes.BITANDEQ;
          }
        case 349: break;
        case 41: 
          { yybegin(DLI_QUOTED_ID); string.append('\'');
          }
        case 350: break;
        case 162: 
          { return ErrorNodeTypes.REPLACE;
          }
        case 351: break;
        case 119: 
          { return ErrorNodeTypes.FROM;
          }
        case 352: break;
        case 112: 
          { return ErrorNodeTypes.NULL;
          }
        case 353: break;
        case 24: 
          { return ErrorNodeTypes.QUESTION;
          }
        case 354: break;
        case 192: 
          { return ErrorNodeTypes.SQLNULLABLE;
          }
        case 355: break;
        case 60: 
          { return ErrorNodeTypes.CONCAT;
          }
        case 356: break;
        case 16: 
          { return ErrorNodeTypes.COMMA;
          }
        case 357: break;
        case 132: 
          { return ErrorNodeTypes.FIELD;
          }
        case 358: break;
        case 197: 
          { return ErrorNodeTypes.WITHV60COMPAT;
          }
        case 359: break;
        case 144: 
          { return ErrorNodeTypes.INSERT;
          }
        case 360: break;
        case 106: 
          { return ErrorNodeTypes.LAST;
          }
        case 361: break;
        case 12: 
          { return ErrorNodeTypes.LCURLY;
          }
        case 362: break;
        case 105: 
          { return ErrorNodeTypes.OPEN;
          }
        case 363: break;
        case 120: 
          { return ErrorNodeTypes.HOLD;
          }
        case 364: break;
        case 107: 
          { return ErrorNodeTypes.LIKE;
          }
        case 365: break;
        case 31: 
          { yybegin(YYINITIAL); string.append('\"'); return ErrorNodeTypes.STRING;
          }
        case 366: break;
        case 177: 
          { return ErrorNodeTypes.CONVERSE;
          }
        case 367: break;
        case 122: 
          { return ErrorNodeTypes.WHEN;
          }
        case 368: break;
        case 35: 
          { yybegin(SQLSTRING); string.append('\'');
          }
        case 369: break;
        case 148: 
          { return ErrorNodeTypes.EXECUTE;
          }
        case 370: break;
        case 79: 
          { return ErrorNodeTypes.FLOATLIT;
          }
        case 371: break;
        case 167: 
          { return ErrorNodeTypes.HANDLER;
          }
        case 372: break;
        case 153: 
          { return ErrorNodeTypes.DISPLAY;
          }
        case 373: break;
        case 101: 
          { return ErrorNodeTypes.EXIT;
          }
        case 374: break;
        case 94: 
          { return ErrorNodeTypes.GET;
          }
        case 375: break;
        case 179: 
          { return ErrorNodeTypes.FUNCTION;
          }
        case 376: break;
        case 20: 
          { return ErrorNodeTypes.BITAND;
          }
        case 377: break;
        case 125: 
          { return ErrorNodeTypes.LABEL;
          }
        case 378: break;
        case 163: 
          { return ErrorNodeTypes.RUNUNIT;
          }
        case 379: break;
        case 99: 
          { return ErrorNodeTypes.NULLCONCATEQ;
          }
        case 380: break;
        case 85: 
          { return ErrorNodeTypes.NUMERICPRIMITIVE;
          }
        case 381: break;
        case 22: 
          { return ErrorNodeTypes.LT;
          }
        case 382: break;
        case 11: 
          { yybegin(STRING); string.setLength(0); string.append('\"');
          }
        case 383: break;
        case 121: 
          { return ErrorNodeTypes.WITH;
          }
        case 384: break;
        case 140: 
          { return ErrorNodeTypes.SCROLL;
          }
        case 385: break;
        case 57: 
          { return ErrorNodeTypes.IN;
          }
        case 386: break;
        case 89: 
          { return ErrorNodeTypes.URL;
          }
        case 387: break;
        case 146: 
          { return ErrorNodeTypes.RETURN;
          }
        case 388: break;
        case 184: 
          { return ErrorNodeTypes.DATATABLE;
          }
        case 389: break;
        case 189: 
          { return ErrorNodeTypes.BYPOSITION;
          }
        case 390: break;
        case 69: 
          { string.append("\\\"");
          }
        case 391: break;
        case 36: 
          { yybegin(SQL); string.append(yytext());
          }
        case 392: break;
        case 173: 
          { return ErrorNodeTypes.INPARENT;
          }
        case 393: break;
        case 34: 
          { yybegin(YYINITIAL); string.append(yytext()); return isSQLCondition ? ErrorNodeTypes.SQLCONDITION : ErrorNodeTypes.SQLSTMTLIT;
          }
        case 394: break;
        case 174: 
          { return ErrorNodeTypes.NOCURSOR;
          }
        case 395: break;
        case 183: 
          { return ErrorNodeTypes.DECREMENT;
          }
        case 396: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              { 	if(yystate() == SQL || yystate() == SQLDELIMITEDID || yystate() == SQLSTRING) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERRORSQLSTMTLIT;
	}
	else if(yystate() == STRING) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERRORSTRING;
	}
	else if(yystate() == BLOCKCOMMENT) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERRORBLOCKCOMMENT;
	}
	else if(yystate() == DLI || yystate() == DLI_QUOTED_ID || yystate() == DLI_DBL_QUOTED_ID) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERROR_INLINE_DLI;
	}
	else {
		return ErrorNodeTypes.EOF;
	}
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
