/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.ide.ui.internal.ResourceAdapterFactory;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.ProblemMarkerManager;
import org.eclipse.edt.ide.ui.internal.editor.folding.FoldingStructureProviderRegistry;
import org.eclipse.edt.ide.ui.internal.templates.CoreContextType;
import org.eclipse.edt.ide.ui.internal.templates.EGLTemplateStore;
import org.eclipse.edt.ide.ui.internal.templates.RUIContextType;
import org.eclipse.edt.ide.ui.internal.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class EDTUIPlugin
extends AbstractUIPlugin {
    private static final String TEMPLATES_KEY = "org.eclipse.edt.ide.ui.text.custom_templates";
    public static final String PLUGIN_ID = "org.eclipse.edt.ide.ui";
    public static final String EGL_EDITOR_ID = "org.eclipse.edt.ide.ui.EGLEditor";
    public static final int INTERNAL_ERROR = 10001;
    public static final int TARGET_RUNTIME_JAVA_MASK = 1;
    public static final int TARGET_RUNTIME_JAVASCRIPT_MASK = 2;
    public static final int TARGET_RUNTIME_COBOL_MASK = 4;
    private static EDTUIPlugin plugin;
    public static final String CLASS = "class";
    private ProblemMarkerManager fProblemMarkerManager;
    private DocumentProvider fEGLDocumentProvider;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private FoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private EGLTemplateStore fDefaultTemplateStore;
    private TemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;
    private IPropertyChangeListener propertyChangeListener;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private FormColors formColors;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerAdapters();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.unregisterAdapters();
    }

    private void registerAdapters() {
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, IResource.class);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
    }

    public static EDTUIPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public Logger getLogger() {
        Logger logger = null;
        try {
            LogManager.getLogManager().readConfiguration();
            logger = Logger.getLogger(PLUGIN_ID);
            logger.setLevel(Level.ALL);
        }
        catch (Throwable t) {
            System.out.println("ERROR - EGL UI Plugin - getting logger unsuccessfully!");
            System.out.println("REASON: " + t.getMessage());
        }
        return logger;
    }

    public static void log(IStatus status) {
        EDTUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        EDTUIPlugin.log((IStatus)new Status(4, EDTUIPlugin.getPluginId(), 10001, "EDTUIPlugin.internal_error", e));
    }

    public static void logErrorMessage(String message) {
        EDTUIPlugin.log((IStatus)new Status(4, EDTUIPlugin.getPluginId(), 10001, message, null));
    }

    public synchronized DocumentProvider getEGLDocumentProvider() {
        if (this.fEGLDocumentProvider == null) {
            this.fEGLDocumentProvider = new DocumentProvider();
        }
        return this.fEGLDocumentProvider;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return EDTUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public static IWorkbenchPage getActivePage() {
        return EDTUIPlugin.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return EDTUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return EDTUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = EDTUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public synchronized FoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new FoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType((TemplateContextType)new CoreContextType());
            this.fContextTypeRegistry.addContextType((TemplateContextType)new RUIContextType());
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new EGLTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY);
            this.fDefaultTemplateStore = new EGLTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY);
            try {
                this.fTemplateStore.load();
                this.fDefaultTemplateStore.load();
            }
            catch (IOException e) {
                EDTUIPlugin.log(e);
            }
            if (this.propertyChangeListener != null) {
                this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            }
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals(EDTUIPlugin.TEMPLATES_KEY)) {
                        try {
                            EDTUIPlugin.this.fTemplateStore.load();
                            EDTUIPlugin.this.fDefaultTemplateStore.load();
                        }
                        catch (IOException e) {
                            EDTUIPlugin.log(e);
                        }
                    }
                }
            };
            this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
        return this.fTemplateStore;
    }

    public TemplateStore getDefaultTemplateStore() {
        return this.fDefaultTemplateStore;
    }

    public IEclipsePreferences getUIPluginPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public void saveUIPluginPreferences() {
        IEclipsePreferences prefs = this.getUIPluginPreferences();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            EDTUIPlugin.log(e);
        }
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }
}

