/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui;

import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class EDTUIPreferenceConstants {
    public static final String CODEASSIST_AUTOACTIVATION = "content_assist_autoactivation";
    public static final String EDITOR_BACKGROUND_COLOR = "AbstractTextEditor.Color.Background";
    public static final String EDITOR_BACKGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.Background.SystemDefault";
    public static final String EDITOR_BOLD_SUFFIX = "_bold";
    public static final String EDITOR_DEFAULT_BOLD = "egl_default_bold";
    public static final String EDITOR_DEFAULT_COLOR = "egl_default";
    public static final String EDITOR_ERROR_INDICATION = "errorIndication";
    public static final String EDITOR_ERROR_INDICATION_IN_OVERVIEW_RULER = "errorIndicationInOverviewRuler";
    public static final String EDITOR_FOLDING_COMMENTS = "editor_folding_comments";
    public static final String EDITOR_FOLDING_ENABLED = "editor_folding_enabled";
    public static final String EDITOR_FOLDING_FUNCTIONS = "editor_folding_functions";
    public static final String EDITOR_FOLDING_IMPORTS = "editor_folding_imports";
    public static final String EDITOR_FOLDING_PARTITIONS = "editor_folding_partitions";
    public static final String EDITOR_FOLDING_PARTS = "editor_folding_parts";
    public static final String EDITOR_FOLDING_PROPERTIESBLOCKS = "editor_folding_propertiesblocks";
    public static final String EDITOR_FOLDING_PROPERTIESBLOCKS_THRESHOLD = "editor_folding_propertiesblocks_threshold";
    public static final String EDITOR_FOLDING_PROVIDER = "editor_folding_provider";
    public static final String EDITOR_FOREGROUND_COLOR = "AbstractTextEditor.Color.Foreground";
    public static final String EDITOR_FOREGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.Foreground.SystemDefault";
    public static final String EDITOR_HANDLE_DYNAMIC_PROBLEMS = "handleDynamicProblems";
    public static final String EDITOR_KEYWORD_BOLD = "egl_keyword_bold";
    public static final String EDITOR_KEYWORD_COLOR = "egl_keyword";
    public static final String EDITOR_MULTI_LINE_COMMENT_BOLD = "egl_multi_line_comment_bold";
    public static final String EDITOR_MULTI_LINE_COMMENT_COLOR = "egl_multi_line_comment";
    public static final String EDITOR_SHOW_SEGMENTS = "org.eclipse.jdt.ui.editor.showSegments";
    public static final String EDITOR_SINGLE_LINE_COMMENT_BOLD = "egl_single_line_comment_bold";
    public static final String EDITOR_SINGLE_LINE_COMMENT_COLOR = "egl_single_line_comment";
    public static final String EDITOR_STRING_BOLD = "egl_string_bold";
    public static final String EDITOR_STRING_COLOR = "egl_string";
    public static final String EDITOR_TAB_WIDTH = "org.eclipse.jdt.ui.editor.tab.width";
    public static final String EDITOR_TEXT_FONT = "org.eclipse.edt.ide.ui.editors.textfont";
    public static final String ORGIMPORTS_IMPORTORDER = "org.eclipse.egl.ui.importorder";
    public static final String ORGIMPORTS_ONDEMANDTHRESHOLD = "org.eclipse.egl.ui.ondemandthreshold";

    private EDTUIPreferenceConstants() {
    }

    public static void initializeDefaultValues(IPreferenceStore store) {
        store.setDefault(CODEASSIST_AUTOACTIVATION, true);
        store.setDefault(EDITOR_ERROR_INDICATION, true);
        store.setDefault(EDITOR_ERROR_INDICATION_IN_OVERVIEW_RULER, true);
        store.setDefault(EDITOR_HANDLE_DYNAMIC_PROBLEMS, true);
        store.setDefault(EDITOR_FOLDING_COMMENTS, false);
        store.setDefault(EDITOR_FOLDING_ENABLED, true);
        store.setDefault(EDITOR_FOLDING_FUNCTIONS, false);
        store.setDefault(EDITOR_FOLDING_IMPORTS, true);
        store.setDefault(EDITOR_FOLDING_PARTITIONS, true);
        store.setDefault(EDITOR_FOLDING_PARTS, false);
        store.setDefault(EDITOR_FOLDING_PROPERTIESBLOCKS, false);
        store.setDefault(EDITOR_FOLDING_PROPERTIESBLOCKS_THRESHOLD, 5);
        store.setDefault(EDITOR_FOLDING_PROVIDER, "org.eclipse.edt.ide.ui.internal.editor.folding.eglFoldingStructureProviders");
        store.setDefault(ORGIMPORTS_IMPORTORDER, "org;edt");
        store.setDefault(ORGIMPORTS_ONDEMANDTHRESHOLD, 99);
        EDTUIPreferenceConstants.initializeDefaultEGLColorPreferences(store);
    }

    public static void initializeDefaultEGLColorPreferences(IPreferenceStore store) {
        store.setDefault(EDITOR_FOREGROUND_DEFAULT_COLOR, true);
        store.setDefault(EDITOR_BACKGROUND_DEFAULT_COLOR, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_MULTI_LINE_COMMENT_COLOR, (RGB)new RGB(63, 127, 95));
        store.setDefault(EDITOR_MULTI_LINE_COMMENT_BOLD, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_SINGLE_LINE_COMMENT_COLOR, (RGB)new RGB(63, 127, 95));
        store.setDefault(EDITOR_SINGLE_LINE_COMMENT_BOLD, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_KEYWORD_COLOR, (RGB)new RGB(127, 0, 85));
        store.setDefault(EDITOR_KEYWORD_BOLD, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_STRING_COLOR, (RGB)new RGB(42, 0, 255));
        store.setDefault(EDITOR_STRING_BOLD, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_DEFAULT_COLOR, (RGB)new RGB(0, 0, 0));
        store.setDefault(EDITOR_DEFAULT_BOLD, false);
    }

    public static IPreferenceStore getPreferenceStore() {
        return EDTUIPlugin.getDefault().getPreferenceStore();
    }

    public static String getPreference(String key, IJavaProject project) {
        String val;
        if (project != null && (val = new ProjectScope(project.getProject()).getNode("org.eclipse.edt.ide.ui").get(key, null)) != null) {
            return val;
        }
        val = new InstanceScope().getNode("org.eclipse.edt.ide.ui").get(key, null);
        if (val != null) {
            return val;
        }
        return new DefaultScope().getNode("org.eclipse.edt.ide.ui").get(key, null);
    }
}

