/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExternalTypeDataBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.internal.search.matching.MatchLocator2;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.actions.SelectionDispatchAction;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.util.BoundNodeModelUtility;
import org.eclipse.edt.ide.ui.internal.editor.util.IBoundNodeRequestor;
import org.eclipse.edt.ide.ui.internal.refactoring.RefactoringExecutionStarter;
import org.eclipse.edt.ide.ui.internal.util.FileProvidingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;

public class RenameAction
extends SelectionDispatchAction {
    private org.eclipse.edt.ide.ui.internal.packageexplorer.RenameAction oldAction = new org.eclipse.edt.ide.ui.internal.packageexplorer.RenameAction();
    private EGLEditor fEditor;
    private FileProvidingView fileView;

    public RenameAction(IWorkbenchSite site, FileProvidingView fileView) {
        super(site);
        this.fileView = fileView;
        this.setText(UINlsStrings.Rename);
    }

    public RenameAction(IWorkbenchSite site) {
        this(site, (FileProvidingView)null);
    }

    public RenameAction(EGLEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        if (selection.size() == 1) {
            this.oldAction.selectionChanged(selection);
            this.setEnabled(this.canRun(selection) || this.oldAction.isEnabled());
            return;
        }
        this.setEnabled(false);
    }

    private static Node getNode(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof Node) {
            return (Node)first;
        }
        return null;
    }

    private static IEGLFile getEGLFile(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IEGLFile)) {
            return null;
        }
        return (IEGLFile)first;
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        Node node = RenameAction.getNode(selection);
        if (node == null) {
            IEGLFile eglFile = RenameAction.getEGLFile(selection);
            if (eglFile == null) {
                this.oldAction.selectionChanged(selection);
                if (this.oldAction.isEnabled()) {
                    this.oldAction.run();
                }
                return;
            }
            try {
                this.run(eglFile);
            }
            catch (CoreException e) {
                EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage, e);
            }
        } else {
            try {
                if (node instanceof Part) {
                    this.run(((Part)node).getName().getCanonicalName(), this.getFile());
                } else if (node instanceof NestedFunction) {
                    NestedFunction nestedFunction = (NestedFunction)node;
                    this.run(nestedFunction, this.getFile());
                }
            }
            catch (CoreException e) {
                EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage, e);
            }
        }
    }

    private IFile getFile() {
        if (this.fileView != null) {
            return this.fileView.getFile();
        }
        return null;
    }

    public boolean willLaunchOldDialog(IStructuredSelection selection) {
        return RenameAction.getEGLFile(selection) == null;
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            PartNameAndFile nodeAndFile = this.getNodeAndFile();
            if (nodeAndFile != null) {
                if (nodeAndFile.nestedFunction == null) {
                    this.run(nodeAndFile.partName, nodeAndFile.file);
                } else {
                    this.run(nodeAndFile.nestedFunction, nodeAndFile.file);
                }
                return;
            }
        }
        catch (CoreException e) {
            EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage, e);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)UINlsStrings.RenameSupport_dialog_title, (String)UINlsStrings.RenameSupport_not_available);
    }

    public boolean canRun() {
        try {
            PartNameAndFile nodeAndFile = this.getNodeAndFile();
            return nodeAndFile != null;
        }
        catch (EGLModelException e) {
            EDTUIPlugin.log(e);
            return false;
        }
    }

    public boolean canRun(IStructuredSelection selection) {
        try {
            Node node = RenameAction.getNode(selection);
            if (node != null) {
                return RenameAction.isRenameAvailable(node);
            }
            return selection.size() == 1 && selection.getFirstElement() instanceof IEGLFile;
        }
        catch (EGLModelException e) {
            EDTUIPlugin.log(e);
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
        }
        return false;
    }

    private PartNameAndFile getNodeAndFile() throws EGLModelException {
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        int currentPosition = ((ITextSelection)selection).getOffset();
        IEGLDocument document = (IEGLDocument)this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        IFile file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
        Node node = document.getNewModelNodeAtOffset(currentPosition);
        if (node instanceof Name) {
            Node parent = node.getParent();
            if (parent instanceof Part && !(parent instanceof TopLevelFunction) && ((Part)parent).getName() == node) {
                return new PartNameAndFile(((Part)parent).getName().getCanonicalName(), file);
            }
            if (parent instanceof NestedFunction) {
                return null;
            }
            final PartNameAndFile[] partNameAndFile = new PartNameAndFile[1];
            BoundNodeModelUtility.getBoundNodeAtOffset(file, currentPosition, new IBoundNodeRequestor(){

                @Override
                public void acceptNode(Node boundPart, Node selectedNode) {
                    selectedNode.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                        public boolean visitName(Name name) {
                            partNameAndFile[0] = this.getPartNameAndFile(name.resolveBinding());
                            return false;
                        }

                        private IPartBinding getPartBinding(IBinding binding) {
                            IPartBinding result = null;
                            if (Binding.isValidBinding((IBinding)binding)) {
                                if (binding.isTypeBinding() && !binding.isFunctionBinding()) {
                                    if (((ITypeBinding)binding).isPartBinding()) {
                                        result = (IPartBinding)binding;
                                    }
                                } else if (binding.isDataBinding()) {
                                    switch (((IDataBinding)binding).getKind()) {
                                        case 26: {
                                            result = (IPartBinding)((ExternalTypeDataBinding)binding).getType();
                                        }
                                    }
                                }
                            }
                            return result;
                        }

                        private PartNameAndFile getPartNameAndFile(IBinding binding) {
                            IEnvironment env;
                            IPartBinding partBinding = this.getPartBinding(binding);
                            if (partBinding != null && (env = partBinding.getEnvironment()) instanceof WorkingCopyProjectEnvironment) {
                                WorkingCopyProjectEnvironment environment = (WorkingCopyProjectEnvironment)env;
                                IPartOrigin origin = environment.getPartOrigin(partBinding.getPackageName(), partBinding.getName());
                                IFile declaringFile = origin.getEGLFile();
                                return new PartNameAndFile(partBinding.getCaseSensitiveName(), declaringFile);
                            }
                            return null;
                        }
                    });
                }
            });
            return partNameAndFile[0];
        }
        return null;
    }

    private void run(String partName, IFile file) throws CoreException {
        IEGLFile eglFile = EGLCore.createEGLFileFrom((IFile)file);
        if (eglFile != null) {
            IPart part = eglFile.getPart(partName);
            RefactoringExecutionStarter.startRenameRefactoring(part, this.getShell());
        }
    }

    private void run(NestedFunction nestedFunction, IFile file) throws CoreException {
        IEGLFile eglFile = EGLCore.createEGLFileFrom((IFile)file);
        if (eglFile != null) {
            IPart part = eglFile.getPart(((Part)nestedFunction.getParent()).getName().getCanonicalName());
            part = new MatchLocator2(null, false, false, 0, null, null, null).createFunctionHandle(nestedFunction, part);
            RefactoringExecutionStarter.startRenameRefactoring(part, this.getShell());
        }
    }

    private void run(IEGLFile eglFile) throws CoreException {
        RefactoringExecutionStarter.startRenameRefactoring(eglFile, this.getShell());
    }

    private static boolean isRenameAvailable(Node node) throws CoreException {
        if (node instanceof TopLevelFunction || node instanceof NestedFunction) {
            return false;
        }
        return node instanceof Part || node instanceof NestedFunction;
    }

    private class PartNameAndFile {
        String partName;
        IFile file;
        NestedFunction nestedFunction;

        public PartNameAndFile(String partName, IFile file) {
            this.partName = partName;
            this.file = file;
        }

        public PartNameAndFile(NestedFunction function, IFile file) {
            this.nestedFunction = function;
            this.file = file;
        }
    }
}

