/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.NodeNameUtility;
import org.eclipse.edt.compiler.internal.core.builder.Problem;

public class AccumulatingSyntaxProblemRequestor
implements ISyntaxErrorRequestor {
    private List problems;
    private String fileContents;

    public AccumulatingSyntaxProblemRequestor(String fileContents) {
        this.fileContents = fileContents;
        this.problems = new ArrayList();
    }

    public List getProblems() {
        return this.problems;
    }

    public void incorrectNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2101, this.getNonTerminalInserts(nonTerminalType)));
    }

    public void incorrectPhrase(int nonTerminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2112, this.getNonTerminalInserts(nonTerminalType)));
    }

    public void incorrectPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2103, this.getNonTerminalInserts(nonTerminalType)));
    }

    public void incorrectPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2108, this.getTerminalInserts(terminalType)));
    }

    public void incorrectTerminal(int terminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2105, this.getTerminalInserts(terminalType)));
    }

    public void missingNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2100, this.getNonTerminalInserts(nonTerminalType)));
    }

    public void missingPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2102, this.getNonTerminalInserts(nonTerminalType)));
    }

    public void missingPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2107, this.getTerminalInserts(terminalType)));
    }

    public void missingScopeCloser(int terminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2110, this.getTerminalInserts(terminalType)));
    }

    public void missingTerminal(int terminalType, int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2104, this.getTerminalInserts(terminalType)));
    }

    public void panicPhrase(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2113, new String[0]));
    }

    public void tooManyErrors() {
        this.problems.add(new Problem(0, 0, 2, 2114, new String[0]));
    }

    public void unexpectedPhrase(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2111, new String[0]));
    }

    public void unexpectedPreviousTerminal(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2109, new String[0]));
    }

    public void unexpectedTerminal(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2106, new String[0]));
    }

    public void invalidEscapeSequence(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2205, new String[0]));
    }

    public void unclosedBlockComment(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2201, new String[0]));
    }

    public void unclosedDLI(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2204, new String[0]));
    }

    public void unclosedSQL(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2202, new String[0]));
    }

    public void unclosedSQLCondition(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2203, new String[0]));
    }

    public void unclosedString(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2200, new String[0]));
    }

    public void whitespaceInDLI(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 1, 2208, new String[0]));
    }

    public void whitespaceInSQL(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 1, 2206, new String[0]));
    }

    public void whitespaceInSQLCondition(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 1, 2207, new String[0]));
    }

    public void invalidCharacterInHexLiteral(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2209, new String[0]));
    }

    public void missingEndForPart(int startOffset, int endOffset) {
        this.problems.add(new Problem(startOffset, endOffset, 2, 2003, new String[0]));
    }

    private String[] getTerminalInserts(int terminalType) {
        String terminalName = NodeNameUtility.getTerminalName((int)terminalType);
        String[] inserts = new String[]{terminalName};
        return inserts;
    }

    private String[] getNonTerminalInserts(int nonTerminalType) {
        String nonTerminalName = NodeNameUtility.getNonterminalName((int)nonTerminalType);
        String[] inserts = new String[]{nonTerminalName};
        return inserts;
    }

    public void keywordAsName(int terminalType, int startOffset, int endOffset) {
        String insert;
        switch (terminalType) {
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                insert = this.fileContents.substring(startOffset, endOffset).toUpperCase();
                break;
            }
            default: {
                insert = NodeNameUtility.getTerminalName((int)terminalType);
            }
        }
        this.problems.add(new Problem(startOffset, endOffset, 2, 3019, new String[]{insert}));
    }
}

