/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.AnnotationHover;
import org.eclipse.edt.ide.ui.internal.editor.AutoIndentStrategy;
import org.eclipse.edt.ide.ui.internal.editor.BestMatchHover;
import org.eclipse.edt.ide.ui.internal.editor.ProblemReconciler;
import org.eclipse.edt.ide.ui.internal.editor.SQLAutoIndentStrategy;
import org.eclipse.edt.ide.ui.internal.editor.ScriptDoubleClickSelector;
import org.eclipse.edt.ide.ui.internal.editor.TextTools;
import org.eclipse.edt.ide.ui.internal.formatting.FormattingStrategy;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;

public class EGLSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private ITextEditor editor;
    private TextTools tools;

    public EGLSourceViewerConfiguration() {
        this(new TextTools(EDTUIPlugin.getDefault().getPreferenceStore()));
        this.editor = null;
    }

    public EGLSourceViewerConfiguration(TextTools textTools) {
        this(textTools, null);
    }

    public EGLSourceViewerConfiguration(TextTools textTools, ITextEditor editor) {
        this.tools = textTools;
        this.editor = editor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover();
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("__dftl_partition_content_type")) {
            return new IAutoEditStrategy[]{new AutoIndentStrategy()};
        }
        return new IAutoEditStrategy[]{new SQLAutoIndentStrategy()};
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__egl_multiline_comment", "__egl_singleline_comment", "__egl_sql", "__egl_sqlCondition"};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new FormattingStrategy());
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new ScriptDoubleClickSelector();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.tools.getEGLCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer(this.tools.getEGLMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__egl_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__egl_multiline_comment");
        dr = new DefaultDamagerRepairer(this.tools.getEGLSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__egl_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__egl_singleline_comment");
        dr = new DefaultDamagerRepairer(this.tools.getEGLSQLCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__egl_sql");
        reconciler.setRepairer((IPresentationRepairer)dr, "__egl_sql");
        reconciler.setRepairer((IPresentationRepairer)dr, "__egl_sqlCondition");
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new BestMatchHover((IEditorPart)this.getEditor());
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return new TextViewerUndoManager(25);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", "--", ""};
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ITextEditor editor = this.getEditor();
        if (editor != null && editor.isEditable()) {
            ProblemReconciler reconciler = new ProblemReconciler(editor);
            return reconciler;
        }
        return null;
    }

    public ITextEditor getEditor() {
        return this.editor;
    }
}

