/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.SaveDirtyEditorsDialog;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.ListContentProvide;
import org.eclipse.edt.ide.ui.internal.outline.OutlineAdapterFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;

public class EditorUtility {
    public static Node getNonWhitespaceNewNodeAtOffset(int selection, IEGLDocument document) {
        Node node = document.getNewModelNodeAtOffset(selection);
        return node;
    }

    public static void addNodeAtOffsetToHashMap(int selection, IEGLDocument document, EGLEditor editor, HashMap hashMap) {
        Node node = document.getNewModelNodeAtOffset(selection);
        OutlineAdapterFactory outlineAdapterFactory = editor.getOutlineAdapterFactory();
        while (node != null) {
            if (outlineAdapterFactory.hasOutlineAdapter(node)) {
                hashMap.put(node, node);
            }
            node = node.getParent();
        }
    }

    public static int populateNodeErrorWarningHashMaps(EGLEditor editor) {
        editor.setNodesWithSavedErrors(new HashMap());
        editor.setNodesWithSavedWarnings(new HashMap());
        int fImageFlags = 0;
        try {
            IDocument doc;
            IMarker[] eglMarkers = null;
            int searchDepth = 0;
            DocumentProvider provider = (DocumentProvider)editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider == null) {
                return fImageFlags;
            }
            IResource resource = provider.getUnderlyingResource(input);
            if (resource == null) {
                return fImageFlags;
            }
            eglMarkers = resource.findMarkers("org.eclipse.core.resources.marker", true, searchDepth);
            if (eglMarkers.length > 0 && (doc = provider.getDocument(input)) instanceof IEGLDocument) {
                IEGLDocument document = (IEGLDocument)doc;
                int markerIndex = 0;
                while (markerIndex < eglMarkers.length) {
                    int charStart;
                    IMarker marker = eglMarkers[markerIndex];
                    if (marker.getAttribute("severity", 0) == 1) {
                        if (fImageFlags == 0) {
                            fImageFlags = 32;
                        }
                        charStart = (Integer)marker.getAttribute("charStart");
                        EditorUtility.addNodeAtOffsetToHashMap(charStart, document, editor, editor.getNodesWithSavedWarnings());
                    }
                    if (marker.getAttribute("severity", 0) == 2) {
                        fImageFlags = 64;
                        charStart = (Integer)marker.getAttribute("charStart");
                        EditorUtility.addNodeAtOffsetToHashMap(charStart, document, editor, editor.getNodesWithSavedErrors());
                    }
                    ++markerIndex;
                }
            }
        }
        catch (CoreException coreException) {}
        if (editor.primGetOutlinePage() != null) {
            editor.getOutlinePage().refresh();
        }
        return fImageFlags;
    }

    public static Node getCurrentNode(TextEditor editor) {
        if (editor == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        IEGLDocument document = (IEGLDocument)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        Node node = document.getNewModelNodeAtOffset(offset);
        return node;
    }

    public static boolean isWithinFunction(TextEditor editor) {
        Node node = EditorUtility.getCurrentNode(editor);
        if (node == null) {
            return false;
        }
        NestedFunction embeddedFunction = EditorUtility.getEmbeddedFunction(node);
        if (embeddedFunction != null) {
            return true;
        }
        TopLevelFunction standAloneFunction = EditorUtility.getStandAloneFunction(node);
        return standAloneFunction != null;
    }

    public static TopLevelFunction getStandAloneFunction(Node node) {
        while (node != null && !(node instanceof TopLevelFunction)) {
            node = node.getParent();
        }
        if (node != null && node instanceof TopLevelFunction) {
            return (TopLevelFunction)node;
        }
        return null;
    }

    public static NestedFunction getEmbeddedFunction(Node node) {
        while (node != null && !(node instanceof NestedFunction)) {
            node = node.getParent();
        }
        if (node != null && node instanceof NestedFunction) {
            return (NestedFunction)node;
        }
        return null;
    }

    public static boolean saveEditors() {
        IEditorPart[] dirtyEditors = EDTUIPlugin.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!EditorUtility.saveAllDirtyEditors()) {
            return false;
        }
        EDTUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false);
        return true;
    }

    public static boolean saveAllDirtyEditors() {
        SaveDirtyEditorsDialog dialog = new SaveDirtyEditorsDialog(EDTUIPlugin.getActiveWorkbenchShell());
        dialog.setTitle(UINlsStrings.SQLSaveDirtyEditorsDialogTitle);
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        });
        dialog.setMessage(UINlsStrings.SQLSaveDirtyEditorsDialogMessage);
        dialog.setContentProvider(new ListContentProvide());
        dialog.setInput(Arrays.asList(EDTUIPlugin.getDirtyEditors()));
        return dialog.open() == 0;
    }

    public static String[] getPackageName(IFile file) {
        IEGLFile eglFile = (IEGLFile)EGLCore.create((IFile)file);
        IPackageFragment packageFragment = (IPackageFragment)eglFile.getAncestor(4);
        String[] packageName = packageFragment.isDefaultPackage() ? new String[]{} : packageFragment.getElementName().split("\\.");
        return packageName;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }
}

