/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.actions.WorkbenchRunnableAdapter;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.edt.ide.ui.internal.dialogs.MultiElementListSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.ProblemDialog;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.handlers.EGLHandler;
import org.eclipse.edt.ide.ui.internal.util.PartInfoLabelProvider;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.progress.IProgressService;

public class OrganizeImportsHandler
extends EGLHandler {
    private boolean fIsQueryShowing = false;

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            this.fSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        }
        if ((editor = HandlerUtil.getActiveEditor((ExecutionEvent)event)) instanceof EGLEditor) {
            IEditorInput editorInput;
            this.fEditor = (EGLEditor)editor;
            if (this.fSelection == null && editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                IFile resource = ((IFileEditorInput)editorInput).getFile();
                IEGLElement element = EGLCore.create((IResource)resource);
                this.fSite = editor.getSite();
                this.fSelection = new StructuredSelection((Object)element);
            }
        }
        if (this.fSelection != null) {
            this.run();
        }
        return null;
    }

    @Override
    public void run() {
        List eglFiles = this.getEGLFiles(this.fSelection);
        int selCnt = eglFiles.size();
        if (selCnt == 0) {
            return;
        }
        if (selCnt == 1) {
            IEGLFile eglFile = (IEGLFile)eglFiles.get(0);
            this.runOnSingle(eglFile);
        } else {
            this.runOnMultiple(eglFiles);
        }
    }

    protected void runOnSingle(IEGLFile eglFile) {
        IEditingSupport helper = this.createViewerHelper();
        OrganizeImportsOperation op = this.createOperation(eglFile);
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        IWorkbenchWindow context = this.fSite.getWorkbenchWindow();
        if (context == null) {
            context = progressService;
        }
        try {
            try {
                this.registerHelper(helper);
                progressService.runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                this.postRun(op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                this.deregisterHelper(helper);
            }
            catch (InterruptedException interruptedException) {
                this.deregisterHelper(helper);
            }
        }
        finally {
            this.deregisterHelper(helper);
        }
    }

    protected void registerHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.register(helper);
        }
    }

    protected void postRun(OrganizeImportsOperation op) {
        OrganizeImportsOperation.SyntaxErrorHelper syntaxErr = op.getSyntaxError();
        if (syntaxErr != null) {
            MessageDialog.openInformation((Shell)this.fSite.getShell(), (String)UINlsStrings.OrganizeImportsAction_status_title, (String)syntaxErr.fErrMsg);
            if (this.fEditor != null && syntaxErr.fSynErr.startOffset > 0) {
                this.fEditor.selectAndReveal(syntaxErr.fSynErr.startOffset, syntaxErr.fSynErr.endOffset - syntaxErr.fSynErr.startOffset + 1);
            }
        } else if (this.fEditor != null) {
            this.setStatusBarMessage(this.getOrganizeSummary(op));
        }
    }

    protected void setStatusBarMessage(String message) {
        IEditorActionBarContributor contributor = this.fEditor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            IStatusLineManager manager = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            manager.setMessage(message);
        }
    }

    private String getOrganizeSummary(OrganizeImportsOperation op) {
        int nImportsAdded = op.getNumberOfImportsAdded();
        int nImportsRemoved = op.getNumberOfImportsRemoved();
        Object[] args = new String[]{String.valueOf(nImportsAdded), String.valueOf(nImportsRemoved)};
        return MessageFormat.format(UINlsStrings.OrganizeImportsAction_summary, args);
    }

    protected void deregisterHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister(helper);
        }
    }

    protected IEditingSupport createViewerHelper() {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
                return true;
            }

            public boolean ownsFocusShell() {
                return OrganizeImportsHandler.this.fIsQueryShowing;
            }
        };
    }

    protected OrganizeImportsOperation createOperation(IEGLFile eglFile) {
        boolean needsave = (Boolean)this.fileNeedsSave.get(eglFile);
        return new OrganizeImportsOperation(eglFile, needsave, this.createChooseImportQuery());
    }

    protected OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery() {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            @Override
            public PartInfo[] chooseImports(Map mapOpenChoices) {
                int cnt = mapOpenChoices.size();
                ArrayList<PartInfo[]> openChoices = new ArrayList<PartInfo[]>(cnt);
                ArrayList<Region> regionList = new ArrayList<Region>(cnt);
                Set keys = mapOpenChoices.keySet();
                for (Name unrevoledTypeName : keys) {
                    List partInfos = (List)mapOpenChoices.get(unrevoledTypeName);
                    Region region = new Region(unrevoledTypeName.getOffset(), unrevoledTypeName.getLength());
                    regionList.add(region);
                    int choicesPerPartCnt = partInfos.size();
                    PartInfo[] openChoice = partInfos.toArray(new PartInfo[choicesPerPartCnt]);
                    openChoices.add(openChoice);
                }
                PartInfo[][] chooseImportChoices = (PartInfo[][])openChoices.toArray((T[])new PartInfo[openChoices.size()][]);
                IRegion[] regions = regionList.toArray(new IRegion[regionList.size()]);
                return OrganizeImportsHandler.this.doChooseImports(chooseImportChoices, regions);
            }
        };
    }

    protected PartInfo[] doChooseImports(PartInfo[][] openChoices, final IRegion[] ranges) {
        ISelection sel = this.fEditor != null ? this.fEditor.getSelectionProvider().getSelection() : null;
        PartInfo[] result = null;
        PartInfoLabelProvider labelProvider = new PartInfoLabelProvider(1);
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.fSite.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeImportsHandler.this.doListSelectionChanged(this.getCurrentPage(), ranges);
            }
        };
        this.fIsQueryShowing = true;
        dialog.setTitle(UINlsStrings.OrganizeImportsAction_selectiondialog_title);
        dialog.setMessage(UINlsStrings.OrganizeImportsAction_selectiondialog_message);
        dialog.setElements(openChoices);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new PartInfo[res.length];
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0) {
                    result[i] = (PartInfo)array[0];
                }
                ++i;
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            this.fEditor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        this.fIsQueryShowing = false;
        return result;
    }

    protected void doListSelectionChanged(int page, IRegion[] ranges) {
        if (this.fEditor != null && ranges != null && page >= 0 && page < ranges.length) {
            IRegion range = ranges[page];
            this.fEditor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private void runOnMultiple(final List eglFiles) {
        String message = UINlsStrings.OrganizeImportsAction_status_description;
        final MultiStatus status = new MultiStatus("org.eclipse.edt.ide.ui", 0, message, null);
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    OrganizeImportsHandler.this.doRunOnMultiple(eglFiles, status, monitor);
                }
            }));
            if (!status.isOK()) {
                String title = UINlsStrings.OrganizeImportsAction_status_title;
                ProblemDialog.open(this.fSite.getShell(), title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
    }

    private void doRunOnMultiple(List eglfiles, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(UINlsStrings.OrganizeImportsAction_op_description);
        int size = eglfiles.size();
        monitor.beginTask("", size);
        OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

            @Override
            public PartInfo[] chooseImports(Map mapOpenChoices) {
                throw new OrganizeImportError();
            }
        };
        try {
            int i = 0;
            while (i < size) {
                String fileLocation;
                IEGLFile eglfile = (IEGLFile)eglfiles.get(i);
                if (this.testOnEGLPath((IEGLElement)eglfile, fileLocation = eglfile.getPath().makeRelative().toString(), status)) {
                    monitor.subTask(fileLocation);
                    boolean needsave = (Boolean)this.fileNeedsSave.get(eglfile);
                    OrganizeImportsOperation op = new OrganizeImportsOperation(eglfile, needsave, query);
                    this.runInSync(op, status, fileLocation, monitor);
                    OrganizeImportsOperation.SyntaxErrorHelper syntaxErr = op.getSyntaxError();
                    if (syntaxErr != null) {
                        String msg = MessageFormat.format(UINlsStrings.OrganizeAction_error_syntax, fileLocation);
                        status.add((IStatus)new Status(1, "org.eclipse.edt.ide.ui", 4, msg, null));
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean testOnEGLPath(IEGLElement eglelem, String fileLocation, MultiStatus status) {
        IEGLProject eglProj = eglelem.getEGLProject();
        if (!eglProj.isOnEGLPath(eglelem)) {
            String message = MessageFormat.format(UINlsStrings.OrganizeImportsAction_multi_error_notoncp, fileLocation);
            status.add((IStatus)new Status(1, "org.eclipse.edt.ide.ui", 4, message, null));
            return false;
        }
        return true;
    }

    private void runInSync(final OrganizeImportsOperation op, final MultiStatus status, final String fileLocation, final IProgressMonitor monitor) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    String message = UINlsStrings.OrganizeAction_error_unexpected;
                    status.add((IStatus)new Status(4, "org.eclipse.edt.ide.ui", 4, message, (Throwable)e));
                }
                catch (OrganizeImportError e) {
                    Object[] args = new String[]{fileLocation};
                    String message = MessageFormat.format(UINlsStrings.OrganizeImportsAction_multi_error_unresolvable, args);
                    status.add((IStatus)new Status(1, "org.eclipse.edt.ide.ui", 4, message, (Throwable)e));
                }
                catch (OperationCanceledException operationCanceledException) {
                    monitor.setCanceled(true);
                }
            }
        };
        this.fSite.getShell().getDisplay().syncExec(runnable);
    }

    static final class OrganizeImportError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        OrganizeImportError() {
        }
    }
}

