/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EditorPreferencePage
extends AbstractPreferencePage {
    protected Button annotateErrorsButton = null;
    protected Button annotateErrorsInOverviewButton = null;
    protected Button annotateErrorsAsYouTypeButton = null;
    protected Button autoActivationButton = null;

    public EditorPreferencePage() {
        this.setPreferenceStore(EDTUIPlugin.getDefault().getPreferenceStore());
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.createHeader(composite);
        Composite internalComposite = this.createComposite(composite, 1);
        this.annotateErrorsButton = EditorPreferencePage.createCheckBox(internalComposite, UINlsStrings.AnnotateErrorsLabel);
        this.annotateErrorsInOverviewButton = EditorPreferencePage.createCheckBox(internalComposite, UINlsStrings.AnnotateErrorsInOverviewLabel);
        this.annotateErrorsAsYouTypeButton = EditorPreferencePage.createCheckBox(internalComposite, UINlsStrings.AnnotateErrorsAsYouTypeLabel);
        Group contentAssistGroup = EditorPreferencePage.createGroup(composite, 1);
        contentAssistGroup.setText(UINlsStrings.ContentAssistLabel);
        Composite contentAssistComposite = this.createComposite((Composite)contentAssistGroup, 1);
        this.autoActivationButton = EditorPreferencePage.createCheckBox(contentAssistComposite, UINlsStrings.AutoActivationLabel);
        this.setSize(composite);
        this.loadPreferences();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.EDITOR_PREFERENCE_CONTEXT);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void createHeader(Composite contents) {
        final Shell shell = contents.getShell();
        String text = UINlsStrings.TextEditorLink;
        Link link = new Link(contents, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        link.setToolTipText(UINlsStrings.TextEditorTooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        this.addFiller(contents);
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    @Override
    protected void performDefaults() {
        this.annotateErrorsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("errorIndication"));
        this.annotateErrorsInOverviewButton.setSelection(this.getPreferenceStore().getDefaultBoolean("errorIndicationInOverviewRuler"));
        this.annotateErrorsAsYouTypeButton.setSelection(this.getPreferenceStore().getDefaultBoolean("handleDynamicProblems"));
        this.autoActivationButton.setSelection(this.getPreferenceStore().getDefaultBoolean("content_assist_autoactivation"));
        super.performDefaults();
    }

    @Override
    protected void initializeValues() {
        this.annotateErrorsButton.setSelection(this.getPreferenceStore().getBoolean("errorIndication"));
        this.annotateErrorsInOverviewButton.setSelection(this.getPreferenceStore().getBoolean("errorIndicationInOverviewRuler"));
        this.annotateErrorsAsYouTypeButton.setSelection(this.getPreferenceStore().getBoolean("handleDynamicProblems"));
        this.autoActivationButton.setSelection(this.getPreferenceStore().getBoolean("content_assist_autoactivation"));
    }

    @Override
    protected void storeValues() {
        this.getPreferenceStore().setValue("errorIndication", this.annotateErrorsButton.getSelection());
        this.getPreferenceStore().setValue("errorIndicationInOverviewRuler", this.annotateErrorsInOverviewButton.getSelection());
        this.getPreferenceStore().setValue("handleDynamicProblems", this.annotateErrorsAsYouTypeButton.getSelection());
        this.getPreferenceStore().setValue("content_assist_autoactivation", this.autoActivationButton.getSelection());
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        EDTUIPlugin.getDefault().saveUIPluginPreferences();
        return result;
    }
}

