/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizard.pages;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ProjectWizardPage;
import org.eclipse.edt.ide.ui.internal.project.wizards.NewEGLProjectWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.wizards.ProjectFinishUtility;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ProjectWizardRUILibraryPage
extends ProjectWizardPage {
    private Group widgetLibraryGroup;
    private Composite contentSection;
    private CheckedListDialogField widgetLibraryList;

    public ProjectWizardRUILibraryPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.RUILibraryPageTitle);
        this.setDescription(NewWizardMessages.RUILibraryPageDescription);
    }

    private void handleWidgetLibrariesDialogFieldChanged(DialogField field) {
        ((NewEGLProjectWizard)this.getWizard()).getModel().setSelectedWidgetLibraries(((CheckedListDialogField)field).getCheckedElements());
    }

    @Override
    public void createContents(Composite parent) {
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        parent.setLayout((Layout)new FormLayout());
        this.createDefaultWidgetsContent(parent);
    }

    @Override
    public void setProjectName(String projectName) {
        ((NewEGLProjectWizard)this.getWizard()).getModel().setProjectName(projectName);
    }

    public boolean isWidgetLibrarySelected(String libName) {
        List checked = this.widgetLibraryList.getCheckedElements();
        return checked.contains(libName);
    }

    private void createDefaultWidgetsContent(Composite parent) {
        this.widgetLibraryGroup = AbstractPreferencePage.createGroup(parent, 1);
        this.widgetLibraryGroup.setText(NewWizardMessages.RUILibraryPage_widget_library);
        WidgetLibrariesAdapter adapter = new WidgetLibrariesAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.BuildPathsBlockClasspathCheckallButton, NewWizardMessages.BuildPathsBlockClasspathUncheckallButton};
        ArrayList<String> widgetLibraries = new ArrayList<String>();
        ArrayList<String> selectedLibraries = new ArrayList<String>();
        IConfigurationElement[] widgetLibraryContributions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.edt.ide.ui.widgetLibraryProvider");
        if (widgetLibraryContributions != null) {
            IConfigurationElement[] iConfigurationElementArray = widgetLibraryContributions;
            int n = widgetLibraryContributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement currContribution = iConfigurationElementArray[n2];
                String libName = currContribution.getAttribute("libname");
                String selected = currContribution.getAttribute("selected");
                String resourcePluginName = currContribution.getAttribute("resourcePluginName");
                String libraryResourceFolder = currContribution.getAttribute("resourceFolder");
                String widgetsProjectName = currContribution.getAttribute("projectName");
                if (libName != null) {
                    try {
                        URL url = ProjectFinishUtility.getWidgetProjectURL(resourcePluginName, libraryResourceFolder, widgetsProjectName);
                        if (url != null) {
                            widgetLibraries.add(libName);
                            if (selected != null && selected.toLowerCase().equals("true")) {
                                selectedLibraries.add(libName);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        this.widgetLibraryList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new LabelProvider());
        this.widgetLibraryList.setDialogFieldListener(adapter);
        this.widgetLibraryList.setCheckAllButtonIndex(0);
        this.widgetLibraryList.setUncheckAllButtonIndex(1);
        LayoutUtil.doDefaultLayout((Composite)this.widgetLibraryGroup, new DialogField[]{this.widgetLibraryList}, true, 0, 0, 10, 10);
        LayoutUtil.setHorizontalGrabbing(this.widgetLibraryList.getListControl(null));
        this.widgetLibraryList.setElements(widgetLibraries);
        this.widgetLibraryList.setCheckedElements(selectedLibraries);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment((Control)this.contentSection, 10);
        data.right = new FormAttachment(100, -10);
        this.widgetLibraryGroup.setLayoutData((Object)data);
    }

    public CheckedListDialogField getWidgetLibraryList() {
        return this.widgetLibraryList;
    }

    private class WidgetLibrariesAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private WidgetLibrariesAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ProjectWizardRUILibraryPage.this.handleWidgetLibrariesDialogFieldChanged(field);
        }
    }
}

