/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizard.pages;

import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.project.wizard.fragments.SourceProjectContentFragment;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ProjectWizardPage;
import org.eclipse.edt.ide.ui.internal.project.wizards.NewEGLProjectWizard;
import org.eclipse.edt.ide.ui.internal.project.wizards.ProjectWizardUtils;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProjectWizardTypePage
extends ProjectWizardPage {
    public static IStatus OK_STATUS = new Status(0, "org.eclipse.edt.ide.ui", 0, "OK", null);
    private Label projectNameLabel;
    private Text projectName;
    private Composite contentSection;
    private SourceProjectContentFragment contentFragment;
    private ProjectConfiguration model;

    public ProjectWizardTypePage(String pageName, ProjectConfiguration model) {
        super(pageName);
        this.model = model;
        this.setTitle(NewWizardMessages.EGLNewProjectWizard_0);
        this.setDescription(NewWizardMessages.EGLProjectWizardTypePage_1);
        this.setImageDescriptor(PluginImages.DESC_WIZBAN_NEWEGLPROJECT);
    }

    @Override
    public void createContents(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new FormLayout());
        this.createProjectNameEntry(parent);
        this.createContentFragment(this.parent);
        this.setControl((Control)parent);
        this.projectName.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.NEW_PROJECT_WIZARD_TYPE_PAGE);
        Dialog.applyDialogFont((Control)parent);
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    private void createProjectNameEntry(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(NewWizardMessages.EGLProjectWizardTypePage_2);
        this.projectName = new Text(parent, 2048);
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = ((Text)e.widget).getText();
                ProjectWizardTypePage.this.model.setProjectName(name);
                ProjectWizardTypePage.this.getContainer().updateButtons();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment(0, 10);
        this.projectNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.projectNameLabel, 10);
        data.top = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.projectName.setLayoutData((Object)data);
        this.hookListenerProjectName(this.projectName);
    }

    private void createContentFragment(Composite parent) {
        this.contentFragment = new SourceProjectContentFragment(parent, this);
        this.contentSection = this.contentFragment.renderSection();
        this.registerFragment(this.contentFragment);
        this.contentFragment.registerIsCompleteListener(this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment((Control)this.projectName, 20);
        data.right = new FormAttachment(100, -10);
        this.contentSection.setLayoutData((Object)data);
    }

    private void hookListenerProjectName(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = ProjectWizardTypePage.validateName(ProjectWizardTypePage.this.projectName.getText());
                if (status != OK_STATUS) {
                    ProjectWizardTypePage.this.setErrorMessage(status.getMessage());
                } else {
                    ProjectWizardTypePage.this.setErrorMessage(null);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validatePage();
    }

    private boolean validatePage() {
        IStatus status = ProjectWizardTypePage.validateName(this.projectName.getText());
        if (status != OK_STATUS) {
            this.contentFragment.specifyProjectDirectory.setEnabled(false);
            return false;
        }
        this.contentFragment.specifyProjectDirectory.setEnabled(true);
        return true;
    }

    public static IStatus validateName(String name) {
        IResource variant;
        IStatus status = ProjectWizardTypePage.validateProjectName(name);
        if (!status.isOK()) {
            return status;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            return ProjectWizardUtils.createErrorStatus(NewWizardMessages.error_project_already_exists);
        }
        if (!ProjectWizardUtils.isPlatformCaseSensitive() && (variant = ((Resource)project).findExistingResourceVariant(project.getFullPath())) != null) {
            return ProjectWizardUtils.createErrorStatus(NewWizardMessages.error_project_exists_different_case);
        }
        return OK_STATUS;
    }

    public static IStatus validateProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.validateName(projectName, 4);
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public ProjectConfiguration getModel() {
        return this.model;
    }

    @Override
    public void setProjectName(String projectName) {
        ((NewEGLProjectWizard)this.getWizard()).getModel().setProjectName(projectName);
    }
}

