/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ProjectWizardRUILibraryPage;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ProjectWizardTypePage;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.SourceProjectWizardCapabilityPage;
import org.eclipse.edt.ide.ui.internal.project.wizards.ProjectWizardUtils;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProjectFinishUtility;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewEGLProjectWizard
extends Wizard
implements IWorkbenchWizard,
INewWizard {
    private ProjectWizardTypePage typePage;
    private ProjectWizardRUILibraryPage libraryPage;
    private SourceProjectWizardCapabilityPage capabilityPage;
    private ProjectConfiguration model;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private IConfigurationElement configElement;

    public NewEGLProjectWizard() {
        this.model = new ProjectConfiguration();
        this.model.setDefaultAttributes();
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_NEWEGLPROJECT);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.EGLNewProjectWizard_0);
    }

    public boolean performFinish() {
        try {
            try {
                ISchedulingRule rule = this.getCurrentSchedulingRule();
                this.model.setProjectName(this.typePage.getModel().getProjectName());
                List<WorkspaceModifyOperation> ops = ProjectFinishUtility.getCreateProjectFinishOperations(this.model, 0, rule);
                for (WorkspaceModifyOperation obj : ops) {
                    if (!(obj instanceof WorkspaceModifyOperation)) continue;
                    WorkspaceModifyOperation op = obj;
                    this.getContainer().run(true, true, (IRunnableWithProgress)op);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.postPerformFinish();
                return false;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof CoreException) {
                    ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
                } else {
                    e.printStackTrace();
                    EDTUIPlugin.log(e);
                }
                this.postPerformFinish();
                return false;
            }
        }
        finally {
            this.postPerformFinish();
        }
        return true;
    }

    protected ISchedulingRule getCurrentSchedulingRule() {
        ISchedulingRule rule = null;
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            rule = job.getRule();
        }
        if (rule == null) {
            rule = this.getSchedulingRule();
        }
        return rule;
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(NewWizardMessages.EGLNewProjectWizard_0);
    }

    public void addPages() {
        this.typePage = new ProjectWizardTypePage(NewWizardMessages.EGLNewProjectWizard_1, this.model);
        this.addPage((IWizardPage)this.typePage);
        this.libraryPage = new ProjectWizardRUILibraryPage(NewWizardMessages.RUILibraryPage);
        this.addPage((IWizardPage)this.libraryPage);
        this.capabilityPage = new SourceProjectWizardCapabilityPage(NewWizardMessages.EGLCapabilityConfigurationPage);
        this.addPage((IWizardPage)this.capabilityPage);
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public ProjectConfiguration getModel() {
        return this.model;
    }

    protected void postPerformFinish() {
        DummyConfigurationElement dummy = new DummyConfigurationElement();
        ProjectWizardUtils.updatePerspective(dummy);
        BasicNewResourceWizard.selectAndReveal((IResource)this.workspaceRoot.getProject(this.model.getProjectName()), (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public class DummyConfigurationElement
    implements IConfigurationElement {
        private static final String FINAL_PERSPECTIVE = "finalPerspective";

        public Object createExecutableExtension(String propertyName) throws CoreException {
            return null;
        }

        public String getAttribute(String name) throws InvalidRegistryObjectException {
            if (name.equals(FINAL_PERSPECTIVE)) {
                return "org.eclipse.edt.ide.ui.EGLPerspective";
            }
            return null;
        }

        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
            return this.getAttribute(attrName);
        }

        public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public String[] getAttributeNames() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
            return null;
        }

        public String getName() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public Object getParent() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue(String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getValueAsIs() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return false;
        }
    }
}

