/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgPolicy;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ParentChecker;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class EGLCopyProcessor
extends CopyProcessor
implements IReorgDestinationValidator {
    private INewNameQueries fNewNameQueries;
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.IEGLCopyPolicy fCopyPolicy;

    public static EGLCopyProcessor create(IResource[] resources, IEGLElement[] eglElements) throws EGLModelException {
        IReorgPolicy.IEGLCopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, eglElements);
        if (!copyPolicy.canEnable()) {
            return null;
        }
        return new EGLCopyProcessor(copyPolicy);
    }

    private EGLCopyProcessor(IReorgPolicy.IEGLCopyPolicy copyPolicy) {
        this.fCopyPolicy = copyPolicy;
    }

    public String getProcessorName() {
        return UINlsStrings.CopyRefactoring_0;
    }

    public String getIdentifier() {
        return this.getClass().getName();
    }

    public boolean isApplicable() throws CoreException {
        return this.fCopyPolicy.canEnable();
    }

    public void setNewNameQueries(INewNameQueries newNameQueries) {
        Assert.isNotNull((Object)newNameQueries);
        this.fNewNameQueries = newNameQueries;
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fReorgQueries = queries;
    }

    public IEGLElement[] getEGLElements() {
        return this.fCopyPolicy.getEGLElements();
    }

    public IResource[] getResources() {
        return this.fCopyPolicy.getResources();
    }

    public Object[] getElements() {
        IEGLElement[] jElements = this.fCopyPolicy.getEGLElements();
        IResource[] resources = this.fCopyPolicy.getResources();
        ArrayList<Object> result = new ArrayList<Object>(jElements.length + resources.length);
        result.addAll(Arrays.asList(jElements));
        result.addAll(Arrays.asList(resources));
        return result.toArray();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)EGLCopyProcessor.checkInSync(ReorgUtils.getNotNulls(this.fCopyPolicy.getResources()))));
        IResource[] eglResources = ReorgUtils.getResources(this.fCopyPolicy.getEGLElements());
        result.merge(RefactoringStatus.create((IStatus)EGLCopyProcessor.checkInSync(ReorgUtils.getNotNulls(eglResources))));
        return result;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fCopyPolicy.getResources(), this.fCopyPolicy.getEGLElements()).getCommonParent();
    }

    public RefactoringStatus setDestination(IEGLElement destination) throws EGLModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws EGLModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    @Override
    public boolean canChildrenBeDestinations(IEGLElement eglElement) {
        return this.fCopyPolicy.canChildrenBeDestinations(eglElement);
    }

    @Override
    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fCopyPolicy.canChildrenBeDestinations(resource);
    }

    @Override
    public boolean canElementBeDestination(IEGLElement eglElement) {
        return this.fCopyPolicy.canElementBeDestination(eglElement);
    }

    @Override
    public boolean canElementBeDestination(IResource resource) {
        return this.fCopyPolicy.canElementBeDestination(resource);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull((Object)this.fNewNameQueries, (String)"Missing new name queries");
        Assert.isNotNull((Object)this.fReorgQueries, (String)"Missing reorg queries");
        pm.beginTask("", 2);
        RefactoringStatus result = this.fCopyPolicy.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, this.fReorgQueries);
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)this.fNewNameQueries);
        Assert.isTrue((this.fCopyPolicy.getEGLElementDestination() == null || this.fCopyPolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fCopyPolicy.getEGLElementDestination() != null || this.fCopyPolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            CompositeChange result = new CompositeChange(this.getChangeName()){

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    return super.perform(pm2);
                }
            };
            Change change = this.fCopyPolicy.createChange(pm, this.fNewNameQueries);
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            CompositeChange compositeChange = result;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    private String getChangeName() {
        return UINlsStrings.EGLCopyProcessor_change_name;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RefactoringParticipant[] result = this.fCopyPolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharedParticipants);
        return result;
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        return new String[]{"com.ibm.etools.egl.model.eglnature"};
    }

    public static IStatus checkInSync(IResource resource) {
        return EGLCopyProcessor.checkInSync(new IResource[]{resource});
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = EGLCopyProcessor.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, MessageFormat.format((String)UINlsStrings.Resources_outOfSync, (Object[])new String[]{resource.getFullPath().toString()}), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, UINlsStrings.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }
}

