/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.templates;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.templates.CoreContextType;
import org.eclipse.edt.ide.ui.internal.templates.EGLTemplateContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.swt.graphics.Point;

public class TemplateEngine {
    private ArrayList fProposals = new ArrayList();
    private CoreContextType fContextType = new CoreContextType();

    public void reset() {
        this.fProposals.clear();
    }

    public TemplateProposal[] getResults() {
        return this.fProposals.toArray(new TemplateProposal[this.fProposals.size()]);
    }

    public void complete(TokenStream tokenStream, ITextViewer viewer, int completionPosition, ParseStack parseStack, String prefix) {
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        EGLTemplateContext context = this.fContextType.createContext(document, completionPosition - prefix.length(), selection.y + prefix.length(), parseStack, prefix);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = EDTUIPlugin.getDefault().getTemplateStore().getTemplates();
        int i = 0;
        while (i != templates.length) {
            if (context.canEvaluate(templates[i])) {
                this.fProposals.add(new TemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, PluginImages.get("org.eclipse.edt.ide.ui.template_obj.gif")));
            }
            ++i;
        }
    }

    public static String getCustomizedTemplateString(String name, String id) {
        TemplatePersistenceData[] templateDatas = EDTUIPlugin.getDefault().getTemplateStore().getTemplateData(false);
        int i = 0;
        while (i != templateDatas.length) {
            TemplatePersistenceData templatedata = templateDatas[i];
            if (templatedata.getTemplate().getName().equals(name) && templatedata.getId().equals(id)) {
                return templatedata.getTemplate().getPattern();
            }
            ++i;
        }
        return "";
    }

    public static String getDefaultTemplateString(String name, String id) {
        TemplatePersistenceData[] templateDatas = EDTUIPlugin.getDefault().getDefaultTemplateStore().getTemplateData(false);
        int i = 0;
        while (i != templateDatas.length) {
            TemplatePersistenceData templatedata = templateDatas[i];
            if (templatedata.getTemplate().getName().equals(name) && templatedata.getId().equals(id)) {
                return templatedata.getTemplate().getPattern();
            }
            ++i;
        }
        return "";
    }

    public static String getCustomizedTemplateString(String name, String id, Map variables) {
        return TemplateEngine.replaceVariables(TemplateEngine.getCustomizedTemplateString(name, id), variables);
    }

    public static String getDefaultTemplateString(String name, String id, Map variables) {
        return TemplateEngine.replaceVariables(TemplateEngine.getDefaultTemplateString(name, id), variables);
    }

    public static String replaceVariables(String template, Map variables) {
        StringBuffer completed_template = new StringBuffer();
        int i = 0;
        while (i < template.length()) {
            char c = template.charAt(i);
            if (c == '$') {
                if (template.charAt(i + 1) == '{') {
                    i += 2;
                    StringBuffer variableKey = new StringBuffer();
                    while (template.charAt(i) != '}') {
                        variableKey.append(template.charAt(i++));
                    }
                    String variableValue = (String)variables.get(variableKey.toString());
                    if (variableValue != null) {
                        completed_template.append(variableValue);
                    } else {
                        completed_template.append("${");
                        completed_template.append(variableKey.toString());
                        completed_template.append("}");
                    }
                } else {
                    completed_template.append(c);
                }
            } else {
                completed_template.append(c);
            }
            ++i;
        }
        return completed_template.toString();
    }
}

