/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.EDTCorePreferenceConstants;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLContainerWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLSourceFolderWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.TypedElementSelectionValidator;
import org.eclipse.edt.ide.ui.internal.wizards.TypedViewerFilter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.edt.ide.ui.wizards.EGLSourceFolderConfiguration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class EGLSourceFolderWizardPage
extends EGLContainerWizardPage {
    private int nColumns = 4;
    private StringButtonDialogField fProjectDialogField;
    private StatusInfo fProjectStatus;
    private StringButtonDialogField fSourceFolderDialogField;
    private StatusInfo fRootStatus;
    private SourceFolderFieldAdapter adapter = new SourceFolderFieldAdapter();

    public EGLSourceFolderWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewSourceFolderWizardPageTitle);
        this.setDescription(NewWizardMessages.NewSourceFolderWizardPageDescription);
        this.fRootStatus = new StatusInfo();
        this.fProjectStatus = new StatusInfo();
    }

    private EGLSourceFolderConfiguration getConfiguration() {
        return ((EGLSourceFolderWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_SOURCE_FOLDER_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createProjectControl(composite);
        this.createSourceFolderControl(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fSourceFolderDialogField.setFocus();
        }
    }

    private void createProjectControl(Composite parent) {
        this.fProjectDialogField = new StringButtonDialogField(this.adapter);
        this.fProjectDialogField.setDialogFieldListener(this.adapter);
        this.fProjectDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPageProjectLabel);
        this.fProjectDialogField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPageProjectButton);
        this.fProjectDialogField.setText(this.getConfiguration().getProjectName());
        this.fProjectDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fProjectDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    private void createSourceFolderControl(Composite parent) {
        this.fSourceFolderDialogField = new StringButtonDialogField(this.adapter);
        this.fSourceFolderDialogField.setDialogFieldListener(this.adapter);
        this.fSourceFolderDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPageRootLabel);
        this.fSourceFolderDialogField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPageRootButton);
        this.fSourceFolderDialogField.setText(this.getConfiguration().getSourceFolderName());
        this.fSourceFolderDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fSourceFolderDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    private void handleProjectBrowseButtonSelected() {
        ElementListSelectionDialog dialog = this.openProjectDialog();
        if (dialog.open() == 0) {
            IEGLProject project = (IEGLProject)dialog.getFirstResult();
            this.getConfiguration().setProjectName(project.getElementName());
            this.fProjectDialogField.setText(this.getConfiguration().getProjectName());
            this.validatePage();
        }
    }

    private void handleSourceFolderBrowseButtonSelected() {
        ElementTreeSelectionDialog dialog = this.openSourceFolderDialog();
        if (dialog.open() == 0) {
            IFolder folder = (IFolder)dialog.getFirstResult();
            Path path = new Path("");
            if (folder != null) {
                path = folder.getFullPath().removeFirstSegments(1);
            }
            this.getConfiguration().setSourceFolderName(path.toOSString());
            this.fSourceFolderDialogField.setText(this.getConfiguration().getSourceFolderName());
            this.validatePage();
        }
    }

    private void handleSourceFolderDialogFieldChanged() {
        this.getConfiguration().setSourceFolderName(this.fSourceFolderDialogField.getText());
        this.validatePage();
    }

    private ElementTreeSelectionDialog openSourceFolderDialog() {
        Class[] acceptedClasses = new Class[]{IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject project = this.fWorkspaceRoot.getProject(this.getConfiguration().getProjectName());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(NewWizardMessages.NewSourceFolderWizardPageChooseExistingRootDialogTitle);
        dialog.setMessage(NewWizardMessages.NewSourceFolderWizardPageChooseExistingRootDialogDescription);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)project);
        IResource res = project.findMember((IPath)new Path(this.getConfiguration().getSourceFolderName()));
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        return dialog;
    }

    private ElementListSelectionDialog openProjectDialog() {
        Object[] projects;
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        try {
            projects = EGLCore.create((IWorkspaceRoot)this.fWorkspaceRoot).getEGLProjects();
        }
        catch (EGLModelException e) {
            EGLLogger.log((Object)this, e);
            projects = new IEGLProject[]{};
        }
        dialog.setTitle(NewWizardMessages.NewSourceFolderWizardPageChooseProjectDialogTitle);
        dialog.setMessage(NewWizardMessages.NewSourceFolderWizardPageChooseProjectDialogDescription);
        dialog.setElements(projects);
        IProject project = null;
        IResource currProject = this.fWorkspaceRoot.findMember(this.getConfiguration().getProjectName());
        if (currProject instanceof IProject) {
            project = (IProject)currProject;
        }
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        return dialog;
    }

    private void validatePage() {
        IEGLProject fCurrEProject;
        Path path;
        String str;
        IPath fOutputLocation;
        IEGLPathEntry[] fEntries;
        block26: {
            fEntries = null;
            fOutputLocation = null;
            str = this.fProjectDialogField.getText();
            if (str.length() == 0) {
                this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorEnterProjectName);
                return;
            }
            path = new Path(str);
            if (path.segmentCount() != 1) {
                this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorInvalidProjectPath);
                return;
            }
            IProject project = this.fWorkspaceRoot.getProject(path.toString());
            if (!project.exists()) {
                this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorProjectNotExists);
                return;
            }
            fCurrEProject = null;
            try {
                if (project.hasNature(EGLCore.NATURE_ID)) {
                    fCurrEProject = EGLCore.create((IProject)project);
                    fEntries = fCurrEProject.getRawEGLPath();
                    fOutputLocation = fCurrEProject.getOutputLocation();
                    this.fProjectStatus.setOK();
                    break block26;
                }
                this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorNotAnEGLProject);
                return;
            }
            catch (CoreException e) {
                EGLLogger.log((Object)this, e);
                fCurrEProject = null;
            }
        }
        this.fSourceFolderDialogField.enableButton(fCurrEProject != null);
        boolean fIsProjectAsSourceFolder = false;
        if (fCurrEProject == null) {
            return;
        }
        this.fRootStatus.setOK();
        IPath projPath = fCurrEProject.getProject().getFullPath();
        str = this.fSourceFolderDialogField.getText();
        if (str.length() == 0) {
            this.fRootStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewSourceFolderWizardPageErrorEnterRootName, (Object)fCurrEProject.getProject().getFullPath().toString()));
        } else {
            try {
                path = projPath.append(str);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.fRootStatus.setError(String.valueOf(NewWizardMessages.NewContainerWizardPageErrorBackSlash) + " " + str + ".");
                this.updateStatus(new IStatus[]{this.fProjectStatus, this.fRootStatus});
                return;
            }
            IStatus validate = this.fWorkspaceRoot.getWorkspace().validatePath(path.toString(), 2);
            if (validate.matches(4)) {
                this.fRootStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewSourceFolderWizardPageErrorInvalidRootName, (Object)validate.getMessage()));
            } else {
                IResource res = this.fWorkspaceRoot.findMember((IPath)path);
                if (res != null && res.getType() != 2) {
                    this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorNotAFolder);
                    return;
                }
                ArrayList<IEGLPathEntry> newEntries = new ArrayList<IEGLPathEntry>(fEntries.length + 1);
                int projectEntryIndex = -1;
                int i = 0;
                while (i < fEntries.length) {
                    IEGLPathEntry curr = fEntries[i];
                    if (curr.getEntryKind() == 3) {
                        if (path.equals((Object)curr.getPath())) {
                            this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorAlreadyExisting);
                            return;
                        }
                        if (projPath.equals((Object)curr.getPath())) {
                            projectEntryIndex = i;
                        }
                    }
                    newEntries.add(curr);
                    ++i;
                }
                IEGLPathEntry newEntry = EGLCore.newSourceEntry((IPath)path);
                HashSet modified = new HashSet();
                if (projectEntryIndex != -1) {
                    fIsProjectAsSourceFolder = true;
                    newEntries.set(projectEntryIndex, newEntry);
                } else {
                    newEntries.add(EGLCore.newSourceEntry((IPath)path));
                }
                IEGLPathEntry[] fNewEntries = newEntries.toArray(new IEGLPathEntry[newEntries.size()]);
                IPath fNewOutputLocation = fOutputLocation;
                IEGLModelStatus status = EGLConventions.validateEGLPath((IEGLProject)fCurrEProject, (IEGLPathEntry[])fNewEntries, (IPath)fNewOutputLocation);
                if (!status.isOK()) {
                    IEGLModelStatus status2;
                    if (fOutputLocation.equals((Object)projPath) && (status2 = EGLConventions.validateEGLPath((IEGLProject)fCurrEProject, (IEGLPathEntry[])fNewEntries, (IPath)(fNewOutputLocation = projPath.append(EDTCorePreferenceConstants.getPreferenceStore().getString("eglOutputFolder"))))).isOK()) {
                        if (fIsProjectAsSourceFolder) {
                            this.fRootStatus.setInfo(NewWizardMessages.bind((String)NewWizardMessages.NewSourceFolderWizardPageWarningReplaceSFandOL, (Object)fNewOutputLocation.makeRelative().toString()));
                        } else {
                            this.fRootStatus.setInfo(NewWizardMessages.bind((String)NewWizardMessages.NewSourceFolderWizardPageWarningReplaceOL, (Object)fNewOutputLocation.makeRelative().toString()));
                        }
                        return;
                    }
                    this.fRootStatus.setError(status.getMessage());
                    return;
                }
                if (fIsProjectAsSourceFolder) {
                    this.fRootStatus.setInfo(NewWizardMessages.NewSourceFolderWizardPageWarningReplaceSF);
                    return;
                }
                if (!modified.isEmpty()) {
                    this.fRootStatus.setInfo(NewWizardMessages.bind((String)NewWizardMessages.NewSourceFolderWizardPageWarningAddedExclusions, (Object)String.valueOf(modified.size())));
                    return;
                }
            }
        }
        this.updateStatus(new IStatus[]{this.fProjectStatus, this.fRootStatus});
    }

    private class SourceFolderFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceFolderFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            if (field == EGLSourceFolderWizardPage.this.fProjectDialogField) {
                EGLSourceFolderWizardPage.this.handleProjectBrowseButtonSelected();
            } else if (field == EGLSourceFolderWizardPage.this.fSourceFolderDialogField) {
                EGLSourceFolderWizardPage.this.handleSourceFolderBrowseButtonSelected();
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field != EGLSourceFolderWizardPage.this.fProjectDialogField && field == EGLSourceFolderWizardPage.this.fSourceFolderDialogField) {
                EGLSourceFolderWizardPage.this.handleSourceFolderDialogFieldChanged();
            }
        }
    }
}

