/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.LibraryWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.LibraryConfiguration;
import org.eclipse.edt.ide.ui.wizards.LibraryOperation;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class LibraryWizard
extends EGLPartWizard
implements INewWizard {
    private static final String WIZPAGENAME_LibraryWizardPage = "WIZPAGENAME_LibraryWizardPage";
    LibraryConfiguration configuration;

    public LibraryWizard() {
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_NEWLIBRARY);
    }

    protected IRunnableWithProgress getOperation() {
        return new LibraryOperation((LibraryConfiguration)this.getConfiguration());
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        IRunnableWithProgress operation = this.getOperation();
        try {
            this.getContainer().run(false, true, operation);
        }
        catch (InterruptedException e) {
            boolean dialogResult = false;
            if (e.getMessage().indexOf(58) != -1) {
                PartTemplateException pe = new PartTemplateException(e.getMessage());
                if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_NOT_FOUND) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_LibraryWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                } else if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_DISABLED) != 0 && pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_CORRUPTED) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_LibraryWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                }
                if (dialogResult) {
                    return this.performFinish();
                }
                return false;
            }
            EGLLogger.log((Object)this, e);
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
            }
            return false;
        }
        ((LibraryWizardPage)this.getPage(WIZPAGENAME_LibraryWizardPage)).finishPage();
        this.openResource(this.configuration.getFile());
        return true;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getConfiguration().init(workbench, selection);
        this.setWindowTitle(NewWizardMessages.NewEGLLibraryWizardPageTitle);
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new LibraryConfiguration();
        }
        return this.configuration;
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)new LibraryWizardPage(WIZPAGENAME_LibraryWizardPage));
    }
}

