/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.RUIHandlerWizard;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.RUIHandlerConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RUIHandlerWizardPage
extends EGLPartWizardPage {
    private static final String PAGE_NAME = "NewRUIHandlerWizardPage";
    private int nColumns = 5;
    private StringDialogField fHandlerDialogField;
    private StringDialogField fHandlerTitleField;
    private boolean hasModifiedTitle = false;
    private StatusInfo fProgramStatus;

    protected RUIHandlerWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLRUIHandlerWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLRUIHandlerWizardPageDescription);
        this.fProgramStatus = new StatusInfo();
    }

    @Override
    public void init() {
    }

    private RUIHandlerConfiguration getConfiguration() {
        return (RUIHandlerConfiguration)((RUIHandlerWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.init();
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_RUI_HANDLER_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createProgramPartControls(composite);
        this.modifyFileListeners();
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void createProgramPartControls(Composite parent) {
        this.fHandlerDialogField = new StringDialogField();
        this.fHandlerDialogField.setDialogFieldListener(new HandlerDialogFieldAdapter());
        this.fHandlerDialogField.setLabelText(NewWizardMessages.NewEGLRUIHandlerWizardPagePartlabel);
        this.fHandlerDialogField.setEnabled(false);
        this.fHandlerDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fHandlerDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fHandlerDialogField.getTextControl(null));
        this.fHandlerTitleField = new StringDialogField();
        this.fHandlerTitleField.setDialogFieldListener(new HandlerTitleFieldAdapter());
        this.fHandlerTitleField.setLabelText(NewWizardMessages.NewEGLRUIHandlerWizardPageTitlelabel);
        this.fHandlerTitleField.setEnabled(true);
        this.fHandlerTitleField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fHandlerTitleField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fHandlerTitleField.getTextControl(null));
        this.fHandlerDialogField.setText(this.getConfiguration().gethandlerName());
        this.fHandlerTitleField.setText(this.getConfiguration().getHandlerTitle());
    }

    private void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RUIHandlerWizardPage.this.fHandlerDialogField.setText(RUIHandlerWizardPage.this.fEGLFileDialogField.getText());
                if (!RUIHandlerWizardPage.this.hasModifiedTitle) {
                    RUIHandlerWizardPage.this.fHandlerTitleField.setText(RUIHandlerWizardPage.this.fEGLFileDialogField.getText());
                }
            }
        });
    }

    private void handleHandlerTitleFieldChanged() {
        if (!this.fHandlerTitleField.getText().equals(this.fHandlerDialogField.getText())) {
            this.hasModifiedTitle = true;
        }
        this.getConfiguration().setHandlerTitle(this.fHandlerTitleField.getText());
    }

    private void handleHandlerDialogFieldChanged() {
        this.getConfiguration().setHandlerName(this.fHandlerDialogField.getText());
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        if (super.validatePage()) {
            this.fProgramStatus.setOK();
            String partName = this.getConfiguration().gethandlerName();
            if (partName.length() == 0) {
                this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
            } else if (partName.indexOf(46) != -1) {
                this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
            } else {
                this.validateEGLName(partName, 2, this.fProgramStatus);
            }
            this.updateStatus(new IStatus[]{this.fProgramStatus});
            return this.fProgramStatus.getSeverity() != 4;
        }
        return false;
    }

    @Override
    public void finishPage() {
        super.finishPage();
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(PAGE_NAME);
        }
    }

    private class HandlerDialogFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private HandlerDialogFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            RUIHandlerWizardPage.this.handleHandlerDialogFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }

    private class HandlerTitleFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private HandlerTitleFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            RUIHandlerWizardPage.this.handleHandlerTitleFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }
}

